#include <iostream>
#include <winsock2.h> // WinSock2 library (may need to add WS2_32.lib to project dependencies).

#define BUFFER_SIZE 512 // Receive buffer size (basically maximum packet size in UDP).
#define HOST "127.0.0.1" // Host to connect to.
#define PORT 30000 // Port to connect to the host through.

// Define types used by InSim.
typedef unsigned char byte;
typedef unsigned short word;
typedef struct
{
	int X, Y, Z;
} Vec;
typedef struct
{
	float X, Y, Z;
} Vector;

// Include InSim header.
#include "InSim.h"

void OutGaugePacketReceived(const OutGaugePack packet);

int main(int argc, char *argv[])
{
    
	// Initialise WinSock version 2.2.
	WSADATA wsaData;
	if (WSAStartup(MAKEWORD(2, 2), &wsaData) != 0)
	{
		WSACleanup();
		std::cerr << "Error: Failed to init WinSock" << std::endl;
		return EXIT_FAILURE;
	}

	// Create UDP socket.
	SOCKET sock = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
	if (sock == INVALID_SOCKET)
	{
		WSACleanup();
		std::cerr << "Error: Could not create socket." << std::endl;
		return EXIT_FAILURE;
	}

	// Bind to receive UDP packets.
	sockaddr_in saddr;
	saddr.sin_family = AF_INET;
	saddr.sin_addr.s_addr = inet_addr(HOST);
	saddr.sin_port = htons(PORT);
	if (bind(sock, (sockaddr *)&saddr, sizeof(sockaddr)) == SOCKET_ERROR)
	{
		closesocket(sock);
		WSACleanup();
		std::cerr << "Error: Could not connect to LFS" << std::endl;
		return EXIT_FAILURE;
	}

	// Packet receive loop.
	char recvbuf[BUFFER_SIZE];
	memset(recvbuf, 0, sizeof(recvbuf)); // Set recvbuf to zero.
	int bytes = 0;
	do
	{
		bytes = recv(sock, recvbuf, BUFFER_SIZE, 0);
		if (bytes > 0)
			OutGaugePacketReceived((OutGaugePack &)recvbuf);
		else if (bytes == 0)
			std::cerr << "Error: Lost connection with LFS" << std::endl;
		else
			std::cerr << "Error: " << WSAGetLastError() << std::endl;
	} while (bytes > 0);

	// Cleanup and exit.
	closesocket(sock);
	WSACleanup();
	return EXIT_SUCCESS;
}

void OutGaugePacketReceived(const OutGaugePack packet)
{
	unsigned mask = 1 << DL_SHIFT;
	if (packet.ShowLights & mask)
	{
		std::cout << "Shift light on!" << std::endl;
	}
}