SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;

SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;

SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';



DROP SCHEMA IF EXISTS `mydb` ;

CREATE SCHEMA IF NOT EXISTS `mydb` DEFAULT CHARACTER SET latin1 COLLATE latin1_swedish_ci ;

DROP SCHEMA IF EXISTS `ABL` ;

CREATE SCHEMA IF NOT EXISTS `ABL` DEFAULT CHARACTER SET latin1 ;

USE `mydb` ;

USE `ABL` ;



-- -----------------------------------------------------

-- Table `ABL`.`commands`

-- -----------------------------------------------------

DROP TABLE IF EXISTS `ABL`.`commands` ;



CREATE  TABLE IF NOT EXISTS `ABL`.`commands` (

  `idcommands` INT(11) NOT NULL AUTO_INCREMENT ,

  `command` VARCHAR(255) NULL DEFAULT NULL ,

  `argument` VARCHAR(255) NULL DEFAULT NULL ,

  `server` VARCHAR(45) NULL ,

  PRIMARY KEY (`idcommands`) )

ENGINE = MyISAM

DEFAULT CHARACTER SET = latin1;





-- -----------------------------------------------------

-- Table `ABL`.`qualifing`

-- -----------------------------------------------------

DROP TABLE IF EXISTS `ABL`.`qualifing` ;



CREATE  TABLE IF NOT EXISTS `ABL`.`qualifing` (

  `idqualifing` INT(11) NOT NULL AUTO_INCREMENT ,

  `UName` VARCHAR(100) NULL DEFAULT NULL ,

  `PName` VARCHAR(100) NULL ,

  `BestTime` INT(11) NULL DEFAULT NULL ,

  PRIMARY KEY (`idqualifing`) )

ENGINE = MyISAM

DEFAULT CHARACTER SET = latin1;





-- -----------------------------------------------------

-- Table `ABL`.`connected`

-- -----------------------------------------------------

DROP TABLE IF EXISTS `ABL`.`connected` ;



CREATE  TABLE IF NOT EXISTS `ABL`.`connected` (

  `idconnected` INT(11) NOT NULL AUTO_INCREMENT ,

  `ServerName` VARCHAR(45) NULL DEFAULT NULL ,

  `PLID` INT NULL ,

  `UCID` INT(11) NULL DEFAULT NULL ,

  `PName` VARCHAR(100) NULL DEFAULT NULL ,

  `UName` VARCHAR(100) NULL DEFAULT NULL ,

  PRIMARY KEY (`idconnected`) ,

  INDEX `fk_connected_qualifing` (`UName` ASC) ,

  CONSTRAINT `fk_connected_qualifing`

    FOREIGN KEY (`UName` )

    REFERENCES `ABL`.`qualifing` (`UName` )

    ON DELETE NO ACTION

    ON UPDATE NO ACTION)

ENGINE = MyISAM

DEFAULT CHARACTER SET = latin1;





-- -----------------------------------------------------

-- Table `ABL`.`lapper`

-- -----------------------------------------------------

DROP TABLE IF EXISTS `ABL`.`lapper` ;



CREATE  TABLE IF NOT EXISTS `ABL`.`lapper` (

  `idlapper` INT(11) NOT NULL AUTO_INCREMENT ,

  `LFSname` VARCHAR(45) NULL DEFAULT NULL ,

  `DisplayName` VARCHAR(45) NULL DEFAULT NULL ,

  `LapsDriven` INT(11) NULL DEFAULT NULL ,

  `Car` VARCHAR(45) NULL DEFAULT NULL ,

  `Track` VARCHAR(45) NULL DEFAULT NULL ,

  `FastestSetDate` VARCHAR(45) NULL DEFAULT NULL ,

  `FastestSetTime` VARCHAR(45) NULL DEFAULT NULL ,

  `FastestLapTime` INT(11) NULL DEFAULT NULL ,

  `FastestSector1` INT(11) NULL DEFAULT NULL ,

  `FastestSector2` INT(11) NULL DEFAULT NULL ,

  `FastestSector3` INT(11) NULL DEFAULT NULL ,

  `HistorySetDate` VARCHAR(125) NULL DEFAULT NULL ,

  `HistorySetTime` VARCHAR(125) NULL DEFAULT NULL ,

  `HistoryLapTime` VARCHAR(125) NULL DEFAULT NULL ,

  `HistorySector1` VARCHAR(125) NULL DEFAULT NULL ,

  `HistorySector2` VARCHAR(125) NOT NULL ,

  `HistorySector3` VARCHAR(125) NULL DEFAULT NULL ,

  `BestSector1` INT(11) NULL DEFAULT NULL ,

  `BestSector2` INT(11) NULL DEFAULT NULL ,

  `BestSector3` INT(11) NULL DEFAULT NULL ,

  `BestSectorLast` INT(11) NULL DEFAULT NULL ,

  PRIMARY KEY (`idlapper`) )

ENGINE = InnoDB

AUTO_INCREMENT = 1714

DEFAULT CHARACTER SET = latin1;







SET SQL_MODE=@OLD_SQL_MODE;

SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;

SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
