using System;
using LFS_External;
using LFS_External.InSim;

namespace LFS_External_Client
{
	/// <summary>Holds information of a connected client to the lfs server</summary>
	public class clsConnection
	{
		protected byte _uniqueid;
		protected string _username;
		protected string _playername;
		protected byte _isadmin;
        protected byte _flags;

        protected int _personalid = 0;
        public int personalId
        {
            get { return personalId; }
            set { personalId = value; }
        }

        protected bool _hudenabled = true;
        public bool hudEnabled
        {
            get { return _hudenabled; }
            set { _hudenabled = value; }
        }

        protected string _cars = "011100101010100001";
        public string cars
        {
            get { return _cars; }
            set { _cars = value; }
        }
        protected string _carsprev = "011100101010100001";
        public string carsPrev
        {
            get { return _carsprev; }
            set { _carsprev = value; }
        }

        protected int _health = 100000;
        public int health
        {
            get { return _health; }
            set { _health = value; }
        }
        protected int _healthprev = 100000;
        public int healthPrev
        {
            get { return _healthprev; }
            set { _healthprev = value; }
        }

        protected int _money = 0;
        public int money
        {
            get { return _money; }
            set { _money = value; }
        }
        protected int _moneyprev = 0;
        public int moneyPrev
        {
            get { return _moneyprev; }
            set { _moneyprev = value; }
        }
        protected int _moneybank = 0;
        public int moneyBank
        {
            get { return _moneybank; }
            set { _moneybank = value; }
        }
        protected int _moneybankprev = 0;
        public int moneyBankPrev
        {
            get { return _moneybankprev; }
            set { _moneybankprev = value; }
        }
        protected int _moneyinitial = 0;
        public int moneyInitial
        {
            get { return _moneyinitial; }
            set { _moneyinitial = value; }
        }

        protected int _distancetotal = 0;
        public int distanceTotal
        {
            get { return _distancetotal; }
            set { _distancetotal = value; }
        }
        protected int _distancetotalprev = 0;
        public int distanceTotalPrev
        {
            get { return _distancetotalprev; }
            set { _distancetotalprev = value; }
        }

		/// <summary>Connection Unique ID</summary>
		public byte UniqueID
		{
			get { return _uniqueid; }
			set { _uniqueid = value; }
		}

		/// <summary>Connection username</summary>
		public string Username
		{
			get { return _username; }
			set { _username = value; }
		}

		/// <summary>Connection player name</summary>
		public string PlayerName
		{
			get { return _playername; }
			set { _playername = value; }
		}

		/// <summary>Connection is admin</summary>
		public byte IsAdmin
		{
			get { return _isadmin; }
			set { _isadmin = value; }
		}

		/// <summary>Bit 2 : remote</summary>
		public byte Flags
		{
			get { return _flags; }
			set { _flags = value; }
		}
	}
}