####	RACE CONTROL SYSTEM
####	============================

####	For Lapper V5.926 and later

####	by Sinanju

####  from an idea by Jonathon.provost (and because Sinanju was curious) 

#################################################################
# Ver 0.1 - 27 April 2011 Initial workup that doesn't go very far
#################################################################

/*

Codes that can be used on button format:

0 - transparent button
16 - light button
32 - dark button
64 - align text to left
128 - align text to right

If you want to make a light colored button with text aligned to the left, combine the codes to one new code, for example 16+64 = 80
*/

/*
To create colored text, use the following codes in front of the text you want to color:

^0 - black
^1 - red
^2 - green
^3 - yellow
^4 - blue
^5 - violet
^6 - cyan
^7 - white
^8 - no color (gray)

Other variables that could be used on expressions
&&	and
||	or
+	plus
-	minus
/	divide
*	multiply
^	pow
==	equal to
!=	not equal to
>	bigger than
<	smaller than
<=	smaller than and equal to
>=	bigger than and equal to
*/

CatchEvent OnLapperStart()

### Set initial dialog coordinates & size for buttons and labels ###
	GlobalVar $RCMorigL; $RCMorigL = 40;	# Left edge of main content window / button / label
	GlobalVar $RCMorigT; $RCMorigT = 50;	# Top edge of window / button / label
	GlobalVar $RCMWidth; $RCMWidth = 20;	# Width of Dialog box / window / button / label
	GlobalVar $RCMHeight; $RCMHeight = 4;	# ...height of row of text
	GlobalVar $RCMspacing; $RCMspacing = 4;	# ...height of spacing between text
	GlobalVar $RCMtime; $RCMtime = 6;	# display button for how many seconds (-1 = permanent)
	
EndCatchEvent


CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 )
	THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH ( $command )
		CASE "!rc":  #	Words/Text needed to start Race Control Menu
		CASE "!RC":
		CASE "!rcm":
		CASE "!RCM":    		
		CASE "!racecontrol":
		CASE "!RACECONTROL":
			DoRCM(0,0);  # Goto Subroutine DoRCM
		BREAK;
	ENDSWITCH
EndCatchEvent


Sub DoRCM( $KeyFlags,$id )

	closePrivButton ("rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu&rcm_menuback&rcm_messageback&rcm_trackback&rcm_penaltyback&rcm_pitlaneback"); # close buttons that may be open from other subroutines

IF ( UserIsAdmin( $userName ) == 1 )
THEN
	openPrivButton( "rcm_back",39,49,22,18,5,-1,16,"" ); # blank background
	openPrivButton( "rcm_menu",$RCMorigL,$RCMorigT,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,32, langEngine( "%{rcm_menu}%"),DoRCmenu ); # look in lang "en" for what rcm_menu means.  DoRCmenu, means goto subroutine DoRCmenu
  openPrivButton( "rcm_closemenu",$RCMorigL,$RCMorigT+12,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_closemenu}%"),DoRCclosemenu );
  	
ELSE
	privMsg( langEngine( "%{rcm_notrcadmin}%" ) );
ENDIF

EndSub


Sub DoRCclosemenu( $KeyFlags,$id )
	closePrivButton ("rcm_back&rcm_menu&rcm_closemenu");
	
EndSub


Sub DoRCmenu( $KeyFlags,$id )
	closePrivButton ("rcm_back&rcm_menu&rcm_closemenu");
	openPrivButton( "rcm_menuback",39,49,22,22,5,-1,16,"" );	
	openPrivButton( "rcm_messages",$RCMorigL,$RCMorigT,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_messages}%"),DoRCmessages );
	openPrivButton( "rcm_track",$RCMorigL,$RCMorigT+4,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_track}%"),DoRCtrack );
	openPrivButton( "rcm_penalties",$RCMorigL,$RCMorigT+8,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_penalties}%"),DoRCpenalties );
	openPrivButton( "rcm_pitlane", $RCMorigL,$RCMorigT+12,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_pitlane}%"),DoRCpitlane );
	openPrivButton( "rcm_closemenu",$RCMorigL,$RCMorigT+16,$RCMWidth,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );
EndSub


Sub DoRCmessages( $KeyFlags,$id )
	closePrivButton ("rcm_menuback&rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu");
	openPrivButton( "rcm_messageback",39,49,22,24,5,-1,16,"" );	
	
EndSub


Sub DoRCtrack( $KeyFlags,$id )
	closePrivButton ("rcm_menuback&rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu");
	openPrivButton( "rcm_trackback",39,49,22,24,5,-1,16,"" );
	
EndSub


Sub DoRCpenalties( $KeyFlags,$id )
	closePrivButton ("rcm_menuback&rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu");
	openPrivButton( "rcm_penaltyback",39,49,22,24,5,-1,16,"" );	
	
EndSub


Sub DoRCpitlane( $KeyFlags,$id )
	closePrivButton ("rcm_menuback&rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu");
	openPrivButton( "rcm_pitlaneback",39,49,22,24,5,-1,16,"" );	
	
EndSub




Lang "EN"

rcm_notrcadmin = "^2You do not have ^1Admin ^2priviliges";
rcm_menu = "^7RACE CONTROL%nl%^7MENU";
rcm_closemenu = "CLOSE";
rcm_messages = "^7MESSAGE OPTIONS";
rcm_track = "^7TRACK CONDITION OPTIONS";
rcm_penalties = "^7PENALTY OPTIONS";
rcm_pitlane = "^7PITLANE OPTIONS";
     	
EndLang

