﻿namespace LFS_External.InSim
{
    using LFS_External;
    using System;
    using System.Runtime.CompilerServices;

    internal interface IInSimInterface
    {
        event InSimInterface.AXC_EventHandler AXC_Received;

        event InSimInterface.AXI_EventHandler AXI_Received;

        event InSimInterface.AXO_EventHandler AXO_Received;

        event InSimInterface.BFN_EventHandler BFN_Received;

        event InSimInterface.BTC_EventHandler BTC_Received;

        event InSimInterface.BTT_EventHandler BTT_Received;

        event InSimInterface.CCH_EventHandler CCH_Received;

        event InSimInterface.CLR_EventHandler CLR_Received;

        event InSimInterface.CNL_EventHandler CNL_Received;

        event InSimInterface.CPP_EventHandler CPP_Received;

        event InSimInterface.CPR_EventHandler CPR_Received;

        event InSimInterface.CRS_EventHandler CRS_Received;

        event InSimInterface.FIN_EventHandler FIN_Received;

        event InSimInterface.FLG_EventHandler FLG_Received;

        event InSimInterface.III_EventHandler III_Received;

        event InSimInterface.ISM_EventHandler ISM_Received;

        event InSimInterface.LAP_EventHandler LAP_Received;

        event InSimInterface.MCI_EventHandler MCI_Received;

        event InSimInterface.MPE_EventHandler MPE_Received;

        event InSimInterface.MSO_EventHandler MSO_Received;

        event InSimInterface.NCN_EventHandler NCN_Received;

        event InSimInterface.NLP_EventHandler NLP_Received;

        event InSimInterface.NPL_EventHandler NPL_Received;

        event InSimInterface.PEN_EventHandler PEN_Received;

        event InSimInterface.PFL_EventHandler PFL_Received;

        event InSimInterface.PIT_EventHandler PIT_Received;

        event InSimInterface.PLA_EventHandler PLA_Received;

        event InSimInterface.PLL_EventHandler PLL_Received;

        event InSimInterface.PLP_EventHandler PLP_Received;

        event InSimInterface.PSF_EventHandler PSF_Received;

        event InSimInterface.REN_EventHandler REN_Received;

        event InSimInterface.REO_EventHandler REO_Received;

        event InSimInterface.REPLY_EventHandler REPLY_Received;

        event InSimInterface.RES_EventHandler RES_Received;

        event InSimInterface.RST_EventHandler RST_Received;

        event InSimInterface.RTP_EventHandler RTP_Received;

        event InSimInterface.SPX_EventHandler SPX_Received;

        event InSimInterface.STA_EventHandler STA_Received;

        event InSimInterface.TOC_EventHandler TOC_Received;

        event InSimInterface.VER_EventHandler VER_Received;

        event InSimInterface.VTA_EventHandler VTA_Received;

        event InSimInterface.VTC_EventHandler VTC_Received;

        event InSimInterface.VTN_EventHandler VTN_Received;

        event InSimInterface.CON_EventHandler CON_Received;

        void Close();
        void Connect();
        void Request_AXI_AutocrossLayoutInfo();
        void Request_AXI_AutocrossLayoutInfo(byte RequestId);
        void Request_CCP_CameraPosition();
        void Request_CCP_CameraPosition(byte RequestId);
        void Request_ISM_MutliplayerInfo();
        void Request_ISM_MutliplayerInfo(byte RequestId);
        void Request_MCI_MCIPacket();
        void Request_MCI_MCIPacket(byte RequestId);
        void Request_NCN_AllConnections();
        void Request_NCN_AllConnections(byte RequestId);
        void Request_NLP_NodeLapPacket();
        void Request_NLP_NodeLapPacket(byte RequestId);
        void Request_NPL_AllPlayers();
        void Request_NPL_AllPlayers(byte RequestId);
        void Request_Ping();
        void Request_REO_RaceStartOrder();
        void Request_REO_RaceStartOrder(byte RequestId);
        void Request_RES_AllResults();
        void Request_RES_AllResults(byte RequestId);
        void Request_RST_RaceStart();
        void Request_RST_RaceStart(byte RequestId);
        void Request_RTP_RaceTime();
        void Request_RTP_RaceTime(byte RequestId);
        void Request_STA_State();
        void Request_STA_State(byte RequestId);
        void Request_VER_InSimVersionInfo();
        void Request_VER_InSimVersionInfo(byte RequestId);
        void Send_BFN_DeleteButton(Enums.BtnFunc Type, byte ClickID, byte UniqueID);
        void Send_BTN_CreateButton(string ButtonText, LFS_External.InSim.Flags.ButtonStyles Style, byte Height, byte Width, byte Top, byte Left, byte ClickID, byte UniqueID, byte RequestID, bool AlwaysVisible);
        void Send_BTN_CreateButton(string ButtonText, string DialogCaption, LFS_External.InSim.Flags.ButtonStyles Style, byte Height, byte Width, byte Top, byte Left, byte TypeIn, byte ClickID, byte UniqueID, byte RequestID, bool AlwaysVisible);
        void Send_CPP_CameraPosition(int X, int Y, int Z, ushort H, ushort P, ushort R, byte PlayerID, byte InGameCam, float FOV, ushort Time, LFS_External.InSim.Flags.StateFlags Flags);
        void Send_MOD_ScreenMode(int Bits16, int RefreshRate, int Width, int Height);
        void Send_MSL_LocalMessage(string Message, Enums.MSL_Sound Sound);
        void Send_MST_Message(string Message);
        void Send_MSX_ExtendedMessage(string Message);
        void Send_MTC_MessageToConnection(string Message, byte UniqueID, byte PlayerID, Enums.MSL_Sound Sound);
        void Send_SCC_SetCarCamera(byte PlayerID, byte InGameCamera);
        void Send_SCH_SingleCharacter(char Char, LFS_External.InSim.Flags.SCHFlags Flags);
        void Send_SFP_StateFlags(LFS_External.InSim.Flags.StateFlags Flags, byte OffOn);
        void Send_SMALL(Enums.Small Type, byte ReqI, uint Value);

        string Name { get; set; }

        InSimInterface.InSimState State { get; }
    }
}

