﻿namespace LFS_External.InSim
{
    using System;
    using System.Net;

    public class InSimSettings : IInSimSettings
    {
        private string _adminpass = "";
        private string _appname = "";
        private uint _autoreconnectdelay = 0xea60;
        private char _commandprefix = '!';
        private LFS_External.InSim.Flags.InSimFlags _flags;
        private ushort _mci_nlp_interval = 500;
        private ushort _portnumber = 0x752f;
        private IPAddress _serverip = IPAddress.Any;
        private ushort _udpreplyport = 0x2716;

        public InSimSettings()
            : this("127.0.0.1", 29999, 0, 0, Char.MinValue, 0, String.Empty, String.Empty, 5)
        { }

        public InSimSettings(string ServerIP, ushort PortNumber, ushort UDPReplyPort, LFS_External.InSim.Flags.InSimFlags Flags, char CommandPrefix, ushort MCI_NLP_Interval, string AdminPass, string AppName, uint AutoReconnectDelayInSeconds)
        {
            this._serverip = IPAddress.Parse(ServerIP);
            this._portnumber = PortNumber;
            this._udpreplyport = UDPReplyPort;
            this._flags = Flags;
            this._commandprefix = CommandPrefix;
            this._mci_nlp_interval = MCI_NLP_Interval;
            this._adminpass = AdminPass;
            this._appname = AppName;
            this._autoreconnectdelay = (AutoReconnectDelayInSeconds == 0) ? 0 : (AutoReconnectDelayInSeconds * 0x3e8);
        }

        public string AdminPass
        {
            get
            {
                return this._adminpass;
            }
            set
            {
                this._adminpass = value;
            }
        }

        public string AppName
        {
            get
            {
                return this._appname;
            }
            set
            {
                this._appname = value;
            }
        }

        public uint AutoReconnectDelay
        {
            get
            {
                return this._autoreconnectdelay;
            }
            set
            {
                this._autoreconnectdelay = value;
            }
        }

        public char CommandPrefix
        {
            get
            {
                return this._commandprefix;
            }
            set
            {
                this._commandprefix = value;
            }
        }

        public LFS_External.InSim.Flags.InSimFlags Flags
        {
            get
            {
                return this._flags;
            }
            set
            {
                this._flags = value;
            }
        }

        public ushort MCI_NLP_Interval
        {
            get
            {
                return this._mci_nlp_interval;
            }
            set
            {
                this._mci_nlp_interval = value;
            }
        }

        public ushort PortNumber
        {
            get
            {
                return this._portnumber;
            }
            set
            {
                this._portnumber = value;
            }
        }

        public IPAddress ServerIP
        {
            get
            {
                return this._serverip;
            }
            set
            {
                this._serverip = value;
            }
        }

        public ushort UdpReplyPort
        {
            get
            {
                return this._udpreplyport;
            }
            set
            {
                this._udpreplyport = value;
            }
        }
    }
}

