﻿namespace LFS_External.OutGauge
{
    using LFS_External;
    using System;
    using System.Runtime.CompilerServices;
    using System.Runtime.InteropServices;

    public sealed class OutGaugeInterface : UDPListener
    {
        private string _name = "Default OutGaugeInterface";
        private int _psize;

        public event OutGauge_EventHandler OutGauge_Received;

        public OutGaugeInterface(ushort Port)
        {
            base._port = Port;
            this._psize = Marshal.SizeOf(new LFS_External.Packets.OutGaugePack());
        }

        protected override void DataReceived(byte[] data)
        {
            if (data.Length == this._psize)
            {
                LFS_External.Packets.OutGaugePack destStruct = new LFS_External.Packets.OutGaugePack();
                destStruct = (LFS_External.Packets.OutGaugePack) Util.DataToPacket(data, destStruct);
                if (this.OutGauge_Received != null)
                {
                    this.OutGauge_Received(destStruct);
                }
            }
        }

        public string Name
        {
            get
            {
                return this._name;
            }
            set
            {
                this._name = value;
            }
        }

        public delegate void OutGauge_EventHandler(LFS_External.Packets.OutGaugePack og);
    }
}

