﻿namespace LFS_External.OutSim
{
    using LFS_External;
    using System;
    using System.Runtime.CompilerServices;
    using System.Runtime.InteropServices;

    public sealed class OutSimInterface : UDPListener
    {
        private string _name = "Default OutSimInterface";
        private int _psize;

        public event OutSim_EventHandler OutSim_Received;

        public OutSimInterface(ushort Port)
        {
            base._port = Port;
            this._psize = Marshal.SizeOf(new LFS_External.Packets.OutSimPack());
        }

        protected override void DataReceived(byte[] data)
        {
            if (data.Length == this._psize)
            {
                LFS_External.Packets.OutSimPack destStruct = new LFS_External.Packets.OutSimPack();
                destStruct = (LFS_External.Packets.OutSimPack) Util.DataToPacket(data, destStruct);
                if (this.OutSim_Received != null)
                {
                    this.OutSim_Received(destStruct);
                }
            }
        }

        public string Name
        {
            get
            {
                return this._name;
            }
            set
            {
                this._name = value;
            }
        }

        public delegate void OutSim_EventHandler(LFS_External.Packets.OutSimPack os);
    }
}

