﻿namespace LFS_External
{
    using LFS_External.InSim;
    using LFS_External.OutGauge;
    using System;
    using System.Runtime.InteropServices;

    public class Packets
    {
        [StructLayout(LayoutKind.Sequential)]
        public struct CompCar
        {
            public ushort Node;
            public ushort Lap;
            public byte PLID;
            public byte Position;
            public LFS_External.InSim.Flags.CompCarFlags Info;
            internal byte Sp3;
            public int X;
            public int Y;
            public int Z;
            public ushort Speed;
            public ushort Direction;
            public ushort Heading;
            public short AngVel;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_AXI
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            internal byte Zero;
            public byte AXStart;
            public byte NumCP;
            public ushort NumO;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x20)]
            public string LName;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_AXO
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_BFN
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public Enums.BtnFunc SubT;
            public byte UCID;
            public byte ClickID;
            public byte Inst;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_BTC
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte UCID;
            public byte ClickID;
            public byte Inst;
            public LFS_External.InSim.Flags.ButtonClickFlags CFlags;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_BTN
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte UCID;
            public byte ClickID;
            public byte Inst;
            public LFS_External.InSim.Flags.ButtonStyles BStyle;
            public byte TypeIn;
            public byte L;
            public byte T;
            public byte W;
            public byte H;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 240)]
            public string Text;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_BTT
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte UCID;
            public byte ClickID;
            public byte Inst;
            public byte TypeIn;
            internal byte Sp3;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x60)]
            public string Text;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_CCH
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public Enums.View Camera;
            internal byte Sp1;
            internal byte Sp2;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_CNL
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte UCID;
            public Enums.CNL_Reason Reason;
            public byte Total;
            internal byte Sp2;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_CPP
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            internal byte Zero;
            public int X;
            public int Y;
            public int Z;
            public ushort H;
            public ushort P;
            public ushort R;
            public byte ViewPLID;
            public byte InGameCam;
            public float FOV;
            public ushort Time;
            public LFS_External.InSim.Flags.StateFlags Flags;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_CPR
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte UCID;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x18)]
            public string PName;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 8)]
            public string Plate;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_CRS
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_FIN
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public uint TTime;
            public uint BTime;
            public byte SpA;
            public byte NumStops;
            public byte Confirm;
            public byte SpB;
            public ushort LapsDone;
            public LFS_External.InSim.Flags.ConfirmationFlags Flags;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_FLG
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public byte OffOn;
            public Enums.Flags Flag;
            public byte CarBehind;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_III
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            internal byte Zero;
            public byte UCID;
            public byte PLID;
            internal byte Sp2;
            internal byte Sp3;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x40)]
            public string Msg;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_ISI
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            internal byte Zero;
            public ushort UDPPort;
            public ushort Flags;
            internal byte Sp0;
            public byte Prefix;
            public ushort Interval;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x10)]
            public string Admin;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x10)]
            public string IName;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_ISM
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            internal byte Zero;
            public byte Host;
            internal byte Sp1;
            internal byte Sp2;
            internal byte Sp3;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x20)]
            public string HName;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_LAP
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public uint LTime;
            public uint ETime;
            public ushort LapsDone;
            public LFS_External.InSim.Flags.PlayerFlags Flags;
            internal byte Sp0;
            public byte Penalty;
            public byte NumStops;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_MCI
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte NumC;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
            public LFS_External.Packets.CompCar[] Info;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_MOD
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            internal byte Zero;
            public int Bits16;
            public int RR;
            public int Width;
            public int Height;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_MSL
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            public Enums.MSL_Sound Sound;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x80)]
            public string Msg;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_MSO
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            internal byte Zero;
            public byte UCID;
            public byte PLID;
            public Enums.MSO_UserType UserType;
            public byte TextStart;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x80)]
            public string Msg;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_MST
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            internal byte Zero;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x40)]
            public string Msg;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_MSX
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            internal byte Zero;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x60)]
            public string Msg;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_MTC
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            public Enums.MSL_Sound Sound;
            public byte UCID;
            public byte PLID;
            internal byte Sp2;
            internal byte Sp3;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 128)]
            public string Msg;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_NCN
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte UCID;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x18)]
            public string UName;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x18)]
            public string PName;
            public byte Admin;
            public byte Total;
            public byte Flags;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_NLP
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte NumP;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 0x20)]
            public LFS_External.Packets.NodeLap[] Info;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_NPL
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public byte UCID;
            public byte PType;
            public LFS_External.InSim.Flags.PlayerFlags Flags;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x18)]
            public string PName;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 8)]
            public string Plate;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 4)]
            public string CName;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x10)]
            public string SName;
            public Enums.NPL_Tyres Tyre_RL;
            public Enums.NPL_Tyres Tyre_RR;
            public Enums.NPL_Tyres Tyre_FL;
            public Enums.NPL_Tyres Tyre_FR;
            public byte H_Mass;
            public byte H_TRes;
            public byte Model;
            public byte Pass;
            public int Spare;
            internal byte Sp0;
            public byte NumP;
            internal byte Sp2;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_PEN
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public Enums.Penalty OldPen;
            public Enums.Penalty NewPen;
            public Enums.PenaltyReason Reason;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_PFL
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public LFS_External.InSim.Flags.PlayerFlags Flags;
            public ushort Spare;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_PIT
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public ushort LapsDone;
            public LFS_External.InSim.Flags.PlayerFlags Flags;
            internal byte Sp0;
            public byte Penalty;
            public byte NumStops;
            internal byte Sp3;
            public Enums.NPL_Tyres RL_Changed;
            public Enums.NPL_Tyres RR_Changed;
            public Enums.NPL_Tyres FL_Changed;
            public Enums.NPL_Tyres FR_Changed;
            public LFS_External.InSim.Flags.PitWorkFlags Work;
            public uint Spare;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_PLA
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public Enums.PitLaneReason Fact;
            internal byte Sp1;
            internal byte Sp2;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_PLL
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_PLP
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_PSF
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public uint STime;
            public uint Spare;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_REO
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte NumP;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 0x20)]
            public byte[] PLID;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_RES
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x18)]
            public string UName;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x18)]
            public string PName;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 8)]
            public string Plate;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 4)]
            public string CName;
            public uint TTime;
            public uint BTime;
            public byte SpA;
            public byte NumStops;
            public LFS_External.InSim.Flags.ConfirmationFlags Confirm;
            public byte SpB;
            public ushort LapsDone;
            public LFS_External.InSim.Flags.PlayerFlags Flags;
            public byte ResultNum;
            public byte NumRes;
            public ushort PSeconds;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_RST
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            internal byte Zero;
            public byte RaceLaps;
            public byte QualMins;
            public byte NumP;
            public byte Timing;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 6)]
            public string Track;
            public byte Weather;
            public byte Wind;
            public LFS_External.InSim.Flags.RaceFlags Flags;
            public ushort NumNodes;
            public ushort Finish;
            public ushort Split1;
            public ushort Split2;
            public ushort Split3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_SCC
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            internal byte Zero;
            public byte ViewPLID;
            public byte InGameCam;
            internal byte Sp2;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_SCH
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            internal byte Zero;
            public byte CharB;
            public byte Flags;
            public byte Spare2;
            public byte Spare3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_SFP
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            internal byte Zero;
            public ushort Flag;
            public byte OffOn;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_SMALL
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            public Enums.Small SubT;
            public uint UVal;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_SPX
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public uint STime;
            public uint ETime;
            public byte Split;
            public LFS_External.Enums.Penalty Penalty;
            public byte NumStops;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_STA
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            internal byte Zero;
            public float ReplaySpeed;
            public LFS_External.InSim.Flags.StateFlags Flags;
            public byte InGameCam;
            public byte ViewPLID;
            public byte NumP;
            public byte NumConns;
            public byte NumFinished;
            public byte RaceInProg;
            public byte QualMins;
            public byte RaceLaps;
            public byte Spare2;
            public byte Spare3;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 6)]
            public string Track;
            public byte Weather;
            public byte Wind;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_TINY
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            public Enums.Tiny SubT;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_TOC
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            public byte PLID;
            public byte OldUCID;
            public byte NewUCID;
            internal byte Sp2;
            internal byte Sp3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_VER
        {
            internal byte Size;
            internal Enums.Packets Type;
            public byte ReqI;
            internal byte Zero;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 8)]
            public string Version;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 6)]
            public string Product;
            public ushort InSimVer;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_VTN
        {
            internal byte Size;
            internal byte Type;
            public byte ReqI;
            internal byte Zero;
            public byte UCID;
            public Enums.VTN_Actions Action;
            public byte Spare2;
            public byte Spare3;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct NodeLap
        {
            public ushort Node;
            public ushort Lap;
            public byte PLID;
            public byte Position;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct OutGaugePack
        {
            public uint Time;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 4)]
            public string Car;
            public LFS_External.OutGauge.Flags.OutGaugeFlags Flags;
            public byte Gear;
            public byte SpareB;
            public float Speed;
            public float RPM;
            public float Turbo;
            public float EngTemp;
            public float Fuel;
            public float OilPress;
            public float OilTemp;
            public LFS_External.OutGauge.Flags.DashLightFlags DashLights;
            public LFS_External.OutGauge.Flags.DashLightFlags ShowLights;
            public float Throttle;
            public float Brake;
            public float Clutch;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x10)]
            public string Display1;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 0x10)]
            public string Display2;
            public int ID;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct OutSimPack
        {
            public uint Time;
            public LFS_External.Packets.VectorF AngVel;
            public float Heading;
            public float Pitch;
            public float Roll;
            public LFS_External.Packets.VectorF Accel;
            public LFS_External.Packets.VectorF Vel;
            public LFS_External.Packets.VectorI Pos;
            public int ID;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct VectorF
        {
            public float X;
            public float Y;
            public float Z;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct VectorI
        {
            public int X;
            public int Y;
            public int Z;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct CarContact // Info about one car in a contact - two of these in the IS_CON (below)
        {
            public byte PLID;
            public LFS_External.InSim.Flags.CompCarFlags Info;		// like Info byte in CompCar (CCI_BLUE / CCI_YELLOW / CCI_LAG)
            public byte Sp2;		// spare
            public sbyte Steer;		// front wheel steer in degrees (right positive)

            public byte ThrBrk;		// high 4 bits : throttle    / low 4 bits : brake (0 to 15)
            public byte CluHan;		// high 4 bits : clutch      / low 4 bits : handbrake (0 to 15)
            public byte GearSp;		// high 4 bits : gear (15=R) / low 4 bits : spare
            public byte Speed;		// m/s

            public byte Direction;	// car's motion if Speed > 0 : 0 = world y direction, 128 = 180 deg
            public byte Heading;	// direction of forward axis : 0 = world y direction, 128 = 180 deg
            public sbyte AccelF;		// m/s^2 longitudinal acceleration (forward positive)
            public sbyte AccelR;		// m/s^2 lateral acceleration (right positive)

            public short X;			// position (1 metre = 16)
            public short Y;			// position (1 metre = 16)
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct IS_CON // CONtact - between two cars (A and B are sorted by PLID)
        {
            public byte Size;		// 40
            public byte Type;		// ISP_CON
            public byte ReqI;		// 0
            public byte Zero;

            public ushort SpClose;	// high 4 bits : reserved / low 12 bits : closing speed (10 = 1 m/s)
            public ushort Time;		// looping time stamp (hundredths - time since reset - like TINY_GTH)

            public CarContact A;
            public CarContact B;
        }
    }
}

