﻿namespace LFS_External
{
    using System;
    using System.Diagnostics;
    using System.Net;
    using System.Net.Sockets;
    using System.Threading;

    public abstract class TCPListener
    {
        private string _address = "isrelay.lfs.net";
        private IPEndPoint _ep;
        private bool _exit = false;
        private ushort _port = 0xb972;
        private enuState _state = enuState.Closed;
        private Thread _trdlisten;
        private const int BUFFERSIZE = 0x200;
        private Socket Client;

        public TCPListener(string address, ushort port)
        {
            this._address = address;
            this._port = port;
        }

        public void Close()
        {
            this._exit = true;
            this.Client.Shutdown(SocketShutdown.Both);
        }

        public void Connect()
        {
            try
            {
                IPAddress address;
                if (IPAddress.TryParse(this._address, out address))
                {
                }
                this.Client = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
                this.Client.Connect(this._ep);
                this._state = enuState.Connected;
                this._trdlisten = new Thread(new ThreadStart(this.TCPListen));
                this._trdlisten.Start();
            }
            catch (Exception exception)
            {
                Debug.WriteLine(exception.Message);
            }
        }

        public abstract void DataArrival(ref byte[] packet);
        private void Send(byte[] Packet)
        {
            if (this._state == enuState.Connected)
            {
                this.Client.Send(Packet);
            }
        }

        private void TCPListen()
        {
            byte[] buffer = new byte[0x200];
            byte[] destinationArray = new byte[0];
            int num = 0;
            int length = 0;
            int index = 0;
            int num4 = 0;
            int destinationIndex = 0;
            int num6 = 0;
            int sourceIndex = 0;
            int num8 = 1;
            bool flag = false;
            bool flag2 = false;
            bool flag3 = false;
            while (!this._exit)
            {
                if (!flag3)
                {
                    num = this.Client.Receive(buffer);
                }
                if (num <= 0)
                {
                    break;
                }
                if (!flag)
                {
                    length = buffer[index];
                }
                if (flag || ((num - index) < length))
                {
                    if (num8 == 1)
                    {
                        flag = true;
                        num6 = length;
                        sourceIndex = index;
                        num4 = num - index;
                        flag3 = false;
                        destinationIndex = 0;
                        destinationArray = new byte[length];
                    }
                    else
                    {
                        if (num6 > num)
                        {
                            num4 = num;
                        }
                        else
                        {
                            num4 = num6;
                        }
                        sourceIndex = 0;
                    }
                    num6 -= num4;
                    if (num6 == 0)
                    {
                        flag2 = true;
                        flag = false;
                        num8 = 1;
                    }
                    else
                    {
                        flag2 = false;
                        num8++;
                    }
                    Array.Copy(buffer, sourceIndex, destinationArray, destinationIndex, num4);
                    destinationIndex += num4;
                    if (flag2)
                    {
                        if ((num - num4) > 0)
                        {
                            flag3 = true;
                            index = num4;
                        }
                        else
                        {
                            flag3 = false;
                            index = 0;
                        }
                        this.DataArrival(ref destinationArray);
                    }
                }
                else
                {
                    destinationArray = new byte[length];
                    Array.Copy(buffer, index, destinationArray, 0, length);
                    if ((num - (length + index)) > 0)
                    {
                        flag3 = true;
                        index += length;
                    }
                    else
                    {
                        flag3 = false;
                        index = 0;
                    }
                    this.DataArrival(ref destinationArray);
                }
            }
        }

        public enuState State
        {
            get
            {
                return this._state;
            }
        }

        public enum enuState
        {
            Closed,
            Connected,
            ConnectionLost
        }
    }
}

