####	RACE CONTROL SYSTEM (V1.7)
####	==========================
####
####	For LFSLapper
####
####	Tested with V6.011 and V6.012
####
####	by Sinanju
####
####	(from an idea suggested by Jonathon.provost)
####
#########################################################################################
# Ver 0.1 - 27 April 2011 - Initial workup
# Ver 1.5 - 17 May 2011 - Put in proper Penalties section
# Ver 1.6 - 19 May 2011 - Put in button to clear penalties
# Ver 1.7 - 20 May 2011 - Added 'Pit_all' and 'Pitlane $nickname' into both Penalties and Pitlane Options sections
#########################################################################################
# To Do: Maybe option of "remembering" if Pit Hud stays on/off depending on last used
#########################################################################################
# LFS TeamChat v1.01 by Krayy
# LFS !pm chat by Fire_optikz001 (and a variation of which was used to code penalties section)
#########################################################################################

CatchEvent OnLapperStart()

### Set initial dialog coordinates & size for buttons and labels ###
### Change the first 2 numbers if you want the Race Control Menu in different location

	GlobalVar $RCMorigL; $RCMorigL = 34;           # Left edge of main content window / button / label
	GlobalVar $RCMorigT; $RCMorigT = 49;           # Top edge of window / button / label
	GlobalVar $RCMWidth; $RCMWidth = 24;           # Width of Dialog box / window / button / label
	GlobalVar $RCMHeight; $RCMHeight = 5;          # ...height of row of text
	GlobalVar $RCMspacing; $RCMspacing = 5;        # ...height of spacing between text
	GlobalVar $RCMtime; $RCMtime = 6;              # display button for how many seconds (-1 = permanent)

### Change the first 2 numbers if you want the HUD in different location

	GlobalVar $HUDorigL; $HUDorigL = 57;           # Left edge of main content window / button / label
	GlobalVar $HUDorigT; $HUDorigT = 0;            # Top edge of window / button / label
	GlobalVar $HUDWidth; $HUDWidth = 2;            # Width of Dialog box / window / button / label
	GlobalVar $HUDHeight; $HUDHeight = 4;          # ...height of row of text
	GlobalVar $HUDspacing; $HUDspacing = 1;        # ...height of spacing between text
	GlobalVar $HUDtime; $HUDtime = -1;             # display button for how many seconds (-1 = permanent)
	GlobalVar $HUDtime_alt; $HUDtime_alt = 5;      # display button for how many seconds

### This bit needed to switch HUD off or on
	GlobalVar $HUDoffon; $HUDoffon = "on";         # switched on as standard - has to be switched off

# Set TeamChat globals
	GlobalVar $tcDelimiterStart;
	GlobalVar $tcDelimiterEnd;
	
# Set the inital values to be square brackets (as used in team names) - change if team uses something else
	$tcDelimiterStart = "[";
	$tcDelimiterEnd = "]";
	
EndCatchEvent 


CatchEvent OnNameChange($userName,$oldNickName,$newNickName) # Player event
	 SetTeamName();
EndCatchEvent

CatchEvent OnMSO( $userName, $text ) # Player event
	$idxOfFirstSpace = indexOf( $text, " ");
	IF( $idxOfFirstSpace == -1 )
	THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirstSpace );
	  $argv = trim( subStr( $text,$idxOfFirstSpace ) );
	ENDIF

	SWITCH ( $command )
		CASE "!rc":  #	Words/Text needed to start Race Control Menu
		CASE "!RC":
		CASE "!rcm":
		CASE "!RCM":    		
		CASE "!racecontrol":
		CASE "!RACECONTROL":
			DoRCM(0,0);
		BREAK;
		
		CASE "!tc":
			TeamChat($argv);
   		BREAK;		
		
CASE "!pm":
	IF( $argv != "" )   THEN
		$idxSpace = indexOf( $argv, " ");
	IF( $idxSpace != -1 ) THEN
		$toUser = subStr( $argv,0,$idxSpace );
		$argv = trim( subStr( $argv,$idxSpace ) );
			privMsg ( "^6Private Admin message ^8" . GetPlayerVar( $toUser , "Nickname" )  );
			privMsg ( "^7" . $argv );
			userMsg (GetCurrentPlayerVar( "Nickname" ), $toUser, $argv);
	ELSE
		privMsg ( "^7Use format ^2!pm <username> <message>" );
		privMsg ( "^7(for instance ^2!pm sinanju Hello^7)" );
	ENDIF
	ELSE
		privMsg ( "^7Use format ^2!pm <username> <message>" );
	ENDIF
BREAK; 		
		
	ENDSWITCH
EndCatchEvent
            
Sub SetTeamName ( )
	$NickName = GetCurrentPlayerVar("NickName");
	$NickStrip = StripLFSColor( ToLower($NickName) );  
	$IdxStart = indexOf( $NickStrip , $tcDelimiterStart);  
	$IdxEnd = indexOf( $NickStrip , $tcDelimiterEnd);  

	IF ( $IdxStart == -1 || $IdxEnd == -1 )
	THEN
		$MyTeam = "";
	ELSE
	IF ( $IdxStart > $IdxEnd )
	THEN
		$MyTeam = "";
	ELSE
		$MyTeam = subStr( $NickStrip ,$IdxStart + 1, ($IdxEnd - $IdxStart) - 1  );
	ENDIF
	ENDIF
	
	IF ( $MyTeam == "" )
	THEN
		privMsg ("^7I am unable to find a valid Team Name in your NickName...");
		privMsg ("^7A Team name should be bracketed with a ^3" . $tcDelimiterStart . "^7 and a ^3" . $tcDelimiterEnd);
	ELSE
		privMsg ("^7Your nickame shows that you are in Team: ^3" . $MyTeam);
	ENDIF
	SetCurrentPlayerVar("TeamName",$MyTeam);
EndSub

Sub TeamChat ( $msg )
	$NickName = GetCurrentPlayerVar("NickName");
	$MyTeam = GetCurrentPlayerVar("TeamName");
	IF ( $MyTeam != "" )
	THEN
		$lop = GetListOfPlayers("N");
		FOREACH ( $de in $lop )
			$userName = $de["value"];
			IF ( GetPlayerVar($userName,"TeamName") == $MyTeam )
			THEN
				privMsg ( $userName, "^5TeamChat from ^8" . $NickName . "^5: ^8");
				privMsg ( $userName, "^6" . $msg );
			ENDIF
		ENDFOREACH
	ELSE
		privMsg ("You must have your Team name in your Nick to use TeamChat!");
	ENDIF
EndSub

Sub DoRCM( $KeyFlags,$id )
	closePrivButton ("rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu&rcm_back&rcm_options&rcm_global&rcm_privrcm&rcm_globrcm&rcm_teammsg&rcm_privmsg&rcm_penclear&rcm_pexclear");
	closePrivButton ("rcm_track_greenflag&rcm_track_yellowflag&rcm_track_blueflag&flag&rcm_track_safetycar&rcm_track_redflag&rcm_track_qualyprogress&rcm_track_raceprogress&rcm_goback&rcm_track_cheqflag");
	closePrivButton ("rcm_pitoptions&rcm_penopen&rcm_penclosed&rcm_pexopen&rcm_pexclosed&rcm_serverrcm&rcm_standardrcm&rcm_mestext&rcm_tracktext&rcm_trackflags&rcm_trackflagsback");
	closePrivButton ("rcm_smessage1&rcm_smessage2&rcm_smessage3&rcm_smessage4&rcm_smessage5&rcm_message1&rcm_message2&rcm_message3&rcm_message4&rcm_message5&rcm_trackprogback&rcm_trackprogress");
	closePrivButton ("rcm_smess1&rcm_smess2&rcm_smess3&rcm_smess4&rcm_smess5&rcm_mess1&rcm_mess2&rcm_mess3&rcm_mess4&rcm_mess5rcm_servtext&rcm_stantext&rcm_pithudtext&hud_message");
	closePrivButton ("rcm_pitdisplay&rcm_pithudmess&rcm_pithudback&rcm_pithudmess&rcm_pithudon&rcm_pithudoff&rcm_goback&rcm_closemenu&rcm_pentext&rcm_penmess&rcm_pitlaneopt");
	closePrivButton ("rcm_penalty&rcm_30pen&rcm_45pen&rcm_dtpen&rcm_sgpen&rcm_specpen&rcm_kickpen&rcm_banpen&rcm_unbanpen&rcm_goback&rcm_closemenu&rcm_penquery&rcm_closepenmess&rcm_clearpen" );
	closePrivButton ("rcm_penquery&rcm_closebanmess&rcm_ban&rcm_ban12&rcm_ban1&rcm_ban7&rcm_ban30&rcm_ban90&rcm_ban999&rcm_goback&rcm_closemenu&rcm_penqueryback&rcm_banlenback");	
	closePrivButton ("rcm_penalty&rcm_drivpenmessback&rcm_drivpenmessage&rcm_banpenmessback&rcm_banpenmessage&rcm_pitpenmessback&rcm_pitpenmessage&rcm_pitlaneback&rcm_banlentext");
	closePrivButton ("rcm_pitpenallmessage&rcm_pitpenonemessback&rcm_pitpenonemessage&rcm_pitqueryback&rcm_pitquery&rcm_pitqueryyes&rcm_pitqueryno&rcm_penaltype" );
	closePrivButton ("rcm_pitpenonemessage&rcm_penqueryback&rcm_pitqueryone&rcm_closepitquery&&rcm_pitpenalty&rcm_pitlaneback&rcm_drivtimetext&rcm_drivothertext");
	closePrivButton ("rcm_pitreturnback&rcm_pitlanetext&rcm_pitreturntext&rcm_pitlaneenmess&rcm_pitlanexmess&rcm_pitreturnall&rcm_pitreturnone&rcm_drivpitstext");
                                                                                                                                                                    
	IF ( UserIsAdmin( $userName ) == 1 )
	THEN
	
	openGlobalButton( "hud_message",73,1,52,5,4,8,0,langEngine( "%{hud_openrcm}%" ) );	
	
	openPrivButton( "rcm_back",$RCMorigL,$RCMorigT,$RCMWidth+2,$RCMHeight+34,$RCMspacing+1,-1,16,"" );
	openPrivButton( "rcm_front",$RCMorigL+1,$RCMorigT+2,$RCMWidth,$RCMHeight+29,$RCMspacing+1,-1,32,"" );
	openPrivButton( "rcm_menu",$RCMorigL+1,$RCMorigT+4,$RCMWidth,$RCMHeight+3,$RCMspacing+1,-1,0, langEngine( "%{rcm_menu}%"));
	openPrivButton( "rcm_by",$RCMorigL+1,$RCMorigT+17,$RCMWidth,$RCMHeight-1,$RCMspacing,2,0, langEngine( "%{rcm_by}%"));
	openPrivButton( "rcm_menumanager",$RCMorigL+1,$RCMorigT+22,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_menumanager}%"),DoRCmenu);	
	openPrivButton( "rcm_closemenu",$RCMorigL+1,$RCMorigT+29,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_closemenu}%"),DoRCclosemenu );
  	ELSE
	privMsg( langEngine( "%{rcm_notrcadmin}%" ) );
	ENDIF
EndSub
     
Sub DoRCclosemenu( $KeyFlags,$id )
	closePrivButton ("rcm_back&rcm_front&rcm_menu&rcm_menumanager&rcm_closemenu");
EndSub
     
Sub DoRCmenu( $KeyFlags,$id )
	closePrivButton ("rcm_menu&rcm_front&rcm_menumanager&rcm_closemenu&rcm_pentext&rcm_penmess&rcm_mestext&rcm_tracktext&rcm_trackflags&rcm_trackflagsback&rcm_privrcm&rcm_penclear&rcm_pexclear");
	closePrivButton ("rcm_track_greenflag&rcm_track_safetycar&rcm_track_redflag&rcm_track_qualyprogress&rcm_track_raceprogress&rcm_track_cheqflag&rcm_trackprogback&rcm_trackprogress");
	closePrivButton ("rcm_pitoptions&rcm_penopen&rcm_penclosed&rcm_pexopen&rcm_pexclosed&rcm_serverrcm&rcm_standardrcm&rcm_privmsg&rcm_teammsg&rcm_globrcm&rcm_track_yellowflag&rcm_track_blueflag");
	closePrivButton ("rcm_smess1&rcm_smess2&rcm_smess3&rcm_smess4&rcm_smess5&rcm_mess1&rcm_mess2&rcm_mess3&rcm_mess4&rcm_mess5&rcm_servtext&rcm_stantext&rcm_pithudtext&rcm_options");
	closePrivButton ("rcm_smessage1&rcm_smessage2&rcm_smessage3&rcm_smessage4&rcm_smessage5&rcm_message1&rcm_message2&rcm_message3&rcm_message4&rcm_message5&rcm_pitdisplay");
	closePrivButton ("rcm_pithudmess&rcm_pithudback&rcm_pithudmess&rcm_pithudon&rcm_pithudoff&rcm_goback&rcm_closemenu&rcm_penquery&rcm_closepenmess&rcm_pitlaneopt");
	closePrivButton ("rcm_penalty&rcm_30pen&rcm_45pen&rcm_dtpen&rcm_sgpen&rcm_specpen&rcm_kickpen&rcm_banpen&rcm_unbanpen&rcm_goback&rcm_closemenu&rcm_clearpen" );
	closePrivButton ("rcm_penquery&rcm_closebanmess&rcm_ban&rcm_ban12&rcm_ban1&rcm_ban7&rcm_ban30&rcm_ban90&rcm_ban999&rcm_goback&rcm_closemenu&rcm_penqueryback");		
	closePrivButton ("rcm_penalty&rcm_drivpenmessback&rcm_drivpenmessage&rcm_banpenmessback&rcm_banpenmessage&rcm_pitpenmessback&rcm_pitpenmessage&rcm_pitlaneback");
	closePrivButton ("rcm_pitreturnback&rcm_pitlanetext&rcm_pitreturntext&rcm_pitlaneenmess&rcm_pitlanexmess&rcm_pitreturnall&rcm_pitreturnone");
  	
	openPrivButton( "rcm_options",$RCMorigL+1,$RCMorigT+1,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,0, langEngine( "%{rcm_options}%") );
	openPrivButton( "rcm_messages",$RCMorigL+1,$RCMorigT+8,$RCMWidth,$RCMHeight,$RCMspacing+1,-1,32, langEngine( "%{rcm_messages}%"),DoRCmessages );
	openPrivButton( "rcm_track",$RCMorigL+1,$RCMorigT+13,$RCMWidth,$RCMHeight,$RCMspacing+1,-1,32, langEngine( "%{rcm_track}%"),DoRCtrack );
	openPrivButton( "rcm_pitlaneopt", $RCMorigL+1,$RCMorigT+18,$RCMWidth,$RCMHeight,$RCMspacing+1,-1,32, langEngine( "%{rcm_pitlaneopt}%"),DoRCpitlane );
	openPrivButton( "rcm_pitdisplay",$RCMorigL+1,$RCMorigT+23,$RCMWidth,$RCMHeight,$RCMspacing+1,-1,32, langEngine( "%{rcm_pithud}%"),DoRCpithud );	
	openPrivButton( "rcm_penalties",$RCMorigL+1,$RCMorigT+28,$RCMWidth,$RCMHeight,$RCMspacing+1,-1,32, langEngine( "%{rcm_penalties}%"),DoRCPenalties );
	openPrivButton( "rcm_closemenu",$RCMorigL+1,$RCMorigT+33,$RCMWidth,$RCMHeight,$RCMspacing+1,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );
EndSub

Sub DoRCpithud( $KeyFlags,$id )
	closePrivButton ("rcm_pitdisplay&rcm_options&rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu&rcm_options&rcm_pitlaneopt");

	openPrivButton( "rcm_pithudtext",$RCMorigL+1,$RCMorigT+1,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,0, langEngine( "%{rcm_pittext}%") );
	openPrivButton( "rcm_pithudback",$RCMorigL+1,$RCMorigT+8,24,$RCMHeight+19,$RCMspacing,-1,32,"" );		
	openPrivButton( "rcm_pithudmess",$RCMorigL+1,$RCMorigT+9,$RCMWidth,$RCMHeight+1,$RCMspacing,-1,0, langEngine( "%{rcm_pitmess}%") );
	openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCmenu );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );
	
IF ( $HUDoffon == "on" )
THEN
	openPrivButton( "rcm_pithudon",$RCMorigL+2,$RCMorigT+25,$RCMWidth-13,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_pithudonalt}%"),DoRCpithudon );
	openPrivButton( "rcm_pithudoff",$RCMorigL+13,$RCMorigT+25,$RCMWidth-13,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_pithudoff}%"),DoRCpithudoff );	
ELSE
	openPrivButton( "rcm_pithudon",$RCMorigL+2,$RCMorigT+25,$RCMWidth-13,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_pithudon}%"),DoRCpithudon );
	openPrivButton( "rcm_pithudoff",$RCMorigL+13,$RCMorigT+25,$RCMWidth-13,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_pithudoffalt}%"),DoRCpithudoff );
ENDIF
EndSub

Sub DoRCmessages( $KeyFlags,$id )
	closePrivButton ("rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu&rcm_options&rcm_trackprogback&rcm_trackprogress&rcm_pitdisplay&rcm_pitlaneopt");
	closePrivButton ("rcm_mestext&rcm_tracktext&rcm_trackflags&rcm_trackflagsback&rcm_privrcm&rcm_globrcm&rcm_serverrcm&rcm_standardrcm&rcm_privmsg&rcm_teammsg");
	closePrivButton ("rcm_smess1&rcm_smess2&rcm_smess3&rcm_smess4&rcm_smess5&rcm_mess1&rcm_mess2&rcm_mess3&rcm_mess4&rcm_mess5&rcm_servtext&rcm_stantext");
	closePrivButton ("rcm_smessage1&rcm_smessage2&rcm_smessage3&rcm_smessage4&rcm_smessage5&rcm_message1&rcm_message2&rcm_message3&rcm_message4&rcm_message5");	

	openPrivButton( "rcm_mestext",$RCMorigL+1,$RCMorigT+1,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,0, langEngine( "%{rcm_mestext}%") );
	openPrivButton( "rcm_privmsg",$RCMorigL+1,$RCMorigT+8,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,32, langEngine( "%{rcm_privmsg}%"),DoRCprivmsg );
	openPrivButton( "rcm_teammsg",$RCMorigL+1,$RCMorigT+12,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,32, langEngine( "%{rcm_teammsg}%"),DoRCteammsg );
 	openPrivButton( "rcm_privrcm",$RCMorigL+1,$RCMorigT+16,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,32, langEngine( "%{rcm_privrcm}%"),DoRCprivrcm );
	openPrivButton( "rcm_globrcm",$RCMorigL+1,$RCMorigT+20,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,32, langEngine( "%{rcm_globrcm}%"),DoRCglobrcm );
	openPrivButton( "rcm_serverrcm",$RCMorigL+1,$RCMorigT+24,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,32, langEngine( "%{rcm_serverrcm}%"),DoRCserverrcm);
	openPrivButton( "rcm_standardrcm",$RCMorigL+1,$RCMorigT+28,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,32, langEngine( "%{rcm_standardrcm}%"),DoRCstandardrcm );
	openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCmenu );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );	
EndSub

Sub DoRCtrack( $KeyFlags,$id )
	closePrivButton ("rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu&rcm_options&rcm_pitdisplay&rcm_pitlaneopt");
	
	openPrivButton( "rcm_tracktext",$RCMorigL+1,$RCMorigT+1,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,0, langEngine( "%{rcm_tracktext}%"));
	openPrivButton( "rcm_trackflagsback",$RCMorigL+1,$RCMorigT+7,$RCMWidth,$RCMHeight+12,$RCMspacing+1,-1,32,"");	
	openPrivButton( "rcm_trackflags",$RCMorigL+1,$RCMorigT+7,$RCMWidth,$RCMHeight-1,$RCMspacing,-1,0, langEngine( "%{rcm_trackflags}%"));
	openPrivButton( "rcm_track_yellowflag",$RCMorigL+2,$RCMorigT+11,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_yellowflag}%"),DoRCyellowflag );	
	openPrivButton( "rcm_track_greenflag",$RCMorigL+13,$RCMorigT+11,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_greenflag}%"),DoRCgreenflag );
	openPrivButton( "rcm_track_blueflag",$RCMorigL+2,$RCMorigT+15,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_blueflag}%"),DoRCblueflag );	
	openPrivButton( "rcm_track_redflag",$RCMorigL+13,$RCMorigT+15,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_redflag}%"),DoRCredflag );	
	openPrivButton( "rcm_track_safetycar",$RCMorigL+2,$RCMorigT+19,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_safetycar}%"),DoRCsafetycar );  	
	openPrivButton( "rcm_track_cheqflag",$RCMorigL+13,$RCMorigT+19,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_cheqflag}%"),DoRCcheqflag );
	openPrivButton( "rcm_trackprogback",$RCMorigL+1,$RCMorigT+24,$RCMWidth,$RCMHeight+4,$RCMspacing+1,-1,32,"");	
	openPrivButton( "rcm_trackprogress",$RCMorigL+1,$RCMorigT+24,$RCMWidth,$RCMHeight-1,$RCMspacing,-1,0, langEngine( "%{rcm_trackprogress}%"));
	openPrivButton( "rcm_track_qualyprogress",$RCMorigL+2,$RCMorigT+28,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_qualyprogress}%"),DoRCqualy );
	openPrivButton( "rcm_track_raceprogress",$RCMorigL+13,$RCMorigT+28,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_raceprogress}%"),DoRCrace );
	openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCmenu );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );
EndSub


# Pit HUD Off/On

Sub DoRCpithudon( $KeyFlags,$id )
	closePrivButton ("rcm_pitdisplay");
	$HUDoffon = "on";

	openPrivButton( "rcm_pithudon",$RCMorigL+2,$RCMorigT+25,$RCMWidth-13,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_pithudonalt}%"),DoRCpithudon ); 
	openPrivButton( "rcm_pithudoff",$RCMorigL+13,$RCMorigT+25,$RCMWidth-13,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_pithudoff}%"),DoRCpithudoff );	
  openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCmenu );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );
	openPrivButton( "hud_penback",$HUDorigL,$HUDorigT,$HUDWidth+11,$HUDHeight+6,$HUDspacing,$HUDtime,32,"");
	openPrivButton( "hud_pentext",$HUDorigL,$HUDorigT,$HUDWidth+11,$HUDHeight,$HUDspacing+4,$HUDtime,0,langEngine("%{hud_pentext}%"));
	openPrivButton( "hud_penfront",$HUDorigL+1,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,"");	
	openPrivButton( "hud_pexback",$HUDorigL+73,$HUDorigT,$HUDWidth+11,$HUDHeight+6,$HUDspacing,$HUDtime,32,"");
	openPrivButton( "hud_pextext",$HUDorigL+73,$HUDorigT,$HUDWidth+11,$HUDHeight,$HUDspacing+4,$HUDtime,0,langEngine("%{hud_pextext}%"));	
	openPrivButton( "hud_pexfront",$HUDorigL+74,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,"");
EndSub

Sub DoRCpithudoff( $KeyFlags,$id )
	$HUDoffon = "off";
	closePrivButton ("rcm_pitdisplay");
	openPrivButton( "rcm_pithudon",$RCMorigL+2,$RCMorigT+25,$RCMWidth-13,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_pithudon}%"),DoRCpithudon );                                 
	openPrivButton( "rcm_pithudoff",$RCMorigL+13,$RCMorigT+25,$RCMWidth-13,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_pithudoffalt}%"),DoRCpithudoff );
	openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCmenu );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );	
	closePrivButton ("hud_penstatus&hud_pexstatus&hud_penback&hud_pentext&hud_penfront&hud_pexback&hud_pextext&hud_pexfront");	
  		
EndSub


# Messaging Section
###################

Sub DoRCprivrcm( $KeyFlags,$id )
	openPrivTextButton( "rcm_priv",70,70,80,7,20,32,"Admin Message","^7please click here to open chat window",90,GoRCMprivate );
	openPrivButton( "rcm_closeprivbrcm",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCcloseprivrdm );
EndSub
 
Sub GoRCMprivate( $Admin Message,$text )
	closePrivButton ("rcm_priv&rcm_closeprivbrcm&rcm_global&rcm_closeglobrcm");
	privMsg( "^1Admin Message: ^6" . $text );
EndSub

Sub DoRCcloseprivrdm( $KeyFlags,$id )
	closePrivButton ("rcm_priv&rcm_closeprivbrcm&rcm_global&rcm_closeglobrcm");
EndSub

Sub DoRCprivmsg( $KeyFlags,$id )
	openPrivButton( "rcm_instruct",80,70,60,6,5,-1,32, langEngine( "%{rcm_instruct}%"));
	openPrivButton( "rcm_privmsginst",80,76,60,6,5,-1,32, langEngine( "%{rcm_privmsginst}%"));
	openPrivButton( "rcm_closeinstruct",104,98,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCcloseinstruct );
EndSub

Sub DoRCteammsg( $KeyFlags,$id )
	openPrivButton( "rcm_instruct",80,70,60,6,5,-1,32, langEngine( "%{rcm_instruct}%"));
	openPrivButton( "rcm_teammsginst",80,76,60,5,4,-1,32, langEngine( "%{rcm_teammsginst}%"));
	openPrivButton( "rcm_closeinstruct",104,108,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCcloseinstruct );
EndSub

Sub DoRCcloseinstruct( $KeyFlags,$id )
	closePrivButton ("rcm_instruct&rcm_closeinstruct&rcm_privmsginst&rcm_teammsginst");
EndSub
      
Sub DoRCglobrcm( $KeyFlags,$id )
	openPrivTextButton( "rcm_global",70,70,80,7,20,32,"Admin Message","^7please click here to open chat window",90,GoRCMglobal );
	openPrivButton( "rcm_closeglobrcm",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCcloseglobrdm );
EndSub
 
Sub GoRCMglobal( $Admin Message,$text )
	closePrivButton ("rcm_priv&rcm_closeprivbrcm&rcm_global&rcm_closeglobrcm");
	GlobalRcm( "^1Admin: ^6" . $text );
EndSub

Sub DoRCcloseglobrdm( $KeyFlags,$id )
	closePrivButton ("rcm_priv&rcm_closeprivbrcm&rcm_global&rcm_closeglobrcm");
EndSub

Sub DoRCserverrcm( $KeyFlags,$id )
	closePrivButton ("rcm_menu&rcm_front&rcm_menumanager&rcm_closemenu&rcm_pentext&rcm_penmess&rcm_mestext&rcm_tracktext&rcm_trackflags&rcm_trackflagsback&rcm_privrcm&rcm_globrcm");
	closePrivButton ("rcm_mestext&rcm_tracktext&rcm_trackflags&rcm_trackflagsback&rcm_privrcm&rcm_globrcm&rcm_serverrcm&rcm_standardrcm&rcm_privmsg&rcm_teammsg&rcm_trackprogback&rcm_trackprogress");
	openPrivButton( "rcm_servtext",$RCMorigL+1,$RCMorigT+1,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,0, langEngine( "%{rcm_servtext}%") );
	openPrivButton( "rcm_smessage1",$RCMorigL+1,$RCMorigT+7,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_smessage1}%"),DoRCsmess1 );
	openPrivButton( "rcm_smessage2",$RCMorigL+1,$RCMorigT+12,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_smessage2}%"),DoRCsmess2 );
	openPrivButton( "rcm_smessage3",$RCMorigL+1,$RCMorigT+17,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_smessage3}%"),DoRCsmess3 );
	openPrivButton( "rcm_smessage4",$RCMorigL+1,$RCMorigT+22,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_smessage4}%"),DoRCsmess4 );
	openPrivButton( "rcm_smessage5",$RCMorigL+1,$RCMorigT+27,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_smessage5}%"),DoRCsmess5 );
	openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCmessages );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );	
EndSub

Sub DoRCstandardrcm( $KeyFlags,$id )
	closePrivButton ("rcm_menu&rcm_front&rcm_menumanager&rcm_closemenu&rcm_pentext&rcm_penmess&rcm_mestext&rcm_tracktext&rcm_trackflags&rcm_trackflagsback&rcm_privrcm&rcm_globrcm");
	closePrivButton ("rcm_mestext&rcm_tracktext&rcm_trackflags&rcm_trackflagsback&rcm_privrcm&rcm_globrcm&rcm_serverrcm&rcm_standardrcm&rcm_privmsg&rcm_teammsg&rcm_trackprogback&rcm_trackprogress");
	openPrivButton( "rcm_stantext",$RCMorigL+1,$RCMorigT+1,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,0, langEngine( "%{rcm_stantext}%") );
	openPrivButton( "rcm_message1",$RCMorigL+1,$RCMorigT+7,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_message1}%"),DoRCmess1 );
	openPrivButton( "rcm_message2",$RCMorigL+1,$RCMorigT+12,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_message2}%"),DoRCmess2 );
	openPrivButton( "rcm_message3",$RCMorigL+1,$RCMorigT+17,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_message3}%"),DoRCmess3 );
	openPrivButton( "rcm_message4",$RCMorigL+1,$RCMorigT+22,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_message4}%"),DoRCmess4 );
	openPrivButton( "rcm_message5",$RCMorigL+1,$RCMorigT+27,$RCMWidth,$RCMHeight,$RCMspacing,-1,32, langEngine( "%{rcm_message5}%"),DoRCmess5 );
	openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCmessages );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );	
EndSub
 
Sub DoRCsmess1( $KeyFlags,$id )
	$Host = getLapperVar( "HostName" );
	closePrivButton ("rcm_smess&rcm_mess");
	openPrivButton( "rcm_smess",80,60,60,6,5,5,32, langEngine( "%{rcm_smess1}%"),$Host);
EndSub

Sub DoRCsmess2( $KeyFlags,$id )
	closePrivButton ("rcm_smess&rcm_mess");
	openPrivButton( "rcm_smess",80,60,60,6,5,5,32, langEngine( "%{rcm_smess2}%"));
EndSub

Sub DoRCsmess3( $KeyFlags,$id )
	closePrivButton ("rcm_smess&rcm_mess");
	openPrivButton( "rcm_smess",80,60,60,6,5,5,32, langEngine( "%{rcm_smess3}%"));
EndSub

Sub DoRCsmess4( $KeyFlags,$id )
	closePrivButton ("rcm_smess&rcm_mess");
	openPrivButton( "rcm_smess",80,60,60,6,5,5,32, langEngine( "%{rcm_smess4}%"));
EndSub

Sub DoRCsmess5( $KeyFlags,$id )
	closePrivButton ("rcm_smess&rcm_mess");
	openPrivButton( "rcm_smess",80,60,60,6,5,5,32, langEngine( "%{rcm_smess5}%"));
EndSub
  
Sub DoRCmess1( $KeyFlags,$id )
	closePrivButton ("rcm_smess&rcm_mess");
	openPrivButton( "rcm_smess",80,60,60,6,5,5,32, langEngine( "%{rcm_mess1}%"));
EndSub

Sub DoRCmess2( $KeyFlags,$id )
	closePrivButton ("rcm_smess&rcm_mess");
	openPrivButton( "rcm_smess",80,60,60,6,5,5,32, langEngine( "%{rcm_mess2}%"));
EndSub

Sub DoRCmess3( $KeyFlags,$id )
	closePrivButton ("rcm_smess&rcm_mess");
	openPrivButton( "rcm_smess",80,60,60,6,5,5,32, langEngine( "%{rcm_mess3}%"));
EndSub

Sub DoRCmess4( $KeyFlags,$id )
	closePrivButton ("rcm_smess&rcm_mess");
	openPrivButton( "rcm_smess",80,60,60,6,5,5,32, langEngine( "%{rcm_mess4}%"));
EndSub

Sub DoRCmess5( $KeyFlags,$id )
	closePrivButton ("rcm_smess&rcm_mess");
	openPrivButton( "rcm_smess",80,60,60,6,5,5,32, langEngine( "%{rcm_mess5}%"));
EndSub


# Track Conditions Section
##########################

Sub DoRCgreenflag( $KeyFlags,$id )
	closeGlobalButton ("rcm_backflag&rcm_contrast&rcm_contrast2&rcm_bl_bsr1&rcm_bl_bsr2&rcm_bl_bsr3&rcm_bl_bsr4&rcm_bl_bsr5&rcm_bl_bsr6&rcm_bl_bsr7&rcm_bl_bsr8&rcm_bl_bsr9&rcm_bl_bsr0");
	closeGlobalButton ("hud_trackstatus&hud_pexstatus&hud_blinkleft&hud_blinkleft1&&hud_blinkleft2&&hud_blinkleft3&&hud_blinkleft4&&hud_blinkleft5&hud_message");
	closeGlobalButton ("hud_blinkright&hud_blinkright1&hud_blinkright2&hud_blinkright3&hud_blinkright4&hud_blinkright5");
	globalRcm( langEngine( "%{hud_greenmessage}%" )); 

	openGlobalButton( "hud_message",73,1,52,5,4,8,0,langEngine( "%{hud_greenmessage}%" ) );	
	openGlobalButton( "hud_blinkleft",71,1,58,5,4,8,64 + 8,langEngine( "%{hud_blink_green}%" ));
	openGlobalButton( "hud_blinkright",71,1,58,5,4,8,128 + 8,langEngine( "%{hud_blink_green}%" ));

IF ( $HUDoffon == "on" )
THEN
	openGlobalButton( "hud_penstatus",$HUDorigL+1,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusopen}%"));
	openGlobalButton( "hud_pexstatus",$HUDorigL+74,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusopen}%"));  	
ENDIF	

EndSub

Sub DoRCyellowflag( $KeyFlags,$id )
	closeGlobalButton ("rcm_backflag&rcm_contrast&rcm_contrast2&rcm_bl_bsr1&rcm_bl_bsr2&rcm_bl_bsr3&rcm_bl_bsr4&rcm_bl_bsr5&rcm_bl_bsr6&rcm_bl_bsr7&rcm_bl_bsr8&rcm_bl_bsr9&rcm_bl_bsr0");
	closeGlobalButton ("hud_trackstatus&hud_blinkleft&hud_blinkleft1&&hud_blinkleft2&&hud_blinkleft3&&hud_blinkleft4&&hud_blinkleft5&hud_message");
	closeGlobalButton ("hud_blinkright&hud_blinkright1&hud_blinkright2&hud_blinkright3&hud_blinkright4&hud_blinkright5");
	globalRcm( langEngine( "%{rcm_yellowflagmessage}%" ));
	openGlobalButton( "hud_message",73,1,52,5,4,8,0,langEngine( "%{hud_yellowmessage}%" ) );	
  openGlobalButton( "hud_blinkleft",71,1,58,5,4,8,64 + 8,langEngine( "%{hud_blink_yellow}%" ));
	openGlobalButton( "hud_blinkright",71,1,58,5,4,8,128 + 8,langEngine( "%{hud_blink_yellow}%" ));     
EndSub

Sub DoRCredflag( $KeyFlags,$id )
	closeGlobalButton ("hud_trackstatus&hud_pexstatus&hud_blinkleft&hud_blinkleft1&&hud_blinkleft2&&hud_blinkleft3&&hud_blinkleft4&&hud_blinkleft5");
	closeGlobalButton ("hud_blinkright&hud_blinkright1&hud_blinkright2&hud_blinkright3&hud_blinkright4&hud_blinkright5&hud_message");
	closeGlobalButton ("rcm_backflag&rcm_contrast&rcm_contrast2&rcm_bl_bsr1&rcm_bl_bsr2&rcm_bl_bsr3&rcm_bl_bsr4&rcm_bl_bsr5&rcm_bl_bsr6&rcm_bl_bsr7&rcm_bl_bsr8&rcm_bl_bsr9&rcm_bl_bsr0");	
	globalRcm( langEngine( "%{rcm_redflagmessage}%" ));
	openGlobalButton( "hud_message",73,1,52,5,4,8,0,langEngine( "%{hud_redmessage}%" ) );
  openGlobalButton( "hud_blinkleft",71,1,58,5,4,8,64 + 8,langEngine( "%{hud_blink_red}%" ));
	openGlobalButton( "hud_blinkright",71,1,58,5,4,8,128 + 8,langEngine( "%{hud_blink_red}%" ));
  
IF ( $HUDoffon == "on" )
THEN
	openGlobalButton( "hud_penstatus",$HUDorigL+1,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusopen}%"));
	openGlobalButton( "hud_pexstatus",$HUDorigL+74,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusclosed}%")); 	
ENDIF      
EndSub
               
Sub DoRCblueflag( $KeyFlags,$id )
	closeGlobalButton ("rcm_backflag&rcm_contrast&rcm_contrast2&rcm_bl_bsr1&rcm_bl_bsr2&rcm_bl_bsr3&rcm_bl_bsr4&rcm_bl_bsr5&rcm_bl_bsr6&rcm_bl_bsr7&rcm_bl_bsr8&rcm_bl_bsr9&rcm_bl_bsr0");
	closeGlobalButton ("hud_trackstatus&hud_blinkleft&hud_blinkleft1&&hud_blinkleft2&&hud_blinkleft3&&hud_blinkleft4&&hud_blinkleft5&hud_message");
	closeGlobalButton ("hud_blinkright&hud_blinkright1&hud_blinkright2&hud_blinkright3&hud_blinkright4&hud_blinkright5");
	globalRcm( langEngine( "%{rcm_blueflagmessage}%" ));
	openGlobalButton( "hud_message",73,1,52,5,4,8,0,langEngine( "%{hud_bluemessage}%" ) );   
  openGlobalButton( "hud_blinkleft",71,1,58,5,4,8,64 + 8,langEngine( "%{hud_blink_blue}%" ));
	openGlobalButton( "hud_blinkright",71,1,58,5,4,8,128 + 8,langEngine( "%{hud_blink_blue}%" ));      
EndSub
 
Sub DoRCsafetycar( $KeyFlags,$id )
	closeGlobalButton ("hud_trackstatus&hud_pexstatus&hud_blinkleft&hud_blinkleft1&&hud_blinkleft2&&hud_blinkleft3&&hud_blinkleft4&&hud_blinkleft5");
	closeGlobalButton ("hud_blinkright&hud_blinkright1&hud_blinkright2&hud_blinkright3&hud_blinkright4&hud_blinkright5&hud_message");
	closeGlobalButton ("rcm_backflag&rcm_contrast&rcm_contrast2&rcm_bl_bsr1&rcm_bl_bsr2&rcm_bl_bsr3&rcm_bl_bsr4&rcm_bl_bsr5&rcm_bl_bsr6&rcm_bl_bsr7&rcm_bl_bsr8&rcm_bl_bsr9&rcm_bl_bsr0");	
	globalRcm( langEngine( "%{rcm_safetycarmessage}%" ));
	openGlobalButton( "hud_message",73,1,52,5,4,8,0,langEngine( "%{hud_trackstatussafety}%" ) ); 
  openGlobalButton( "hud_blinkleft",71,1,58,5,4,8,64 + 8,langEngine( "%{hud_blink_white}%" ));
	openGlobalButton( "hud_blinkright",71,1,58,5,4,8,128 + 8,langEngine( "%{hud_blink_white}%" ));
  
IF ( $HUDoffon == "on" )
THEN
	openGlobalButton( "hud_penstatus",$HUDorigL+1,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusopen}%"));
	openGlobalButton( "hud_pexstatus",$HUDorigL+74,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusclosed}%")); 	
ENDIF  
EndSub      

Sub DoRCcheqflag( $KeyFlags,$id )
	closeGlobalButton ("hud_trackstatus&hud_pexstatus&hud_blinkleft&hud_blinkleft1&&hud_blinkleft2&&hud_blinkleft3&&hud_blinkleft4&&hud_blinkleft5");
	closeGlobalButton ("hud_blinkright&hud_blinkright1&hud_blinkright2&hud_blinkright3&hud_blinkright4&hud_blinkright5&hud_message");
	closeGlobalButton ("rcm_backflag&rcm_contrast&rcm_contrast2&rcm_bl_bsr1&rcm_bl_bsr2&rcm_bl_bsr3&rcm_bl_bsr4&rcm_bl_bsr5&rcm_bl_bsr6&rcm_bl_bsr7&rcm_bl_bsr8&rcm_bl_bsr9&rcm_bl_bsr0");	
	globalRcm( langEngine( "%{rcm_chequeredflag}%" )); 
	openGlobalButton( "rcm_backflag",92,64,15,16,1,6,32," "); # backing for whole flag
  openGlobalButton( "rcm_contrast",92,64,15,16,1,6,16," "); # backing for contrast
  openGlobalButton( "rcm_contrast2",92,64,15,16,1,6,16," "); # another layer for contrast
  openGlobalButton( "rcm_bl_bsr1",95,64,3,4,1,6,32," "); # first of little black squares on flag
  openGlobalButton( "rcm_bl_bsr2",92,68,3,4,1,6,32," ");
  openGlobalButton( "rcm_bl_bsr3",95,72,3,4,1,6,32," ");
  openGlobalButton( "rcm_bl_bsr4",92,76,3,4,1,6,32," ");
  openGlobalButton( "rcm_bl_bsr5",101,64,3,4,1,6,32," ");
  openGlobalButton( "rcm_bl_bsr6",98,68,3,4,1,6,32," ");
  openGlobalButton( "rcm_bl_bsr7",101,72,3,4,1,6,32," ");
  openGlobalButton( "rcm_bl_bsr8", 98,76,3,4,1,6,32," "); 
  openGlobalButton( "rcm_bl_bsr9",104,68,3,4,1,6,32," ");
 	openGlobalButton( "rcm_bl_bsr0",104,76,3,4,1,6,32," ");
	openGlobalButton( "hud_message",73,1,52,5,4,8,0,langEngine( "%{hud_trackstatuscheq}%" ) ); 	

	openGlobalButton( "hud_blinkleftback",$HUDorigL+12,$HUDorigT+39,$HUDWidth+2,$HUDHeight+8,$HUDspacing+1,$HUDtime_alt,16,"");	
	openGlobalButton( "hud_blinkleft",$HUDorigL+12,$HUDorigT+39,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,16,"");
	openGlobalButton( "hud_blinkleft1",$HUDorigL+14,$HUDorigT+39,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,32,"");
	openGlobalButton( "hud_blinkleft2",$HUDorigL+14,$HUDorigT+43,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,16,"");
	openGlobalButton( "hud_blinkleft3",$HUDorigL+12,$HUDorigT+43,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,32,"");  
 	openGlobalButton( "hud_blinkleft4",$HUDorigL+12,$HUDorigT+47,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,16,"");
	openGlobalButton( "hud_blinkleft5",$HUDorigL+14,$HUDorigT+47,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,32,"");
  openGlobalButton( "hud_blinkleftback",$HUDorigL+70,$HUDorigT+39,$HUDWidth+2,$HUDHeight+8,$HUDspacing+1,$HUDtime_alt,16,"");	
 	openGlobalButton( "hud_blinkright",$HUDorigL+70,$HUDorigT+39,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,16,"");
 	openGlobalButton( "hud_blinkright1",$HUDorigL+72,$HUDorigT+39,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,32,"");
	openGlobalButton( "hud_blinkright2",$HUDorigL+72,$HUDorigT+43,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,16,""); 	
	openGlobalButton( "hud_blinkright3",$HUDorigL+70,$HUDorigT+43,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,32,"");
	openGlobalButton( "hud_blinkright4",$HUDorigL+70,$HUDorigT+47,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,16,"");
	openGlobalButton( "hud_blinkright5",$HUDorigL+72,$HUDorigT+47,$HUDWidth,$HUDHeight,$HUDspacing+1,$HUDtime_alt,32,""); 
  
IF ( $HUDoffon == "on" )
THEN
	openGlobalButton( "hud_penstatus",$HUDorigL+1,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusopen}%"));
	openGlobalButton( "hud_pexstatus",$HUDorigL+74,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusopen}%"));	
ENDIF
  	 	
EndSub

Sub DoRCqualy( $KeyFlags,$id )
	closeGlobalButton ("hud_trackstatus&hud_pexstatus&hud_blinkleft&hud_blinkleft1&&hud_blinkleft2&&hud_blinkleft3&&hud_blinkleft4&&hud_blinkleft5");
	closeGlobalButton ("hud_blinkright&hud_blinkright1&hud_blinkright2&hud_blinkright3&hud_blinkright4&hud_blinkright5&hud_message");
	closeGlobalButton ("rcm_backflag&rcm_contrast&rcm_contrast2&rcm_bl_bsr1&rcm_bl_bsr2&rcm_bl_bsr3&rcm_bl_bsr4&rcm_bl_bsr5&rcm_bl_bsr6&rcm_bl_bsr7&rcm_bl_bsr8&rcm_bl_bsr9&rcm_bl_bsr0");	
	globalRcm( langEngine( "%{rcm_qualymessage}%" ));
	openGlobalButton( "hud_message",73,1,52,5,4,8,0,langEngine( "%{hud_trackstatusqualy}%" ) ); 	
	
IF ( $HUDoffon == "on" )
THEN
	openGlobalButton( "hud_pexstatus",$HUDorigL+74,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusopen}%"));	
ENDIF
	
EndSub

Sub DoRCrace( $KeyFlags,$id )
	closeGlobalButton ("hud_trackstatus&hud_pexstatus&hud_blinkleft&hud_blinkleft1&&hud_blinkleft2&&hud_blinkleft3&&hud_blinkleft4&&hud_blinkleft5");
	closeGlobalButton ("hud_blinkright&hud_blinkright1&hud_blinkright2&hud_blinkright3&hud_blinkright4&hud_blinkright5&hud_message");
	closeGlobalButton ("rcm_backflag&rcm_contrast&rcm_contrast2&rcm_bl_bsr1&rcm_bl_bsr2&rcm_bl_bsr3&rcm_bl_bsr4&rcm_bl_bsr5&rcm_bl_bsr6&rcm_bl_bsr7&rcm_bl_bsr8&rcm_bl_bsr9&rcm_bl_bsr0");	
	globalRcm( langEngine( "%{rcm_racemessage}%" ));
	openGlobalButton( "hud_message",73,1,52,5,4,8,0,langEngine( "%{hud_trackstatusrace}%" ) );
  openGlobalButton( "hud_blinkleft",71,1,58,5,4,8,64 + 8,langEngine( "%{hud_blink_green}%" ));
	openGlobalButton( "hud_blinkright",71,1,58,5,4,8,128 + 8,langEngine( "%{hud_blink_green}%" ));

IF ( $HUDoffon == "on" )
THEN
	openGlobalButton( "hud_pexstatus",$HUDorigL+74,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusopen}%"));
ENDIF
         
EndSub
 

# Pitlane Conditions Section
############################

Sub DoRCpitlane( $KeyFlags,$id )
	closePrivButton ("rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu&rcm_options&rcm_track_yellowflag&rcm_track_blueflag&rcm_pitdisplay&rcm_pitlaneopt");
	closePrivButton ("rcm_track_greenflag&rcm_track_safetycar&rcm_track_redflag&rcm_track_qualyprogress&rcm_track_raceprogress&rcm_goback&rcm_track_cheqflag");
	closePrivButton ("rcm_pitreturnall&rcm_pitqueryback&rcm_pitquery&rcm_pitqueryyes&rcm_pitqueryno&rcm_pitreturnone");
		
	openPrivButton( "rcm_pitoptions",$RCMorigL+1,$RCMorigT+1,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,0, langEngine( "%{rcm_pitoptions}%") );
	openPrivButton( "rcm_pitlaneback",$RCMorigL+1,$RCMorigT+8,$RCMWidth,$RCMHeight+11,$RCMspacing+1,-1,32,"" );
	openPrivButton( "rcm_pitreturnback",$RCMorigL+1,$RCMorigT+24,$RCMWidth,$RCMHeight+4,$RCMspacing+1,-1,32,"" );
 	openPrivButton( "rcm_pitlanetext",$RCMorigL+1,$RCMorigT+8,$RCMWidth,$RCMHeight-1,$RCMspacing,-1,0, langEngine( "%{rcm_pitlanetext}%"));
	openPrivButton( "rcm_pitreturntext",$RCMorigL+ 1,$RCMorigT+24,$RCMWidth,$RCMHeight-1,$RCMspacing,-1,0, langEngine( "%{rcm_pitreturntext}%"));
	openPrivButton( "rcm_pitlaneenmess",$RCMorigL+1,$RCMorigT+13,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,64,langEngine( "%{rcm_pitlaneenmess}%"));
	openPrivButton( "rcm_pitlanexmess",$RCMorigL+1,$RCMorigT+18,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,64,langEngine( "%{rcm_pitlanexmess}%"));
	openPrivButton( "rcm_penopen",$RCMorigL+9,$RCMorigT+13,$RCMWidth-19,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_penopenshort}%"),DoRCpenopen );
	openPrivButton( "rcm_penclosed",$RCMorigL+14,$RCMorigT+13,$RCMWidth-19,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_penclosedshort}%"),DoRCpenclosed );
	openPrivButton( "rcm_penclear",$RCMorigL+19,$RCMorigT+13,$RCMWidth-19,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_penclearshort}%"),DoRCpenclear );
	openPrivButton( "rcm_pexopen",$RCMorigL+9,$RCMorigT+18,$RCMWidth-19,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_pexopenshort}%"),DoRCpexopen );
	openPrivButton( "rcm_pexclosed", $RCMorigL+14,$RCMorigT+18,$RCMWidth-19,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_pexclosedshort}%"),DoRCpexclosed );
 	openPrivButton( "rcm_pexclear", $RCMorigL+19,$RCMorigT+18,$RCMWidth-19,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_pexclearshort}%"),DoRCpexclear );
	openPrivButton( "rcm_pitreturnall",$RCMorigL+2,$RCMorigT+28,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_pitreturnall}%"),DoRCDpitallPens  );
	openPrivButton( "rcm_pitreturnone",$RCMorigL+13,$RCMorigT+28,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_pitreturnone}%"),DoRCpitonepens );
	openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCmenu );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );	
EndSub

Sub DoRCDpitallPens( $KeyFlags,$id ) # Pit everyone on track
	closePrivButton ("rcm_pitqueryback&rcm_pitpenallmessage&rcm_pitreturnall");
	
	openPrivButton( "rcm_pitreturnall",$RCMorigL+2,$RCMorigT+28,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_pitreturnallalt}%")  );
	openPrivButton( "rcm_pitqueryback",82,58,36,20,1,-1,16,"" );
	openPrivButton( "rcm_pitquery",83,60,34,9,3,-1,16,langEngine( "%{rcm_pitquery}%") );
	openPrivButton( "rcm_pitqueryyes",86,70,12,7,2,-1,32,langEngine( "%{rcm_pitqueryyes}%"),DoRCpitallyesalt );
	openPrivButton( "rcm_pitqueryno",102,70,12,7,2,-1,32,langEngine( "%{rcm_pitqueryno}%"),DoRCpitallnoalt );
EndSub

Sub DoRCpitallyesalt( $KeyFlags,$id )
	closePrivButton ("rcm_pitqueryback&rcm_pitpenallmessage&rcm_pitqueryback&rcm_pitquery&rcm_pitqueryyes&rcm_pitqueryno");
	openPrivButton( "rcm_pitreturnall",$RCMorigL+2,$RCMorigT+28,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_pitreturnall}%"),DoRCDpitallPens  );
  cmdLFS( "/pit_all"); 	
EndSub

Sub DoRCpitallnoalt( $KeyFlags,$id )
	closePrivButton ("rcm_pitqueryback&rcm_pitpenallmessage&rcm_pitqueryback&rcm_pitquery&rcm_pitqueryyes&rcm_pitqueryno&rcm_pitreturnall");
	openPrivButton( "rcm_pitreturnall",$RCMorigL+2,$RCMorigT+28,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_pitreturnall}%"),DoRCDpitallPens  );
EndSub 

Sub DoRCpitonepens( $KeyFlags,$id ) # Only pit specific player
	closePrivButton ("rcm_pitpenonemessage");
	openPrivButton( "rcm_pitreturnone",$RCMorigL+13,$RCMorigT+28,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_pitreturnonealt}%"),DoRCpitonepens );
  openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
	openPrivTextButton( "rcm_pitqueryone",70,70,80,7,20,32,"^7NICKNAME ^0of driver to be pitted is","^7Click here to enter ^2NICKNAME ^7of driver to be pitted",70,Applypitonealt );
	openPrivButton( "rcm_closepitquery",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCclosepitqueryalt );	
EndSub	
	
Sub Applypitonealt( $NICKNAME of driver to be pitted is,$text )	
	closePrivButton ("rcm_pitpenonemessage&rcm_penqueryback&rcm_pitqueryone&rcm_closepitquery&rcm_pitreturnone");
	openPrivButton( "rcm_pitreturnone",$RCMorigL+13,$RCMorigT+28,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_pitreturnone}%"),DoRCDpitonePens );  
	privRCM("^6". $text ." ^7has been pitted by Admin");
	globalMsg("^6". $text ." ^7has been pitted by Admin");	  
  cmdLFS( "/pitlane " . $text );  	
EndSub

Sub DoRCclosepitqueryalt( $KeyFlags,$id )
	closePrivButton ("rcm_penqueryback&rcm_pitqueryone&rcm_closepitquery&rcm_pitreturnone");
	openPrivButton( "rcm_pitreturnone",$RCMorigL+13,$RCMorigT+28,$RCMWidth-13,$RCMHeight-1,$RCMspacing,-1,16, langEngine( "%{rcm_pitreturnone}%"),DoRCpitonepens ); 
EndSub

Sub DoRCpenclear( $KeyFlags,$id )
IF ( $HUDoffon == "on" )
THEN
	closeGlobalButton ("hud_penstatus");
	openGlobalButton( "hud_penstatus",$HUDorigL+1,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,"");
ENDIF	
EndSub

Sub DoRCpexclear( $KeyFlags,$id )
IF ( $HUDoffon == "on" )
THEN
	closeGlobalButton ("hud_pexstatus");
	openGlobalButton( "hud_pexstatus",$HUDorigL+74,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,"");
ENDIF	
EndSub

Sub DoRCpenopen( $KeyFlags,$id )
IF ( $HUDoffon == "on" )
THEN
	closeGlobalButton ("hud_penstatus");
	globalRcm( langEngine( "%{rcm_penopenmsg}%" ) );
	openGlobalButton( "hud_penstatus",$HUDorigL+1,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusopen}%"));
ELSE
	closePrivButton ("hud_penback&hud_pentext&hud_penfront&hud_pexback&hud_pextext&hud_pexfront");  	
ENDIF	
EndSub

Sub DoRCpexopen( $KeyFlags,$id )
IF ( $HUDoffon == "on" )
THEN
	closeGlobalButton ("hud_pexstatus");
	globalRcm( langEngine( "%{rcm_pexopenmsg}%" ) );
	openGlobalButton( "hud_pexstatus",$HUDorigL+74,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusopen}%"));
ELSE
	closePrivButton ("hud_penback&hud_pentext&hud_penfront&hud_pexback&hud_pextext&hud_pexfront");	
ENDIF	
EndSub

Sub DoRCpenclosed( $KeyFlags,$id )
IF ( $HUDoffon == "on" )
THEN
	closeGlobalButton ("hud_penstatus");
	globalRcm( langEngine( "%{rcm_penclosedmsg}%" ) );
	openGlobalButton( "hud_penstatus",$HUDorigL+1,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusclosed}%"));	
ELSE
	closePrivButton ("hud_penback&hud_pentext&hud_penfront&hud_pexback&hud_pextext&hud_pexfront");	
ENDIF	
EndSub

Sub DoRCpexclosed( $KeyFlags,$id )
IF ( $HUDoffon == "on" )
THEN
	closeGlobalButton ("hud_pexstatus");
	globalRcm( langEngine( "%{rcm_pexclosedmsg}%" ) );
	openGlobalButton( "hud_pexstatus",$HUDorigL+74,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,langEngine( "%{hud_pstatusclosed}%"));
ELSE
	closePrivButton ("hud_penback&hud_pentext&hud_penfront&hud_pexback&hud_pextext&hud_pexfront");  	
ENDIF	
EndSub


# Penalties Section
####################

Sub DoRCpenalties( $KeyFlags,$id )
	closePrivButton ("rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu&rcm_options&rcm_pitdisplay&rcm_pitlaneopt&rcm_drivpitstext");
	closePrivButton ("rcm_ban&rcm_ban12&rcm_ban1&rcm_ban7&rcm_ban30&rcm_ban90&rcm_ban999&rcm_goback&rcm_closemenu&rcm_closepenmess&&rcm_banlenback");
	closePrivButton ("rcm_penalty&rcm_30pen&rcm_45pen&rcm_dtpen&rcm_sgpen&rcm_specpen&rcm_kickpen&rcm_banpen&rcm_unbanpen&rcm_drivothertext" );
	closePrivButton ("rcm_goback&rcm_closemenu&rcm_penquery&rcm_closepenmess&rcm_clearpen&rcm_pitpenalty&rcm_pitpenallmessback&rcm_banlentext" );
	closePrivButton ("rcm_pitpenallmessage&rcm_pitpenonemessback&rcm_pitpenonemessage&rcm_pitqueryback&rcm_pitquery&rcm_pitqueryyes&rcm_pitqueryno" );
	closePrivButton ("rcm_pitpenonemessage&rcm_penqueryback&rcm_pitqueryone&rcm_closepitquery&rcm_pitlaneback&rcm_penaltype&rcm_drivtimetext");
     	                                                                                      
	openPrivButton( "rcm_penalty",$RCMorigL+1,$RCMorigT+1,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,0, langEngine( "%{rcm_penalty}%") );
	openPrivButton( "rcm_drivpenmessback",$RCMorigL+1,$RCMorigT+8,$RCMWidth,$RCMHeight+3,$RCMspacing,-1,32,"" );
	openPrivButton( "rcm_drivpenmessage",$RCMorigL+1,$RCMorigT+9,$RCMWidth,$RCMHeight,$RCMspacing,-1,0, langEngine( "%{rcm_drivpen}%"),DoRCDrivePenalties ); # Go to driving penalties page 
	openPrivButton( "rcm_banpenmessback",$RCMorigL+1,$RCMorigT+16,$RCMWidth,$RCMHeight+3,$RCMspacing,-1,32,"" );
	openPrivButton( "rcm_banpenmessage",$RCMorigL+1,$RCMorigT+17,$RCMWidth,$RCMHeight,$RCMspacing,-1,0, langEngine( "%{rcm_banpens}%"),DoRCbanpenalties ); # go to ban penalties page

	openPrivButton( "rcm_pitpenmessback",$RCMorigL+1,$RCMorigT+24,$RCMWidth,$RCMHeight+3,$RCMspacing,-1,32,"" );
	openPrivButton( "rcm_pitpenmessage",$RCMorigL+1,$RCMorigT+25,$RCMWidth,$RCMHeight,$RCMspacing,-1,0, langEngine( "%{rcm_pitpens}%"),DoRCpitpenalties ); # go to pit penalties page
	
	openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCmenu );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );	
EndSub	
    

Sub DoRCpitPenalties( $KeyFlags,$id )
	closePrivButton ("rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu&rcm_options&rcm_pitdisplay&rcm_unbanpen");
	closePrivButton ("rcm_ban&rcm_ban12&rcm_ban1&rcm_ban7&rcm_ban30&rcm_ban90&rcm_ban999&rcm_goback&rcm_closemenu&rcm_pitlaneopt");
	closePrivButton ("rcm_penalty&rcm_drivpenmessback&rcm_drivpenmessage&rcm_banpenmessback&rcm_banpenmessage&rcm_closepenmess&rcm_pitpenmessback&rcm_pitpenmessage");
	closePrivButton ("rcm_pitpenonemessage&rcm_penqueryback&rcm_pitqueryone&rcm_closepitquery");
	
	openPrivButton( "rcm_pitpenalty",$RCMorigL+1,$RCMorigT+1,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,0, langEngine( "%{rcm_pitpenalty}%") );  	
	openPrivButton( "rcm_pitpenallmessback",$RCMorigL+1,$RCMorigT+8,$RCMWidth,$RCMHeight+7,$RCMspacing,-1,32,"" );
	openPrivButton( "rcm_pitpenallmessage",$RCMorigL+1,$RCMorigT+9,$RCMWidth,$RCMHeight,$RCMspacing,-1,0, langEngine( "%{rcm_pitpenall}%"),DoRCDpitallPenalties ); # Go to pit all page 
	openPrivButton( "rcm_pitpenonemessback",$RCMorigL+1,$RCMorigT+20,$RCMWidth,$RCMHeight+7,$RCMspacing,-1,32,"" );
	openPrivButton( "rcm_pitpenonemessage",$RCMorigL+1,$RCMorigT+21,$RCMWidth,$RCMHeight,$RCMspacing,-1,0, langEngine( "%{rcm_pitpenone}%"),DoRCpitonepenalties ); # go to pit one page
	
	openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCpenalties );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );	
EndSub

Sub DoRCDpitallPenalties( $KeyFlags,$id ) # Pit everyone on track
	closePrivButton ("rcm_pitqueryback&rcm_pitpenallmessage");
	
	openPrivButton( "rcm_pitpenallmessage",$RCMorigL+1,$RCMorigT+9,$RCMWidth,$RCMHeight,$RCMspacing,-1,0, langEngine( "%{rcm_pitpenallalt}%"),DoRCDpitallPenalties );
	openPrivButton( "rcm_pitqueryback",82,58,36,20,1,-1,16,"" );
	openPrivButton( "rcm_pitquery",83,60,34,9,3,-1,16,langEngine( "%{rcm_pitquery}%") );
	openPrivButton( "rcm_pitqueryyes",86,70,12,7,2,-1,32,langEngine( "%{rcm_pitqueryyes}%"),DoRCpitallyes );
	openPrivButton( "rcm_pitqueryno",102,70,12,7,2,-1,32,langEngine( "%{rcm_pitqueryno}%"),DoRCpitallno );
EndSub

Sub DoRCpitallyes( $KeyFlags,$id )
	closePrivButton ("rcm_pitqueryback&rcm_pitpenallmessage&rcm_pitqueryback&rcm_pitquery&rcm_pitqueryyes&rcm_pitqueryno");
	openPrivButton( "rcm_pitpenallmessage",$RCMorigL+1,$RCMorigT+9,$RCMWidth,$RCMHeight,$RCMspacing,-1,0, langEngine( "%{rcm_pitpenall}%"),DoRCDpitallPenalties ); # Go to pit all page 
  cmdLFS( "/pit_all"); 	
EndSub

Sub DoRCpitallno( $KeyFlags,$id )
	closePrivButton ("rcm_pitqueryback&rcm_pitpenallmessage&rcm_pitqueryback&rcm_pitquery&rcm_pitqueryyes&rcm_pitqueryno");
	openPrivButton( "rcm_pitpenallmessage",$RCMorigL+1,$RCMorigT+9,$RCMWidth,$RCMHeight,$RCMspacing,-1,0, langEngine( "%{rcm_pitpenall}%"),DoRCDpitallPenalties );
EndSub 

Sub DoRCpitonepenalties( $KeyFlags,$id ) # Only pit specific player
	closePrivButton ("rcm_pitpenonemessage");

	openPrivButton( "rcm_pitpenonemessage",$RCMorigL+1,$RCMorigT+21,$RCMWidth,$RCMHeight,$RCMspacing,-1,0, langEngine( "%{rcm_pitpenonealt}%"),DoRCpitonepenalties );
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
	openPrivTextButton( "rcm_pitqueryone",70,70,80,7,20,32,"^7NICKNAME ^0of driver to be pitted is","^7Click here to enter ^2NICKNAME ^7of driver to be pitted",70,Applypitone );
	openPrivButton( "rcm_closepitquery",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCclosepitquery );	
EndSub	
	
Sub Applypitone( $NICKNAME of driver to be pitted is,$text )	
	closePrivButton ("rcm_pitpenonemessage&rcm_penqueryback&rcm_pitqueryone&rcm_closepitquery");
	openPrivButton( "rcm_pitpenonemessage",$RCMorigL+1,$RCMorigT+21,$RCMWidth,$RCMHeight,$RCMspacing,-1,0, langEngine( "%{rcm_pitpenone}%"),DoRCpitonepenalties );  
	privRCM("^6". $text ." ^7has been pitted by Admin");
	globalMsg("^6". $text ." ^7has been pitted by Admin");	  
  cmdLFS( "/pitlane " . $text );  	
EndSub

Sub DoRCclosepitquery( $KeyFlags,$id )
	closePrivButton ("rcm_pitpenonemessage&rcm_penqueryback&rcm_pitqueryone&rcm_closepitquery");
	openPrivButton( "rcm_pitpenonemessage",$RCMorigL+1,$RCMorigT+21,$RCMWidth,$RCMHeight,$RCMspacing,-1,0, langEngine( "%{rcm_pitpenone}%"),DoRCpitonepenalties );	
EndSub
	
Sub DoRCDrivePenalties( $KeyFlags,$id )
	closePrivButton ("rcm_messages&rcm_track&rcm_penalties&rcm_pitlane&rcm_closemenu&rcm_options&rcm_pitdisplay&rcm_unbanpen");
	closePrivButton ("rcm_ban&rcm_ban12&rcm_ban1&rcm_ban7&rcm_ban30&rcm_ban90&rcm_ban999&rcm_goback&rcm_closemenu&rcm_pitlaneopt");
	closePrivButton ("rcm_penalty&rcm_drivpenmessback&rcm_drivpenmessage&rcm_banpenmessback&rcm_banpenmessage&rcm_closepenmess&rcm_pitpenmessback&rcm_pitpenmessage");
  	
	openPrivButton( "rcm_penalty",$RCMorigL+1,$RCMorigT+1,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,0, langEngine( "%{rcm_drivepenalty}%") );
	openPrivButton( "rcm_pitlaneback",$RCMorigL+1,$RCMorigT+8,$RCMWidth,$RCMHeight+13,$RCMspacing+1,-1,32,"" );
  openPrivButton( "rcm_penaltype",$RCMorigL+1,$RCMorigT+8,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,0, langEngine( "%{rcm_drivepenaltype}%") );
 	openPrivButton( "rcm_drivtimetext",$RCMorigL+1,$RCMorigT+12,$RCMWidth,$RCMHeight-1,$RCMspacing,-1,64, langEngine( "%{rcm_drivtimetext}%"));
	openPrivButton( "rcm_drivpitstext",$RCMorigL+1,$RCMorigT+16,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,64,langEngine( "%{rcm_drivpitstext}%"));
	openPrivButton( "rcm_drivothertext",$RCMorigL+1,$RCMorigT+20,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,64,langEngine( "%{rcm_drivothertext}%"));
	openPrivButton( "rcm_30pen",$RCMorigL+6,$RCMorigT+12,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_30pen}%"),DoRC30pen );
	openPrivButton( "rcm_45pen",$RCMorigL+15,$RCMorigT+12,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_45pen}%"),DoRC45pen );	
	openPrivButton( "rcm_dtpen",$RCMorigL+6,$RCMorigT+16,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_dtpen}%"),DoRCdtpen );
	openPrivButton( "rcm_sgpen",$RCMorigL+15,$RCMorigT+16,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_sgpen}%"),DoRCsgpen );	
	openPrivButton( "rcm_specpen",$RCMorigL+6,$RCMorigT+20,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_specpen}%"),DoRCspecpen );
	openPrivButton( "rcm_kickpen",$RCMorigL+15,$RCMorigT+20,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_kickpen}%"),DoRCkickpen );
	openPrivButton( "rcm_clearpen",$RCMorigL+1,$RCMorigT+26,$RCMWidth,$RCMHeight+1,$RCMspacing+1,-1,32, langEngine( "%{rcm_clearpen}%"),DoRCclearpen );
	openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCpenalties );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );	
EndSub


Sub DoRC30pen( $KeyFlags,$id )# 30 sec penalty
	closePrivButton ("rcm_30pen");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );	
	openPrivButton( "rcm_30pen",$RCMorigL+6,$RCMorigT+12,$RCMWidth-15,$RCMHeight-1,$RCMspacing+1,-1,32, langEngine( "%{rcm_30penalt}%") );
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given penalty",70,Apply30penalty );
	openPrivButton( "rcm_closepenmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCclosepenalty );
EndSub
   
Sub Apply30penalty( $NICKNAME of offender is,$text )
	closePrivButton ("rcm_penquery&rcm_closepenmess&rcm_30pen&rcm_penqueryback");
	openPrivButton( "rcm_30pen",$RCMorigL+6,$RCMorigT+12,$RCMWidth-15,$RCMHeight-1,$RCMspacing+1,-1,16, langEngine( "%{rcm_30pen}%"),DoRC30pen );		
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been given ^130 second ^7penalty");
	globalMsg("^6". $text ." ^7has been given ^130 second ^7penalty");		
  cmdLFS( "/p_30 " . $text ); 	
EndSub  

Sub DoRC45pen( $KeyFlags,$id )# 45 sec penalty
	closePrivButton ("rcm_45pen");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
	openPrivButton( "rcm_45pen",$RCMorigL+15,$RCMorigT+12,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,32, langEngine( "%{rcm_45penalt}%") );	
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given penalty",70,Apply45penalty );
	openPrivButton( "rcm_closepenmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCclosepenalty );
EndSub
   
Sub Apply45penalty( $NICKNAME of offender is,$text )
	closePrivButton ("rcm_penquery&rcm_closepenmess&rcm_45pen&rcm_penqueryback");
	openPrivButton( "rcm_45pen",$RCMorigL+15,$RCMorigT+12,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_45pen}%"),DoRC45pen );	
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been given ^145 second ^7penalty");
	globalMsg("^6". $text ." ^7has been given ^145 second ^7penalty");		
  cmdLFS( "/p_45 " . $text ); 	
EndSub     

Sub DoRCdtpen( $KeyFlags,$id )# Drive Through penalty
	closePrivButton ("rcm_dtpen");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );	
	openPrivButton( "rcm_dtpen",$RCMorigL+6,$RCMorigT+16,$RCMWidth-15,$RCMHeight-1,$RCMspacing+1,-1,32, langEngine( "%{rcm_dtpenalt}%") );
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given penalty",70,Applydtpenalty );
	openPrivButton( "rcm_closepenmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCclosepenalty );
EndSub
   
Sub Applydtpenalty( $NICKNAME of offender is,$text )
	closePrivButton ("rcm_penquery&rcm_closepenmess&rcm_dtpen&rcm_penqueryback");
	openPrivButton( "rcm_dtpen",$RCMorigL+6,$RCMorigT+16,$RCMWidth-15,$RCMHeight-1,$RCMspacing+1,-1,16, langEngine( "%{rcm_dtpen}%"),DoRCdtpen );	
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been given ^1DRIVE THROUGH ^7penalty");
	globalMsg("^6". $text ." ^7has been given ^1DRIVE THROUGH ^7penalty");		
  cmdLFS( "/p_dt " . $text ); 	
EndSub

Sub DoRCsgpen( $KeyFlags,$id )# Stop and Go penalty
	closePrivButton ("rcm_sgpen ");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );	
	openPrivButton( "rcm_sgpen",$RCMorigL+15,$RCMorigT+16,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,32, langEngine( "%{rcm_sgpenalt}%"));	
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given penalty",70,Applysgpenalty );
	openPrivButton( "rcm_closepenmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCclosepenalty );
EndSub
   
Sub Applysgpenalty( $NICKNAME of offender is,$text )
	closePrivButton ("rcm_penquery&rcm_closepenmess&rcm_sgpen&rcm_penqueryback");
	openPrivButton( "rcm_sgpen",$RCMorigL+15,$RCMorigT+16,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_sgpen}%"),DoRCsgpen );	
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been given ^1STOP and GO ^7penalty");
	globalMsg("^6". $text ." ^7has been given ^1STOP and GO ^7penalty");		
  cmdLFS( "/p_sg " . $text ); 	
EndSub

Sub DoRCspecpen( $KeyFlags,$id )# Spectate penalty
	closePrivButton ("rcm_specpen");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );	
	openPrivButton( "rcm_specpen", $RCMorigL+6,$RCMorigT+20,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,32, langEngine( "%{rcm_specpenalt}%") );
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given penalty",70,Applyspecpenalty );
	openPrivButton( "rcm_closepenmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCclosepenalty );
EndSub
   
Sub Applyspecpenalty( $NICKNAME of offender is,$text )
	closePrivButton ("rcm_penquery&rcm_closepenmess&rcm_specpen&rcm_penqueryback");
	openPrivButton( "rcm_specpen", $RCMorigL+6,$RCMorigT+20,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_specpen}%"),DoRCspecpen );	
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been given ^1SPECTATE ^7penalty");
	globalMsg("^6". $text ." ^7has been given ^1SPECTATE ^7penalty");		
  cmdLFS( "/spec " . $text ); 	
EndSub

Sub DoRCkickpen( $KeyFlags,$id )# Kick penalty
	closePrivButton ("rcm_kickpen");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );	
	openPrivButton( "rcm_kickpen",$RCMorigL+15,$RCMorigT+20,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,32, langEngine( "%{rcm_kickpenalt}%") ); 
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given penalty",70,Applykickpenalty );
	openPrivButton( "rcm_closepenmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCclosepenalty );
EndSub
   
Sub Applykickpenalty( $NICKNAME of offender is,$text )
	closePrivButton ("rcm_penquery&rcm_closepenmess&rcm_kickpen&rcm_penqueryback");
	openPrivButton( "rcm_kickpen",$RCMorigL+15,$RCMorigT+20,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_kickpen}%"),DoRCkickpen ); 	
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been ^1KICKED ^7from server");
	globalMsg("^6". $text ." ^7has been ^1KICKED ^7from server");	
  cmdLFS( "/kick " . $text ); 	
EndSub


Sub DoRCclearpen( $KeyFlags,$id )# Kick penalty
	closePrivButton ("rcm_clearpen");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
 	openPrivButton( "rcm_clearpen",$RCMorigL+1,$RCMorigT+26,$RCMWidth,$RCMHeight+1,$RCMspacing+1,-1,32, langEngine( "%{rcm_clearpenalt}%"),DoRCclearpen );
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to have penalty ^3CLEARED",70,Applyclearpenalty );
	openPrivButton( "rcm_closepenmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCclosepenalty );
EndSub

Sub Applyclearpenalty( $NICKNAME of driver is,$text )
	closePrivButton ("rcm_penquery&rcm_closepenmess&rcm_unbanpen&rcm_penqueryback&rcm_clearpen");
 	openPrivButton( "rcm_clearpen",$RCMorigL+1,$RCMorigT+26,$RCMWidth,$RCMHeight+1,$RCMspacing+1,-1,32, langEngine( "%{rcm_clearpen}%"),DoRCclearpen );	
	privRCM("^6". $text ." ^7has had their penalty ^2CLEARED");
	globalMsg("^6". $text ." ^7has had their penalty ^2CLEARED");	
  cmdLFS( "/p_clear " . $text ); 	
EndSub     

Sub DoRCunbanpen( $KeyFlags,$id )# Unban
	closePrivButton ("rcm_unbanpen");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
	openPrivButton( "rcm_unbanpen",$RCMorigL+13,$RCMorigT+26,$RCMWidth-13,$RCMHeight,$RCMspacing+1,-1,32, langEngine( "%{rcm_unbanpenalt}%"),DoRCunbanpen );
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be ^3UNBANNED",70,Applyunbanpenalty );
	openPrivButton( "rcm_closepenmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCclosepenalty );
EndSub
   
Sub Applyunbanpenalty( $NICKNAME of driver is,$text )
	closePrivButton ("rcm_penquery&rcm_closepenmess&rcm_unbanpen&rcm_penqueryback");
	openPrivButton( "rcm_unbanpen",$RCMorigL+13,$RCMorigT+26,$RCMWidth-13,$RCMHeight,$RCMspacing+1,-1,32, langEngine( "%{rcm_unbanpen}%"),DoRCunbanpen );	
	privRCM("^6". $text ." ^7has had their ^2BAN ^7removed");
	globalMsg("^6". $text ." ^7has had their ^2BAN ^7removed");	
  cmdLFS( "/unban " . $text ); 	
EndSub

Sub DoRCclosepenalty( $KeyFlags,$id )
	closePrivButton ("rcm_penquery&rcm_closepenmess&rcm_penqueryback&rcm_clearpen");
	closePrivButton ("rcm_30pen&rcm_45pen&rcm_dtpen&rcm_sgpen&rcm_specpen&rcm_kickpen&rcm_banpen&rcm_unbanpen");
	openPrivButton( "rcm_30pen",$RCMorigL+6,$RCMorigT+12,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_30pen}%"),DoRC30pen );
	openPrivButton( "rcm_45pen",$RCMorigL+15,$RCMorigT+12,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_45pen}%"),DoRC45pen );	
	openPrivButton( "rcm_dtpen",$RCMorigL+6,$RCMorigT+16,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_dtpen}%"),DoRCdtpen );
	openPrivButton( "rcm_sgpen",$RCMorigL+15,$RCMorigT+16,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_sgpen}%"),DoRCsgpen );	
	openPrivButton( "rcm_specpen",$RCMorigL+6,$RCMorigT+20,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_specpen}%"),DoRCspecpen );
	openPrivButton( "rcm_kickpen",$RCMorigL+15,$RCMorigT+20,$RCMWidth-15,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_kickpen}%"),DoRCkickpen );
	openPrivButton( "rcm_clearpen",$RCMorigL+1,$RCMorigT+26,$RCMWidth,$RCMHeight+1,$RCMspacing+1,-1,32, langEngine( "%{rcm_clearpen}%"),DoRCclearpen );	
EndSub

#	Ban section
####################

Sub DoRCbanpenalties ( $KeyFlags,$id )
	closePrivButton ("rcm_penquery&rcm_closepenmess&rcm_penqueryback&rcm_clearpen&rcm_penquery&rcm_closepenmess");
	closePrivButton ("rcm_drivpenmessback&rcm_drivpenmessage&rcm_banpenmessback&rcm_banpenmessage&rcm_pitpenmessback&rcm_pitpenmessage");          
	closePrivButton ("rcm_penalty&rcm_30pen&rcm_45pen&rcm_dtpen&rcm_sgpen&rcm_specpen&rcm_kickpen&rcm_banpen&rcm_unbanpen&rcm_goback&rcm_closemenu&rcm_penquery " );

	openPrivButton( "rcm_ban",$RCMorigL+1,$RCMorigT+1,$RCMWidth,$RCMHeight+2,$RCMspacing+1,-1,0, langEngine( "%{rcm_ban}%") );
	openPrivButton( "rcm_banlenback",$RCMorigL+1,$RCMorigT+8,$RCMWidth,$RCMHeight+13,$RCMspacing+1,-1,32,"" );
  openPrivButton( "rcm_banlentext",$RCMorigL+1,$RCMorigT+8,$RCMWidth,$RCMHeight-1,$RCMspacing+1,-1,0, langEngine( "%{rcm_banlentext}%") );
	openPrivButton( "rcm_ban12",$RCMorigL+2,$RCMorigT+12,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban12}%"),DoRCban12);
	openPrivButton( "rcm_ban1",$RCMorigL+13,$RCMorigT+12,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban1}%"),DoRCban1 );	
	openPrivButton( "rcm_ban7",$RCMorigL+2,$RCMorigT+16,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban7}%"),DoRCban7 );
	openPrivButton( "rcm_ban30",$RCMorigL+13,$RCMorigT+16,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban30}%"),DoRCban30 );	
	openPrivButton( "rcm_ban90", $RCMorigL+2,$RCMorigT+20,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban90}%"),DoRCban90 );
	openPrivButton( "rcm_ban999", $RCMorigL+13,$RCMorigT+20,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban999}%"),DoRCban999 );
	openPrivButton( "rcm_unbanpen",$RCMorigL+1,$RCMorigT+26,$RCMWidth,$RCMHeight+1,$RCMspacing-1,-1,32, langEngine( "%{rcm_unbanpen1}%"),DoRCunbanpen1 );
	openPrivButton( "rcm_goback",$RCMorigL+1,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_goback}%"),DoRCPenalties );
	openPrivButton( "rcm_closemenu",$RCMorigL+13,$RCMorigT+33,$RCMWidth-12,$RCMHeight,$RCMspacing,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCM );
EndSub 

Sub DoRCban12 ( $KeyFlags,$id )
	closePrivButton ("rcm_ban12");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
	openPrivButton( "rcm_ban12",$RCMorigL+2,$RCMorigT+12,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,32, langEngine( "%{rcm_ban12alt}%"),DoRCban12);
  openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given a ^112 hour ^7ban",70,Applyban12 );
	openPrivButton( "rcm_closebanmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCcloseban );
EndSub   

Sub Applyban12 ( $NICKNAME of driver is,$text )
	closePrivButton ("rcm_penquery&rcm_closebanmess&rcm_ban12&rcm_penqueryback");
	openPrivButton( "rcm_ban12",$RCMorigL+2,$RCMorigT+12,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban12}%"),DoRCban12);
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been given ^112 hour ban ^7from server");
	globalMsg("^6". $text ." ^7has been given ^112 hour ban ^7from server");	
  cmdLFS( "/ban " . $text. " 0" );	#	ban user X for Y days (if Y = 0, then 0 = 12hrs)
EndSub

Sub DoRCban1 ( $KeyFlags,$id  )
	closePrivButton ("rcm_ban1");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
	openPrivButton( "rcm_ban1",$RCMorigL+13,$RCMorigT+12,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,32, langEngine( "%{rcm_ban1alt}%"),DoRCban1);
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given a ^11 day ^7ban",70,Applyban1 );
	openPrivButton( "rcm_closebanmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCcloseban );
EndSub         

Sub Applyban1 ( $NICKNAME of driver is,$text )
	closePrivButton ("rcm_penquery&rcm_closebanmess&rcm_ban1&rcm_penqueryback");
	openPrivButton( "rcm_ban1",$RCMorigL+13,$RCMorigT+12,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban1}%"),DoRCban1);
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been given ^11 day ban ^7from server");
	globalMsg("^6". $text ." ^7has been given ^11 day ban ^7from server");	
cmdLFS( "/ban " . $text. " 1" );
EndSub

Sub DoRCban7 ( $KeyFlags,$id )
	closePrivButton ("rcm_ban7");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
	openPrivButton( "rcm_ban7",$RCMorigL+2,$RCMorigT+16,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,32, langEngine( "%{rcm_ban7alt}%"),DoRCban7);
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given a ^17 day ^7ban",70,Applyban7 );
	openPrivButton( "rcm_closebanmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCcloseban );
EndSub

Sub Applyban7 ( $NICKNAME of driver is,$text )
	closePrivButton ("rcm_penquery&rcm_closebanmess&rcm_ban7&rcm_penqueryback");
	openPrivButton( "rcm_ban7",$RCMorigL+2,$RCMorigT+16,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban7}%"),DoRCban7);
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been given ^17 day ban ^7from server");
	globalMsg("^6". $text ." ^7has been given ^17 day ban ^7from server");	
cmdLFS( "/ban " . $text. " 7" );
EndSub

Sub DoRCban30 ( $KeyFlags,$id )
	closePrivButton ("rcm_ban30");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
	openPrivButton( "rcm_ban30",$RCMorigL+13,$RCMorigT+16,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,32, langEngine( "%{rcm_ban30alt}%"),DoRCban30);
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given a ^130 day ^7ban",70,Applyban30 );
	openPrivButton( "rcm_closebanmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCcloseban );
EndSub

Sub Applyban30 ( $NICKNAME of driver is,$text )
	closePrivButton ("rcm_penquery&rcm_closebanmess&rcm_ban30&rcm_penqueryback");
	openPrivButton( "rcm_ban30",$RCMorigL+13,$RCMorigT+16,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban30}%"),DoRCban30);
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been given ^130 day ban ^7from server");
	globalMsg("^6". $text ." ^7has been given ^130 day ban ^7from server");	
cmdLFS( "/ban " . $text. " 30" );
EndSub

Sub DoRCban90 ( $KeyFlags,$id )
	closePrivButton ("rcm_ban90");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
	openPrivButton( "rcm_ban90",$RCMorigL+2,$RCMorigT+20,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,32, langEngine( "%{rcm_ban90alt}%"),DoRCban90);
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given a ^190 day ^7ban",70,Applyban90 );
	openPrivButton( "rcm_closebanmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCcloseban );
EndSub 

Sub Applyban90 ( $NICKNAME of driver is,$text )
	closePrivButton ("rcm_penquery&rcm_closebanmess&rcm_ban90&rcm_penqueryback");
	openPrivButton( "rcm_ban90",$RCMorigL+2,$RCMorigT+20,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban90}%"),DoRCban90);
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been given ^190 day ban ^7from server");
	globalMsg("^6". $text ." ^7has been given ^190 day ban ^7from server");	
cmdLFS( "/ban " . $text. " 90" );
EndSub 

Sub DoRCban999( $KeyFlags,$id )
	closePrivButton ("rcm_ban999");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
	openPrivButton( "rcm_ban999",$RCMorigL+13,$RCMorigT+20,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,32, langEngine( "%{rcm_ban999alt}%"),DoRCban999);
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be given a ^1999 day ^7ban",70,Applyban999 );
	openPrivButton( "rcm_closebanmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCcloseban );
EndSub       

Sub Applyban999 ( $NICKNAME of driver is,$text )
	closePrivButton ("rcm_penquery&rcm_closebanmess&rcm_ban999&rcm_penqueryback");
	openPrivButton( "rcm_ban999",$RCMorigL+13,$RCMorigT+20,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban999}%"),DoRCban999);
	privMsg( "^1Offender NickName:^7 " . $text );
	privRCM("^6". $text ." ^7has been given ^1999 day ban ^7from server");
	globalMsg("^6". $text ." ^7has been given ^1999 day ban ^7from server");	
cmdLFS( "/ban " . $text. " 999" );
EndSub

Sub DoRCcloseban ( $KeyFlags,$id )
	closePrivButton ("rcm_penquery&rcm_closebanmess&rcm_ban&rcm_ban12&rcm_ban1&rcm_ban7&rcm_ban30&rcm_ban90&rcm_ban999&rcm_penqueryback&rcm_unbanpen&rcm_closepenmess");		
	openPrivButton( "rcm_ban12",$RCMorigL+2,$RCMorigT+12,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban12}%"),DoRCban12);
	openPrivButton( "rcm_ban1",$RCMorigL+13,$RCMorigT+12,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban1}%"),DoRCban1 );	
	openPrivButton( "rcm_ban7",$RCMorigL+2,$RCMorigT+16,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban7}%"),DoRCban7 );
	openPrivButton( "rcm_ban30",$RCMorigL+13,$RCMorigT+16,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban30}%"),DoRCban30 );	
	openPrivButton( "rcm_ban90", $RCMorigL+2,$RCMorigT+20,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban90}%"),DoRCban90 );
	openPrivButton( "rcm_ban999", $RCMorigL+13,$RCMorigT+20,$RCMWidth-13,$RCMHeight-1,$RCMspacing-1,-1,16, langEngine( "%{rcm_ban999}%"),DoRCban999 );
	openPrivButton( "rcm_unbanpen",$RCMorigL+1,$RCMorigT+26,$RCMWidth,$RCMHeight+1,$RCMspacing-1,-1,32, langEngine( "%{rcm_unbanpen1}%"),DoRCunbanpen1 );
EndSub

Sub DoRCunbanpen1( $KeyFlags,$id )# Unban
	closePrivButton ("rcm_unbanpen");
	openPrivButton( "rcm_penqueryback",68,68,84,20,1,-1,16,"" );
	openPrivButton( "rcm_unbanpen",$RCMorigL+1,$RCMorigT+26,$RCMWidth,$RCMHeight+1,$RCMspacing+1,-1,32, langEngine( "%{rcm_unbanpen1alt}%"),DoRCunbanpen1 );	
	openPrivTextButton( "rcm_penquery",70,70,80,7,20,32,"^7NICKNAME ^0of driver is","^7Click here to enter ^2NICKNAME ^7of driver to be ^3UNBANNED",70,Applyunbanpenalty1 );
	openPrivButton( "rcm_closepenmess",104,80,12,6,5,-1,16, langEngine( "%{rcm_closemenu}%"),DoRCcloseban );
EndSub
   
Sub Applyunbanpenalty1( $NICKNAME of driver is,$text )
	closePrivButton ("rcm_penquery&rcm_closepenmess&rcm_unbanpen&rcm_penqueryback");
	openPrivButton( "rcm_unbanpen",$RCMorigL+1,$RCMorigT+27,$RCMWidth,$RCMHeight,$RCMspacing+1,-1,32, langEngine( "%{rcm_unbanpen1}%"),DoRCunbanpen1 );		
	privRCM("^6". $text ." ^7has been ^2UNBANNED ^7from server");
	globalMsg("^6". $text ." ^7has been ^2UNBANNED ^7from server");	
  cmdLFS( "/unban " . $text ); 	
EndSub


# HUD Status Section
####################

CatchEvent OnNewPlayerJoin( $userName )  # Player event
	openPrivButton( "hud_backdark",$HUDorigL+13,$HUDorigT,$HUDWidth+58,$HUDHeight+4,$HUDspacing+3,$HUDtime,32,"");
	openPrivButton( "hud_frontlight",$HUDorigL+14,$HUDorigT+1,$HUDWidth+56,$HUDHeight+2,$HUDspacing+3,$HUDtime,16,"");
  
IF ($HUDoffon  == "on" )
THEN	
	openPrivButton( "hud_penback",$HUDorigL,$HUDorigT,$HUDWidth+11,$HUDHeight+6,$HUDspacing,$HUDtime,32,"");
	openPrivButton( "hud_pentext",$HUDorigL,$HUDorigT,$HUDWidth+11,$HUDHeight,$HUDspacing+4,$HUDtime,0,langEngine("%{hud_pentext}%"));
	openPrivButton( "hud_penfront",$HUDorigL+1,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,"");	
	openPrivButton( "hud_pexback",$HUDorigL+73,$HUDorigT,$HUDWidth+11,$HUDHeight+6,$HUDspacing,$HUDtime,32,"");
	openPrivButton( "hud_pextext",$HUDorigL+73,$HUDorigT,$HUDWidth+11,$HUDHeight,$HUDspacing+4,$HUDtime,0,langEngine("%{hud_pextext}%"));	
	openPrivButton( "hud_pexfront",$HUDorigL+74,$HUDorigT+4,$HUDWidth+9,$HUDHeight,$HUDspacing,$HUDtime,16,"");
ELSE
	closePrivButton ("hud_penback&hud_pentext&hud_penfront&hud_pexback&hud_pextext&hud_pexfront");	
ENDIF		
EndCatchEvent


# English Language Section
##########################

Lang "EN"

rcm_30pen = "^330 Secs";	
rcm_30penalt = "30 Secs";	
rcm_45pen = "^345 Secs";	
rcm_45penalt = "45 Secs";	
rcm_ban = "^7BAN PENALTIES";	
rcm_ban1 = "^31 Day";	
rcm_ban12 = "^312 Hours";	
rcm_ban12alt = "12 Hours";	
rcm_ban1alt = "1 Day";	
rcm_ban30 = "^330 Days";	
rcm_ban30alt = "30 Days";	
rcm_ban7 = "^37 Days";	
rcm_ban7alt = "7 Days";	
rcm_ban90 = "^390 Days";	
rcm_ban90alt = "90 Days";	
rcm_ban999 = "^3999 Days";	
rcm_ban999alt = "999 Days";	
rcm_banlentext = "^7Length";
rcm_banpen = "^3Ban (^2+^3)";	
rcm_banpenalt = "Ban";	
rcm_banpens = "^3Ban Penalties";	
rcm_blueflag = "^4Blue ^3Flag";	
rcm_blueflagmessage = "^4BLUE FLAG - LET LEADER(S) THROUGH";	
rcm_by = "^8by Sinanju";	
rcm_cheqflag = "^0Chequered Flag";	
rcm_chequeredflag = "^0CHEQUERED FLAG";	
rcm_clearpen = "^2Cancel ^3Any ^2Penalty";  	
rcm_clearpenalt = "Cancel Any Penalty";	
rcm_closemenu = "^1CLOSE";	
rcm_drivepenalty = "^7DRIVING PENALTIES";
rcm_drivepenaltype = "^7Penalty Type";	
rcm_drivpen = "^3Driving Penalties";
rcm_drivtimetext = "^6Time";
rcm_drivpitstext = "^6Pits";
rcm_drivothertext = "^6Other";	
rcm_dtpen = "^3Drive Thru";	
rcm_dtpenalt = "Drive Thru";	
rcm_globrcm = "^1SHOUT ^3Global Message";	
rcm_goback = "^7< BACK";	
rcm_greenflag = "^2Green ^3Flag";	
rcm_instruct = "Please follow these instructions"; 	
rcm_kickpen = "^3Kick";	
rcm_kickpenalt = "Kick";	
rcm_menu = "^7RACE CONTROL%nl%^7MANAGER";	
rcm_menumanager = "^3RCM MENU";	
rcm_mess1 = "^1CAUTION! ^2You can go blind doing that!";	
rcm_mess2 = "^2Crashing is ^1not ^2encouraged; can get you ^7kicked";	
rcm_mess3 = "^2Accidents happen; ^3Shift S ^2or ^3Shift P ^2to get out of way.";	
rcm_mess4 = "^2The race will start shortly";	
rcm_mess5 = "^2Qualifying will start shortly";	
rcm_message1 = "^3Going blind";	
rcm_message2 = "^3Crashing";	
rcm_message3 = "^3Accidents";	
rcm_message4 = "^3Race shortly";	
rcm_message5 = "^3Qualy shortly";	
rcm_messages = "^3Messaging";	
rcm_mestext = "^7MESSAGING";	
rcm_notrcadmin = "^2You do not have ^1Admin ^2priviliges";	
rcm_options = "^7OPTIONS";	
rcm_penalties = "^3Penalties";	
rcm_penalty = "^7PENALTIES";
rcm_penclear = "^3Clear Entrance Status";	
rcm_penclearshort = "^3Clear";	
rcm_penclosed = "^1Close ^3Pitlane Entrance";
rcm_penclosedshort = "^1Close";	
rcm_penclosedmsg = "^3Pitlane Entrance ^1Closed";	
rcm_penopen = "^2Open ^3Pitlane Entrance";
rcm_penopenmsg = "^3Pitlane Entrance ^2Open";
rcm_pentext = "^7PENALTIES";	
rcm_pexclear = "^3Close Exit Status";	
rcm_pexclearshort = "^3Clear";	
rcm_pexclosed = "^1Close ^3Pitlane Exit";
rcm_pexclosedshort = "^1Close";		
rcm_pexclosedmsg = "^3Pitlane Exit ^1Closed";	
rcm_pexopen = "^2Open ^3Pitlane Exit";
rcm_pexopenshort = "^2Open";
rcm_penopenshort = "^2Open";	
rcm_pexopenmsg = "^3Pitlane Exit ^2Open";	
rcm_pithud = "^3Pit HUD Display";	
rcm_pithudoff = "^1OFF";	
rcm_pithudoffalt = "off";	
rcm_pithudon = "^2ON";	
rcm_pithudonalt = "on";	
rcm_pitlane = "^3PITLANE OPTIONS";
rcm_pitlaneenmess = "^6Entrance";
rcm_pitlanexmess = "^6Exit";
rcm_pitlaneopt = "^3Pitlane Options";
rcm_pitlanetext = "^7Pitlane";	
rcm_pitmess = "^3Pit Entry%nl%^3& Pit Exit%nl%^3Hud Displays";	
rcm_pitoptions = "^7Pitlane Options";
rcm_pitpenall = "^3Pit everyone%nl%^3on track";
rcm_pitpenallalt = "^Pit everyone%nl%on track";
rcm_pitpenalty	= "^7PIT PENALTIES";
rcm_pitpenone = "^3Pit only%nl%^3specific player";
rcm_pitpenonealt = "Pit only%nl%specific player";	
rcm_pitpens = "^3Pit Penalties";
rcm_pitquery = "^0Are you sure?";
rcm_pitqueryyes = "^2YES";
rcm_pitqueryno = "^1NO";
rcm_pitreturnall = "^3Everyone";
rcm_pitreturnallalt = "Everyone";
rcm_pitreturnone = "^31 Player";
rcm_pitreturnonealt = "1 Player";
rcm_pitreturntext = "^7Return to Pits";		
rcm_pittext = "^7PIT HUD DISPLAY";	
rcm_privmsg = "^3Send ^1PRIVATE ^3message";	
rcm_privmsginst = "^7Use following format%nl%^2!pm <username> <message>%nl%^7for instance%nl%^3!pm sinanju Hello";	
rcm_privrcm = "^2WHISPER ^3Global Message";	
rcm_qualymessage = "^7!! QUALIFYING IN PROGRESS !!";	
rcm_qualyprogress = "^6Qualy";	
rcm_racemessage = "^7!! RACE IN PROGRESS !!";	
rcm_raceprogress = "^6Race";	
rcm_redflag = "^1Red ^3Flag";	
rcm_redflagmessage = "^1!! RED FLAG !!";	
rcm_safetycar = "^3Safety Car";	
rcm_safetycarmessage = "^7!! SAFETY CAR DEPLOYED !!";	
rcm_serverrcm = "^3Server Messages";	
rcm_servtext = "^7SERVER MESSAGES";	
rcm_sgpen = "^3Stop n Go";	
rcm_sgpenalt = "Stop n Go";	
rcm_smess1 = "^2Welcome to {0}";	
rcm_smess2 = "^2email address is: ^6sinanju@hotmail.co.uk";	
rcm_smess3 = "^2Any problems then contact Admin or email team";	
rcm_smess4 = "^2Admin is taking short break.  Back shortly.";	
rcm_smess5 = "^2The Admins ruling is final";	
rcm_smessage1 = "^3Welcome to server";	
rcm_smessage2 = "^3email address";	
rcm_smessage3 = "^3Any problems";	
rcm_smessage4 = "^3Admin Break";	
rcm_smessage5 = "^3Admin Rules";	
rcm_specpen = "^3Spec";	
rcm_specpenalt = "Spec";	
rcm_standardrcm = "^3Standard Messages";	
rcm_stantext = "^7STANDARD MESSAGES";	
rcm_teammsg = "^3Send ^1TEAM ^3message";	
rcm_teammsginst = "^7To use in game, make sure that you and the %nl%^7other members of your team have their teamname%nl%^7set with their team name in square brackets%nl%^7(this can be changed in the module) ie Krayy[LFSNZ]%nl%^7Then when you type '^3!tc <msg>'%nl%^7everyone who has the same team name%nl%^7will see the message but no one else";	
rcm_track = "^3Track Options";	
rcm_trackflags = "^7Flags";	
rcm_trackprogress = "^7In Progress";	
rcm_tracktext = "^7TRACK OPTIONS";	
rcm_unbanpen = "^3Unban";	
rcm_unbanpen1 = "^2Cancel ^3Any ^2Ban";	
rcm_unbanpen1alt = "Cancel Any Ban";	
rcm_yellowflag = "^3Yellow Flag";	
rcm_yellowflagmessage = "^3YELLOW FLAG - BE PREPARED TO SLOW OR STOP";	
                      

# HUD System
############

hud_blink_cheq = "^7• •%at%^0• •";
hud_blink_blue = "^4• •";
hud_blink_green = "^2• •";
hud_blink_red = "^1• •";
hud_blink_white = "^7• •";
hud_blink_yellow = "^3• •";
hud_bluemessage = "^4!! Blue Flag - Let leader(s) through !!";
hud_greenmessage = "^2!! GREEN FLAG !!  CONTINUE RACING !!";
hud_pentext = "^7Pitlane Entry"; 
hud_pextext = "^7Pitlane Exit" ;
hud_pstatusclosed = "^1CLOSED";
hud_pstatusopen = "^2OPEN";
hud_openrcm = "^7Admin is operating the ^1R^7ace ^1C^7ontrol ^1M^7anager";
hud_redmessage = "^1> ^7Race has been ^1RED ^7flagged ^1<";
hud_trackstatusblue = "^4BLUE FLAG";
hud_trackstatuscheq = "^3RACE COMPLETE";
hud_trackstatusqualy = "^3QUALIFYING IN PROGRESS";
hud_trackstatusrace = "^2RACE IN PROGRESS";
hud_trackstatusred = "^1RED FLAG";
hud_trackstatussafety = "^7SAFETY CAR DEPLOYED - ^1NO ^7OVERTAKING";
hud_yellowmessage = "^1ACCIDENT: ^7Be prepared to slow down or stop";
       	
EndLang



# French Language Section
##########################

Lang "FR"

rcm_penalties = "^7OPTIONS PEINE";
rcm_greenflag = "^3Drapeau Vert";
rcm_greenflagmessage = "^2!! DRAPEAU VERT !!";
rcm_redflag = "^3Drapeau Rouge";
rcm_redflagmessage = "^2!! DRAPEAU ROUGE !!";
     	
EndLang

