#pragma once
#include <algorithm>
#include <cctype>
#include <fstream>
#include <functional>
#include <iostream>
#include <sstream>
#include <string>
#include <vector>

class ConfigHandler
{
 public:
	ConfigHandler(void);
	~ConfigHandler(void);

	void loadConfigFile(void);
	bool saveConfigFile(void);

	std::wstring ipAddress;
	short inSimPort;
	short outGaugePort;
	std::wstring adminPass;
	int updateSpeed;
	short mode;
	short units;
	short xOffset;
	short yOffset;
	bool dispInLFS;
	bool dispInExt;

 private:
	void parseLine(std::wstring*);
	void processReadData(std::wstring*);
	void removeWhiteSpaces(std::wstring*);
	void storeParsedLine(std::wstring*);
	
	//Parsed contents of the config file
	std::vector< std::vector<std::wstring> > parsedConfig;
	int lineNum;

	//At which line are stored values that can be changed in runtime
	int modeAt;
	int unitsAt;
	int xOffsetAt;
	int yOffsetAt;
};

template <class T>
std::wstring to_string(T t, std::ios_base & (*f)(std::ios_base&));
