#include "win32wnd.h"
#include "fueldataprocess.h"

Win32Wnd::Win32Wnd(void* inPtr)
{
	hInstance = GetModuleHandle(NULL);
	winClassName = L"ECMETER_W32";

	wcx.cbSize = sizeof(WNDCLASSEX);
	wcx.style = 0;
	wcx.lpfnWndProc = &Win32Wnd::WndProc;
	wcx.cbClsExtra = 0;
	wcx.cbWndExtra = 0;
	wcx.hInstance = hInstance;
	wcx.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wcx.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcx.hbrBackground = (HBRUSH)(COLOR_WINDOW);
	wcx.lpszMenuName = NULL;
	wcx.lpszClassName = winClassName;
	wcx.hIconSm = LoadIcon(NULL, IDI_APPLICATION);

	cbk_fdProc = inPtr;
	me = this;
}

/** Attempts to create a window thread.
*   Retunrns false in case of failure.
*/
bool Win32Wnd::createWindow()
{
	//Create a thread for message loop
	hMsgLoop = CreateThread(NULL, 0, &Win32Wnd::WindowThread, NULL, 0, NULL);
	if(hMsgLoop == NULL)
	{
		MessageBox(NULL, L"Cannot create window thread!", L"(Win32Wnd)Error", MB_ICONERROR | MB_OK);
		return false;
	}

	state = true;	//Set state to true => assume that the window creation won't fail.

	return true;
}

bool Win32Wnd::checkState()
{
	return state;
}

/** The main window thread
*/
DWORD WINAPI Win32Wnd::WindowThread(LPVOID lpParam)
{
	Win32Wnd* parentClass = (Win32Wnd*)me;				//Pointer to our parent class

	HWND mainHWnd;											//The main window handle

	//Register window class
	if(!RegisterClassEx(&parentClass->wcx))					//Couldn't register window class, tell the user and report it back
	{
		MessageBox(NULL, L"Cannot register window class", L"ERROR", MB_OK);
		parentClass->state = false;
		return -1;
	}

	//Create the main window
	mainHWnd = CreateWindowEx(WS_EX_WINDOWEDGE,
							  parentClass->winClassName,
							  L"EconoMeter",
							  WS_SYSMENU | WS_MINIMIZEBOX,
							  0, 0, 247, 95,
							  NULL,
							  NULL,
							  parentClass->hInstance,
							  NULL);

	if(mainHWnd == NULL)									//Couldn't create main window, tell the user and report it back
	{
		MessageBox(NULL, L"Cannot create window", L"ERROR", MB_OK);
		parentClass->state = false;
		return -1;
	}

	parentClass->mainHWnd = mainHWnd;						//Set a handle to out main window in the class member variable too.

	ShowWindow(mainHWnd, SW_SHOW);							//Display the main window
	

	//Enter message loop
	MSG msg;
	while(GetMessage(&msg, mainHWnd, 0, 0) > 0)
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	parentClass->state = false;

	return 0;
}

/** Update the text output in 
*   the main window.*/
void Win32Wnd::updateData(char* inText)
{
	wchar_t temp[240];
	mbstowcs(temp, inText, 240);
	SetDlgItemText(mainHWnd, EB_OUTPUT, temp);
}

Win32Wnd::~Win32Wnd()
{
}

/**Window procedure*/
LRESULT CALLBACK Win32Wnd::WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	Win32Wnd* parentClass = (Win32Wnd*)me;

	switch(msg)
	{
	case WM_CREATE:
		{
		//Create editbox to display consumption and range info
		parentClass->ctr_EBoutput = CreateWindowEx(WS_EX_CLIENTEDGE,
												   L"EDIT",
												   NULL,
												   WS_CHILD | WS_VISIBLE | ES_READONLY | ES_CENTER,
												   CW_USEDEFAULT, CW_USEDEFAULT, 241, 30,
												   hWnd,
												   (HMENU)EB_OUTPUT,
												   parentClass->hInstance,
												   NULL);

		//Create a button to toggle mode
		parentClass->ctr_BTmode = CreateWindowEx(WS_DLGFRAME,
												 L"BUTTON",
												 L"Mode",
												 WS_CHILD | WS_VISIBLE,
												 0, 32, 79, 30,
												 hWnd,
												 (HMENU)BT_MODE,
												 parentClass->hInstance,
												 NULL);

		//Create a button to toggle units
		parentClass->ctr_BTmode = CreateWindowEx(WS_DLGFRAME,
												 L"BUTTON",
												 L"Units",
												 WS_CHILD | WS_VISIBLE,
												 81, 32, 79, 30,
												 hWnd,
												 (HMENU)BT_UNITS,
												 parentClass->hInstance,
												 NULL);

		//Create a button to reset the average counter
		parentClass->ctr_BTmode = CreateWindowEx(WS_DLGFRAME,
												 L"BUTTON",
												 L"Reset",
												 WS_CHILD | WS_VISIBLE,
												 162, 32, 79, 30,
												 hWnd,
												 (HMENU)BT_RESET,
												 parentClass->hInstance,
												 NULL);
		}
		break;
	case WM_COMMAND:
		{
			FuelDataProcess* temp = (FuelDataProcess*)parentClass->cbk_fdProc;

			switch(LOWORD(wParam))
			{
			case BT_MODE:
				temp->toggleMode();
				break;
			case BT_UNITS:
				temp->toggleUnits();
				break;
			case BT_RESET:
				temp->reInitPlr(temp->activePlid);
				break;
			}
		}
		break;
	case WM_CLOSE:
		DestroyWindow(hWnd);
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, msg, wParam, lParam);
	}
	
	return 0;
}