﻿using System;
using System.Linq;
using LfsPoints.Projects;

namespace LfsPoints.Commands {
    public class AddAllocationCommand : ICommand {
        public bool Execute(IWorkbench workbench) {

            using (PromptDialog dialog = new PromptDialog()) {
                dialog.Title = StringResources.AddAllocationDialogTitle;
                dialog.Caption = StringResources.AddAllocationDialogMessage;
                dialog.Value = String.Empty;

                if (DialogHelper.ShowDialog(dialog)) {
                    string name = dialog.Value;

                    if (Project.Current.Allocations.Any(a => a.Name == name)) {
                        DialogHelper.ShowError(
                            StringResources.AllocationExistsDialogTitle,
                            StringResources.AllocationExistsDialogMessage,
                            name);
                    }
                    else {
                        Allocation allocation = new Allocation(name);

                        Project.Current.Allocations.Add(allocation);

                        workbench.AddAllocation(allocation, selected: true);

                        return true;
                    }
                }
            }

            return false;
        }
    }
}
