﻿using System.Collections.Generic;
using System.Linq;
using LfsPoints.Projects;

namespace LfsPoints.Commands {
    public class ChangeDisplayNameCommand : ICommand {
        private string _userName;
        private string _displayName;

        public ChangeDisplayNameCommand(string userName, string displayName) {
            _userName = userName;
            _displayName = displayName;
        }

        public bool Execute(IWorkbench workbench) {
            string name = Project.Current.GetDisplayName(_userName);
            if (_displayName != name) {
                Project.Current.SetDisplayName(_userName, _displayName);

                workbench.UpdateStandingDisplayName(_userName, _displayName);

                Replay replay = workbench.ActiveReplay;
                if (replay != null) {
                    IEnumerable<Result> results = replay.Results.Where(r => r.UserName == _userName);
                    if (results.Any()) {
                        workbench.UpdateResults(results);
                    }
                }

                return true;
            }

            return false;
        }
    }
}
