﻿using System;
using LfsPoints.Projects;

namespace LfsPoints.Commands {
    public class CustomPenaltyCommand : ICommand {
        public bool Execute(IWorkbench workbench) {
            Result result = workbench.ActiveResult;

            using (NumericDialog dialog = new NumericDialog()) {
                dialog.Title = StringResources.CustomPenaltyDialogTitle;
                dialog.Caption = String.Format(StringResources.CustomPenaltyDialogMessage, result.DisplayName);
                dialog.Minimum = 0;
                dialog.Maximum = (int)TimeSpan.FromHours(1).TotalSeconds;
                dialog.Value = result.PenaltyTime.Value.TotalSeconds;

                if (DialogHelper.ShowDialog(dialog)) {
                    result.PenaltyTime = new SerializableTimeSpan(TimeSpan.FromSeconds(dialog.Value));
                    result.Replay.ReorderResults();

                    workbench.UpdateResults(result.Replay);
                    workbench.UpdateStandings();

                    return true;
                }
            }

            return false;
        }
    }
}
