﻿using System;
using System.IO;
using System.Linq;
using System.Windows.Forms;
using LfsPoints.Projects;
using LfsPoints.Properties;

namespace LfsPoints.Commands {
    public class ImportAllocationCommand : ICommand {
        public bool Execute(IWorkbench workbench) {
            bool allocationAdded = false;

            using (OpenFileDialog dialog = new OpenFileDialog()) {
                dialog.Title = "Export Points Allocation";
                dialog.Filter = "LFSPoints Points Allocation File (*.points)|*.points";
                dialog.AddExtension = true;
                dialog.Multiselect = true;
                dialog.CheckFileExists = true;
                dialog.InitialDirectory = Settings.Default.ExportDirectory;

                if (DialogHelper.ShowDialog(dialog)) {
                    workbench.Cursor = Cursors.WaitCursor;

                    foreach (string filename in dialog.FileNames) {
                        try {
                            Allocation allocation = Allocation.Load(filename);

                            if (Project.Current.Allocations.Any(a => a.Name == allocation.Name)) {
                                DialogHelper.ShowError(
                                    StringResources.AllocationExistsDialogTitle,
                                    StringResources.AllocationExistsDialogMessage,
                                    allocation.Name);
                            }
                            else {
                                Project.Current.Allocations.Add(allocation);

                                workbench.AddAllocation(allocation, selected: true);

                                allocationAdded = true;
                            }
                        }
                        catch (Exception ex) {
                            DialogHelper.ShowError("Error Importing Points Allocation", ex.Message);
                        }
                    }

                    if (allocationAdded) {
                        Settings.Default.ExportDirectory = Path.GetDirectoryName(dialog.FileName);
                    }

                    workbench.Cursor = null;
                }
            }

            return allocationAdded;
        }
    }
}
