﻿using LfsPoints.Projects;

namespace LfsPoints.Commands {
    public class PointsChangedCommand : ICommand {
        private Allocation _allocation;
        private int _position;
        private int _points;

        public PointsChangedCommand(Allocation allocation, int position, int points) {
            _allocation = allocation;
            _position = position;
            _points = points;
        }

        public bool Execute(IWorkbench workbench) {
            if (_points != _allocation.Points[_position]) {
                _allocation.Points[_position] = _points;

                workbench.UpdateStandings();

                if (workbench.ActiveReplay != null && workbench.ActiveReplay.Allocation == _allocation) {
                    workbench.UpdateResults(workbench.ActiveReplay);
                }

                return true;
            }

            return false;
        }
    }

    public class WinnerPointsChangedCommand : ICommand {
        private Allocation _allocation;
        private int _points;

        public WinnerPointsChangedCommand(Allocation allocation, int points) {
            _allocation = allocation;
            _points = points;
        }

        public bool Execute(IWorkbench workbench) {
            if (_allocation.Winner != _points) {
                _allocation.Winner = _points;

                workbench.UpdateStandings();

                if (workbench.ActiveReplay != null && workbench.ActiveReplay.Allocation == _allocation) {
                    workbench.UpdateResults(workbench.ActiveReplay);
                }

                return true;
            }

            return false;
        }
    }

    public class PolePositionPointsChangedCommand : ICommand {
        private Allocation _allocation;
        private int _points;

        public PolePositionPointsChangedCommand(Allocation allocation, int points) {
            _allocation = allocation;
            _points = points;
        }

        public bool Execute(IWorkbench workbench) {
            if (_allocation.PolePosition != _points) {
                _allocation.PolePosition = _points;

                workbench.UpdateStandings();

                if (workbench.ActiveReplay != null && workbench.ActiveReplay.Allocation == _allocation) {
                    workbench.UpdateResults(workbench.ActiveReplay);
                }

                return true;
            }

            return false;
        }
    }

    public class FastestLapPointsChangedCommand : ICommand {
        private Allocation _allocation;
        private int _points;

        public FastestLapPointsChangedCommand(Allocation allocation, int points) {
            _allocation = allocation;
            _points = points;
        }

        public bool Execute(IWorkbench workbench) {
            if (_allocation.FastestLap != _points) {
                _allocation.FastestLap = _points;

                workbench.UpdateStandings();

                if (workbench.ActiveReplay != null && workbench.ActiveReplay.Allocation == _allocation) {
                    workbench.UpdateResults(workbench.ActiveReplay);
                }

                return true;
            }

            return false;
        }
    }

    public class HighestClimbPointsChangedCommand : ICommand {
        private Allocation _allocation;
        private int _points;

        public HighestClimbPointsChangedCommand(Allocation allocation, int points) {
            _allocation = allocation;
            _points = points;
        }

        public bool Execute(IWorkbench workbench) {
            if (_allocation.HighestClimb != _points) {
                _allocation.HighestClimb = _points;

                workbench.UpdateStandings();

                if (workbench.ActiveReplay != null && workbench.ActiveReplay.Allocation == _allocation) {
                    workbench.UpdateResults(workbench.ActiveReplay);
                }

                return true;
            }

            return false;
        }
    }

    public class PercentCompletedChangedCommand : ICommand {
        private Allocation _allocation;
        private int _percent;

        public PercentCompletedChangedCommand(Allocation allocation, int percent) {
            _allocation = allocation;
            _percent = percent;
        }

        public bool Execute(IWorkbench workbench) {
            if (_allocation.PercentCompleted != _percent) {
                _allocation.PercentCompleted = _percent;

                workbench.UpdateStandings();

                if (workbench.ActiveReplay != null && workbench.ActiveReplay.Allocation == _allocation) {
                    workbench.UpdateResults(workbench.ActiveReplay);
                }

                return true;
            }

            return false;
        }
    }

    public class OmitDisqualifiedPointsChangedCommand : ICommand {
        private Allocation _allocation;
        private bool _value;

        public OmitDisqualifiedPointsChangedCommand(Allocation allocation, bool value) {
            _allocation = allocation;
            _value = value;
        }

        public bool Execute(IWorkbench workbench) {
            if (_allocation.OmitDisqualified != _value) {
                _allocation.OmitDisqualified = _value;

                workbench.UpdateStandings();

                if (workbench.ActiveReplay != null && workbench.ActiveReplay.Allocation == _allocation) {
                    workbench.UpdateResults(workbench.ActiveReplay);
                }

                return true;
            }

            return false;
        }
    }
}
