﻿using LfsPoints.Projects;

namespace LfsPoints.Commands {
    public class RemovePointsCommand : ICommand {
        private Allocation _allocation;

        public RemovePointsCommand(Allocation allocation) {
            _allocation = allocation;
        }

        public bool Execute(IWorkbench workbench) {
            int last = _allocation.Points.Count - 1;
            int points = _allocation.Points[last];

            _allocation.Points.RemoveAt(last);

            if (points > 0) {
                workbench.UpdateStandings();

                if (workbench.ActiveReplay != null && workbench.ActiveReplay.Allocation == _allocation) {
                    workbench.UpdateResults(workbench.ActiveReplay);
                }
            }

            return true;
        }
    }
}
