﻿using System.Linq;
using LfsPoints.Projects;

namespace LfsPoints.Commands {
    public class RenameAllocationCommand : ICommand {
        public bool Execute(IWorkbench workbench) {
            Allocation allocation = workbench.ActiveAllocation;

            using (PromptDialog dialog = new PromptDialog()) {
                dialog.Title = StringResources.RenameAllocationDialogTitle;
                dialog.Caption = StringResources.RenameAllocationDialogMessage;
                dialog.Value = allocation.Name;

                if (DialogHelper.ShowDialog(dialog)) {
                    string name = dialog.Value;

                    if (Project.Current.Allocations.Any(a => a.Name == name)) {
                        DialogHelper.ShowError(
                            StringResources.AllocationExistsDialogTitle,
                            StringResources.AllocationExistsDialogMessage,
                            name);
                    }
                    else {
                        allocation.Name = name;

                        workbench.UpdateAllocation(allocation);
                        workbench.UpdateReplays(Project.Current.Replays.Where(r => r.Allocation == allocation));

                        return true;
                    }
                }
            }

            return false;
        }
    }
}
