<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" indent="yes" doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN" />
  <xsl:template match="/">
    <html xmlns="http://www.w3.org/1999/xhtml">
      <head>
        <title><xsl:value-of select="Project/@Name"/> Championship</title>
        <style type="text/css">
          *
          {
            padding: 0px;
            margin: 0px;
          }

          body
          {
            font-family: Verdana, Sans-Serif;
          }

          #container
          {
            margin: auto;
            margin-top: 20px;
            width: 736px;
          }

          h1, h2
          {
            font-weight: normal;
            margin-bottom: 10px;
          }

          table
          {
            margin-bottom: 10px;
          }

          h1
          {
            font-size: 1.6em;
            margin-bottom: 20px;
          }

          h2
          {
           font-size: 1.3em;
          }

          table tr td, table tr th
          {
            font-size: 0.8em;
            padding-right: 20px;
            padding-bottom: 2px;
          }

          table tr th
          {
            font-weight: bold;
            text-align: left;
          }

          .replay, #standings
          {
            border-bottom: 1px dashed #ddd;
            margin-bottom: 20px;
            padding-bottom: 10px;
          }

          #footer
          {
            font-size: 0.6em;
            text-align: center;
            margin-bottom: 20px;
          }
        </style>
      </head>
      <body>
        <div id="container">
          <div id="header">
            <h1><xsl:value-of select="Project/@Name"/> Championship</h1>
          </div>

          <div id="standings">
            <h2>Driver Standings</h2>

            <table>
              <tr>
                <th>#</th>
                <th>Driver</th>
                <th>Points</th>
              </tr>
              <xsl:for-each select="Project/Standings/Standing">
                <tr>
                  <td><xsl:value-of select="Position"/>.</td>
                  <td><xsl:value-of select="Driver"/></td>
                  <td><xsl:value-of select="Points"/></td>
                </tr>
              </xsl:for-each>
            </table>
          </div>

          <div id="replays">
            <xsl:for-each select="Project/Replays/Replay">
              <div class="replay">
                <h2><xsl:value-of select="Name"/></h2>

                <table>
                  <tr>
                    <td><strong>Track:</strong></td>
                    <td><xsl:value-of select="Track"/></td>
                    <td><strong>Laps:</strong></td>
                    <td><xsl:value-of select="Laps"/></td>
                  </tr>
                  <tr>
                    <td><strong>Date:</strong></td>
                    <td><xsl:value-of select="Date"/></td>
                    <td><strong>Points:</strong></td>
                    <td><xsl:value-of select="Points"/></td>
                  </tr>
                </table>

                <table>
                  <tr>
                    <th>#</th>
                    <th>Driver</th>
                    <th>Car</th>
                    <th>Grid</th>
                    <th>Time</th>
                    <th>Penalty</th>
                    <th>Best Lap</th>
                    <th>Points</th>
                  </tr>
                  <xsl:for-each select="Results/Result">
                    <tr>
                      <td><xsl:value-of select="Position"/>.</td>
                      <td><xsl:value-of select="Driver"/></td>
                      <td><xsl:value-of select="Car"/></td>
                      <td><xsl:value-of select="Grid"/></td>
                      <td><xsl:value-of select="Time"/></td>
                      <td><xsl:value-of select="Penalty"/></td>
                      <td><xsl:value-of select="BestLap"/></td>
                      <td><xsl:value-of select="Points"/></td>
                    </tr>
                  </xsl:for-each>
                </table>
              </div>
            </xsl:for-each>

            <div id="footer">Generated by <a href="http://www.lfsforum.net/showthread.php?t=31513">LFSPoints</a></div>
          </div>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>