﻿using System.Diagnostics;
using System.IO;
using System.Linq;
using Microsoft.Win32;

namespace LfsPoints {
    public static class LfsHelper {
        private const string LfsRegistryPath = @"Software\Live for Speed";

        public static bool IsLfsInstalled {
            get {
                using (RegistryKey key = Registry.CurrentUser.OpenSubKey(LfsRegistryPath)) {
                    return key != null;
                }
            }
        }

        public static bool IsLfsRunning {
            get {
                return Process.GetProcesses().Any(p => p.ProcessName == "LFS");
            }
        }

        public static string LfsDirectory {
            get {
                using (RegistryKey key = Registry.CurrentUser.OpenSubKey(LfsRegistryPath)) {
                    if (key != null) {
                        return key.GetValue(null) as string;
                    }
                }

                return null;
            }
        }

        public static string LfsExePath {
            get {
                string lfsDir = LfsDirectory;
                if (Directory.Exists(lfsDir)) {
                    return Path.Combine(lfsDir, "LFS.exe");
                }
                return null;
            }
        }

        public static string MprDirectory {
            get {
                string lfsDir = LfsDirectory;
                if (Directory.Exists(lfsDir)) {
                    return Path.Combine(lfsDir, "data", "mpr");
                }
                return null;
            }
        }
    }
}
