﻿using System;
using System.Collections.Specialized;
using System.Linq;
using LfsPoints.Properties;
using Microsoft.VisualBasic.ApplicationServices;

namespace LfsPoints {
    public class LfsPointsApp : WindowsFormsApplicationBase {
        public LfsPointsApp()
            : base() {
            IsSingleInstance = true;
            ShutdownStyle = ShutdownMode.AfterMainFormCloses;
        }

        protected override bool OnStartup(StartupEventArgs eventArgs) {
            InitializeSettings();

            return base.OnStartup(eventArgs);
        }

        private static void InitializeSettings() {
            string documents = Environment.GetFolderPath(Environment.SpecialFolder.MyDocuments);

            if (String.IsNullOrEmpty(Settings.Default.ExportDirectory)) {
                Settings.Default.ExportDirectory = documents;
            }

            if (String.IsNullOrEmpty(Settings.Default.SaveDirectory)) {
                Settings.Default.SaveDirectory = documents;
            }

            if (String.IsNullOrEmpty(Settings.Default.ReplayDirectory)) {
                Settings.Default.ReplayDirectory = LfsHelper.MprDirectory ?? documents;
            }

            if (Settings.Default.RecentProjects == null) {
                Settings.Default.RecentProjects = new StringCollection();
            }
        }

        protected override void OnShutdown() {
            Settings.Default.Save();

            base.OnShutdown();
        }

        protected override void OnCreateMainForm() {
            Workbench workbench = new Workbench(CommandLineArgs);
            MainForm = workbench;
            DialogHelper.Owner = workbench;

            base.OnCreateMainForm();
        }

        protected override void OnStartupNextInstance(StartupNextInstanceEventArgs eventArgs) {
            eventArgs.BringToForeground = true;

            if (CommandLineArgs.Any()) {
                ((IWorkbench)MainForm).HandleCommandLineArgs(eventArgs.CommandLine);
            }

            base.OnStartupNextInstance(eventArgs);
        }
    }
}
