﻿using System;
using System.ComponentModel;
using System.Windows.Forms;
using System.Linq;
using LfsPoints.Commands;
using LfsPoints.Projects;

namespace LfsPoints.Menus {
    public class ReplaysContextMenu : ContextMenuBase {
        private ToolStripMenuItem _removeMenuItem;
        private ToolStripMenuItem _pointsAllocationMenuItem;
        private ToolStripSeparator toolStripSeparator1;

        public ReplaysContextMenu()
            : base() {
            InitializeComponent();

            _removeMenuItem.Click += new EventHandler(_removeMenuItem_Click);
        }

        private void InitializeComponent() {
            this._removeMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this._pointsAllocationMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.SuspendLayout();
            // 
            // _removeMenuItem
            // 
            this._removeMenuItem.Name = "_removeMenuItem";
            this._removeMenuItem.ShortcutKeyDisplayString = "Del";
            this._removeMenuItem.Size = new System.Drawing.Size(164, 22);
            this._removeMenuItem.Text = "Remove";
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size(161, 6);
            // 
            // _pointsAllocationMenuItem
            // 
            this._pointsAllocationMenuItem.Name = "_pointsAllocationMenuItem";
            this._pointsAllocationMenuItem.Size = new System.Drawing.Size(164, 22);
            this._pointsAllocationMenuItem.Text = "Points Allocation";
            // 
            // ReplaysContextMenu
            // 
            this.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._removeMenuItem,
            this.toolStripSeparator1,
            this._pointsAllocationMenuItem});
            this.Size = new System.Drawing.Size(165, 54);
            this.ResumeLayout(false);

        }

        protected override void OnOpening(CancelEventArgs e) {
            ClearAddReplaysMenu();

            Replay replay = AppWorkbench.ActiveReplay;

            foreach (Allocation allocation in Project.Current.Allocations) {
                ToolStripMenuItem item = (ToolStripMenuItem)_pointsAllocationMenuItem.DropDownItems.Add(allocation.Name);
                item.Click += new EventHandler(_allocationMenuItem_Click);
                item.Tag = allocation;
                item.Checked = allocation == replay.Allocation;
            }

            base.OnOpening(e);
        }

        private void ClearAddReplaysMenu() {
            foreach (ToolStripItem item in _pointsAllocationMenuItem.DropDownItems) {
                item.Click -= _allocationMenuItem_Click;
            }
            _pointsAllocationMenuItem.DropDownItems.Clear();
        }

        private void _allocationMenuItem_Click(object sender, EventArgs e) {
            Allocation allocation = (Allocation)((ToolStripItem)sender).Tag;
            AppWorkbench.ExecuteCommand(new ChangeReplayAllocationCommand(allocation));
        }

        private void _removeMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.ExecuteCommand(new RemoveReplaysCommand());
        }
    }
}
