﻿using System;
using System.ComponentModel;
using System.Windows.Forms;
using LfsPoints.Commands;

namespace LfsPoints.Menus {
    public class ResultsContextMenu : ContextMenuBase {
        private ToolStripSeparator toolStripSeparator1;
        private ToolStripMenuItem _customPenaltyMenuItem;
        private ToolStripSeparator toolStripSeparator2;
        private ToolStripMenuItem _removeMenuItem;
        private DisplayNamesMenuItem _displayNamesMenuItem;
        private ToolStripMenuItem _viewLfsWorldStatsMenuItem;

        public ResultsContextMenu()
            : base() {
            InitializeComponent();

            _removeMenuItem.Click += new EventHandler(_removeMenuItem_Click);
            _customPenaltyMenuItem.Click += new EventHandler(_customPenaltyMenuItem_Click);
            _viewLfsWorldStatsMenuItem.Click += new EventHandler(_viewLfsWorldStatsMenuItem_Click);
        }

        private void InitializeComponent() {
            this._viewLfsWorldStatsMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this._customPenaltyMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripSeparator2 = new System.Windows.Forms.ToolStripSeparator();
            this._removeMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this._displayNamesMenuItem = new LfsPoints.Menus.DisplayNamesMenuItem();
            this.SuspendLayout();
            // 
            // _viewLfsWorldStatsMenuItem
            // 
            this._viewLfsWorldStatsMenuItem.Name = "_viewLfsWorldStatsMenuItem";
            this._viewLfsWorldStatsMenuItem.Size = new System.Drawing.Size(187, 22);
            this._viewLfsWorldStatsMenuItem.Text = "View LFSWorld Stats";
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size(184, 6);
            // 
            // _customPenaltyMenuItem
            // 
            this._customPenaltyMenuItem.Name = "_customPenaltyMenuItem";
            this._customPenaltyMenuItem.Size = new System.Drawing.Size(187, 22);
            this._customPenaltyMenuItem.Text = "Custom Penalty";
            // 
            // toolStripSeparator2
            // 
            this.toolStripSeparator2.Name = "toolStripSeparator2";
            this.toolStripSeparator2.Size = new System.Drawing.Size(184, 6);
            // 
            // _removeMenuItem
            // 
            this._removeMenuItem.Name = "_removeMenuItem";
            this._removeMenuItem.ShortcutKeyDisplayString = "Del";
            this._removeMenuItem.Size = new System.Drawing.Size(187, 22);
            this._removeMenuItem.Text = "Remove";
            // 
            // _displayNamesMenuItem
            // 
            this._displayNamesMenuItem.Name = "_displayNamesMenuItem";
            this._displayNamesMenuItem.Size = new System.Drawing.Size(187, 22);
            this._displayNamesMenuItem.Text = "Driver Name";
            // 
            // ResultsContextMenu
            // 
            this.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._removeMenuItem,
            this._customPenaltyMenuItem,
            this.toolStripSeparator2,
            this._displayNamesMenuItem,
            this.toolStripSeparator1,
            this._viewLfsWorldStatsMenuItem});
            this.Size = new System.Drawing.Size(188, 104);
            this.ResumeLayout(false);

        }

        private void _removeMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.ExecuteCommand(new RemoveResultsCommand());
        }

        private void _customPenaltyMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.ExecuteCommand(new CustomPenaltyCommand());
        }

        private void _viewLfsWorldStatsMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.ExecuteCommand(new OpenLfsWorldCommand(AppWorkbench.ActiveResult.UserName));
        }
    }
}
