﻿using System;
using System.ComponentModel;
using System.Windows.Forms;
using LfsPoints.Commands;

namespace LfsPoints.Menus {
    public class StandingsContextMenu : ContextMenuBase {
        private ToolStripSeparator toolStripSeparator1;
        private DisplayNamesMenuItem _displayNamesMenuItem;
        private ToolStripMenuItem _viewLfsWorldStatsMenuItem;

        public StandingsContextMenu()
            : base() {
            InitializeComponent();

            _viewLfsWorldStatsMenuItem.Click += new EventHandler(_viewLfsWorldStatsMenuItem_Click);
        }

        private void InitializeComponent() {
            this.toolStripSeparator1 = new System.Windows.Forms.ToolStripSeparator();
            this._viewLfsWorldStatsMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this._displayNamesMenuItem = new LfsPoints.Menus.DisplayNamesMenuItem();
            this.SuspendLayout();
            // 
            // toolStripSeparator1
            // 
            this.toolStripSeparator1.Name = "toolStripSeparator1";
            this.toolStripSeparator1.Size = new System.Drawing.Size(184, 6);
            // 
            // _viewLfsWorldStatsMenuItem
            // 
            this._viewLfsWorldStatsMenuItem.Name = "_viewLfsWorldStatsMenuItem";
            this._viewLfsWorldStatsMenuItem.Size = new System.Drawing.Size(187, 22);
            this._viewLfsWorldStatsMenuItem.Text = "View LFSWorld Stats";
            // 
            // _displayNamesMenuItem
            // 
            this._displayNamesMenuItem.Name = "_displayNamesMenuItem";
            this._displayNamesMenuItem.Size = new System.Drawing.Size(187, 22);
            this._displayNamesMenuItem.Text = "Driver Name";
            // 
            // StandingsContextMenu
            // 
            this.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this._displayNamesMenuItem,
            this.toolStripSeparator1,
            this._viewLfsWorldStatsMenuItem});
            this.Size = new System.Drawing.Size(188, 54);
            this.ResumeLayout(false);
        }

        private void _viewLfsWorldStatsMenuItem_Click(object sender, EventArgs e) {
            AppWorkbench.ExecuteCommand(new OpenLfsWorldCommand(AppWorkbench.ActiveStanding.UserName));
        }
    }
}
