﻿using System;
using System.Windows.Forms;

namespace LfsPoints {
    public partial class NumericDialog : Form {
        private double _originalValue;

        public string Title {
            get { return Text; }
            set { Text = value; }
        }

        public string Caption {
            get { return _captionLabel.Text; }
            set { _captionLabel.Text = value; }
        }

        public double Value {
            get { return (double)_valueNumericUpDown.Value; }
            set {
                _valueNumericUpDown.Value = (decimal)value;
                _originalValue = value;
            }
        }

        public double Maximum {
            get { return (double)_valueNumericUpDown.Maximum; }
            set { _valueNumericUpDown.Maximum = (decimal)value; }
        }

        public double Minimum {
            get { return (double)_valueNumericUpDown.Minimum; }
            set { _valueNumericUpDown.Minimum = (decimal)value; }
        }

        public NumericDialog() {
            InitializeComponent();

            ActiveControl = _valueNumericUpDown;
        }

        private void OnOkButtonClick(object sender, EventArgs e) {
            if (Value != _originalValue) {
                DialogResult = DialogResult.OK;
            }
            Close();
        }
    }
}
