﻿using System;
using System.IO;
using System.Text;

namespace LfsPoints.Projects {
    public class LfsFileReader : BinaryReader {
        public LfsFileReader(Stream input)
            : base(input) { }

        public void Skip(int count) {
            BaseStream.Seek(count, SeekOrigin.Current);
        }

        public string ReadString(int count) {
            return ASCIIEncoding.ASCII.GetString(ReadBytes(count)).TrimEnd(Char.MinValue);
        }

        public string ReadLfsString(int count) {
            return EncodingHelper.GetString(ReadBytes(count));
        }

        public DateTime ReadTimestamp() {
            return new DateTime(1970, 1, 1).AddSeconds(ReadUInt32()).ToLocalTime();
        }

        public TimeSpan ReadSeconds() {
            return TimeSpan.FromSeconds(ReadUInt16());
        }

        public TimeSpan ReadMilliseconds() {
            return TimeSpan.FromMilliseconds(ReadUInt32());
        }
    }
}
