﻿using System;
using System.Xml.Serialization;

namespace LfsPoints.Projects {
    [Serializable]
    public class SerializableDateTime {
        [XmlIgnore]
        public DateTime Value { get; private set; }

        public string SerializationValue {
            get { return Value.ToString(); }
            set { Value = DateTime.Parse(value); }
        }

        public SerializableDateTime()
            : this(new DateTime()) { }

        public SerializableDateTime(DateTime value) {
            Value = value;
        }

        public override string ToString() {
            return Value.ToString();
        }

        public string ToString(string format) {
            return Value.ToString(format);
        }
    }
}
