﻿using System;
using System.Xml.Serialization;

namespace LfsPoints.Projects {
    [Serializable]
    public class SerializableTimeSpan {
        [XmlIgnore]
        public TimeSpan Value { get; private set; }

        public string SerializationValue {
            get { return Value.ToString(); }
            set { Value = TimeSpan.Parse(value); }
        }

        public SerializableTimeSpan()
            : this(TimeSpan.Zero) { }

        public SerializableTimeSpan(TimeSpan value) {
            Value = value;
        }

        public override string ToString() {
            return Value.ToString();
        }

        public string ToString(string format) {
            return Value.ToString(format);
        }
    }
}
