﻿using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Globalization;
using System.Linq;
using System;

namespace LfsPoints.Projects {
    public static class TrackHelper {
        private static readonly Dictionary<string, string> TrackMap = new Dictionary<string, string>()
        {
            { "BL1", "Blackwood Grand Prix" },
            { "BL2", "Blackwood Rallycross" },
            { "BL3", "Blackwood Car Park" },
            { "SO1", "South City Classic" },
            { "SO2", "South City Sprint 1" },
            { "SO3", "South City Sprint 2" },
            { "SO4", "South City Long" },
            { "SO5", "South City Town" },
            { "SO6", "South City Chicane" },
            { "FE1", "Fern Bay Club" },
            { "FE2", "Fern Bay Green" },
            { "FE3", "Fern Bay Gold" },
            { "FE4", "Fern Bay Black" },
            { "FE5", "Fern Bay Rallycross" },
            { "FE6", "Fern Bay RallyX Green" },
            { "AU1", "Autocross" },
            { "AU2", "Skid Pad" },
            { "AU3", "Drag Strip" },
            { "AU4", "Eight Lane Drag" },
            { "KY1", "Kyoto Ring Oval" },
            { "KY2", "Kyoto Ring National" },
            { "KY3", "Kyoto Ring Grand Prix" },
            { "WE1", "Westhill International" },
            { "AS1", "Aston Cadet" },
            { "AS2", "Aston Club" },
            { "AS3", "Aston National" },
            { "AS4", "Aston Historic" },
            { "AS5", "Aston Grand Prix" },
            { "AS6", "Aston Grand Touring" },
            { "AS7", "Aston North" },
            { "BL1R", "Blackwood Grand Prix Reversed" },
            { "BL2R", "Blackwood Rallycross Reversed" },
            { "BL3R", "Blackwood Car Park Reversed" },
            { "SO1R", "South City Classic Reversed" },
            { "SO2R", "South City Sprint 1 Reversed" },
            { "SO3R", "South City Sprint 2 Reversed" },
            { "SO4R", "South City Long Reversed" },
            { "SO5R", "South City Town Reversed" },
            { "SO6R", "South City Chicane Reversed" },
            { "FE1R", "Fern Bay Club Reversed" },
            { "FE2R", "Fern Bay Green Reversed" },
            { "FE3R", "Fern Bay Gold Reversed" },
            { "FE4R", "Fern Bay Black Reversed" },
            { "FE5R", "Fern Bay Rallycross Reversed" },
            { "FE6R", "Fern Bay RallyX Green Reversed" },
            { "AU1R", "Autocross Reversed" },
            { "AU2R", "Skid Pad Reversed" },
            { "AU3R", "Drag Strip Reversed" },
            { "AU4R", "Eight Lane Drag Reversed" },
            { "KY1R", "Kyoto Ring Oval Reversed" },
            { "KY2R", "Kyoto Ring National Reversed" },
            { "KY3R", "Kyoto Ring Grand Prix Reversed" },
            { "WE1R", "Westhill International Reversed" },
            { "AS1R", "Aston Cadet Reversed" },
            { "AS2R", "Aston Club Reversed" },
            { "AS3R", "Aston National Reversed" },
            { "AS4R", "Aston Historic Reversed" },
            { "AS5R", "Aston Grand Prix Reversed" },
            { "AS6R", "Aston Grand Touring Reversed" },
            { "AS7R", "Aston North Reversed" },
        };

        public static string GetFullTrackName(string shortTrackName) {
            string track;
            if (TrackMap.TryGetValue(shortTrackName, out track)) {
                return track;
            }

            return String.Empty;
        }
    }
}
