﻿using System.Windows.Forms;
using LfsPoints.Projects;

namespace LfsPoints {
    public class ReplaysColumnSorter : IColumnSorter {
        public int Column { get; set; }
        public SortOrder Order { get; set; }

        public ReplaysColumnSorter() {
            Reset();
        }

        public void Reset() {
            Column = 4; // Date
            Order = SortOrder.Ascending;
        }

        public int Compare(object x, object y) {
            Replay a = (Replay)((ListViewItem)x).Tag;
            Replay b = (Replay)((ListViewItem)y).Tag;
            int compare = 0;

            switch (Column) {
                case 0:
                    compare = a.Name.CompareTo(b.Name);
                    break;
                case 1:
                    compare = a.TrackName.CompareTo(b.TrackName);
                    break;
                case 2:
                    compare = a.Laps.CompareTo(b.Laps);
                    break;
                case 3:
                    compare = a.Results.Count.CompareTo(b.Results.Count);
                    break;
                case 4:
                    compare = a.StartTime.Value.CompareTo(b.StartTime.Value);
                    break;
                case 5:
                    compare = a.RaceMode.CompareTo(b.RaceMode);
                    break;
                case 6:
                    compare = a.Allocation.Name.CompareTo(b.Allocation.Name);
                    break;
            }

            if (Order == SortOrder.Ascending) {
                return compare;
            }
            else if (Order == SortOrder.Descending) {
                return -compare;
            }
            return 0;
        }
    }
}
