using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Xml;
using System.Collections;
using System.Security.Cryptography;



namespace ADMLapperGUI
{
    public partial class ManageServers : Form
    {
        public ManageServers( MainForm form1 )
        {
            this.form1 = form1;
            InitializeComponent();
        }
        XmlDocument myDoc = new XmlDocument();
        bool flagProgChangeText = false;
        MainForm form1;
        private void processNode( XmlNodeList nodeList, TreeNode tnode ){
            foreach (XmlNode node in nodeList)
            {
                if (node.NodeType == XmlNodeType.Element)
                {
                    if (node.Name == "infoServ")
                    {
                        TreeNode newNode = tnode.Nodes.Add(node.Attributes["name"].Value);
                        newNode.ImageIndex = 2;
                        newNode.SelectedImageIndex = 2;
                        newNode.Tag = node;
                    }
                    else if (node.Name == "LAPServers")
                    {
                        tnode.Tag = node;
                        tnode.Text = node.Attributes["name"].Value;
                        if (node.HasChildNodes)
                            processNode(node.ChildNodes, tnode);
                    }
                    else if (node.Name == "GroupServers")
                    {
                        TreeNode newNode = tnode.Nodes.Add(node.Attributes["name"].Value);
                        newNode.ImageIndex = 0;
                        newNode.SelectedImageIndex = 0;
                        newNode.Tag = node;

                        if (node.HasChildNodes)
                            processNode(node.ChildNodes, newNode);
                    }
                }

            }
        }
        private void ManageServers_Load(object sender, EventArgs e)
        {
            myDoc.Load("ADMLapperGUI.cfg");
            TreeNode tn = new TreeNode("LFS Servers");
            tn.ImageIndex = 0;
            tn.SelectedImageIndex = 0;
            treeServers.Nodes.Add(tn);
            processNode(myDoc.SelectNodes("/ADMLapperGUI/LAPServers"), tn);
            tn.Expand();
            treeServers.TreeViewNodeSorter = new NodeSorter();

//            treeServers.Sort();

        }

        private void treeServers_AfterSelect(object sender, TreeViewEventArgs e)
        {
            XmlNode currXmlNode = (XmlNode)e.Node.Tag;
            majInfoNode(currXmlNode);
            
        }
        private void majInfoNode(XmlNode currXmlNode)
        {
            if (currXmlNode.Name == "infoServ" )
            {
                ServerName.Text = currXmlNode.Attributes["name"].Value;
                serverIp.Text = currXmlNode.Attributes["ip"].Value; ;
                serverPass.Text = currXmlNode.Attributes["pass"].Value;
                ServerName.Enabled = true;
                serverIp.Enabled = true;
                serverPass.Enabled = true;
                treeServers.ContextMenuStrip.Items["addGroupToolStripMenuItem"].Visible = false;
                treeServers.ContextMenuStrip.Items["addServerToolStripMenuItem"].Visible = false;
                treeServers.ContextMenuStrip.Items["removeServerToolStripMenuItem"].Visible = true;
                treeServers.ContextMenuStrip.Items["removeGroupToolStripMenuItem"].Visible = false;

                
            }
            else
            {
                ServerName.Text = "";
                serverIp.Text = "";
                serverPass.Text = "";
                ServerName.Enabled = false;
                serverIp.Enabled = false;
                serverPass.Enabled = false;
                treeServers.ContextMenuStrip.Items["addGroupToolStripMenuItem"].Visible = true;
                treeServers.ContextMenuStrip.Items["addServerToolStripMenuItem"].Visible = true;
                treeServers.ContextMenuStrip.Items["removeServerToolStripMenuItem"].Visible = false;
                treeServers.ContextMenuStrip.Items["removeGroupToolStripMenuItem"].Visible = true;
            }
            flagProgChangeText = false;
        }
        private void treeServers_AfterExpand(object sender, TreeViewEventArgs e)
        {
            XmlNode currXmlNode = (XmlNode)e.Node.Tag;
            if (currXmlNode.Name == "GroupServers" || currXmlNode.Name == "LAPServers")
            {
                e.Node.ImageIndex = 1;
                e.Node.SelectedImageIndex = 1;
            }

        }

        private void treeServers_BeforeCollapse(object sender, TreeViewCancelEventArgs e)
        {
            XmlNode currXmlNode = (XmlNode)e.Node.Tag;
            if (currXmlNode.Name == "GroupServers" || currXmlNode.Name == "LAPServers")
            {
                e.Node.ImageIndex = 0;
                e.Node.SelectedImageIndex = 0;
            }

        }

        private void treeServers_AfterLabelEdit(object sender, NodeLabelEditEventArgs e)
        {
            XmlNode currXmlNode = (XmlNode)e.Node.Tag;
            if (e.Label != null)
            {
                currXmlNode.Attributes["name"].Value = e.Label;
            }
            majInfoNode(currXmlNode);
        }
        private void ServerName_Validating(object sender, CancelEventArgs e)
        {
            if (ServerName.Modified)
            {
                treeServers.SelectedNode.Text = ServerName.Text;
                XmlNode currXmlNode = (XmlNode)treeServers.SelectedNode.Tag;
                currXmlNode.Attributes["name"].Value = ServerName.Text;
            }

        }
        private void serverIp_Validating(object sender, CancelEventArgs e)
        {
            if (serverIp.Modified)
            {
                XmlNode currXmlNode = (XmlNode)treeServers.SelectedNode.Tag;
                currXmlNode.Attributes["ip"].Value = serverIp.Text;
            }
        }
        private void pass_Validating(object sender, CancelEventArgs e)
        {
            ASCIIEncoding encoder = new ASCIIEncoding();
            if (serverPass.Modified)
            {
                XmlNode currXmlNode = (XmlNode)treeServers.SelectedNode.Tag;
                MD5 MD5Pass = MD5.Create("MD5");
                //            currInfoServ.pass = encoder.GetString(MD5Pass.ComputeHash(encoder.GetBytes(this.pass.Text)));
                currXmlNode.Attributes["pass"].Value = serverPass.Text;
            }
        }

        private void addGroupToolStripMenuItem_Click(object sender, EventArgs e)
        {
            TreeNode currNode = treeServers.SelectedNode;
            XmlNode currXmlNode = (XmlNode)treeServers.SelectedNode.Tag;
            string name = "New group";

            treeServers.TreeViewNodeSorter = null;

            System.Xml.XmlElement newXmlNode = myDoc.CreateElement("GroupServers");
            newXmlNode.SetAttribute("name", name);
            newXmlNode.InnerText = "";
            currXmlNode.AppendChild(newXmlNode);


            TreeNode tn = new TreeNode(name);
            tn.ImageIndex = 0;
            tn.SelectedImageIndex = 0;
            tn.Tag = newXmlNode;
            currNode.Nodes.Add(tn);
            currNode.Expand();
            Save.Enabled = true;
            treeServers.TreeViewNodeSorter = new NodeSorter();

            tn.BeginEdit();
        }

        private void addServerToolStripMenuItem_Click(object sender, EventArgs e)
        {
            TreeNode currNode = treeServers.SelectedNode;
            XmlNode currXmlNode = (XmlNode)treeServers.SelectedNode.Tag;
            string name = "New server";

            treeServers.TreeViewNodeSorter = null;

            System.Xml.XmlElement newXmlNode = myDoc.CreateElement( "infoServ" );
            newXmlNode.SetAttribute("name", name);
            newXmlNode.SetAttribute("ip", "127.0.0.1");
            newXmlNode.SetAttribute("pass", "");
            newXmlNode.InnerText = "";
            currXmlNode.AppendChild(newXmlNode);

            TreeNode tn = new TreeNode(name);
            tn.ImageIndex = 2;
            tn.SelectedImageIndex = 2;
            tn.Tag = newXmlNode;
            currNode.Nodes.Add(tn);
            currNode.Expand();
            Save.Enabled = true;
            treeServers.TreeViewNodeSorter = new NodeSorter();
            tn.BeginEdit();
        }

        private void removeServerToolStripMenuItem_Click(object sender, EventArgs e)
        {
            treeServers.TreeViewNodeSorter = null;

            TreeNode currNode = treeServers.SelectedNode;
            (currNode.Tag as XmlNode).RemoveAll();
            XmlNode oldNode = (XmlNode)currNode.Tag;
            (currNode.Tag as XmlNode).ParentNode.RemoveChild(oldNode);
            currNode.Remove();
            Save.Enabled = true;
            treeServers.TreeViewNodeSorter = new NodeSorter();

        }

        private void removeGroupToolStripMenuItem_Click(object sender, EventArgs e)
        {
            TreeNode currNode = treeServers.SelectedNode;
            if (currNode.Level > 0)
            {
                treeServers.TreeViewNodeSorter = null;
                (currNode.Tag as XmlNode).RemoveAll();
                XmlNode oldNode = (XmlNode)currNode.Tag;
                (currNode.Tag as XmlNode).ParentNode.RemoveChild(oldNode);
                currNode.Remove();
                Save.Enabled = true;
                treeServers.TreeViewNodeSorter = new NodeSorter();

            }
        }

        private void treeServers_MouseDown(object sender, MouseEventArgs e)
        {
            treeServers.SelectedNode = treeServers.GetNodeAt(e.X, e.Y); 
        }

        private void renameToolStripMenuItem_Click(object sender, EventArgs e)
        {
            treeServers.SelectedNode.BeginEdit();
            Save.Enabled = true;
        }


        private void ServerName_TextChanged(object sender, EventArgs e)
        {
            if (!flagProgChangeText)
                Save.Enabled = true;
        }

        private void serverIp_TextChanged(object sender, EventArgs e)
        {
            if (!flagProgChangeText)
                Save.Enabled = true;
        }

        private void serverPass_TextChanged(object sender, EventArgs e)
        {
            if (!flagProgChangeText)
                Save.Enabled = true;

        }

        private void Save_Click(object sender, EventArgs e)
        {
            myDoc.Save("ADMLapperGUI.cfg");
            form1.updateTree();
            Save.Enabled = false;
        }
        private void Quit_Click(object sender, EventArgs e)
        {
            this.Close();
        }


    }
}