#	Sinanju's amended "lapper" file
#	=======================
#	LFS Lapper v 6.012                                                                                                       
#	updated 9 January 2012                           
#	- To show some of the things that can be done with LFSLapper ("lapper")
##########################

##############
# Const include #
##############

include( "./includes/consts.lpr");

###############
#General options#
###############

$AdminFile = "./admin.txt"; # Name of the file containing admin lfsname player
$StoredValueDbs = "storedvalue"; # Name of the database in which additional values are stored
$TrackInfoFile = "trackInfo.cfg"; # Path to the TrackInfoFile used to compare splits
$TCPmode = true; # Connection to LFS in UDP mode or TCP mode
$EnableRegisterWeb = true; # When set to "true" your LFS Server is displayed on the FRH Team website
$DateFormat = "dd/MM/yyyy";
$LongDateFormat = "dddd dd MMMM yyyy";
$MessageTime = 4500; # Time in milliseconds for a racecontrol message (started by: rcm_all) to be displayed on screen
$PubStatIdk = "";
$DefaultTopCar = "UFR+XFR+RB4+RAC+FZR+XRR+FXR+FBM+LX4+LX6+XFG+XRG+XRT+FZ5+FXO+FO8+FOX+MRT+UF1+BF1";
$ShowPlayerControl = False; # Set option to "true" if you want to show the control configuration of players when leaving the pits.


#########################################################
# To make your own test, called when you type !test in chat LFS Window #
#########################################################
Sub MyTest()
IF( UserInGroup( "admin",$userName ) == 1 )
THEN
	privMsg( GetCurrentPlayerVar("NickName") . " ^7is testing...");
ELSE
		openGlobalButton( "hud_message",74,1,52,5,4,8,0,langEngine( "%{main_notadmin}%" ) );
EndSub


############################
#Event triggered when lapper start#
############################

Event OnLapperStart()

######		Query for later: can points be awarded for fastest lap and/or pole position
#For points system

  GlobalVar $point_L ;
   $point_L = 75 ;
  GlobalVar $point_T ;
   $point_T = 30 ;
  GlobalVar $ps_max_points;
   $ps_max_points=10;


	GlobalVar $marshall_on_off; # 	For turning Marshall off and on (but NOT boards)
		$marshall_on_off = "on";       #Marshall option turned on, unless player wants to switch off

	RegisterScheduleAction( "0 0 0 * * * *", SA_mid );
	RegisterScheduleAction( "0 0 0 * 1 1 *", SA_newyear );
	RegisterScheduleAction( "53 28 1 * * * *", SE_faster );
	RegisterScheduleAction( "19 41 1 * * * *", SE_tired1 );
	RegisterScheduleAction( "36 41 1 * * * *", SE_tired2 );
	RegisterScheduleAction( "42 57 1 * * * *", SE_email );

	RegisterZoneAction( "AS1" , -313,-136, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "AS1" , -295,236, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "AS1R" , -299,210, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "AS1R" , -302,-127, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "AS2" , -619,-16, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "AS2" , -610,536, 3 , SE_enterpits,SE_flashinglights );
 
	RegisterZoneAction( "AS2R" , -620,-440, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "AS2R" , -620,-193, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "AS3" , -618,-5, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "AS3" , -610,-533, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "AS3R" , -621,-440, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "AS3R" , -620,-126, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "AS4" , -621,-440, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "AS4" , -620,-126, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "AS4R" , -619,-439, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "AS4R" , -619,3, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "AS6R" , -621,-440, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "AS6R" , -620,49, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "BL1" , 12,591, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "BL1" , -32,-169, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "BL1R" , -31,-176, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "BL1R" , -13,373, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "BL2" , -78,198, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "BL2" , -56,-71, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "BL2R" , -85,-29, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "BL2R" , -53,273, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "FE1" , 185,192, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE1" , 178,-55, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "FE1R" , 180,-35, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE1R" , 178,226, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "FE2" , -24,-238, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE2" , -8,-480, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "FE2R" , -23,-420, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE2R" , -6,-176, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "FE2X" , -27,-255, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE2X" , -9,-486, 3 , SE_enterpits,SE_flashinglights );


	RegisterZoneAction( "FE3" , 184,173, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE3" , 174,-78, 3 , SE_enterpits,SE_flashinglights );
	                    
	RegisterZoneAction( "FE3R" , 186,5, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE3R" , 176,241, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "FE4" , 184,173, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE4" , 182,-35, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "FE4R" , 186,5, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE4R" , 177,233, 3 , SE_enterpits,SE_flashinglights );	
	
	RegisterZoneAction( "FE5" , -26,-256, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE5" , -9,-489, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "FE5R" , -23,-419, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE5R" , -9,-187, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "FE6" , -220,-405, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE6" , -175,-516, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "FE6R" , -193,-462, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "FE6R" , -242,-366, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "KY1" , -463,696, 3 , SE_enterpits,SE_flashinglights );
	RegisterZoneAction( "KY1" , -370,26, 3 , SE_leavepits,SE_bluelights );

	RegisterZoneAction( "KY1R" , -460,569, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "KY1R" , -343,28, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "KY2" , -462,570, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "KY2" , -392,-64, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "KY2R" , -360,7, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "KY2R" , -462,-645, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "KY3" , -705,343, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "KY3" , -715,795, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "KY3R" , -735,713, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "KY3R" , -686,280, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "SO1" , 143,378, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO1" , 233,-112, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "SO1R" , 242,-36, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO1R" , 148,365, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "SO2" , -91,62, 3 , SE_leavepits,SE_bluelights );

	RegisterZoneAction( "SO2R" , -39,0, 2 , SE_leavepits,SE_bluelights );
	RegisterNodeAction( "SO2R" , 4 , SE_HighStreet,"" );
	RegisterNodeAction( "SO2R" , 84 , SE_Odeon,"" );
	RegisterNodeAction( "SO2R" , 137 , SE_Bromley,"" );
	RegisterNodeAction( "SO2R" , 252 , SE_Kenton,"" );

	RegisterZoneAction( "SO3" , -349,379, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO3" , -212,361, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "SO3R" , -243,366, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO3R" , -354,389, 3 , SE_enterpits,SE_flashinglights );
	
	RegisterZoneAction( "SO4" , 143,378, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO4" , 233,-112, 3 , SE_enterpits,SE_flashinglights );
      	
	RegisterZoneAction( "SO4R" , 242,-36, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO4R" , 141,375, 3 , SE_enterpits,SE_flashinglights );
	
	RegisterZoneAction( "SO5" , 208,227, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO5" , -20,532, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO5" , 92,-148, 3 , SE_enterpits,SE_flashinglights );
	
	RegisterZoneAction( "SO5R" , 242,-36, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO5R" , 141,375, 3 , SE_leavepits,SE_bluelights );
      	
	RegisterZoneAction( "SO6" , 242,-36, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO6" , 141,375, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "SO6R" , 208,227, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO6R" , -20,532, 3 , SE_leavepits,SE_bluelights );
	RegisterZoneAction( "SO6R" , 234,-115, 3 , SE_enterpits,SE_flashinglights );

	RegisterZoneAction( "WE1" , -309,741, 3 , SE_enterpits,SE_flashinglights );
	RegisterZoneAction( "WE1" , -300,423, 3 , SE_leavepits,SE_bluelights );

	RegisterZoneAction( "WE1R" , -313,274, 3 , SE_enterpits,SE_flashinglights );
	RegisterZoneAction( "WE1R" , -300,654, 3 , SE_leavepits,SE_bluelights );
	
 	MoveUserToGroup( "superuser" , "Sinanju");
	MoveUserToGroup( "admin" , "Sinanju");
	GlobalVar $enable_pitboard;
	GlobalVar $enable_pitwindow_gui;
	GlobalVar $enable_safetycar_gui;
	GlobalVar $enable_ctrack_gui;
	GlobalVar $enable_config_gui;

EndEvent

Sub SA_mid() # Lapper Event
	globalRcm( langEngine( "%{main_midnight}%" ) );
EndSub

Sub SA_newyear() # Lapper Event
	globalRcm( langEngine( "%{main_newyear}%" ) );
EndSub

Sub SE_keys() # A Sinanju Event
	globalRcm( langEngine( "%{main_keyboard}%" ) );
EndSub

Sub DisplaySpeed( $userName )
	openPrivButton( "speedtrap_text",1,16,26,6,3,4,80, langEngine( "%{main_speedtrap}%" , ToPlayerUnit( GetCurrentPlayerVar( "InstantSpeed" )),GetCurrentPlayerVar("UnitSpeed") ) );
EndSub

Sub SE_test( $userName ) # A Sinanju Event

	closePrivButton( "blank_back&warning&warning1&info&impressive&remember&warning_message1&adjective" );
	closePrivButton( "manhand1&manhand1a&manarm1&manarm1a&head1&head1a&white_band&marshall_hat&yellow_trim&earA&earB&earA1&earB1&eyeA&eyeB&mouth" );
	closePrivButton( "manarm&manarma&manarm7&manarm7a&manlines&man8&manlines1&clogo&manlogo&manll1&manll2&manrl1&manrl2&manlf&manrf&shorts1&shorts2" );

IF ( GetCurrentPlayerVar( "$marshall_on_off" ) == "on" )
THEN	
		SE_DrawMarshall();
ENDIF

EndSub

Sub SE_DrawMarshall() # A Sinanju Event
	closePrivButton( "manhand1&manhand1a&manarm1&manarm1a&head1&head1a&manarm&manarma&manarm7&manarm7a&manlines" );
	closePrivButton( "man8&white_band&marshall_hat&yellow_trim&earA&earB&earA1&earB1&eyeA&eyeB&mouth&manlf&manrf" );
	closePrivButton( "shorts1&shorts2&manlines1&clogo&manlogo&manll1&manll2&manrl1&manrl2" );
	closePrivButton( "yellow_flag1a&yellow_flag2a&yellow_flag3a&yellow_flag4a&yellow_flag5a&yellow_flag6a&yellow_flag7a&yellow_flag8a&yellow_flag9a" );
	closePrivButton( "green_vest1&green_vest2&green_vest3&green_vest4&green_vest5&green_vest6&green_vest7&green_vest8&green_vest9" );
	closePrivButton( "blue_vest1&blue_vest2&blue_vest3&blue_vest4&blue_vest5&blue_vest6&blue_vest7&blue_vest8&blue_vest9" );
	openPrivButton( "manhand1",164,70,3,15,1,8,32," ");
	openPrivButton( "manhand1a",164,70,3,15,1,8,32," ");
	openPrivButton( "manarm1",164,85,3,19,1,8,32," ");
	openPrivButton( "manarm1a",164,85,3,19,1,8,32," ");

	openPrivButton( "head1",171,84,10,16,1,8,32," ");
	openPrivButton( "head1a",171,90,10,10,1,8,32," ");

	openPrivButton( "white_band",171,85,10,4,1,8,16," ");
	openPrivButton( "marshall_hat",171,85,10,4,1,8,0,"^3= MARSHALL =");
	openPrivButton( "yellow_trim",171,87,10,4,1,8,0,"^1--------");

	openPrivButton( "earA",170,92,1,5,1,8,32," ");
	openPrivButton( "earB",181,92,1,5,1,8,32," ");
	openPrivButton( "earA1",170,92,1,5,1,8,32," ");
	openPrivButton( "earB1",181,92,1,5,1,8,32," ");
	openPrivButton( "eyeA",173,93,3,3,1,8,32,"^80");
	openPrivButton( "eyeB",177,93,3,3,1,8,32,"^80");
	openPrivButton( "mouth",175,97,3,3,1,8,32,"^1< === >");

    	openPrivButton( "yellow_flag1a",159,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag2a",160,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag3a",162,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag4a",164,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag5a",166,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag6a",168,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag7a",170,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag8a",172,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag9a",173,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );

	openPrivButton( "manarm",185,103,10,5,1,8,32," ");
	openPrivButton( "manarma",185,103,10,5,1,8,32," ");

	openPrivButton( "manarm7",192,88,3,15,1,8,32," ");
	openPrivButton( "manarm7a",192,88,3,15,1,8,32," ");
	openPrivButton( "manlines",167,102,18,6,1,8,0,"^1===========");
	openPrivButton( "man8",167,107,18,6,1,8,0,"^1= MARSHALL =");
	openPrivButton( "manlines1",167,112,18,6,1,8,0,"^1===========");
	openPrivButton( "clogo",169,117,14,6,1,8,0,"^2[c]");
	openPrivButton( "manlogo",167,122,18,6,1,8,0,"^0S i n ' r s");
	openPrivButton( "manll1",169,140,5,30,1,8,32," ");
	openPrivButton( "manll2",169,140,5,30,1,8,32," ");

	openPrivButton( "manrl1",178,140,5,30,1,8,32," ");
	openPrivButton( "manrl2",178,140,5,30,1,8,32," ");

	openPrivButton( "manlf",169,165,5,5,1,8,16," ");
	openPrivButton( "manrf",178,165,5,5,1,8,16," ");

	openPrivButton( "shorts1",168,130,16,10,1,8,32," ");
	openPrivButton( "shorts2",168,130,16,10,1,8,32," ");
EndSub


Sub SE_DrawPitcrew() # A Sinanju Event
	closePrivButton( "manhand1&manhand1a&manarm1&manarm1a&head1&head1a&manarm&manarma&manarm7&manarm7a&manlines" );
	closePrivButton( "man8&white_band&marshall_hat&yellow_trim&earA&earB&earA1&earB1&eyeA&eyeB&mouth&manlf&manrf" );
	closePrivButton( "shorts1&shorts2&manlines1&clogo&manlogo&manll1&manll2&manrl1&manrl2" );
	closePrivButton( "yellow_flag1a&yellow_flag2a&yellow_flag3a&yellow_flag4a&yellow_flag5a&yellow_flag6a&yellow_flag7a&yellow_flag8a&yellow_flag9a" );
	closePrivButton( "green_vest1&green_vest2&green_vest3&green_vest4&green_vest5&green_vest6&green_vest7&green_vest8&green_vest9" );
	closePrivButton( "blue_vest1&blue_vest2&blue_vest3&blue_vest4&blue_vest5&blue_vest6&blue_vest7&blue_vest8&blue_vest9" );
	openPrivButton( "manhand1",164,70,3,15,1,8,32," ");
	openPrivButton( "manhand1a",164,70,3,15,1,8,32," ");
	openPrivButton( "manarm1",164,85,3,19,1,8,32," ");
	openPrivButton( "manarm1a",164,85,3,19,1,8,32," ");

	openPrivButton( "head1",171,84,10,16,1,8,32," ");
	openPrivButton( "head1a",171,90,10,10,1,8,32," ");

	openPrivButton( "white_band",171,85,10,4,1,8,16," ");
	openPrivButton( "marshall_hat",171,85,10,4,1,8,0,"^3= PITCREW =");
	openPrivButton( "yellow_trim",171,87,10,4,1,8,0,"^1--------");

	openPrivButton( "earA",170,92,1,5,1,8,32," ");
	openPrivButton( "earB",181,92,1,5,1,8,32," ");
	openPrivButton( "earA1",170,92,1,5,1,8,32," ");
	openPrivButton( "earB1",181,92,1,5,1,8,32," ");
	openPrivButton( "eyeA",173,93,3,3,1,8,32,"^80");
	openPrivButton( "eyeB",177,93,3,3,1,8,32,"^80");
	openPrivButton( "mouth",175,97,3,3,1,8,32,"^1< === >");

	openPrivButton( "green_vest1",159,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest2",160,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest3",162,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest4",164,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest5",166,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest6",168,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest7",170,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest8",172,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest9",173,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );

	openPrivButton( "manarm",185,103,10,5,1,8,32," ");
	openPrivButton( "manarma",185,103,10,5,1,8,32," ");

	openPrivButton( "manarm7",192,88,3,15,1,8,32," ");
	openPrivButton( "manarm7a",192,88,3,15,1,8,32," ");
	openPrivButton( "manlines",167,102,18,6,1,8,0,"^1===========");
	openPrivButton( "man8",167,107,18,6,1,8,0,"^1= PITCREW =");
	openPrivButton( "manlines1",167,112,18,6,1,8,0,"^1===========");
	openPrivButton( "clogo",169,117,14,6,1,8,0,"^3[c]");
	openPrivButton( "manlogo",167,122,18,6,1,8,0,"^0S i n ' r s");
	openPrivButton( "manll1",169,140,5,30,1,8,32," ");
	openPrivButton( "manll2",169,140,5,30,1,8,32," ");

	openPrivButton( "manrl1",178,140,5,30,1,8,32," ");
	openPrivButton( "manrl2",178,140,5,30,1,8,32," ");

	openPrivButton( "manlf",169,165,5,5,1,8,16," ");
	openPrivButton( "manrf",178,165,5,5,1,8,16," ");

	openPrivButton( "shorts1",168,130,16,10,1,8,32," ");
	openPrivButton( "shorts2",168,130,16,10,1,8,32," ");
EndSub


Sub SE_DrawCop() # A Sinanju Event
	openPrivButton( "manhand1",164,70,3,15,1,8,32," ");
	openPrivButton( "manhand1a",164,70,3,15,1,8,32," ");
	openPrivButton( "manarm1",164,85,3,19,1,8,32," ");
	openPrivButton( "manarm1a",164,85,3,19,1,8,32," ");
	openPrivButton( "head1",171,84,10,16,1,8,32," ");
	openPrivButton( "head1a",171,90,10,10,1,8,32," ");
	openPrivButton( "white_band",171,85,10,4,1,8,32," ");
	openPrivButton( "police_hat",171,85,10,4,1,8,0,"^4POLICE");
  openPrivButton( "yellow_trim",171,87,10,4,1,8,0,"^1--------");
	openPrivButton( "earA",170,92,1,5,1,8,32," ");
	openPrivButton( "earB",181,92,1,5,1,8,32," ");
	openPrivButton( "earA1",170,92,1,5,1,8,32," ");
	openPrivButton( "earB1",181,92,1,5,1,8,32," ");
	openPrivButton( "eyeA",173,93,3,3,1,8,32,"^80");
	openPrivButton( "eyeB",177,93,3,3,1,8,32,"^80");
	openPrivButton( "mouth",175,97,3,3,1,8,32,"^1< === >");
     	openPrivButton( "blue_vest1",159,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest2",160,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest3",162,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest4",164,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest5",166,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest6",168,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest7",170,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest8",172,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest9",173,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
	openPrivButton( "manarm",182,113,10,5,1,8,32," ");
	openPrivButton( "manarma",182,113,10,5,1,8,32," ");
	openPrivButton( "manarm7",189,98,3,15,1,8,32," ");
	openPrivButton( "manarm7a",189,98,3,15,1,8,32," ");
	openPrivButton( "man8",167,107,18,6,1,8,0,"^1P O L I C E");
	openPrivButton( "manlines1",167,112,18,6,1,8,0,"^1O F F I C E R");
	openPrivButton( "clogo",169,117,14,4,1,8,0,"^3[c]");
	openPrivButton( "manlogo",167,122,18,6,1,8,0,"^0S i n ' r s");
	openPrivButton( "manll1",169,140,5,30,1,8,32," ");
	openPrivButton( "manll2",169,140,5,30,1,8,32," ");
	openPrivButton( "manrl1",178,140,5,30,1,8,32," ");
	openPrivButton( "manrl2",178,140,5,30,1,8,32," ");
	openPrivButton( "manlf",169,165,5,5,1,8,16," ");
	openPrivButton( "manrf",178,165,5,5,1,8,16," ");
	openPrivButton( "shorts1",168,130,16,10,1,8,32," ");
	openPrivButton( "shorts2",168,130,16,10,1,8,32," ");
EndSub

Sub SE_DrawWarden() # A Sinanju Event
	closePrivButton( "manhand1&manhand1a&manarm1&manarm1a&head1&head1a&manarm&manarma&manarm7&manarm7a&manlines" );
	closePrivButton( "man8&white_band&marshall_hat&yellow_trim&earA&earB&earA1&earB1&eyeA&eyeB&mouth&manlf&manrf" );
	closePrivButton( "shorts1&shorts2&manlines1&clogo&manlogo&manll1&manll2&manrl1&manrl2" );
	closePrivButton( "yellow_flag1a&yellow_flag2a&yellow_flag3a&yellow_flag4a&yellow_flag5a&yellow_flag6a&yellow_flag7a&yellow_flag8a&yellow_flag9a" );
	closePrivButton( "green_vest1&green_vest2&green_vest3&green_vest4&green_vest5&green_vest6&green_vest7&green_vest8&green_vest9" );
	closePrivButton( "blue_vest1&blue_vest2&blue_vest3&blue_vest4&blue_vest5&blue_vest6&blue_vest7&blue_vest8&blue_vest9" );
	openPrivButton( "manhand1",164,70,3,15,1,8,32," ");
	openPrivButton( "manhand1a",164,70,3,15,1,8,32," ");
	openPrivButton( "manarm1",164,85,3,19,1,8,32," ");
	openPrivButton( "manarm1a",164,85,3,19,1,8,32," ");
	openPrivButton( "head1",171,84,10,16,1,8,32," ");
	openPrivButton( "head1a",171,90,10,10,1,8,32," ");
	openPrivButton( "white_band",171,85,10,4,1,8,16," ");
	openPrivButton( "warden_hat",171,85,10,4,1,8,0,"^2= WARDEN =");
	openPrivButton( "yellow_trim",171,87,10,4,1,8,0,"^1--------");
	openPrivButton( "earA",170,92,1,5,1,8,32," ");
	openPrivButton( "earB",181,92,1,5,1,8,32," ");
	openPrivButton( "earA1",170,92,1,5,1,8,32," ");
	openPrivButton( "earB1",181,92,1,5,1,8,32," ");
	openPrivButton( "eyeA",173,93,3,3,1,8,32,"^80");
	openPrivButton( "eyeB",177,93,3,3,1,8,32,"^80");
	openPrivButton( "mouth",175,97,3,3,1,8,32,"^1< === >");
	openPrivButton( "green_vest1",159,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest2",160,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest3",162,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest4",164,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest5",166,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest6",168,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest7",170,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest8",172,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "green_vest9",173,88,20,50,1,8,0,langEngine( "%{main_greenvest}%") );
	openPrivButton( "manarm",185,103,10,5,1,8,32," ");
	openPrivButton( "manarma",185,103,10,5,1,8,32," ");
	openPrivButton( "manarm7",192,88,3,15,1,8,32," ");
	openPrivButton( "manarm7a",192,88,3,15,1,8,32," ");
	openPrivButton( "man8",167,107,18,6,1,8,0,"^1T R A F F I C");
	openPrivButton( "manlines1",167,112,18,6,1,8,0,"^1W A R D E N");
	openPrivButton( "clogo",169,117,14,6,1,8,0,"^3[c]");
	openPrivButton( "manlogo",167,122,18,6,1,8,0,"^0S i n ' r s");
	openPrivButton( "manll1",169,140,5,30,1,8,32," ");
	openPrivButton( "manll2",169,140,5,30,1,8,32," ");
	openPrivButton( "manrl1",178,140,5,30,1,8,32," ");
	openPrivButton( "manrl2",178,140,5,30,1,8,32," ");
	openPrivButton( "manlf",169,165,5,5,1,8,16," ");
	openPrivButton( "manrf",178,165,5,5,1,8,16," ");
	openPrivButton( "shorts1",168,130,16,10,1,8,32," ");
	openPrivButton( "shorts2",168,130,16,10,1,8,32," ");
EndSub

Sub SE_DrawPaint() # A Sinanju Event
	openPrivButton( "manhand1",164,70,3,15,1,8,32," ");
	openPrivButton( "manhand1a",164,70,3,15,1,8,32," ");
	openPrivButton( "manarm1",164,85,3,19,1,8,32," ");
	openPrivButton( "manarm1a",164,85,3,19,1,8,32," ");
	openPrivButton( "gunsight",163,57,2,2,1,8,16," ");
	openPrivButton( "gunarm",161,57,2,23,1,8,16," ");
	openPrivButton( "gunstock",158,90,4,5,1,8,16," ");
	openPrivButton( "gunsight1",163,57,2,2,1,8,16," ");
	openPrivButton( "gunarm1",161,57,2,23,1,8,16," ");
	openPrivButton( "gunstock1",158,90,4,5,1,8,16," ");
	openPrivButton( "head1",171,84,10,16,1,8,32," ");
	openPrivButton( "head1a",171,90,10,10,1,8,32," ");
	openPrivButton( "white_band",171,85,10,4,1,8,32," ");
	openPrivButton( "marshall_hat",171,85,10,4,1,8,0,"^4SNIPER");
	openPrivButton( "yellow_trim",171,87,10,4,1,8,0,"^1--------");
	openPrivButton( "earA",170,92,1,5,1,8,32," ");
	openPrivButton( "earB",181,92,1,5,1,8,32," ");
	openPrivButton( "earA1",170,92,1,5,1,8,32," ");
	openPrivButton( "earB1",181,92,1,5,1,8,32," ");
	openPrivButton( "eyeA",173,93,3,3,1,8,32,"^80");
	openPrivButton( "eyeB",177,93,3,3,1,8,32,"^80");
	openPrivButton( "mouth",175,97,3,3,1,8,32,"^1< === >");
    	openPrivButton( "yellow_flag1a",159,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag2a",160,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag3a",162,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag4a",164,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag5a",166,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag6a",168,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag7a",170,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag8a",172,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openPrivButton( "yellow_flag9a",173,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
	openPrivButton( "manarm",185,103,10,5,1,8,32," ");
	openPrivButton( "manarma",185,103,10,5,1,8,32," ");
	openPrivButton( "manarm7",192,88,3,15,1,8,32," ");
	openPrivButton( "manarm7a",192,88,3,15,1,8,32," ");
	openPrivButton( "man8",167,107,18,6,1,8,0,"^1O F F I C I A L");
	openPrivButton( "manlines1",167,112,18,6,1,8,0,"^1S N I P E R");
	openPrivButton( "clogo",169,117,14,4,1,8,0,"^2[c]");
	openPrivButton( "manlogo",167,122,18,6,1,8,0,"^0S i n ' r s");
	openPrivButton( "manll1",169,140,5,30,1,8,32," ");
	openPrivButton( "manll2",169,140,5,30,1,8,32," ");
	openPrivButton( "manrl1",178,140,5,30,1,8,32," ");
	openPrivButton( "manrl2",178,140,5,30,1,8,32," ");
	openPrivButton( "manlf",169,165,5,5,1,8,16," ");
	openPrivButton( "manrf",178,165,5,5,1,8,16," ");
	openPrivButton( "shorts1",168,130,16,10,1,8,32," ");
	openPrivButton( "shorts2",168,130,16,10,1,8,32," ");
EndSub

Sub SE_DrawPatrol() # A Sinanju Event
	closePrivButton( "manhand1&manhand1a&manarm1&manarm1a&head1&head1a&manarm&manarma&manarm7&manarm7a&manlines" );
	closePrivButton( "man8&white_band&marshall_hat&yellow_trim&earA&earB&earA1&earB1&eyeA&eyeB&mouth&manlf&manrf" );
	closePrivButton( "shorts1&shorts2&manlines1&clogo&manlogo&manll1&manll2&manrl1&manrl2" );
	closePrivButton( "yellow_flag1a&yellow_flag2a&yellow_flag3a&yellow_flag4a&yellow_flag5a&yellow_flag6a&yellow_flag7a&yellow_flag8a&yellow_flag9a" );
	closePrivButton( "green_vest1&green_vest2&green_vest3&green_vest4&green_vest5&green_vest6&green_vest7&green_vest8&green_vest9" );
	closePrivButton( "blue_vest1&blue_vest2&blue_vest3&blue_vest4&blue_vest5&blue_vest6&blue_vest7&blue_vest8&blue_vest9" );
	openPrivButton( "manhand1",164,70,3,15,1,8,32," ");
	openPrivButton( "manhand1a",164,70,3,15,1,8,32," ");
	openPrivButton( "manarm1",164,85,3,19,1,8,32," ");
	openPrivButton( "manarm1a",164,85,3,19,1,8,32," ");
	openPrivButton( "head1",171,84,10,16,1,8,32," ");
	openPrivButton( "head1a",171,90,10,10,1,8,32," ");
	openPrivButton( "white_band",171,85,10,4,1,8,32," ");
	openPrivButton( "patrol_hat",171,85,10,4,1,8,0,"^3= PATROL =");
	openPrivButton( "yellow_trim",171,87,10,4,1,8,0,"^1--------");
	openPrivButton( "earA",170,92,1,5,1,8,32," ");
	openPrivButton( "earB",181,92,1,5,1,8,32," ");
	openPrivButton( "earA1",170,92,1,5,1,8,32," ");
	openPrivButton( "earB1",181,92,1,5,1,8,32," ");
	openPrivButton( "eyeA",173,93,3,3,1,8,32,"^80");
	openPrivButton( "eyeB",177,93,3,3,1,8,32,"^80");
	openPrivButton( "mouth",175,97,3,3,1,8,32,"^1< === >");
	
    	openPrivButton( "blue_vest1",159,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest2",160,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest3",162,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest4",164,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest5",166,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest6",168,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest7",170,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest8",172,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
    	openPrivButton( "blue_vest9",173,88,20,50,1,8,0,langEngine( "%{main_bluevest}%") );
	openPrivButton( "stopsign",105,0,120,120,1,8,0,"^1•");
	openPrivButton( "stopsign1",155,52,20,24,1,8,0,"^7S T O P");
	openPrivButton( "manarm",185,103,10,5,1,8,32," ");
	openPrivButton( "manarma",185,103,10,5,1,8,32," ");
	openPrivButton( "manarm7",192,88,3,15,1,8,32," ");
	openPrivButton( "manarm7a",192,88,3,15,1,8,32," ");
	openPrivButton( "man8",167,107,18,6,1,8,0,"^1T R A F F I C");
	openPrivButton( "manlines1",167,112,18,6,1,8,0,"^1P A T R O L");
	openPrivButton( "clogo",169,117,14,4,1,8,0,"^3[c]");
	openPrivButton( "manlogo",167,122,18,6,1,8,0,"^0S i n ' r s");
	openPrivButton( "manll1",169,140,5,30,1,8,32," ");
	openPrivButton( "manll2",169,140,5,30,1,8,32," ");
	openPrivButton( "manrl1",178,140,5,30,1,8,32," ");
	openPrivButton( "manrl2",178,140,5,30,1,8,32," ");
	openPrivButton( "manlf",169,165,5,5,1,8,16," ");
	openPrivButton( "manrf",178,165,5,5,1,8,16," ");
	openPrivButton( "shorts1",168,130,16,10,1,8,32," ");
	openPrivButton( "shorts2",168,130,16,10,1,8,32," ");
EndSub

Sub SE_exitpits($userName) # A Sinanju Event
	openPrivButton( "exitpits",153,60,44,5,4,8,16,langEngine( "%{main_careful}%" ));
EndSub

Sub SE_pitenter($userName) # A Sinanju Event
	openPrivButton( "remember",153,46,44,8,6,8,32,langEngine( "%{main_remember}%", $NickName ));
	openPrivButton( "pitentry",153,60,44,5,4,8,16,langEngine( "%{main_pitentry}%" ));
EndSub

Sub SE_leavepits( $userName ) # A Sinanju Event

	$NickName = GetCurrentPlayerVar("NickName");
	closePrivButton("warning&warning1&info&impressive&remember&warning_message1&adjective" );
	closePrivButton("swear_not_please&swear_not_kick&enterpits&leavepits&pitcareful&lowdrift&acceleration&spamming&topback&serverlogo" );
	closePrivButton("track&date&easyklik&easyklikhelp&easykliktyes&easykliktoptimes&easykliktopdrifts&easyklikstats&easyklikadmin&easyklikclose");
	closePrivButton("easyklikopen&closetop&closetop1&easyklikclosemarshall&option_lang_bg&option_lang_title&close&drfback_button&");
	closePrivButton("help&help2&close&statsbacking&statstitle&statsdetails&qualdetails&closestats&closedrftop&closedrftop1&help&help2");
	closePrivButton("drf_rubbish_button&drftop_button&19_36_button&37_54_button&option_Lang_it&option_Lang_en&option_Lang_fr&option_Lang_no&option_Lang_nl");
	closePrivButton("55_72_button&73_90_button&91_108_button&217_234_button&235_252_button&271_289_button&290_307_button");
	closePrivButton("109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&199_216_button&253_270_button");
	closePrivButton("back_button&UF1_button&XFG_button&XRG_button&XRT_button&RB4_button&FXO_button&RAC_button&FZ5_button&LX4_button&LX6_button");
	closePrivButton("MRT_button&UFR_button&XFR_button&FBM_button&FOX_button&FXR_button&XRR_button&FZR_button&FO8_button&BF1_button");
	closePrivButton("top35_button&top52_button&top69_button&top86_button&top103_button&top120_button&topGTR_button&topFWD_button&topRWD_button&topTBO_button");
	closePrivButton("top1_button&top18_button&drf_rubbish_button&drfnear_button");
	openPrivButton( "blank_back",152,45,46,25,3,8,32," ");
	openPrivButton( "remember",153,46,44,8,6,8,32,langEngine( "%{main_remember}%", $NickName ));
	openPrivButton( "leavepits",153,60,44,5,4,8,16,langEngine( "%{main_leavepits}%" ));
	
IF ( GetCurrentPlayerVar( "$marshall_on_off" ) == "on" )

	THEN
	SE_DrawMarshall();
ENDIF
EndSub

Sub SE_enterpits($userName) # A Sinanju Event

	$NickName = GetCurrentPlayerVar("NickName");
	closePrivButton("blank_back&warning&warning1&info&impressive&remember&warning_message1&adjective" );
	closePrivButton("warning&warning1&info&impressive&remember&warning_message1&adjective" );
	closePrivButton("swear_not_please&swear_not_kick&enterpits&leavepits&pitcareful&lowdrift&acceleration&spamming" );
	closePrivButton("speed_current&speed_current1&speed_bg&speed_title&speed_kmh&speed_mph&speed_close");
	closePrivButton("easyklikpstats&easyklikpbests&easykliktopcombo&easyklikpoints&easyklikspeed");
	closePrivButton("topback&serverlogo&track&date&easyklik&easyklikhelp&easykliktyes&easykliktoptimes&easykliktopdrifts&easyklikstats");
	closePrivButton("easyklikadmin&easyklikclose&easyklikopen&closetop&closetop1&easyklikclosemarshall&option_Lang_it&option_Lang_en&option_Lang_fr");
	closePrivButton("option_Lang_no&option_Lang_nlhelp&help2&close&statsbacking&statstitle&statsdetails&qualdetails&closestats&option_lang_bg&option_lang_title");
	closePrivButton("closedrftop&closedrftop1&help&help2&close&drfback_button&drf_rubbish_button&drftop_button&topTBO_button");
	closePrivButton("19_36_button&37_54_button&55_72_button&73_90_button&91_108_button&217_234_button&235_252_button&271_289_button&290_307_button");
	closePrivButton("109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&199_216_button&253_270_button");
	closePrivButton("back_button&UF1_button&XFG_button&XRG_button&XRT_button&RB4_button&FXO_button&RAC_button&FZ5_button&LX4_button&LX6_button");
	closePrivButton("MRT_button&UFR_button&XFR_button&FBM_button&FOX_button&FXR_button&XRR_button&FZR_button&FO8_button&BF1_button&top1_button");
	closePrivButton("top18_button&top35_button&top52_button&top69_button&top86_button&top103_button&top120_button&topGTR_button&topFWD_button&topRWD_button");
	closePrivButton("statsbacking&statstitle&statsdetails&qualdetails&closestats&drf_rubbish_button&drfnear_button");

	openPrivButton( "blank_back",152,45,46,25,3,8,32," ");
	openPrivButton( "remember",153,46,44,8,6,8,32,langEngine( "%{main_remember}%", $NickName ));
	openPrivButton( "enterpits",153,60,44,5,4,8,16,langEngine( "%{main_enterpits}%" ));
IF ( GetCurrentPlayerVar( "$marshall_on_off" ) == "on" )

THEN
		SE_DrawMarshall();
ENDIF
EndSub

Sub SE_bluelights($userName) # A Sinanju Event - blue lights when leaving pits

	openPrivButton( "blink_bg",91,6,18,9,1,6,32," ");
	openPrivButton( "blink_bga",91,6,18,9,1,6,32," ");
	openPrivButton( "blink1",84,0,20,20,1,6,0,"^4 %at%^4•" );
	openPrivButton( "blink1a",88,0,20,20,1,6,0,"^4 %at%^4•" );
  openPrivButton( "blink2",92,0,20,20,1,6,0,"^4•%at%^4 " );
  openPrivButton( "blink2a",96,0,20,20,1,6,0,"^4•%at%^4 " );

EndSub

Sub SE_flashinglights($userName) # A Sinanju Event - flashing lights when enteringpits
	openPrivButton( "blink_bg",91,6,18,9,1,8,32," ");
	openPrivButton( "blink_bga",91,6,18,9,1,8,32," ");
	openPrivButton( "blink1",84,0,20,20,1,8,0,"^2 %at%^2•" );
	openPrivButton( "blink1a",88,0,20,20,1,8,0,"^2 %at%^2•" );
  openPrivButton( "blink2",92,0,20,20,1,6,0,"^2•%at%^2 " );
  openPrivButton( "blink2a",96,0,20,20,1,6,0,"^2•%at%^2 " );
EndSub

Sub SE_leader() # A Sinanju Event
	globalRcm( langEngine( "%{main_faster}%" ) );
EndSub

Sub SE_tired1() # A Sinanju Event
	globalRcm( langEngine( "%{main_tired1}%" ) );
EndSub

Sub SE_tired2() # A Sinanju Event
	globalRcm( langEngine( "%{main_tired2}%" ) );
EndSub

Sub SE_email() # A Sinanju Event
	globalRcm( langEngine( "%{main_email}%" ) );
EndSub

Sub SE_HighStreet( $userName )
	openPrivButton( "location_HighSt",2,20,24,6,2,4,96,"^7HIGH STREET TURN -->");
EndSub

Sub SE_Odeon( $userName )
	openPrivButton( "location_Odeon",2,20,24,6,2,4,96,"^7ODEON TURN -->");
EndSub

Sub SE_Bromley( $userName )
	openPrivButton( "location_Bromley",2,20,24,6,2,4,96,"^7BROMLEY TURN -->");
EndSub

Sub SE_Kenton( $userName )
	openPrivButton( "location_Kenton",2,20,24,6,2,4,96,"^7KENTON WAY TURN -->");
EndSub

###################################
#Authorization Options ( license )#
###################################
#Authorization Options
#
#$Auth1 $Auth2 ... $Auth10 variable
#Syntax : $AuthX = "Label,Carname:Trackname:MinimumTime&Carname:Trackname:MinimumTime&...| Carname:Trackname:MinimumTime&Carname:Trackname:MinimumTime&... | ...";
#& -> And condition
#| -> Or condition
#
#$AuthAllowPlayer="Auth1|...|AuthX|@username1,username2,...,usernameN";
#or
#$AuthAllowPlayer="All";
#-------------------------------------------------------------------

#$Auth1 = "Bronze,XFG:BL1:1.45.00 | XRT:SO4:1.20.20";
#$Auth2 = "Silver,XFG:BL1:1.40.00 | XRT:SO4:1.20.20";
#$Auth3 = "Gold,XFG:BL1:1.35.00";

$AuthAllowPlayer = "All";

$AuthMinPlayer = 0;	# Minimum number of players on the server to auto enable authorization
			# If number of players is below value, all players are allowed
			# If number of players is above value, only AuthAllowPlayer are allowed

Event OnAuthAllowed( $userName ) # Player event
	globalMsg( langEngine( "%{main_allowed}%", GetCurrentPlayerVar("NickName") ) );
Endevent

Event OnAuthNotAllowed( $userName ) # Player event
	cmdLFS("/spec "  . GetCurrentPlayerVar("NickName") );
	globalMsg( langEngine( "%{main_notallowed}%", GetCurrentPlayerVar("NickName") ));
Endevent

# Local viariable that can be used
# $auth -> Authorization reached

Event OnAuthReached( $userName,$level ) # Player event
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_gotlevel}%", $level ) );
EndEvent

##################
#Swearword filter#
##################
#Specify a list of swearwords seperated by ,
#Specify a file with swearwords, one word per line
#-------------------------------------------------------------------

$SwearWordsList = "&./swear.txt";
$SwearWordsMax = 3; # Maximum number of allowed swearwords per session

Event OnSwearWords1( $userName ) # Player event

	$NickName = GetCurrentPlayerVar("NickName");

	closePrivButton( "blank_back&warning&warning1&info&impressive&remember&warning_message1&adjective" );
	closePrivButton( "swear_not_please&swear_not_kick&enterpits&leavepits&pitcareful&lowdrift&acceleration&spamming" );
	openPrivButton( "blank_back",152,45,46,25,3,8,32," ");
	openPrivButton( "warning",153,46,44,8,6,6,32,langEngine( "%{main_warning}%", $NickName ) );
	openPrivButton( "swear_not_please",153,60,44,5,4,5,16,langEngine( "%{main_swearL1}%", GetCurrentPlayerVar("SwearWordsRem") ) );

IF ( GetCurrentPlayerVar( "$marshall_on_off" ) == "on" )

THEN
	SE_DrawMarshall();
ENDIF
EndEvent

Event OnSwearWords2($userName )  # Player event

	openPrivButton( "hud_message",74,1,51,5,4,8,0, langEngine( "%{main_swear21}%" ) );
	cmdLFS( "/spec " . GetCurrentPlayerVar("NickName") );

EndEvent


#################
#Control Allowed#
#################
# Racer flags
# "Y" = Yes
# "N" = No
# "*"" = Yes or No
# Local variable
#-------------------------------------------------------------------

$SwapSide = "*";
$AutoGears = "*";
$Shifter = "*";
$HelpBrake = "*";
$AxisClutch = "*";
$AutoClutch = "*";
$Mouse = "*";
$KbNoHelp = "*";
$KbStabilised = "*";
$CustomView = "*";

Event OnNotMatchFlags( $userName ) # Player event
	privMsg(langEngine( "%{main_nomatchflag}%" )  );
	privMsg(langEngine( "%{main_yourflag}%" , GetCurrentPlayerVar("PlayerFlags") ) );
	privMsg(langEngine( "%{main_yourflag}%" , getLapperVar( "RequiredFlags" ) ) );
	privMsg(langEngine( "%{main_spectated}%" ) );
	cmdLFS("/spec " . GetCurrentPlayerVar("UserName") );
EndEvent

##############
#Race Control#
##############
#Voting:
#
#$InRaceLapsVoteMinMax = Laps in between where votes are allowed in race
#$InRaceLapsVoteMinMax = 0-0 Votes are never allowed
#$InRaceLapsVoteMinMax = -5 Votes are allowed between lap 1 and 5
#$InRaceLapsVoteMinMax = 2- Votes are allowed between laps 2 and the end of the race
#$InRaceLapsVoteMinMax = - Votes are always allowed
#
#$VoteRestart = percentage of players that have to vote to restart a race. To let LFS admin this function, set it to -1
#OnVoteRestartChange = Command to do when player votes to restart
#OnVoteRestartReach = Command to execute when VoteRestart is reached
#OnVoteRestartZero = Command to execute when no nb of player reach zero

#$VoteQualify = percentage of players that have to vote to start a qualification. To let LFS admin this function, set it to -1
#OnVoteQualifyChange = same as restart but for qualify
#OnVoteQualifyReach = same as restart but for qualify
#OnVoteQualifyZero = same as restart but for qualify
#
#$VoteEnd = percentage of players that have to vote to end a race. To let LFS admin this function, set it to -1
#OnVoteEndChange = same as restart but for endrace
#OnVoteEndReach = same as restart but for endrace
#OnVoteEndyZero = same as restart but for endrace
#-------------------------------------------------------------------
#Local variable:
#
#$Vote - Number of players that have voted
#$Remain - Number of players remaining to vote
#$Need - Number of players needed for an action
#$VoteLifeSec = Number of seconds to keep the vote alive after voting
#-------------------------------------------------------------------

$InRaceLapsVoteMinMax = "-3";

$VoteRestart = 60;     

Event OnVoteRestartChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "bargr1",40,1,10,6,6,30,96,langEngine( "%{main_vote_restart1}%"));
	openGlobalButton( "bargr2",50,1,20,6,6,30,96,langEngine( "%{main_vote_restart2}%",$Vote,$PlayerOnTrack,$Need ) );
EndEvent

Event OnVoteRestartReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
	closeGlobalButton( "bargr1&bargr2" );
EndEvent

Event OnVoteRestartZero() # Lapper Event
	closeGlobalButton( "bargr1&bargr2" );
EndEvent

$VoteQualify = 60;

Event OnVoteQualifyChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "bargq1",70,1,10,6,6,30,96,langEngine( "%{main_vote_qualify1}%") );
	openGlobalButton( "bargq2",80,1,20,6,6,30,96,langEngine( "%{main_vote_qualify2}%",$Vote,$PlayerOnTrack,$Need ));
EndEvent

Event OnVoteQualifyReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
	closeGlobalButton("bargq1&bargq2" );
EndEvent

Event OnVoteQualifyZero() # Lapper Event
	closeGlobalButton("bargq1&bargq2" );
EndEvent

$VoteEnd = 80;

Event OnVoteEndChange($PlayerOnTrack, $Vote , $Need) # Lapper Event
	openGlobalButton( "barge1",100,1,10,6,6,30,96,langEngine( "%{main_vote_end1}%") );
	openGlobalButton( "barge2",110,1,20,6,6,30,96,langEngine( "%{main_vote_end2}%",$Vote,$PlayerOnTrack,$Need ) );
EndEvent

Event OnVoteEndReach($PlayerOnTrack, $Vote , $Need) # Lapper Event
 	closeGlobalButton( "barge1&barge2" );
EndEvent

Event OnVoteEndZero() # Lapper Event
 	closeGlobalButton( "barge1&barge2" );
EndEvent

$VoteLifeSec = 30;

#Auto restart:
#
#$AutoRestartRaceSec = Second between the end of a race (last player finished) and an automatic restart
#
#Rotation only work if AutoRestartRaceSec is set
#EnableRotation =	Allow or disallow rotation for track and/or car
#			Values : true or false
#$RotateTracks = "tracks to rotate"; separated by ','
#$RotateCars = "cars to rotate"; separated by ',' Use LFS definition for car, if not set, no car rotation
#$RotateEveryNbRaces = Number of races to do before rotation;
#-------------------------------------------------------------------

#$AutoRestartRaceSec = 120;
$AutoRestartOnFirstFinished = false;

$EnableRotation = false;
#$RotateTracks = "SO1,BL1R,AS3,FE2,SO2R,AS2,BL2,FE5R,SO6,AS1R,FE6,SO5R,AS7,FE3,SO2,WE1R,BL2R,SO1R,FE5,AS1,SO6R,FE5R,BL2,AS3R,SO4,FE2R,AS7R,SO3,FE6R,AS2R,SO3R,FE1,SO5,FE1R,SO4R";
$RotateEveryNbRaces = 4;
$RotateCars = "XFR+XFG+UF1+TBO+XFR+UFR+FBM+MRT+LX4+FBM+RAC+FZ5";

Event OnRotateCar() # Lapper Event
		openGlobalButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_car_changed}%",getLapperVar( "CurrRotateCar" )));
EndEvent

Event OnRotateTrack() # Lapper Event
 	globalMsg(langEngine( "%{main_track_changed1}%") );
	globalMsg(langEngine( "%{main_track_changed2}%", getLapperVar( "CurrLongRotateTrack" )));
EndEvent

#################################################
#Connect messages when a player joins the server#
#################################################

Event OnConnect( $userName ) # Player event
	$NickName = GetCurrentPlayerVar("NickName");
	UserGroupFromFile( "notwelcome", "./notwelcome.txt" );

	IF( UserInGroup( "notwelcome",$Username ) == 1 )
	THEN
	cmdLFS( "/ban " . $Username . " 30" );
	ENDIF

	$NickName = GetCurrentPlayerVar("NickName");
	$Posabs = GetCurrentPlayerVar("PosAbs");
	$Groupqual = GetCurrentPlayerVar("GroupQual");
	$PBDrift = GetCurrentPlayerVar("PBDrift");
	
	openPrivButton( "shorttrackname",162,165,17,10,1,12,0,langEngine( "%{main_shorttrackname}%",GetLapperVar("ShortTrackName"))); 	

	openPrivButton( "welc_back",60,70,80,60,1,17,16, "");
	openPrivButton( "welc_front",61,71,78,58,1,17,32, "");
	openPrivButton( "welc",62,72,76,7,7,17,0, langEngine("%{main_welc1}%", $NickName ));
	openPrivButton( "pos",62,81,76,5,5,17,0,langEngine("%{main_welc2}%",$Posabs ));
	openPrivButton( "pbdrift",62,86,76,5,5,17,0, langEngine("%{main_welc3}%",$PBDrift  ));
	openPrivButton( "blurb",62,108,76,4,4,17,0, langEngine("%{main_blurb}%"));	
	openPrivButton( "accept_back",93,121,14,7,4,17,16, "");
	openPrivButton( "clos",94,122,12,5,3,17,32,langEngine("%{main_accept}%"),OnConnectClose );
	openPrivButton( "hud_back",70,0,60,8,4,-1,16, "");
	openPrivButton( "hud_front",71,1,58,6,4,-1,32, "");	
	openGlobalButton( "hud_blinkleft",71,1,58,5,4,8,64 + 8,langEngine( "%{hud_blink_green}%" ));
	openGlobalButton( "hud_blinkright",71,1,58,5,4,8,128 + 8,langEngine( "%{hud_blink_green}%" )); 	  	
IF( UserInGroup( "admin",$userName ) == 1 )
THEN
			    	openGlobalButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_serverentermessage_admin}%", $NickName ) );
ELSE
			    	openGlobalButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_serverentermessage}%", $NickName ) );
ENDIF	

EndEvent

Sub OnConnectClose( $KeyFlags,$id )
	OnConnectClose_Marshall();
	closePrivButton("welc_back&welc_front&welc&pos&clos&ref&serv&five&thanks&serv1&sin&pbdrift&blurb&accept_back");
	IF( $Nickname == "unnamed" )
	THEN
	privMsg( langEngine( "%{main_noname}%" ) );
		cmdLFS( "/kick " . $Username );
	ENDIF

	### Close buttons config screen Pitboard ###
	closePrivButton( "config_pb_display_mode_txt&config_pb_display_mode_graphical&config_pb_display_mode_text&config_pb_display_mode_off&config_pb_information_mode_txt" );
	closePrivButton( "config_pb_bg&config_pb_title&config_pb_practise&config_pb_race&config_pb_race_gaps&config_pb_race_splits" );
	closePrivButton( "config_pb_tb_coordinate&config_pb_tb_coordinate_min&config_pb_tb_coordinate_value&config_pb_tb_coordinate_plus" );
	closePriVButton( "config_pb_lr_coordinate&config_pb_lr_coordinate_min&config_pb_lr_coordinate_value&config_pb_lr_coordinate_plus" );
	closePrivButton( "config_pb_test_position&config_pb_test_end&config_pb_split_setting_txt&config_pb_split_setting_value&config_pb_save_settings" );
	closePrivButton( "config_pb_spb_setting_txt&config_pb_spb_setting_splits&config_pb_spb_setting_endlap&config_pb_lost/gained_txt&config_pb_lost/gained_yes&config_pb_lost/gained_no&config_pb_close" );
	### End ###
	IF ( $enable_pitboard == "true" )
	THEN
  config_pb_close($KeyFlags,$id);
#	  OnConnectClose_Pitboard();
  	ENDIF
EndSub

Sub OnConnectCloseKick( $KeyFlags,$id )
	closePrivButton("welc&pos&clos&ref&serv&five&thanks&serv1&sin&pbdrift");
	cmdLFS("/kick " . GetCurrentPlayerVar("UserName") );
EndSub

Sub OnEasyClickClose( $KeyFlags,$id )
	closePrivButton("topback&serverlogo&track&date&easyklik&easyklikhelp&easykliktquiz&easykliktoptimes&easykliktopdrifts");
	closePrivButton("easyklikstats&easyklikadmin&easyklikclose&easyklikclosepb&closedriftbox&easyklikclosemarshall");
	closePrivButton("option_lang_bg&option_lang_title&&option_Lang_en&option_Lang_fr&option_Lang_no&option_Lang_nl&option_Lang_it");
	closePrivButton("easyklikpstats&easyklikpbests&easykliktopcombo&easyklikpoints&easyklikspeed");
EndSub

Sub OnConnectClose_Marshall()
	### Get UserName and search in storedvalue.dbs for saved values for this user ###
	$userName = GetCurrentPlayerVar( "UserName" );

	SetCurrentPlayerVar( "$marshall_on_off",GetStoredValue( $userName . "$marshall_on_off" ) );

	### Set default values if no values are loaded ###
	IF ( GetStoredValue( $userName . "$marshall_on_off" ) == "")
	THEN
	SetCurrentPlayerVar( "$marshall_on_off","on" ); # Set marshall "on"
	ENDIF
EndSub

Sub OnClickCloseMarshall( $KeyFlags,$id )
	SetCurrentPlayerVar( "$marshall_on_off","off" ); # Set marshall "off"
	closePrivButton( "m_instruct&m_instruct1&hide_marshall&notohide_marshall" );
	closePrivButton( "paintball_warning&blank_back&warning&warning1&info&impressive&remember&warning_message1&adjective" );
	closePrivButton( "manhand1&manhand1a&manarm1&manarm1a&head1&head1a&white_band&marshall_hat&yellow_trim&earA&earB&earA1&earB1&eyeA&eyeB&mouth" );
	closePrivButton( "yellow_flag1a&yellow_flag2a&yellow_flag3a&yellow_flag4a&yellow_flag5a&yellow_flag6a&yellow_flag7a&yellow_flag8a&yellow_flag9a" );
	closePrivButton( "manarm&manarma&manarm7&manarm7a&manlines&man8&manlines1&clogo&manlogo&manll1&manll2&manrl1&manrl2&manlf&manrf&shorts1&shorts2" );
EndSub

Sub OnClickClosepb( $KeyFlags,$id )

	    closePrivButton( "pitboard_current_sector_1_txt&pitboard_last_sector_1_txt&pitboard_best_sector_1_txt");
	    closePrivButton( "pitboard_current_sector_1&pitboard_last_sector_1&pitboard_best_sector_1" );
	    closePrivButton( "pitboard_before_sector_1&pitboard_behind_sector_1" );
	    closePrivButton( "pitboard_current_sector_2_txt&pitboard_last_sector_2_txt&pitboard_best_sector_2_txt");
	    closePrivButton( "pitboard_current_sector_2&pitboard_last_sector_2&pitboard_best_sector_2" );
	    closePrivButton( "pitboard_before_sector_2&pitboard_behind_sector_2");
	    closePrivButton( "pitboard_current_sector_3_txt&pitboard_last_sector_3_txt&pitboard_best_sector_3_txt");
	    closePrivButton( "pitboard_current_sector_3&pitboard_last_sector_3&pitboard_best_sector_3" );
	    closePrivButton( "pitboard_before_sector_3&pitboard_behind_sector_3");
	    closePrivButton( "pitboard_current_sector_last_txt&pitboard_last_sector_last_txt&pitboard_best_sector_last_txt");
	    closePrivButton( "pitboard_current_sector_last&pitboard_last_sector_last&pitboard_best_sector_last" );
	    closePrivButton( "pitboard_before_sector_last&pitboard_behind_sector_last" );
	    closePrivButton( "pitboard_information&pitboard_information_2" );
	    closePrivButton( "pitboard_safetycar_message_1&pitboard_safetycar_message_2&pitboard_safetycar_message_3" );
	    closePrivButton( "pitboard_safetycar_bg&pitboard_txt&pitboard_total" );
	    closePrivButton( "pitboard_start_pitwindow_lap&pitboard_end_pitwindow_lap&pitboard_number_of_stops&pitboard_start_pitwindow&pitboard_end_pitwindow" );
	    closePrivButton( "pitboard_no_pitwindow&pitboard_pw_stops");

	IF ( $enable_pitboard == "true" )
	THEN
	  OnConnectClose_Pitboard();
	ENDIF
EndSub

Sub OnClickCloseDM( $KeyFlags,$id )
	$GUI_drift="no";
	closePrivButton("dminstruct&dminstruct1&yes_to_drift&no_to_drift" );
	closePrivButton("statsbacking&statstitle&statsdetails&qualdetails&closestats&mylogo&sinrslogo&driftboxback");
	closePrivButton("driftanglebox&driftcombbox&driftscorebox&driftangleboxtext&driftcomboboxtext&driftscoreboxtext&driftcomboboxtexttop");
	closePrivButton("closedrftop&closedrftop1&help&help2&close&drfback_button&drf_rubbish_button&drfnear_button");
	closePrivButton("19_36_button&37_54_button&55_72_button&73_90_button&91_108_button&199_216_button&217_234_button&271_289_button&290_307_button");
	closePrivButton("109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&235_252_button&253_270_button");
	closePrivButton("driftcomboboxtexttopmessage&driftcomboboxtexttopmessage0&driftcomboboxtexttopmessage1&driftcomboboxtexttopmessage2");
	closePrivButton("driftangleboxtextanglerev&driftanglerev&driftscoretextrev&driftcombotextrev");
	closePrivButton("driftangleboxtextangle&driftangle&driftscoretext&driftcombotext&drftop_button");
	closePrivButton("TDSM0&TDSM&TDSM1&TDSM2&TDSM3&TDSM4&TDSM5&TDSM6&TDSM7&TDSM8&TDSM9" );
	closePrivButton("TDSLL&TDSLL1&TDSLL2&TDSLL3&TDSLL4&TDSLL5&TDSLL6&TDSLL7&TDSLL8&TDSLL9" );
	closePrivButton("TDSRL&TDSLR1&TDSLR2&TDSLR3&TDSLR4&TDSLR5&TDSLR6&TDSLR7&TDSLR8&TDSLR9" );
	closePrivButton("TDS11&TDS12&TDS13&TDS14&TDS15&TDS21&TDS22&TDS23&TDS24&TDS25&TDS31&TDS32&TDS33&TDS34&TDS35" );
	closePrivButton("TDS41&TDS42&TDS43&TDS44&TDS45&TDS51&TDS52&TDS53&TDS54&TDS55&TDS61&TDS62&TDS63&TDS64&TDS65" );
	closePrivButton("TDS71&TDS72&TDS73&TDS74&TDS75&TDS81&TDS82&TDS83&TDS84&TDS85&TDS91&TDS92&TDS93&TDS94&TDS95" );
	closePrivButton("TDS01&TDS02&TDS03&TDS04&TDS05&main_driftadequate" );
	closePrivButton( "drift399&drift400&drift500&drift1000&drift2000&drift5000&drift10000&drift15000&drift20000&drift30000" );
	closePrivButton("driftmeter_TDS01&driftmeter_TDS02&driftmeter_TDS03&driftmeter_TDS04&driftmeter_TDS05&driftmeter_TDS11&driftmeter_TDS12&driftmeter_TDS13" );
	closePrivButton("driftmeter_TDS21&driftmeter_TDS22&driftmeter_TDS23&driftmeter_TDS24&driftmeter_TDS25&driftmeter_TDS31&driftmeter_TDS32&driftmeter_TDS335" );
	closePrivButton("driftmeter_TDS14&driftmeter_TDS15&driftmeter_TDS34&driftmeter_TDS3&driftmeter_TDS41&driftmeter_TDS42&driftmeter_TDS43&driftmeter_TDS44" );
	closePrivButton("driftmeter_TDS45&driftmeter_TDS51&driftmeter_TDS52driftmeter_TDS53&driftmeter_TDS54&driftmeter_TDS55&driftmeter_TDS61&driftmeter_TDS62" );
	closePrivButton("driftmeter_TDS63&driftmeter_TDS64&driftmeter_TDS65&driftmeter_TDS71&driftmeter_TDS72&driftmeter_TDS73&driftmeter_TDS74&driftmeter_TDS75" );
	closePrivButton("driftmeter_TDS81&driftmeter_TDS82&driftmeter_TDS83&driftmeter_TDS84&driftmeter_TDS85&driftmeter_TDS91&driftmeter_TDS92&driftmeter_TDS93" );
	closePrivButton("driftmeter_TDS94&driftmeter_TDS95&driftmeter_TDSM&driftmeter_TDSM0&driftmeter_TDSM1&driftmeter_TDSM2&driftmeter_TDSM3&driftmeter_TDSM4" );
	closePrivButton("driftmeter_TDSM5&driftmeter_TDSM6&driftmeter_TDSM7&driftmeter_TDSM8&driftmeter_TDSM9&driftmeter_driftbarelyadequate&driftmeter_driftadequate" );
	closePrivButton("driftmeter_driftgood&driftmeter_driftsuperb&driftmeter_driftoutrageous&driftmeter_driftinsane&driftmeter_driftroyalty&driftmeter_driftgod" );
	closePrivButton("driftmeter_driftnotworthy&driftmeter_mylogo&driftmeter_driftanglebox&driftmeter_driftangleboxtext&driftmeter_driftangleboxtextangle" );
	closePrivButton("driftmeter_driftanglerevboxp&driftmeter_driftcombotext&driftmeter_driftcomboboxtext&driftmeter_driftcomboboxtextto" );
	closePrivButton("driftmeter_driftcomboboxtexttopmessage&driftmeter_driftcomboboxtexttopmessage2&driftmeter_driftscoretext&driftmeter_driftscoreboxtext" );
	closePrivButton("driftmeter_drifttolow&driftmeter_driftlap&driftmeter_newdriftpb&driftmeter_ongooddrift" );
EndSub

##########################################
#New Player joining race or leaving pits)#
##########################################

Event OnNewPlayerJoin( $userName )  # Player event

	closePrivButton("speed_current&speed_current1&speed_bg&speed_title&speed_kmh&speed_mph&speed_close");
	closePrivButton("easyklikpstats&easyklikpbests&easykliktopcombo&easyklikpoints&easyklikspeed");
	closePrivButton("topback&serverlogo&track&date&easyklik&easyklikhelp&easykliktquiz&easykliktoptimes&easykliktopdrifts&easyklikstats&easyklikadmin");
	closePrivButton("easyklikclose&easyklikclosepb&closedriftbox&easyklikopen&closetop&closetop1&easyklikclosemarshall");
	closePrivButton("blank_back&warning&warning1&info&impressive&remember&warning_message1&adjective&option_lang_bg&option_lang_title" );
	closePrivButton("swear_not_please&swear_not_kick&enterpits&leavepits&pitcareful&lowdrift&acceleration&spamming&option_Lang_en&option_Lang_fr" );
	closePrivButton("help&help2&close&statsbacking&statstitle&statsdetails&qualdetails&closestats&drf_rubbish_button&option_Lang_it&topTBO_button");
	closePrivButton("closedrftop&closedrftop1&help&help2&close&drfback_button&drf_rubbish_button&drftop_button&option_Lang_no&option_Lang_nl");
	closePrivButton("19_36_button&37_54_button&55_72_button&73_90_button&91_108_button&217_234_button&235_252_button&271_289_button&290_307_button");
	closePrivButton("drfnear_button&109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&199_216_button&253_270_button");
	closePrivButton("back_button&UF1_button&XFG_button&XRG_button&XRT_button&RB4_button&FXO_button&RAC_button&FZ5_button&LX4_button&LX6_button");
	closePrivButton("MRT_button&UFR_button&XFR_button&FBM_button&FOX_button&FXR_button&XRR_button&FZR_button&FO8_button&BF1_button&top1_button");
	closePrivButton("top18_button&top35_button&top52_button&top69_button&top86_button&top103_button&top120_button&topGTR_button&topFWD_button&topRWD_button");
	openPrivButton( "label_lfslogo",5,181,21,4,1,-1,128,langEngine( "%{label_lfslogo}%" ));
	openPrivButton( "label_logo",4,170,24,14,1,-1,128,langEngine( "%{label_logo}%" ));
EndEvent

#####################################################
# Event  when a player changes their nickname
#####################################################
Event OnNameChange($userName,$oldNickName,$newNickName) # Player event
	openGlobalButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_namechangemessage}%", $oldNickName,$newNickName ) );
EndEvent

#####################################################
#DisConnect messages when a player leaves the server#
#####################################################

#Event OnDisConnect( $userName, $reason ) # Player event
#	$NickName = GetCurrentPlayerVar("NickName");
#  openGlobalButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_namedisconnect}%", $NickName,$reason ) );EndEvent
##############################################
#Splitting (general action when passing split)#
###############################################

Event OnSplit1( $userName ) # Player event
EndEvent

Event OnSplit2( $userName ) # Player event
EndEvent

Event OnSplit3( $userName ) # Player event
EndEvent

Event OnLap( $userName ) # Player event
EndEvent

#################################################
#Action when a predefined dist is done by player#
# Minimum dist is 100 meters
# -1 deactivate this feature
#################################################
$distToDo = 100;
Event OnDistDone( $userName ) # Player event
	closePrivButton( "invoice_line&invoice_times&invoice_list&invoice_prices&invoice_debit&invoice_thanks");
	closePrivButton( "invoice_list_mechs&invoice_prices_mechs&invoice_list_body&invoice_prices_body&invoice_back&invoice_logo&invoice_text");
EndEvent

#############################################
#Action when a new Gapping Info is available#
#############################################

Event OnNewGapPlayerBefore( $userName,$split ) # Player Event

EndEvent

Event OnNewGapPlayerBehind( $userName,$split )  # Player Event

EndEvent

#######################################################
#Splitting (compare player split to best player split)#
#######################################################

$ShowSplitPB = true; # Set to false if you don't want to see messages about splits

Event OnSpbSplit1( $userName ) # Player event

EndEvent

Event OnSpbSplit2( $userName ) # Player event

EndEvent

Event OnSpbSplit3( $userName ) # Player event

EndEvent

Event OnSpbLast( $userName ) # Player event

EndEvent

####################################################
#Actions to do on splits relative to trackinfo.cfg#
####################################################
#Local variable: {SplitTime} - Split time
#-------------------------------------------------------------------

Sub TRI_split1_0( $userName ) # Player event
	globalMsg(  langEngine( "%{main_great1}%", NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_split1_1( $userName ) # Player event
	globalMsg( langEngine( "%{main_good1}%",NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_split2_0( $userName ) # Player event
	globalMsg(  langEngine( "%{main_great2}%", NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_split2_1( $userName ) # Player event
	globalMsg( langEngine( "%{main_good2}%",NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_split3_0( $userName ) # Player event
	globalMsg(  langEngine( "%{main_great3}%", NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_split3_1( $userName ) # Player event
	globalMsg( langEngine( "%{main_good3}%",NumToMSH(GetCurrentPlayerVar("SplitTime")),GetCurrentPlayerVar("NickName") ) );
EndSub

Sub TRI_lap_0( $userName ) # Player event
	globalMsg( langEngine( "%{main_greatlap}%",NumToMSH( GetCurrentPlayerVar("LapTime") ), GetCurrentPlayerVar("NickName" ) ) );
EndSub

Sub TRI_lap_1( $userName ) # Player event
	globalMsg( langEngine( "%{main_goodlap}%", NumToMSH( GetCurrentPlayerVar("LapTime") ), GetCurrentPlayerVar("NickName") ) );
EndSub



#########################
#List of user qualifying#
#########################
#RefreshQualUsers : allow Lapper to refresh QualUsers on each outgoing pits, Usefull if QualUsers is a file and this is changed frequently by an external program
#QualUser : is a list of racers that participed in the qualification, required for function !nearqual !topqual and !statsqual
#if you prefix with & , You can indicate a file name that contains a list of racers, one racer per line (example : QualUsers = ./userfile.txt;)
#if you prefix with @, You can list usernames separated with ',' (example : QualUsers = @Gai-Luron,gwendoline,_-ALUCARD-_,lagamel;)
#You can specify which car is used by a user adding car after username separated by ':' (example : Gai-Luron:XFR,lagamel:UFR)
#You can specify the scheme of group of this qualification using a special username called DefGroup
#Defgroup Take 3 argument separated with ':'
#1 - Is the number Max of Group for this qualification
#2 - Is the number max of user per group
#3 - Is the minimum of user in the last group, recalc previous group as possible if number is low
#If you ommit scheme of groups, the group of qualification do not appear
#-------------------------------------------------------------------

$RefreshQualUsers = true;
#$QualUsers = "&./your_file.flt";
#$QualUsers = "@DefGroup:5:5:2,Gai-Luron,MataGyula,nesrulz,gwendoline,_-ALUCARD-_,lagamel,lister88,bruno7529,boby5,kevinb,edgar,berlioz,latortue,neron59,eur-can,stff,2psbob,oliv76000";

#################
#Command actions#
#################
#If ! before a name, force nickName authentification if UseUsernameForAuthentication=true
#If ! before a name, force userName authentification if UseUsernameForAuthentication=false
#You can use regexp expression in userName pattern, type regex=your regular expression
#
#Example:	if UseUsernameForAuthentication=true
#		!regex=^\[COP\].*
#		Find all user with a nickname that begins with [COP]
#		regex=^Gai.*
#		Find all user with a username that begins with Gai
# 		See regular expression on web for more info how it work
#
#Use & sign at end of patterns
#-------------------------------------------------------------------

Event OnMSO( $userName, $text ) # Player event

	$idxOfFirtsSpace = indexOf( $text, " ");

#	$LOF = getListOfPlayers();
#	dumpVar( $LOF );

	IF( $idxOfFirtsSpace == -1 ) THEN
	  $command = $text;
	  $argv = "";
	ELSE
	  $command = subStr( $text,0,$idxOfFirtsSpace );
	  $argv = trim( subStr( $text,$idxOfFirtsSpace ) );
	ENDIF
	
	SWITCH( $command )

		CASE "!quiz":
		CASE "quiz":
		CASE "Quiz":
		CASE "QUIZ":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_quiz}%" ));
		BREAK;


		CASE "!point":
		CASE "!points":
		CASE "!rank":
			topUser( "^1Lapper P^0oints ^1S^0ystem","ps_points_total","DESC",argv );
			BREAK;

		CASE "!node":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_currnode}%", GetCurrentPlayerVar( "CurrNode" ) ) );
			ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_notadmin}%" ) );
			ENDIF
			BREAK;

		CASE "!zone":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_currzone}%", GetCurrentPlayerVar( "X" ) . ":" . GetCurrentPlayerVar( "Y" ) ) );
			ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_notadmin}%" ) );
			ENDIF
			BREAK;

		CASE "!term":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  globalMsg( langEngine( "%{main_lapclose}%" ) );
			  termLapper();
			ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_notadmin}%" ) );
			ENDIF
			BREAK;

		CASE "!cop":
				SE_DrawCop();
			BREAK;

		CASE "!warden":
		SE_DrawWarden();
			BREAK;


		CASE "!paint":
		SE_DrawPaint();

			BREAK;

		CASE "!patrol":
		SE_DrawPatrol();

			BREAK;

		CASE "!test":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
		        privRcm( GetCurrentPlayerVar("NickName") . " ^7is testing...");
	openPrivButton( "circledrift_background",0,70,165,165,1,5,64,"^1•"); # red background
			ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0, langEngine( "%{main_notadmin}%" ) );
			ENDIF		        
			BREAK;

		CASE "!powered":
			http("http://www.frh-team.net/reglapper/getserver2.php");
			BREAK;

		CASE "!license":
		CASE "!licence":
		  setLicense( $argv );
	 		BREAK;

		CASE "!groupcmdlfs":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
			  groupCmdLfs( $argv );
			ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_notadmin}%" ) );
			ENDIF
			BREAK;

		CASE "!ban":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_ban}%", GetCurrentPlayerVar( "NickName" ), GetPlayerVar( $argv, "NickName" ) ) );
			  cmdLFS( "/ban " . $argv . " 1" );
			ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_notadmin}%" ) );
			ENDIF			  
			BREAK;

		CASE "!kick":
			IF ( UserIsAdmin( $userName ) == 1 )
			THEN
		openPrivButton( "hud_message",74,1,51,5,4,8,0, langEngine( "%{main_kick}%", GetCurrentPlayerVar( "NickName" ), GetPlayerVar( $argv, "NickName" ) ));
			  cmdLFS( "/kick " . $argv );
			ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_notadmin}%" ) );
			ENDIF
			BREAK;

		CASE "!pos":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_friendpos}%", GetCurrentPlayerVar( "PosAbs" ) ) );
			BREAK;

		CASE "!groupqual":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_groupqual}%", GetCurrentPlayerVar( "GroupQual" ) ) );
			BREAK;

		CASE "!ver":
			http("http://www.frh-team.net/reglapper/getserver2.php");
			lapperVersion();
			BREAK;

		CASE "!auth":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_level}%", GetCurrentPlayerVar("AuthLevel") ) );
			BREAK;
			
		CASE "!cleanspb":
			cleanSpb();
			BREAK;

		CASE "!spb":
			openPrivButton( "spb",0,17,28,5,1,7,96,langEngine( "%{main_spb}%" ) );
			showSpb();
			BREAK;

		CASE "!hand":
			showHand( $argv );
			BREAK;

		CASE "!statsqual":
			statsQual( $argv );
			BREAK;

		CASE "!dstatsqual":
			dStatsQual( $argv );
			BREAK;

		CASE "!stats":
			stats( $argv );
			BREAK;

		CASE "!dstats":
			dStats( $argv );
			BREAK;

		CASE "!nearqual":
			nearQual( $argv );
			BREAK;

		CASE "!drfnearqual":
			drfNearQual( $argv );
			BREAK;

		CASE "!near":
		CASE "!Near":
		CASE "!NEAR":
			near( $argv );
			BREAK;

		CASE "!drfnear":
			drfNear( $argv );
			BREAK;

		CASE "!mypb":
		CASE "!myPB":
		CASE "!MYPB":
			CurrentPlayerlfsWorldPB( $argv );
			BREAK;

		CASE "!myconfig":
			myConfig( );
			BREAK;

		CASE "!drf":
			drf( $argv );
			BREAK;

		CASE "!topqual":
			topQual( $argv );
			BREAK;

		CASE "!drfqual":
			drfQual( $argv );
			BREAK;

		CASE "!distance":
			openPrivButton( "distance_done",0,11,85,6,5,6,0,langEngine( "%{main_dist}%",GetCurrentPlayerVar("Car"),getLapperVar("ShortTrackName"),ToPlayerUnit( GetCurrentPlayerVar("Dist")),GetCurrentPlayerVar("UnitDist"),ToPlayerUnit(GetCurrentPlayerVar("SessDist")),GetCurrentPlayerVar("UnitDist")));
			BREAK;
			
		CASE "!laps":
			openPrivButton( "laps_done",0,11,85,6,6,4,0,langEngine("%{main_lapsdone}%",GetCurrentPlayerVar("Car"),getLapperVar("ShortTrackName"),GetCurrentPlayerVar("Laps"),GetCurrentPlayerVar("SessLaps")));
			 BREAK;

		CASE "!pit":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_timeinpit}%",NumToMSH (GetCurrentPlayerVar("TotalPitTime"))));
			BREAK;

		CASE "!track":
		CASE "!tr":		
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_trackused}%",getLapperVar("ShortTrackName"),getLapperVar("LongTrackName") ) );
			BREAK;

		CASE "!time":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_serverclock}%",getLapperVar("LongTime") ) );
			BREAK;

		CASE "!closepb":
		CASE "!pbclose":
			IF ( $enable_pitboard == "true" )
			THEN
			  close_pitboard( $KeyFlags );
			ENDIF
			BREAK;

		CASE "!config":
		CASE "!pbconfig":
			IF ( $enable_pitboard == "true" )
			THEN
			  Config_Pitboard( $KeyFlags );
			ENDIF
			BREAK;

		CASE "!pitwindow":
			IF ( $enable_pitboard == "true" )
			THEN
			  Pitwindow( $KeyFlags ); 
			ENDIF
			BREAK;

		CASE "!pwgui":
			IF ( $enable_pitwindow_gui == "true" )
			THEN
			  IF( UserInGroup( "admin", $userName ) == 1 )
			  THEN
			    MA_pwgui(0,0);
			  ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_notadmin}%" ));
			  ENDIF
			ENDIF
			BREAK;

		CASE "!sc":
			IF ( $enable_safetycar_gui == "true" )
			THEN
			  IF( UserInGroup( "admin", $userName ) == 1 )
			  THEN
			    Safetycar_gui( $KeyFlags );
			  ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_notadmin}%" ));
			  ENDIF
			ENDIF
			BREAK;

		CASE "!ctrack":
			IF ( $enable_ctrack_gui == "true" )
			THEN
			  IF( UserInGroup( "admin", $userName ) == 1 )
			  THEN
			    Ctrack(0,0);
			  ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_notadmin}%" ));
			  ENDIF
			ENDIF
			BREAK;

		CASE "!admin":
		CASE "!ADMIN":
		CASE "!Admin":
			DoMultiPageHelp(0, "multihelp_contents_4");
			BREAK;

		CASE "!reload":
			UserGroupFromFile( "superusers", "./superusers.txt" );
			IF( UserInGroup( "superusers",$userName) )
      		THEN
				privMsg("Restarting and reloading config!");
				reload();
			ELSE
	      		privMsg("Only for admin!");
			ENDIF
			BREAK;

#	How to ask people do they want Drift Meter or not

#		CASE "!drift":
#		CASE "!Drift":
#		CASE "!DRIFT":
#		OnClickDriftQuery(0,0);
#			BREAK;

#	How to ask people do they want marshall to show or not

		CASE "!mar":
		CASE "!marshall":
		CASE "!Marshall":
		CASE "!MARSHALL":
		OnClickMarshallQuery(0,0);
			BREAK;

		CASE "!ps":
		CASE "!PS":
		CASE "!show":
		CASE "!Show":
		CASE "!SHOW":
		    IF( $argv == "" ) THEN
				PstInfo( $userName );
			ELSE
				PstInfo( $argv );
			ENDIF
			BREAK;

		CASE "!tpb":
		CASE "!TPB":
		CASE "!Tpb":
			openPrivButton( "tpb",8,8,30,4,0,7,96,langEngine( "%{main_tpb}%" ) );
			privMsg(NumToMSH (GetCurrentPlayerVar("Tpb")));
			 BREAK;

		CASE "!server":
		CASE "!host":
			privMsg("This server is hosted by 500Servers");
			BREAK;

	CASE "!count":
	CASE "!Count":
	CASE "!COUNT":
	IF( UserInGroup( "admin",$userName ) == 1 )
		THEN

    	openGlobalButton( "yellow_go",84,70,20,50,1,9,0,"^3|"); # Yellow button will last for 8 seconds - will 'appear' when green button goes away
   	openGlobalButton( "yellow_go1",86,70,20,50,1,9,0,"^3|");
    	openGlobalButton( "yellow_go2",88,70,20,50,1,9,0,"^3|");
    	openGlobalButton( "yellow_go3",90,70,20,50,1,9,0,"^3|");
    	openGlobalButton( "yellow_go4",92,70,20,50,1,9,0,"^3|");
    	openGlobalButton( "yellow_go5",94,70,20,50,1,9,0,"^3|");
    	openGlobalButton( "yellow_go6",96,70,20,50,1,9,0,"^3|");
    	openGlobalButton( "yellow_go7",98,70,20,50,1,9,0,"^3|");
    	openGlobalButton( "yellow_go8",100,70,20,50,1,9,0,"^3|");
   	openGlobalButton( "green_GO",92,78,20,40,5,9,0,"^2GO !"); # to give drivers time to react, will show green 'GO' for further 3 seconds after green button goes off 

    	openGlobalButton( "green_1",84,70,20,50,1,6,0,"^2|"); # Green button on for 6 seconds - will 'appear' when blue button goes away
     	openGlobalButton( "green_1a",86,70,20,50,1,6,0,"^2|");
     	openGlobalButton( "green_1b",88,70,20,50,1,6,0,"^2|");
    	openGlobalButton( "green_1c",90,70,20,50,1,6,0,"^2|");
    	openGlobalButton( "green_1d",92,70,20,50,1,6,0,"^2|");
    	openGlobalButton( "green_1e",94,70,20,50,1,6,0,"^2|");
    	openGlobalButton( "green_1f",96,70,20,50,1,6,0,"^2|");
    	openGlobalButton( "green_1g",98,70,20,50,1,6,0,"^2|");
    	openGlobalButton( "green_1h",100,70,20,50,1,6,0,"^2|");
    	openGlobalButton( "blue_1",92,78,20,40,5,6,0,"^41"); # will show blue number 1 on green button

    	openGlobalButton( "blue_2a",84,70,20,50,1,5,0,"^4|"); # Blue button on for 5 seconds - will 'appear' when red button goes away
    	openGlobalButton( "blue_2b",86,70,20,50,1,5,0,"^4|");
    	openGlobalButton( "blue_2c",88,70,20,50,1,5,0,"^4|");
    	openGlobalButton( "blue_2d",90,70,20,50,1,5,0,"^4|");
    	openGlobalButton( "blue_2e",92,70,20,50,1,5,0,"^4|");
    	openGlobalButton( "blue_2f",94,70,20,50,1,5,0,"^4|");
    	openGlobalButton( "blue_2g",96,70,20,50,1,5,0,"^4|");
    	openGlobalButton( "blue_2h",98,70,20,50,1,5,0,"^4|");
    	openGlobalButton( "blue_2i",100,70,20,50,1,5,0,"^4|");
    	openGlobalButton( "red_2",92,78,20,40,5,5,0,"^12"); # will show red number 2 on blue button

    	openGlobalButton( "red_3a",84,70,20,50,1,4,0,"^1|"); # Red button on for 4 seconds - will 'appear' when black button goes away
	openGlobalButton( "red_3b",86,70,20,50,1,4,0,"^1|");
	openGlobalButton( "red_3c",88,70,20,50,1,4,0,"^1|");
	openGlobalButton( "red_3d",90,70,20,50,1,4,0,"^1|");
	openGlobalButton( "red_3e",92,70,20,50,1,4,0,"^1|");
	openGlobalButton( "red_3f",94,70,20,50,1,4,0,"^1|");
	openGlobalButton( "red_3g",96,70,20,50,1,4,0,"^1|");
	openGlobalButton( "red_3h",98,70,20,50,1,4,0,"^1|");
	openGlobalButton( "red_3i",100,70,20,50,1,4,0,"^1|");
    	openGlobalButton( "black_3",92,78,20,40,5,4,0,"^03"); # will show black number 3 on red button

    	openGlobalButton( "black_1a",84,70,20,50,1,3,0,"^1|"); # Black button on for 3 seconds - to give drivers short time to prepare
    	openGlobalButton( "black_1b",86,70,20,50,1,3,0,"^1|");
    	openGlobalButton( "black_1c",88,70,20,50,1,3,0,"^1|");
    	openGlobalButton( "black_1d",90,70,20,50,1,3,0,"^1|");
   	openGlobalButton( "black_1e",92,70,20,50,1,3,0,"^1|");
   	openGlobalButton( "black_1f",94,70,20,50,1,3,0,"^1|");
   	openGlobalButton( "black_1g",96,70,20,50,1,3,0,"^1|");
   	openGlobalButton( "black_1h",98,70,20,50,1,3,0,"^1|");
   	openGlobalButton( "black_1i",100,70,20,50,1,3,0,"^1|");
   	openGlobalButton( "white_ready",92,78,20,40,5,3,0,"^7R E A D Y"); # to give drivers time to prepare, will show white 'READY' on black button - will be on for 3 seconds

		ENDIF
	 BREAK;

	CASE "!UF1":
	CASE "!uf1":
		Click_UF1(0,0);
	 BREAK;

	CASE "!LX6":
	CASE "!lx6":
		Click_LX6(0,0);
	BREAK;

	CASE "!LX4":
	CASE "!lx4":
		Click_LX4(0,0);
	BREAK;

	CASE "!FZ5":
	CASE "!fz5":
		Click_FZ5(0,0);
	BREAK;

	CASE "!FXO":
	CASE "!fxo":
		Click_FXO(0,0);
	BREAK;

	CASE "!RAC":
	CASE "!rac":
		Click_RAC(0,0);
	BREAK;

	CASE "!RB4":
	CASE "!rb4":
		Click_RB4(0,0);
	BREAK;

	CASE "!FBM":
	CASE "!fbm":
		Click_FBM(0,0);
	 BREAK;

	CASE "!FOX":
	CASE "!fox":
		Click_FOX(0,0);
	 BREAK;

	CASE "!FO8":
	CASE "!fo8":
		Click_FO8(0,0);
	 BREAK;

	CASE "!FZR":
	CASE "!fzr":
		Click_FZR(0,0);
	 BREAK;

	CASE "!FXR":
	CASE "!fxr":
		Click_FXR(0,0);
	 BREAK;

	CASE "!XRR":
	CASE "!xrr":
		Click_XRR(0,0);
	 BREAK;

	CASE "!XRG":
	CASE "!xrg":
		Click_XRG(0,0);
	 BREAK;

	CASE "!MRT":
	CASE "!mrt":
		Click_MRT(0,0);
	 BREAK;

	CASE "!XRT":
	CASE "!xrt":
		Click_XRT(0,0);
	 BREAK;

	CASE "!XFR":
	CASE "!xfr":
		Click_XFR(0,0);
	 BREAK;

	CASE "!XFG":
	CASE "!xfg":
		Click_XFG(0,0);
	 BREAK;

	CASE "!UFR":
	CASE "!ufr":
		Click_UFR(0,0);
	 BREAK;

	CASE "!BF1":
	CASE "!bf1":
		Click_BF1(0,0);
	 BREAK;

	CASE "!mystats":
	CASE "!Mystats":
	CASE "!MYSTATS":
	CASE "!MyStats":
	CASE "mystats":
	CASE "Mystats":
	CASE "MYSTATS":
	CASE "MyStats":
	CASE "!mystat":
	CASE "!Mystat":
	CASE "!MYSTAT":
	CASE "!MyStat":
		OnClickStats(0,0);
	 BREAK;

		CASE "scotland":
		CASE "Scotland":
		CASE "SCOTLAND":
		CASE "ecosse":
		CASE "Ecosse":
		CASE "schotland":
		CASE "Schotland":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_scotland}%" ));
		BREAK;

		CASE "ho":
		CASE "hoho":
		CASE "hohoho":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_santa}%", GetCurrentPlayerVar("NickName") ) );
		BREAK;

		CASE "ha":
		CASE "haha":
		CASE "hahaha":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_funny}%", GetCurrentPlayerVar("NickName") ) );
		BREAK;

		CASE "lol":
		CASE "LOL":
		CASE "ROFL":
		CASE "rofl":
		CASE "RAFL":
		CASE "rafl":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_funny2}%" ));
		BREAK;

		CASE "sorry":
		CASE "Sorry":
		CASE "SORRY":
		CASE "bad":
		CASE "Bad":
		CASE "BAD":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_sorry}%" ));
		BREAK;

		CASE "damn":
		CASE "damn!":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_damn}%" ));
		BREAK;

		CASE "brb":
		CASE "BRB":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_brb}%" ));
		BREAK;

		CASE "g25":
		CASE "G25":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_g25}%" ));
		BREAK;

		CASE "dutch":
		CASE "Dutch":
		CASE "DUTCH":
		CASE "holland":
		CASE "Holland":
		CASE "HOLLAND":
		CASE "netherland":
		CASE "Netherland":
		CASE "NETHERLAND":
		CASE "nederland":
		CASE "Nederland":
		CASE "NEDERLAND":
		CASE "netherlands":
		CASE "Netherlands":
		CASE "NETHERLANDS":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_dutch}%" ));
		BREAK;

		CASE "finland":
		CASE "Finland":
		CASE "FINLAND":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_finland}%" ));
		BREAK;

		CASE "czech":
		CASE "Czech":
		CASE "CZECH":
		CASE "czechs":
		CASE "Czechs":
		CASE "CZECHS":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_czech}%" ));
		BREAK;

		CASE "canada":
		CASE "Canada":
		CASE "CANADA":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_canada}%" ));
		BREAK;

    CASE "america":
		CASE "America":
		CASE "USA":
		CASE "usa":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_usa}%" ));
		BREAK;
		
		CASE "switzerland":
		CASE "Switzerland":
		CASE "SWITZERLAND":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_swiss}%" ));
		BREAK;

		CASE "australia":
		CASE "Australia":
		CASE "AUSTRALIA":
		CASE "Oz":
		CASE "oz":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_australia}%" ));
		BREAK;

		CASE "zealand":
		CASE "Zealand":
		CASE "ZEALAND":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_kiwi}%" ));
		BREAK;

		CASE "pb":
		CASE "Pb":
		CASE "PB":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_pb}%" ));
		BREAK;

		CASE "spain":
		CASE "Spain":
		CASE "SPAIN":
		CASE "spanish":
		CASE "Spanish":
		CASE "SPANISH":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_spain}%" ));
		BREAK;

		CASE "kiwi":
		CASE "Kiwi":
		CASE "KIWI":
		CASE "zealand":
		CASE "Zealand":
		CASE "ZEALAND":
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_kiwi}%" ));
		BREAK;

		CASE "italy":
		CASE "Italy":
		CASE "ITALY":
	privMsg(langEngine( "%{main_italy}%" ));
		BREAK;

		CASE "england":
		CASE "England":
		CASE "ENGLAND":
	privMsg(langEngine( "%{main_england}%" ));
		BREAK;

		CASE "iceland":
		CASE "Iceland":
		CASE "ICELAND":
	privMsg(langEngine( "%{main_iceland}%" ));
		BREAK;

		CASE "god":
		CASE "God":
		CASE "GOD":
	privMsg(langEngine( "%{main_god}%" ));
		BREAK;

		CASE "jesus":
		CASE "Jesus":
		CASE "JESUS":
	privMsg(langEngine( "%{main_jesus}%" ));
		BREAK;

		CASE "keys":
		CASE "Keys":
		CASE "KEYS":
		CASE "keyboard":
		CASE "keyboarder":
		CASE "Keyboard":
	privMsg(langEngine( "%{main_keys}%" ));
		BREAK;

		CASE "cheers":
		CASE "Cheers":
		CASE "Na Zdravi":
		CASE "na zdravi":
		CASE "prost":
		CASE "Prost":
		CASE "proost":
		CASE "Proost":
		CASE "saude":
		CASE "Saude":
		CASE "sante":
		CASE "Sante":
		CASE "jamas":
		CASE "Jamas":
		CASE "Zivjeli":
		CASE "zivjeli":
		CASE "kampai":
		CASE "Kampai":
	privMsg(langEngine( "%{main_cheers}%" ));
		BREAK;

		CASE "feck":
		CASE "Feck":
		CASE "FECK":
	privMsg(langEngine( "%{main_feck}%" ));
		BREAK;

		CASE "re!":
		CASE "re!!":
		CASE "restart":
		CASE "RESTART":
		CASE "RE!":
		CASE "RE!!":
	privMsg(langEngine( "%{main_restart}%" ));
		BREAK;

		CASE "porn":
		CASE "Porn":
		CASE "PORN":
	privMsg(langEngine( "%{main_porn}%" ));
		BREAK;

		CASE "joke":
		CASE "Joke":
		CASE "JOKE":
	privMsg(langEngine( "%{main_joke}%" ));
		BREAK;

		CASE "sex":
		CASE "Sex":
		CASE "SEX":
	privMsg(langEngine( "%{main_sex}%" ));
		BREAK;

		CASE "penis":
		CASE "Penis":
		CASE "PENIS":
	privMsg(langEngine( "%{main_penis}%" ));
		BREAK;

		CASE "imho":
		CASE "IMHO":
	privMsg(langEngine( "%{main_imho}%" ));
		BREAK;

		CASE "halla":
		CASE "hello":
		CASE "hola":
		CASE "konnichi":
		CASE "salaam":
		CASE "moikka":
		CASE "salud":
		CASE "hi":
		CASE "hay":
		CASE "salut":
		CASE "bonjour":
		CASE "hej":
		CASE "Halla":
		CASE "Hello":
		CASE "Hola":
		CASE "Kkonnichi":
		CASE "Salaam":
		CASE "Moikka":
		CASE "Salud":
		CASE "Hi":
		CASE "Salut":
		CASE "Bonjour":
		CASE "Hej":
		CASE "HALLA":
		CASE "HELLO":
		CASE "HOLA":
		CASE "KONNICHI":
		CASE "SALAAM":
		CASE "MOIKA":
		CASE "SALUD":
		CASE "HI":
		CASE "SALUT":
		CASE "BONJOUR":
		CASE "HEJ":
		CASE "HEJSAN":
		CASE "hejsan":
		CASE "Hejsan":
		CASE "MOIN":
		CASE "Moin":
		CASE "moin":
		CASE "buenas":
		CASE "Buenas":
		CASE "BUENAS":
	privMsg(langEngine( "%{main_hello}%", GetCurrentPlayerVar("NickName") ) );
		BREAK;

		CASE "women":
		CASE "Women":
		CASE "WOMEN":
		CASE "girl":
		CASE "Girl":
		CASE "girls":
		CASE "Girls":
	privMsg(langEngine( "%{main_women}%" ));
		BREAK;

		CASE "imo":
		CASE "IMO":
	privMsg(langEngine( "%{main_imo}%" ));
		BREAK;

		CASE ":)":
		CASE ";)":
		CASE ":-)":
		CASE ";-)":
		CASE ";0":
		CASE ":0":
		CASE ";O":
		CASE ":O":
		CASE ";-0":
		CASE ":-0":
		CASE ";-O":
		CASE ":-O":
	privMsg(langEngine( "%{main_smiley}%" ));
		BREAK;

		CASE ":(":
		CASE ";(":
		CASE ":-(":
		CASE ";-(":
	privMsg(langEngine( "%{main_sadsmiley}%" ));
		BREAK;

		CASE "help":
		CASE "Help":
		CASE "HELP":
	privMsg(langEngine( "%{main_help2}%" ));
		BREAK;

		CASE "wtf":
		CASE "wtf!":
		CASE "WTF":
		CASE "WTF!":
	privMsg(langEngine( "%{main_wtf}%" ));
		BREAK;

		CASE "omfg":
		CASE "omg":
		CASE "OMFG":
		CASE "OMG":
	privMsg(langEngine( "%{main_omg}%" ));
		BREAK;

		CASE "alien":
		CASE "Alien":
		CASE "ALIEN":
	privMsg(langEngine( "%{main_alien}%" ));
		BREAK;

		CASE "sinanju":
		CASE "Sinanju":
		CASE "SINANJU":
	privMsg(langEngine( "%{main_sinanju}%" ));
		BREAK;

		CASE "ja":
		CASE "JA":
	privMsg(langEngine( "%{main_ja}%" ));
		BREAK;

		CASE "please":
		CASE "Please":
		CASE "PLEASE":
	privMsg(langEngine( "%{main_please}%" ));
		BREAK;

		CASE "brake":
		CASE "Brake":
		CASE "BRAKE":
	privMsg(langEngine( "%{main_brake1}%" ));
		BREAK;

		CASE "noob":
		CASE "Noob":
		CASE "NOOB":
		CASE "NOOBS":
		CASE "noobs":
		CASE "Noobs":
	privMsg(langEngine( "%{main_noob}%" ));
		BREAK;

	ENDSWITCH
EndEvent

Sub onfinishopenstart($KeyFlags,$id)
	closePrivButton("counter_text1");
     openGlobalButton( "lone_counter",80,55,40,40,5,20,0,"^3> %cpt% <", endcounter );
EndSub

Sub endcounter($KeyFlags,$id)
	closePrivButton("counter_text1&lone_counter");
     openGlobalButton( "circle_GO",80,55,40,40,5,6,0,"^2! GO !");
EndSub

Sub Click_UF1( $KeyFlags,$id )
	top ( UF1 );
EndSub

Sub Click_XFG( $KeyFlags,$id )
	top ( XFG );
EndSub

Sub Click_XRG( $KeyFlags,$id )
	top ( XRG );
EndSub

Sub Click_XRT( $KeyFlags,$id )
	top ( XRT );
EndSub

Sub Click_RB4( $KeyFlags,$id )
	top ( RB4 );
EndSub

Sub Click_FXO( $KeyFlags,$id )
	top ( FXO );
EndSub

Sub Click_RAC( $KeyFlags,$id )
	top ( RAC );
EndSub

Sub Click_FZ5( $KeyFlags,$id )
	top ( FZ5 );
EndSub

Sub Click_LX4( $KeyFlags,$id )
	top ( LX4 );
EndSub

Sub Click_LX6( $KeyFlags,$id )
	top ( LX6 );
EndSub

Sub Click_MRT( $KeyFlags,$id )
	top ( MRT );
EndSub

Sub Click_UFR( $KeyFlags,$id )
	top ( UFR );
EndSub

Sub Click_XFR( $KeyFlags,$id )
	top ( XFR );
EndSub

Sub Click_FBM( $KeyFlags,$id )
	top ( FBM );
EndSub

Sub Click_FOX( $KeyFlags,$id )
	top ( FOX );
EndSub

Sub Click_FXR( $KeyFlags,$id )
	top ( FXR );
EndSub

Sub Click_XRR( $KeyFlags,$id )
	top ( XRR );
EndSub

Sub Click_FZR( $KeyFlags,$id )
	top ( FZR );
EndSub

Sub Click_FO8( $KeyFlags,$id )
	top ( FO8 );
EndSub

Sub Click_BF1( $KeyFlags,$id )
	top ( BF1 );
EndSub

Sub Click_top1( $KeyFlags,$id )
	top ( 1 );
EndSub

Sub Click_top18( $KeyFlags,$id )
	top ( 18 );
EndSub

Sub Click_top35( $KeyFlags,$id )
	top ( 35 );
EndSub

Sub Click_top52( $KeyFlags,$id )
	top ( 52 );
EndSub

Sub Click_top69( $KeyFlags,$id )
	top ( 69 );
EndSub

Sub Click_top86( $KeyFlags,$id )
	top (86 );
EndSub

Sub Click_top103( $KeyFlags,$id )
	top (103 );
EndSub

Sub Click_top120( $KeyFlags,$id )
	top (120 );
EndSub

Sub Click_topGTR( $KeyFlags,$id )
	top (GTR );
EndSub

Sub Click_topFWD( $KeyFlags,$id )
	top (FWD);
EndSub

Sub Click_topRWD( $KeyFlags,$id )
	top (RWD);
EndSub

Sub Click_topTBO( $KeyFlags,$id )
	top (TBO);
EndSub


Sub DoHelp_Admin( $KeyFlags,$id )

	closePrivButton("statsbacking&statstitle&statsdetails&qualdetails&closestats");
	closePrivButton("closetop&closetop1&back_button&closedrftop&closedrftop1&drfback_button&drf_rubbish_button&drftop_button&topTBO_button");
	closePrivButton("19_36_button&37_54_button&55_72_button&73_90_button&91_108_button&199_216_button&217_234_button&271_289_button&290_307_button");
	closePrivButton("drfnear_button&109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&235_252_button&253_270_button");
	closePrivButton("back_button&UF1_button&XFG_button&XRG_button&XRT_button&RB4_button&FXO_button&RAC_button&FZ5_button&LX4_button&LX6_button");
	closePrivButton("MRT_button&UFR_button&XFR_button&FBM_button&FOX_button&FXR_button&XRR_button&FZR_button&FO8_button&BF1_button");
	closePrivButton("top1_button&top18_button&top35_button&top52_button&top69_button&top86_button&top103_button&top120_button&topGTR_button&topFWD_button&topRWD_button");
	closePrivButton("help_stats_button&help_track_button");

	IF( UserInGroup( "admin", $userName ) == 1 )
	THEN
		DoMultiPageHelp(0, "multihelp_contents_4");
	ELSE
		openPrivButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_notadmin}%" ) );
	ENDIF
EndSub

Sub DoHelp( $KeyFlags,$id )
	DoMultiPageHelp(0, "multihelp_contents_1");
	closePrivButton( "blank_back" );
	closePrivButton( "warning&warning1&info&impressive&remember&warning_message1&adjective" );
	closePrivButton( "swear_not_please&swear_not_kick&enterpits&leavepits&pitcareful&lowdrift&acceleration&spamming" );
	closePrivButton("help&help2&close&statsbacking&statstitle&statsdetails&qualdetails&closestats&topTBO_button");
	closePrivButton("closedrftop&closedrftop1&help&help2&close&drfback_button&back_button&drf_rubbish_button&drftop_button");
	closePrivButton("19_36_button&37_54_button&55_72_button&73_90_button&91_108_button&217_234_button&235_252_button&271_289_button&290_307_button");
	closePrivButton("drfnear_button&109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&199_216_button&253_270_button");
	closePrivButton("UF1_button&XFG_button&XRG_button&XRT_button&RB4_button&FXO_button&RAC_button&FZ5_button&LX4_button&LX6_button");
	closePrivButton("MRT_button&UFR_button&XFR_button&FBM_button&FOX_button&FXR_button&XRR_button&FZR_button&FO8_button&BF1_button");
	closePrivButton("top1_button&top18_button&top35_button&top52_button&top69_button&top86_button&top103_button&top120_button&topGTR_button&topFWD_button&topRWD_button");
	closePrivButton("statsbacking&statstitle&statsdetails&qualdetails&closestats");
EndSub

Sub OnClickStats( $KeyFlags,$id )
	closePrivButton("statsbacking&statstitle&statsdetails&qualdetails&closestats");
	closePrivButton("help_title&help_contents&helpbutton_admin&helpbutton_close&helpbutton_prev&helpbutton_next&help_bg");
	closePrivButton("help_stats_button&back_button&closedrftop&closedrftop1&help&help2&close");
	closePrivButton("drfback_button&drftop_button&drf_rubbish_button&drfnear_button");
	closePrivButton("19_36_button&37_54_button&55_72_button&73_90_button&91_108_button&199_216_button&217_234_button&235_252_button");
	closePrivButton("&271_289_button&290_307_button&109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&253_270_button");
	closePrivButton("help&help2&close&statsbacking&statstitle&statsdetails&qualdetails&closestats");

	openPrivButton( "statsbacking",55,47,90,10,5,-1,32,langEngine( "%{main_statsbacking}%" ));
	openPrivButton( "statstitle",55,57,90,8,5,-1,32,langEngine( "%{main_statstitle}%" ));
	openPrivButton( "statsdetails",55,65,90,6,5,-1,16,langEngine("%{main_statsdetails}%",GetCurrentPlayerVar("UserName"),GetCurrentPlayerVar("NickName"),GetCurrentPlayerVar("PosAbs"),GetCurrentPlayerVar("PBDrift"),GetCurrentPlayerVar("Car"),getLapperVar("LongTrackName"),getLapperVar("ShortTrackName"),NumToMSH (GetCurrentPlayerVar("PBLapTime")),NumToMSH (GetCurrentPlayerVar("Tpb")),GetCurrentPlayerVar("Laps"),GetCurrentPlayerVar("Dist"),GetCurrentPlayerVar("UnitDist")));
	openPrivButton( "qualdetails",55,116,90,6,5,-1,32,langEngine( "%{main_qualdetails}%",GetCurrentPlayerVar("PosQual"),GetCurrentPlayerVar("GroupQual"),getLapperVar("ShortDate"),getLapperVar("ShortTime")));
	openPrivButton( "closestats",90,154,20,10,8,-1,32,langEngine( "%{main_closestats}%" ),MA_closeStats );
EndSub

Sub OnClickToptimes( $KeyFlags,$id )
	closePrivButton("help&help2&close&statsbacking&statstitle&statsdetails&qualdetails&closestats");
	closePrivButton("closedrftop&closedrftop1&help&help2&close&drfback_button&back_button&drf_rubbish_button&drftop_button");
	closePrivButton("19_36_button&37_54_button&55_72_button&73_90_button&91_108_button&217_234_button&235_252_button&271_289_button&290_307_button");
	closePrivButton("drfnear_button&109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&199_216_button&253_270_button");
	openPrivButton( "back_button",50,20,100,15,2,-1,32," " );
	openPrivButton( "UF1_button",50,25,10,5,2,-1,16,langEngine( "%{main_UF1}%" ),Click_UF1 );
	openPrivButton( "XFG_button",60,25,10,5,2,-1,16,langEngine( "%{main_XFG}%" ),Click_XFG );
	openPrivButton( "XRG_button",70,25,10,5,2,-1,16,langEngine( "%{main_XRG}%" ),Click_XRG );
	openPrivButton( "XRT_button",80,25,10,5,2,-1,16,langEngine( "%{main_XRT}%" ),Click_XRT );
	openPrivButton( "RB4_button",90,25,10,5,2,-1,16,langEngine( "%{main_RB4}%" ),Click_RB4 );
	openPrivButton( "FXO_button",100,25,10,5,2,-1,16,langEngine( "%{main_FXO}%" ),Click_FXO );
	openPrivButton( "RAC_button",110,25,10,5,2,-1,16,langEngine( "%{main_RAC}%" ),Click_RAC );
	openPrivButton( "FZ5_button",120,25,10,5,2,-1,16,langEngine( "%{main_FZ5}%" ),Click_FZ5 );
	openPrivButton( "LX4_button",130,25,10,5,2,-1,16,langEngine( "%{main_LX4}%" ),Click_LX4 );
	openPrivButton( "LX6_button",140,25,10,5,2,-1,16,langEngine( "%{main_LX6}%" ),Click_LX6 );
	openPrivButton( "MRT_button",50,30,10,5,2,-1,16,langEngine( "%{main_MRT}%" ),Click_MRT );
	openPrivButton( "UFR_button",60,30,10,5,2,-1,16,langEngine( "%{main_UFR}%" ),Click_UFR );
	openPrivButton( "XFR_button",70,30,10,5,2,-1,16,langEngine( "%{main_XFR}%" ),Click_XFR );
	openPrivButton( "FBM_button",80,30,10,5,2,-1,16,langEngine( "%{main_FBM}%" ),Click_FBM );
	openPrivButton( "FOX_button",90,30,10,5,2,-1,16,langEngine( "%{main_FOX}%" ),Click_FOX );
	openPrivButton( "FXR_button",100,30,10,5,2,-1,16,langEngine( "%{main_FXR}%" ),Click_FXR );
	openPrivButton( "XRR_button",110,30,10,5,2,-1,16,langEngine( "%{main_XRR}%" ),Click_XRR );
	openPrivButton( "FZR_button",120,30,10,5,2,-1,16,langEngine( "%{main_FZR}%" ),Click_FZR );
	openPrivButton( "FO8_button",130,30,10,5,2,-1,16,langEngine( "%{main_FO8}%" ),Click_FO8 );
	openPrivButton( "BF1_button",140,30,10,5,2,-1,16,langEngine( "%{main_BF1}%" ),Click_BF1 );
	openPrivButton( "top1_button",50,20,10,5,2,-1,16,langEngine( "%{main_top1}%" ),Click_top1 );
	openPrivButton( "top18_button",60,20,10,5,2,-1,16,langEngine( "%{main_top18}%" ),Click_top18 );
	openPrivButton( "top35_button",70,20,10,5,2,-1,16,langEngine( "%{main_top35}%" ),Click_top35);
	openPrivButton( "top52_button",80,20,10,5,2,-1,16,langEngine( "%{main_top52}%" ),Click_top52);
	openPrivButton( "top69_button",90,20,10,5,2,-1,16,langEngine( "%{main_top69}%" ),Click_top69);
	openPrivButton( "top86_button",100,20,10,5,2,-1,16,langEngine( "%{main_top86}%" ),Click_top86);

	openPrivButton( "top103_button",110,20,10,5,2,-1,16,langEngine( "%{main_top103}%" ),Click_top103);
	openPrivButton( "top120_button",120,20,10,5,2,-1,16,langEngine( "%{main_top120}%" ),Click_top120);

	openPrivButton( "topGTR_button",130,20,10,5,2,-1,16,langEngine( "%{main_topGTR}%" ),Click_topGTR);
	openPrivButton( "topTBO_button",140,20,10,5,2,-1,16,langEngine( "%{main_topTBO}%" ),Click_topTBO);
	openPrivButton( "closetop",40,20,10,5,5,-1,32,langEngine( "%{main_closetop}%" ),MA_closetop );
	openPrivButton( "closetop1",150,20,10,5,5,-1,32,langEngine( "%{main_closetop1}%" ),MA_closetop );

EndSub

Sub MA_closeStats( $KeyFlags,$id )
	closePrivButton("statsbacking&statstitle&statsdetails&qualdetails&closestats");
	closePrivButton("closedrftop&closedrftop1&help&help2&close&drfback_button&back_button&drf_rubbish_button&drftop_button");
	closePrivButton("19_36_button&37_54_button&55_72_button&73_90_button&91_108_button&217_234_button&235_252_button&271_289_button&290_307_button");
	closePrivButton("drfnear_button&109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&199_216_button&253_270_button");
EndSub

Sub OnClickTopdrifts( $KeyFlags,$id )
	closePrivButton("statsbacking&statstitle&statsdetails&qualdetails&closestats&back_button");
	closePrivButton("help&help2&close&statsbacking&statstitle&statsdetails&qualdetails&closestats");
	closePrivButton("drf_rubbish_button&drftop_button&closedrftop&closedrftop1&help&help2&close&drfback_button");
	closePrivButton("drfnear_button&drf_rubbish_button&closedrftop&closedrftop1&help&help2&close&drfback_button");
	closePrivButton("closetop&closetop1&help&help2&close&back_button&topTBO_button");
	closePrivButton("back_button&UF1_button&XFG_button&XRG_button&XRT_button&RB4_button&FXO_button&RAC_button&FZ5_button&LX4_button&LX6_button");
	closePrivButton("UF1_button&XFG_button&XRG_button&XRT_button&RB4_button&FXO_button&RAC_button&FZ5_button&LX4_button&LX6_button");
	closePrivButton("MRT_button&UFR_button&XFR_button&FBM_button&FOX_button&FXR_button&XRR_button&FZR_button&FO8_button&BF1_button");
	closePrivButton("top1_button&top18_button&top35_button&top52_button&top69_button&top86_button&top103_button&top120_button&topGTR_button&topFWD_button&topRWD_button");
	openPrivButton( "drfback_button",50,25,100,10,2,-1,32," " );
	openPrivButton( "drftop_button",50,25,20,5,2,-1,16,langEngine( "%{main_drftop}%" ),Click_drftop );
	openPrivButton( "19_36_button",70,25,10,5,2,-1,16,langEngine( "%{main_1936}%" ),Click_1936 );
	openPrivButton( "37_54_button",80,25,10,5,2,-1,16,langEngine( "%{main_3754}%" ),Click_3754 );
	openPrivButton( "55_72_button",90,25,10,5,2,-1,16,langEngine( "%{main_5572}%" ),Click_5572 );
	openPrivButton( "73_90_button",100,25,10,5,2,-1,16,langEngine( "%{main_7390}%" ),Click_7390 );
	openPrivButton( "91_108_button",110,25,10,5,2,-1,16,langEngine( "%{main_91108}%" ),Click_91108 );
	openPrivButton( "109_126_button",120,25,10,5,2,-1,16,langEngine( "%{main_109126}%" ),Click_109126 );
	openPrivButton( "127_144_button",130,25,10,5,2,-1,16,langEngine( "%{main_127144}%" ),Click_127144 );
	openPrivButton( "145_162_button",140,25,10,5,2,-1,16,langEngine( "%{main_145162}%" ),Click_145162 );
	openPrivButton( "drfnear_button",50,30,20,5,2,-1,16,langEngine( "%{main_drfnear}%" ),Click_drfnear );
	openPrivButton( "163_180_button",70,30,10,5,2,-1,16,langEngine( "%{main_163180}%" ),Click_163180 );
	openPrivButton( "181_198_button",80,30,10,5,2,-1,16,langEngine( "%{main_181198}%" ),Click_181198 );
	openPrivButton( "199_216_button",90,30,10,5,2,-1,16,langEngine( "%{main_199216}%" ),Click_199216 );
	openPrivButton( "217_234_button",100,30,10,5,2,-1,16,langEngine( "%{main_217234}%" ),Click_217234 );
	openPrivButton( "235_252_button",110,30,10,5,2,-1,16,langEngine( "%{main_235252}%" ),Click_235252 );
	openPrivButton( "253_270_button",120,30,10,5,2,-1,16,langEngine( "%{main_253270}%" ),Click_253270 );
	openPrivButton( "271_289_button",130,30,10,5,2,-1,16,langEngine( "%{main_271289}%" ),Click_271289 );
	openPrivButton( "290_307_button",140,30,10,5,2,-1,16,langEngine( "%{main_290307}%" ),Click_290307 );
	openPrivButton( "drf_rubbish_button",150,35,10,5,5,-1,32,langEngine( "%{main_drfrubbish}%" ),Click_drfrubbish );
	openPrivButton( "closedrftop",40,25,10,5,5,-1,32,langEngine( "%{main_closetopa}%" ),MA_closedrftop );
	openPrivButton( "closedrftop1",150,25,10,5,5,-1,32,langEngine( "%{main_closetop1a}%" ),MA_closedrftop );
EndSub

#Sub OnClickTopdrifts( $KeyFlags,$id )
#	drf( $argv );
#EndSub

Sub MA_closedrftop( $KeyFlags,$id )
	closePrivButton("statsbacking&statstitle&statsdetails&qualdetails&closestats&back_button&drftop_button");
	closePrivButton("drf_rubbish_button&closedrftop&closedrftop1&help&help2&close&drfback_button&drf_rubbish_button&drfnear_button");
	closePrivButton("19_36_button&37_54_button&55_72_button&73_90_button&91_108_button&217_234_button&235_252_button&271_289_button&290_307_button");
	closePrivButton("109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&199_216_button&253_270_button");
EndSub

Sub Click_drftop( $KeyFlags,$id )
	drf( $argv );
EndSub

Sub Click_1936( $KeyFlags,$id )
	drf( 19 );
EndSub

Sub Click_3754( $KeyFlags,$id )
	drf( 37 );
EndSub

Sub Click_5572( $KeyFlags,$id )
	drf( 55 );
EndSub

Sub Click_7390( $KeyFlags,$id )
	drf( 73 );
EndSub

Sub Click_91108( $KeyFlags,$id )
	drf( 91 );
EndSub

Sub Click_109126( $KeyFlags,$id )
	drf( 109 );
EndSub

Sub Click_127144( $KeyFlags,$id )
	drf( 127 );
EndSub

Sub Click_145162( $KeyFlags,$id )
	drf( 145 );
EndSub

Sub Click_163180( $KeyFlags,$id )
	drf( 163 );
EndSub

Sub Click_181198( $KeyFlags,$id )
	drf( 181 );
EndSub

Sub Click_199216( $KeyFlags,$id )
	drf( 199 );
EndSub

Sub Click_217234( $KeyFlags,$id )
	drf( 217 );
EndSub

Sub Click_235252( $KeyFlags,$id )
	drf( 235 );
EndSub

Sub Click_253270( $KeyFlags,$id )
	drf( 253 );
EndSub

Sub Click_271289( $KeyFlags,$id )
	drf( 271 );
EndSub

Sub Click_290307( $KeyFlags,$id )
	drf( 290 );
EndSub

Sub Click_drfrubbish( $KeyFlags,$id )
	drf( 308 );
EndSub

Sub Click_drfnear( $KeyFlags,$id )
	$NickName = GetCurrentPlayerVar("NickName");
	drfNear( $NickName );
EndSub

Sub OnClickPstats($KeyFlags,$userName) 

	openPrivButton( "ps_stats_error",75,90,50,8,8,4,32, "^3Work in Progress"
. "%nl%^2To see Public Stats"
. "%nl%^2type ^1!ps");

EndSub

Sub OnClickPbests($KeyFlags,$userName) 
	CurrentPlayerlfsWorldPB( $argv );
EndSub

Sub OnClickPoints($KeyFlags,$userName) 
	topUser( "^1Lapper P^0oints ^1S^0ystem","ps_points_total","DESC",argv );
EndSub

Sub OnClickTcombo($KeyFlags,$userName)
		openPrivButton( "hud_message",74,1,51,5,4,8,0, langEngine( "%{main_friendpos}%", GetCurrentPlayerVar( "PosAbs" ) ) );
EndSub

Sub OnClickAdmin( $KeyFlags,$id )
	IF( UserInGroup( "admin",$userName ) == 1 )
		THEN
	openGlobalButton( "timer",70,70,50,10,10,10,32,"^7Race will start in approx ^1(%cpt%) ^7seconds",OnClikCloseTimer );
	ENDIF
EndSub

Sub SE_OnClikCloseTimer() # Sinanju Event
	IF( UserInGroup( "admin",$userName ) == 1 )
		THEN
			closeGlobalButton ("timer")
	ENDIF
EndSub 

Sub MA_closeHelp( $KeyFlags,$id )
	closePrivButton("help&help2&close");
EndSub

Sub MA_closetop( $KeyFlags,$id )
	closePrivButton("closetop&closetop1&help&help2&close&back_button&topTBO_button");
	closePrivButton("UF1_button&XFG_button&XRG_button&XRT_button&RB4_button&FXO_button&RAC_button&FZ5_button&LX4_button&LX6_button");
	closePrivButton("MRT_button&UFR_button&XFR_button&FBM_button&FOX_button&FXR_button&XRR_button&FZR_button&FO8_button&BF1_button");
	closePrivButton("top1_button&top18_button&top35_button&top52_button&top69_button&top86_button&top103_button&top120_button&topGTR_button&topFWD_button&topRWD_button");
EndSub

Sub OnClickMarshallQuery( $KeyFlags,$id )
	openPrivButton( "m_instruct",65,66,70,9,9,-1,32,"^6Do you wish to hide the Marshall(s)?" );
	openPrivButton( "m_instruct1",65,75,70,6,6,-1,32,"^8(Board will still be visible)" );
	openPrivButton( "hide_marshall",80,85,18,10,10,-1,32," Yes ",OnClickCloseMarshall );
	openPrivButton( "notohide_marshall",102,85,18,10,10,-1,32," No ",OnClickShowMarshall );
EndSub


Sub OnClickShowMarshall( $KeyFlags,$id )
	$Marshall_state = "yes";
		closePrivButton("m_instruct&m_instruct1&hide_marshall&notohide_marshall" );
		openPrivButton( "yes_marshall",65,66,70,9,9,6,32,"^6If not currently showing, the ^2Marshall%nl%^6will appear on next scheduled occurance" );
EndSub

Sub OnClickQuiz( $KeyFlags,$id )
	SWITCH( quiz )
		CASE "quiz":
		CASE "!quiz":
		CASE "quiz":
		CASE "Quiz":
		CASE "QUIZ":
			privMsg(langEngine( "%{main_quiz}%" ));
		BREAK;
	ENDSWITCH
EndSub
#####################################
#Action on teleport to pit (Shift+P)#
#####################################

# Actions to execute when player spectates or disconnects (leaves race).

Event OnLeaveRace( $userName )  # Player event
	$NickName = GetCurrentPlayerVar("NickName");
	closePrivButton("invoice_list_mechs&invoice_prices_mechs&invoice_list_body&invoice_prices_body" );
	closePrivButton("topback&serverlogo&track&date&easyklik&easyklikhelp&easykliktyes&easykliktoptimes&easykliktopdrifts&easyklikstats&easyklikadmin&easyklikclose");
	closePrivButton("easyklikopen&easyklikclose&easyklikclosepb&closedriftbox&easyklikclosemarshall&back_button");
	closePrivButton("blank_back&warning&warning1&info&impressive&remember&warning_message1&adjective&closetop&closetop1" );
	closePrivButton("swear_not_please&swear_not_kick&enterpits&leavepits&pitcareful&lowdrift&acceleration&spamming" );
	closePrivButton("help&help2&close&statsbacking&statstitle&statsdetails&qualdetails&closestats&topTBO_button");
	closePrivButton("closedrftop&closedrftop1&help&help2&close&drfback_button&back_button&drf_rubbish_button&drftop_button");
	closePrivButton("19_36_button&37_54_button&55_72_button&73_90_button&91_108_button&217_234_button&235_252_button&271_289_button&290_307_button");
	closePrivButton("drfnear_button&109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&199_216_button&253_270_button");
	closePrivButton("UF1_button&XFG_button&XRG_button&XRT_button&RB4_button&FXO_button&RAC_button&FZ5_button&LX4_button&LX6_button");
	closePrivButton("MRT_button&UFR_button&XFR_button&FBM_button&FOX_button&FXR_button&XRR_button&FZR_button&FO8_button&BF1_button");
	closePrivButton("top1_button&top18_button&top35_button&top52_button&top69_button&top86_button&top103_button&top120_button&topGTR_button&topFWD_button&topRWD_button");
   	closeGlobalButton( "yellow_flag_top&spin_green_flag&spin_green_flag1&spin_green_flag2&spin_green_flag3&spin_green_flag4&spin_green_flag5&spin_green_flag6&spin_green_flag7");
   	closeGlobalButton( "spin_yellow_flag1a&spin_yellow_flag2a&spin_yellow_flag3a&spin_yellow_flag4a&spin_yellow_flag5a&spin_yellow_flag6a&spin_yellow_flag7a&spin_yellow_flag8a&spin_yellow_flag9a");
  openGlobalButton( "hud_blinkleft",71,1,58,5,4,8,64 + 8,langEngine( "%{hud_blink_yellow}%" ));
	openGlobalButton( "hud_blinkright",71,1,58,5,4,8,128 + 8,langEngine( "%{hud_blink_yellow}%" ));      	
	openGlobalButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_specmessage}%", $NickName ) );
	openPrivButton( "label_lfslogo",5,181,21,4,1,-1,128,langEngine( "%{label_lfslogo}%" ));
	openPrivButton( "label_logo",4,170,24,14,1,-1,128,langEngine( "%{label_logo}%" ));
	
EndEvent

Sub OnClickSpeed($KeyFlags,$userName)

#		UnitSpeedKmh	// unit used for speed and distance: 1 = kms 0 = miles  ( Can be SET )

    openPrivButton("speed_bg",88,73,26,18,5,-1,16,""); 
    openPrivButton("speed_title",89,74,24,5,5,-1,0,"^7Change Speed Unit");     
    openPrivButton("speed_kmh",89,80,11,4,2,-1,32,"^7kph",OnClick_kmh);
    openPrivButton("speed_mph",100,80,11,4,2,-1,32,"^7mph",OnClick_mph);
    openPrivButton("speed_close",93,85,14,5,3,-1,32,"^0CLOSE",OnSpeed_close);
          
    $user_speed = GetCurrentPlayerVar("UnitSpeedKmh");             
 IF($user_speed == "1")  
    THEN
    	  closePrivButton("speed_current1");
        openPrivButton( "speed_current",80,66,40,5,5,3,0,"^2Your current unit of speed: ^1KPH");         
    ELSE
    	  closePrivButton("speed_current1");
        openPrivButton( "speed_current",80,66,40,5,5,3,0,"^2Your current unit of speed: ^1MPH");
ENDIF
   
EndSub

Sub OnClick_kmh($KeyFlags,$userName)
	SetCurrentPlayerVar("UnitSpeedKmh","1" );
	  closePrivButton("speed_kmh&speed_mph&speed_current1");
    openPrivButton( "speed_current1",80,66,40,5,5,3,0,"^2Your current unit of speed now: ^1KPH");	  
    openPrivButton( "speed_kmh",89,80,11,4,2,-1,32,"^1kph",OnClick_kmh);
    openPrivButton( "speed_mph",100,80,11,4,2,-1,32,"mph",OnClick_mph);
EndSub
  
Sub OnClick_mph($KeyFlags,$userName)
	SetCurrentPlayerVar("UnitSpeedKmh","0" );
	  closePrivButton("speed_kmh&speed_mph&speed_current1");
	  openPrivButton( "speed_current1",80,66,40,5,5,3,0,"^2Your current unit of speed now: ^1MPH");
	  openPrivButton( "speed_kmh",89,80,11,4,2,-1,32,"kph",OnClick_kmh);
    openPrivButton( "speed_mph",100,80,11,4,2,-1,32,"^1mph",OnClick_mph);
EndSub

Sub OnSpeed_close($KeyFlags,$userName)
    closePrivButton("speed_current&speed_current1&speed_bg&speed_title&speed_kmh&speed_mph&speed_close");
EndSub

###################
# TEST

Sub DoMenu_Options($KeyFlags,$userName) 

     
    $user_lang = GetCurrentPlayerVar("IdLang"); 
    privMsg("^2Your current language now set to: ".$user_lang); 

        IF($user_lang == "IT") 
        THEN 
        privMsg("Language Choice = Italian"); 
        $btncolor_it = "^6"; 
    ENDIF
        IF($user_lang == "EN") 
        THEN 
        privMsg("Language Choice = English"); 
        $btncolor_en = "^6"; 
    ENDIF         
        IF($user_lang == "FR") 
        THEN 
        privMsg("Language Choice = French"); 
        $btncolor_fr = "^6"; 
    ENDIF         
        IF($user_lang == "NL") 
        THEN 
        privMsg("Language Choice = Dutch"); 
        $btncolor_nl = "^6"; 
    ENDIF         
        IF($user_lang == "NO") 
        THEN 
        privMsg("Language Choice = Norvegian"); 
        $btncolor_no = "^6"; 
    ENDIF

EndSub 

Sub SetLang_en($KeyFlags,$userName) 
    SetCurrentPlayerVar("IdLang","EN"); 
    DoMenu_Options($KeyFlags,$userName); 
EndSub 
Sub SetLang_fr($KeyFlags,$userName) 
    SetCurrentPlayerVar("IdLang","FR"); 
    DoMenu_Options($KeyFlags,$userName); 
EndSub 
Sub SetLang_nl($KeyFlags,$userName) 
    SetCurrentPlayerVar("IdLang","NL"); 
    DoMenu_Options($KeyFlags,$userName); 
EndSub 
Sub SetLang_no($KeyFlags,$userName) 
    SetCurrentPlayerVar("IdLang","NO"); 
    DoMenu_Options($KeyFlags,$userName); 
EndSub 
Sub SetLang_it($KeyFlags,$userName) 
    SetCurrentPlayerVar("IdLang","IT"); 
    DoMenu_Options($KeyFlags,$userName); 
EndSub 
#############

###############################
#Action a player flooding chat#
###############################

$MaxFloodLines = 6; # Maximum number of consecutive lines allowed

$MaxFloodLinesTime = 4800; # Maximum time between two consecutive lines in milliseconds to count as flooding

Event OnFlood( $userName ) # Player event
	privMsg( langEngine( "%{main_flood}%", GetCurrentPlayerVar("NickName") ) );
	cmdLFS( "/kick " . GetCurrentPlayerVar("UserName" ) );
EndEvent

#########################
#Action on Qual and race#
#########################

# Reorder grid can be "LFS", "PB", "WR"

#$ReorderGrid = "LFS";
Event OnRaceStart( $NumP ) # Lapper event
	globalRcm(  langEngine( "%{main_careful}%" ) );
#  $ps_max_points=$NumP;
#  cmdLFS( "/msg ^3Max. points to score this race (^2 " . $ps_max_points . " ^3)" );
  closeGlobalButton("point900&point910&point920&point001&point002&point003&point004&point005&point006&point007&point008&point009&point010&point011&point012");
  closeGlobalButton("point101&point102&point103&point104&point105&point106&point107&point108&point109&point110&point111&point112");
  closeGlobalButton("point201&point202&point203&point204&point205&point206&point207&point208&point209&point210&point211&point212");
  closeGlobalButton("point013&point014&point015&point016&point017&point018&point019&point020&point021&point022&point023&point024");
  closeGlobalButton("point113&point114&point115&point116&point117&point118&point119&point120&point121&point122&point123&point124");
  closeGlobalButton("point213&point214&point215&point216&point217&point218&point219&point220&point221&point222&point223&point224");

	DelayedCommand( 5, ORS );
EndEvent

Sub ORS()
	IF ( $enable_pitboard == "true" )
	THEN
		OnRaceStart_Pitboard();
	ELSE
	        globalRcm(  langEngine( "%{main_brake}%" ) );
	ENDIF
EndSub

Event OnQualStart( $NumP ) # Lapper event
closeGlobalButton("point900&point910&point920&point001&point002&point003&point004&point005&point006&point007&point008&point009&point010&point011&point012");
  closeGlobalButton("point101&point102&point103&point104&point105&point106&point107&point108&point109&point110&point111&point112");
  closeGlobalButton("point201&point202&point203&point204&point205&point206&point207&point208&point209&point210&point211&point212");
  closeGlobalButton("point013&point014&point015&point016&point017&point018&point019&point020&point021&point022&point023&point024");
  closeGlobalButton("point113&point114&point115&point116&point117&point118&point119&point120&point121&point122&point123&point124");
  closeGlobalButton("point213&point214&point215&point216&point217&point218&point219&point220&point221&point222&point223&point224");
	  DelayedCommand( 5, OQS );
EndEvent

Sub OQS()
	IF ( $enable_pitboard == "true" )
	THEN
	  OnQualStart_Pitboard();
	ENDIF
EndSub

Event OnFinish( $userName ) # Player event
EndEvent

Event OnResult( $userName,$flagConfirm ) # Player event

  $Username = GetCurrentPlayerVar( "Username" ); 
  SetCurrentPlayerVar( "ps_race_points",(($ps_max_points+1) - GetCurrentPlayerVar( "FinishedPos" ) ) );
  SetCurrentPlayerVar( "ps_points_total",getUserStoredValue( "ps_points_total" ) );
 
  IF( GetCurrentPlayerVar( "ps_points_total" ) == "" )
  THEN
    SetCurrentPlayerVar( "ps_points_total","0" );
  ENDIF

  IF( ToNum(GetCurrentPlayerVar( "ps_race_points" )) < 1 )
  THEN
    SetCurrentPlayerVar( "ps_race_points",0 );
  ENDIF

SWITCH( GetCurrentPlayerVar("FinishedPos") )   # variable for race finish order

  CASE 1:
   IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
   THEN
      openGlobalButton( "point900",$point_L,$point_T-4,40,4,4,-1,96,"^7 Race on ^3" . getLapperVar("LongDate") . " @ " . getLapperVar("LongTime") );
      openGlobalButton( "point910",$point_L+40,$point_T-4,6,4,4,-1,96,"^7points" ); 
      openGlobalButton( "point001",$point_L,$point_T,40,4,4,-1,96,"^7 1 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point101",$point_L+40,$point_T,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 

  ENDIF
  BREAK; 

  CASE 2:
     IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
   THEN
      openGlobalButton( "point002",$point_L,$point_T+4,40,4,4,-1,96,"^7 2 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point102",$point_L+40,$point_T+4,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 

 ENDIF
 BREAK;

  CASE 3:
     IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
   THEN
      openGlobalButton( "point003",$point_L,$point_T+8,40,4,4,-1,96,"^7 3 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point103",$point_L+40,$point_T+8,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 

  ENDIF
  BREAK;

  CASE 4:
     IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
   THEN
      openGlobalButton( "point004",$point_L,$point_T+12,40,4,4,-1,96,"^7 4 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point104",$point_L+40,$point_T+12,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 

  ENDIF
  BREAK;

  CASE 5:
     IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
   THEN

      openGlobalButton( "point005",$point_L,$point_T+16,40,4,4,-1,96,"^7 5 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point105",$point_L+40,$point_T+16,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 

  ENDIF
  BREAK;

  CASE 6:
    IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
    THEN 
      openGlobalButton( "point006",$point_L,$point_T+20,40,4,4,-1,96,"^7 6 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point106",$point_L+40,$point_T+20,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 
    ENDIF
    BREAK;

  CASE 7:
    IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
    THEN 
      openGlobalButton( "point007",$point_L,$point_T+24,40,4,4,-1,96,"^7 7 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point107",$point_L+40,$point_T+24,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 
    ENDIF
    BREAK;

  CASE 8:
    IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
    THEN 
      openGlobalButton( "point008",$point_L,$point_T+28,40,4,4,-1,96,"^7 8 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point108",$point_L+40,$point_T+28,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 
    ENDIF
   BREAK;

  CASE 9:
    IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
    THEN 
      openGlobalButton( "point009",$point_L,$point_T+32,40,4,4,-1,96,"^7 9 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point109",$point_L+40,$point_T+32,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 
    ENDIF
    BREAK;

  CASE 10:
    IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
    THEN 
      openGlobalButton( "point010",$point_L,$point_T+36,40,4,4,-1,96,"^710 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point110",$point_L+40,$point_T+36,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 
    ENDIF
    BREAK;

  CASE 11:
    IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
    THEN 
      openGlobalButton( "point011",$point_L,$point_T+40,40,4,4,-1,96,"^711 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point111",$point_L+40,$point_T+40,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 
    ENDIF
    BREAK;

  CASE 12:
    IF(( $flagConfirm == 2 )||( $flagConfirm == 18 )||( $flagConfirm == 34 ))
    THEN 
      openGlobalButton( "point012",$point_L,$point_T+44,40,4,4,-1,96,"^712 : " . GetCurrentPlayerVar("NickName") );
      openGlobalButton( "point112",$point_L+40,$point_T+44,6,4,4,-1,32,"^3" . GetCurrentPlayerVar( "ps_race_points" ) ); 
    ENDIF
    BREAK; 

  DEFAULT: # If no value match then do this (in this case, do nothing)

  BREAK;
  
ENDSWITCH
   SetCurrentPlayerVar( "ps_points_total",ToNum(GetCurrentPlayerVar( "ps_points_total" ))+ GetCurrentPlayerVar( "ps_race_points" ) ); 
   setUserStoredValue( "ps_points_total", GetCurrentPlayerVar( "ps_points_total" ) );

EndEvent

#########################
#Action to do on session#
#########################
$MaxSessionLaps = 2;

Event OnMaxSessionLaps( $userName ) # Player event
#	privMsg( "Max session laps reached" );
EndEvent

###############################
#Options on spinning detection#
###############################

$MinAngleVelocity = 181; # Minimum angle velocity to trigger action. Possible values: 0 - 720

# Action to execute when angle velocity is higher than MinAngleVelocity.

Event OnAngleVelocity( $userName ) # Player event
	$NickName = GetCurrentPlayerVar("NickName");
	closePrivButton( "blank_back&warning&warning1&info&impressive&remember&warning_message1&adjective" );
	closePrivButton( "manhand1&manhand1a&manarm1&manarm1a&head1&head1a&white_band&marshall_hat&yellow_trim&earA&earB&earA1&earB1&eyeA&eyeB&mouth" );
	closePrivButton( "manarm&manarma&manarm7&manarm7a&manlines&man8&manlines1&clogo&manlogo&manll1&manll2&manrl1&manrl2&manlf&manrf&shorts1&shorts2" );
	closePrivButton( "blink_bg&blink_bga&blink1&blink1a&blink2&blink2a" );
	globalMsg( langEngine( "%{main_lost_control}%" ,GetCurrentPlayerVar("NickName") ) );
	privMsg( langEngine( "%{main_linespace}%" ) );
	privMsg( langEngine( "%{main_danger}%" ) );
   	openGlobalButton( "yellow_flag_top",166,91,21,10,1,8,0,langEngine( "%{main_yellowflag}%") );

    	openGlobalButton( "spin_green_flag",160,89,18,48,1,16,0,langEngine( "%{main_greenflag}%") );
    	openGlobalButton( "spin_green_flag1",161,89,18,48,1,16,0,langEngine( "%{main_greenflag}%") );
    	openGlobalButton( "spin_green_flag2",163,89,18,48,1,16,0,langEngine( "%{main_greenflag}%") );
    	openGlobalButton( "spin_green_flag3",165,89,18,48,1,16,0,langEngine( "%{main_greenflag}%") );
    	openGlobalButton( "spin_green_flag4",167,89,18,48,1,16,0,langEngine( "%{main_greenflag}%") );
    	openGlobalButton( "spin_green_flag5",169,89,18,48,1,16,0,langEngine( "%{main_greenflag}%") );
    	openGlobalButton( "spin_green_flag6",171,89,18,48,1,16,0,langEngine( "%{main_greenflag}%") );
    	openGlobalButton( "spin_green_flag7",172,89,18,48,1,16,0,langEngine( "%{main_greenflag}%") );

    	openGlobalButton( "spin_yellow_flag1a",159,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openGlobalButton( "spin_yellow_flag2a",160,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openGlobalButton( "spin_yellow_flag3a",162,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openGlobalButton( "spin_yellow_flag4a",164,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openGlobalButton( "spin_yellow_flag5a",166,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openGlobalButton( "spin_yellow_flag6a",168,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openGlobalButton( "spin_yellow_flag7a",170,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openGlobalButton( "spin_yellow_flag8a",172,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
    	openGlobalButton( "spin_yellow_flag9a",173,88,20,50,1,8,0,langEngine( "%{main_yellowflag1}%") );
	openPrivButton( "blink_gbg",91,6,18,9,1,6,32," ");
	openPrivButton( "blink_gbga1",91,6,18,9,1,6,32," ");
    	openGlobalButton( "gblink1",84,0,20,20,1,6,0,"^3 %at%^3•" );
    	openGlobalButton( "gblink1a",88,0,20,20,1,6,0,"^3 %at%^3•" );
    	openGlobalButton( "gblink2",92,0,20,20,1,6,0,"^3•%at%^3 " );
    	openGlobalButton( "gblink2a",96,0,20,20,1,6,0,"^3•%at%^3 " );
	   	openGlobalButton( "hud_blinkleft",71,1,58,5,4,8,64 + 8,langEngine( "%{hud_blink_yellow}%" ) );
	    openGlobalButton( "hud_blinkright",71,1,58,5,4,8,128 + 8,langEngine( "%{hud_blink_yellow}%" ) );
      openGlobalButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_spinningmessage}%") );
EndEvent

$MaxNbInStunt = 20; #MaxNbInStunt is max time (in 100 ms) allowed in stunt mode before OnMaxNbInStunt is executed. If -1 No OnMaxNbInStunt are activated

Event OnMaxNbInStunt( $userName ) # Player event
	cmdLFS( "/spec " . GetCurrentPlayerVar("NickName") );
EndEvent

#################################
#Actions when player is too slow#
#################################

$MaxAllowedLapTime1 = 180; # % Max allowed time to complete a lap relative to MaxLapTime in trackInfo.cfg


Event OnMaxAllowedLapTime1( $userName ) # Player event
	privMsg( langEngine( "%{main_toslow1}%" ,$MaxAllowedLapTime1 ) );
	privMsg( langEngine( "%{main_toslow2}%" , GetCurrentPlayerVar("MaxAllowedLapTime2") ) );
EndEvent


$MaxAllowedLapTime2 = 250; # % Max allowed time to complete a lap relative to MaxLapTime in trackInfo.cfg


Event OnMaxAllowedLapTime2( $userName ) # Player event
	privMsg( langEngine( "%{main_toslowvery1}%" ) );
	globalMsg( langEngine( "%{main_toslowvery2}%", GetCurrentPlayerVar("NickName")));
	cmdLFS( "/spec " . GetCurrentPlayerVar("UserName") );
EndEvent


##################################
#Options for idle player on track#
##################################

#$IdleExclude = "Sinanju"; # Usernames excluded for idle check

$OnIdleTimeout1 = 14; # Idle timeout for OnIdleAction1 in seconds

Event OnIdle1( $userName ) # Player event
#	privMsg( langEngine( "%{main_idle1}%" ) );

	$NickName = GetCurrentPlayerVar("NickName");

	closePrivButton( "blank_back&warning&warning1&info&impressive&remember&warning_message1&adjective" );
	closePrivButton( "swear_not_please&swear_not_kick&enterpits&leavepits&pitcareful&lowdrift&acceleration&spamming&driver_idle1&driver_idle2" );

IF ( GetCurrentPlayerVar( "$marshall_on_off" ) == "on" )

THEN
	SE_DrawMarshall();
ENDIF

	openPrivButton( "blank_back",152,45,46,25,3,8,32," ");
	openPrivButton( "info",153,46,44,8,6,8,32,langEngine( "%{main_info}%", $NickName ) );
	openPrivButton( "driver_idle1",153,60,44,5,4,8,16,langEngine( "%{main_idle1}%" ) );

EndEvent

$OnIdleTimeout2 = 24; # Idle timeout for OnIdleAction2 in seconds

Event OnIdle2( $userName ) # Player event

	$NickName = GetCurrentPlayerVar("NickName");

	closePrivButton( "blank_back&warning&warning1&info&impressive&remember&warning_message1&adjective" );
	closePrivButton( "swear_not_please&swear_not_kick&enterpits&leavepits&pitcareful&lowdrift&acceleration&spamming&driver_idle1&driver_idle2" );
	openPrivButton( "blank_back",152,45,46,25,3,8,32," ");
	openPrivButton( "info",153,46,44,8,6,8,32,langEngine( "%{main_info}%", $NickName ) );
	openPrivButton( "driver_idle2",153,60,44,5,4,8,16,langEngine( "%{main_idle2}%"));
#	privMsg( langEngine( "%{main_idle2}%" ) );

IF ( GetCurrentPlayerVar( "$marshall_on_off" ) == "on" )

THEN
	SE_DrawMarshall();

ENDIF
	cmdLFS("/spec "  . GetCurrentPlayerVar("NickName") );
EndEvent

################################
#Options for hotlapping options#
################################

$GripDatabase = "./GripPB";	# This is the filepath of a file containing the collected data
				# This file will be created if it doesnt exist yet
				# You must ensure read/write access to this path

$LapTimeUsedForPb = 1; # How many PB lap used to make average PB time, Min = 1 and Max = 10

# Action to do on new personal best lap.
# OnPBQual for the racer who make qualif ( in QualUser )
# OnPB the other racer


Event OnPB( $userName ) # Player event
	globalMsg( langEngine( "%{main_onnewpb}%" , GetCurrentPlayerVar("NickName"), GetCurrentPlayerVar("Car"),NumToMSH(GetCurrentPlayerVar("LapTime")) ) );
	globalMsg( langEngine( "%{main_onnewpb_rank}%" ,GetCurrentPlayerVar("PosAbs") ) );
	privMsg( langEngine( "%{main_onnewpb_sesslaps}%" , GetCurrentPlayerVar("SessLaps") ) );
	privMsg( langEngine( "%{main_onnewpb_servlaps}%" , GetCurrentPlayerVar("Laps") ) );
	privMsg( langEngine( "%{main_onnewpb_avgspeed}%" ,ToPlayerUnit( GetCurrentPlayerVar("AvgSpeed") ),GetCurrentPlayerVar("UnitSpeed") ) );
	privRcm(  langEngine( "%{main_onnewpb_rank2}%" ,GetCurrentPlayerVar("Car"),GetCurrentPlayerVar("PosAbs") ) );
EndEvent

Event OnPBQual( $userName ) # Player event
	globalMsg( langEngine( "%{main_onnewpbqual}%" ,GetCurrentPlayerVar("NickName"),NumToMSH( GetCurrentPlayerVar("LapTime")) ) );
	globalMsg( langEngine( "%{main_onnewpbqual_rank}%" , GetCurrentPlayerVar("PosAbs") ) );
	privMsg( langEngine( "%{main_onnewpbqual_pos}%" ,GetCurrentPlayerVar("Posqual") ) );
	privMsg( langEngine( "%{main_onnewpbqual_pool}%" ,GetCurrentPlayerVar("GroupQual") ) );
	privMsg( langEngine( "%{main_onnewpbqual_avgspeed}%" , ToPlayerUnit( GetCurrentPlayerVar("AvgSpeed") ), GetCurrentPlayerVar("UnitSpeed") ) );
	privRcm( langEngine( "%{main_onnewpbqual_posqual}%" ,GetCurrentPlayerVar("NickName"),GetCurrentPlayerVar("Posqual"),GetCurrentPlayerVar("GroupQual") ) );
EndEvent


############################
#Actions to do on Car Reset#
############################

$MaxCarResets = 3;        # Set to a positive number to limit number of race resets
Event OnMaxCarResets( $userName ) # Player event Spectate if player has used car reset more than the max
    globalMsg( langEngine( "%{main_maxreset}%" , GetCurrentPlayerVar( "NickName" ) ) );
    cmdLFS( "/spec " . GetCurrentPlayerVar( "UserName" ) );
EndEvent

Event OnCarReset( $userName ) # Player event Player event Do something when the car resets
    globalMsg( langEngine( "%{main_oncarreset}%", GetCurrentPlayerVar( "NickName" ),GetCurrentPlayerVar( "LapsDone" )+1 ));
    IF( getConfigVar("MaxCarResets") > 0 )
    THEN
        openPrivButton( "carres_warn",50,60,100,15,5,4,16, langEngine( "%{main_specwarn}%" ) );
        openPrivButton( "carres_msg1",50,75,100,10,5,4,16,langEngine( "%{main_resetrest}%",getConfigVar("MaxCarResets") - GetCurrentPlayerVar( "NumCarResets" )));
        privdelayedcommand( 4, ApplyCarResetPenalty);
    ELSE
        privdelayedcommand( 1, ApplyCarResetPenalty);
    ENDIF
EndEvent

Sub ApplyCarResetPenalty( $userName )
    IF( GetCurrentPlayerVar( "LapsDone" ) > 0 )
    THEN
        IF( getLapperVar( "RaceLapsLeft" ) <= 1 )
        THEN
            cmdLFS( "/p_30 " . GetCurrentPlayerVar( "UserName" ) );
        ELSE
            cmdLFS( "/p_dt " . GetCurrentPlayerVar( "UserName" ) );
        ENDIF
    ELSE
        IF( getLapperVar( "RaceLapsLeft" ) > 1 )
        THEN
            cmdLFS( "/p_dt " . GetCurrentPlayerVar( "UserName" ) );
        ENDIF
    ENDIF
EndSub

######################
#Actions for pit stop#
######################
#Local variable tou can use
#-------------------------------------------------------------------
# no pit windows if two var set to 0

$PitWindowStart=0;
$PitWindowStop=0;

Event OnNotPitWindow( $userName )  # Player event
	privMsg( langEngine( "%{main_notpitwindow}%" ,GetCurrentPlayerVar("NickName"),getConfigVar("PitWindowStart"),getConfigVar("PitWindowStop") ) );
EndEvent

Event OnBeginPitWindow( $userName ) # Player event
	privMsg( langEngine( "%{main_inpitwindows}%" ,GetCurrentPlayerVar("NickName") ) );
EndEvent

Event OnEndPitWindow( $userName )  # Player event
	privMsg( langEngine( "%{main_outpitwindows}%", GetCurrentPlayerVar("NickName"] ) ));
EndEvent

Event OnBeginPit( $userName )  # Player event
	$NickName = GetCurrentPlayerVar("NickName");
	$SDate = getLapperVar("ShortDate");
	$STime = getLapperVar("ShortTime");
	$PitWork = GetCurrentPlayerVar("PitWork");

	closePrivButton( "blank_back&warning&warning1&info&impressive&remember&warning_message1&adjective" );
	closePrivButton( "manhand1&manhand1a&manarm1&manarm1a&head1&head1a&white_band&marshall_hat&yellow_trim&earA&earB&earA1&earB1&eyeA&eyeB&mouth" );
	closePrivButton( "manarm&manarma&manarm7&manarm7a&manlines&man8&manlines1&clogo&manlogo&manll1&manll2&manrl1&manrl2&manlf&manrf&shorts1&shorts2" );

	openPrivButton( "invoice_back",160,85,38,76,1,-1,32," ");
	openPrivButton( "invoice_logo",161,86,36,6,1,-1,0,langEngine( "%{main_mylogo}%" ));
	openPrivButton( "invoice_text",161,91,36,7,7,-1,0,langEngine( "%{main_invoice}%", $NickName ) );
	openPrivButton( "invoice_line",161,96,36,4,1,-1,0,"--------------------------------------");
	openPrivButton( "invoice_times",161,104,36,5,1,-1,0,langEngine( "%{main_date_time}%", $SDate, $STime ) );

	openPrivButton( "invoice_debit",162,140,34,5,3,-1,0,langEngine( "%{main_invdebit}%" ));
	openPrivButton( "invoice_thanks",162,150,33,5,3,-1,0,langEngine( "%{main_invthanks}%" ));


	$IsNotBlank = 1;
 	$PitWorkIndex = 0;
WHILE ($IsNotBlank == 1)
	 $PitWork=split( GetCurrentPlayerVar("PitWork"),", ",$PitWorkIndex );

IF ( $PitWork == "Mechanicals Damages" )
THEN
	$PitWorkIndex = $PitWorkIndex + 1;

IF( GetCurrentPlayerVar("Car") == "UF1" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_UF1}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_UF1}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "XFG" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_XFG}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_XFG}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "XRG" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_XRG}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_XRG}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FXO" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_FXO}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_FXO}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "RB4" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_RB4}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_RB4}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "XRT" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_XRT}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_XRT}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "MRT" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_MRT}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_MRT}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "UFR" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_UFR}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_UFR}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "RAC" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_RAC}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_RAC}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FZ5" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_FZ5}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_FZ5}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "LX4" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_LX4}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_LX4}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "LX6" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_LX6}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_LX6}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FBM" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_FBM}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_FBM}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FOX" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_FOX}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_FOX}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "XFR" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_XFR}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_XFR}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "XRR" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_XRR}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_XRR}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FXR" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_FXR}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_FXR}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FZR" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_FZR}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_FZR}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FO8" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_FO8}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_FO8}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "BF1" )
THEN
	openPrivButton( "invoice_list_mechs",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_mechs_BF1}%" ));
	openPrivButton( "invoice_prices_mechs",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_mechs_BF1}%" ));
ENDIF

ELSE
	$IsNotBlank = 0;
ENDIF


IF ( $PitWork == "Body Dammage" ) THEN

	openPrivButton( "invoice_list_body",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_body}%" ));
	openPrivButton( "invoice_prices_body",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_body}%" ));

	$PitWorkIndex = $PitWorkIndex + 1;
 
ELSE
	$IsNotBlank = 0;
ENDIF

IF ( $PitWork == "Refuel" )
THEN

IF( GetCurrentPlayerVar("Car") == "UF1" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_UF1}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_UF1}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "XFG" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_XFG}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_XFG}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "XRG" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_XRG}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_XRG}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FXO" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_FXO}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_FXO}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "RB4" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_RB4}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_RB4}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "XRT" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_XRT}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_XRT}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "MRT" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_MRT}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_MRT}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "UFR" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_UFR}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_UFR}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "RAC" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_RAC}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_RAC}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FZ5" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_FZ5}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_FZ5}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "LX4" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_LX4}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_LX4}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "LX6" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_LX6}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_LX6}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FBM" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_FBM}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_FBM}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FOX" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_FOX}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_FOX}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "XFR" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_XFR}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_XFR}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "XRR" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_XRR}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_XRR}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FXR" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_FXR}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_FXR}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FZR" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_FZR}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_FZR}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "FO8" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_FO8}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_FO8}%" ));
ENDIF

IF( GetCurrentPlayerVar("Car") == "BF1" )
THEN
	openPrivButton( "invoice_list",163,110,22,5,4,-1,80,langEngine( "%{main_invlist_BF1}%" ));
	openPrivButton( "invoice_prices",185,110,9,5,4,-1,144,langEngine( "%{main_invprices_BF1}%" ));
ENDIF

	$PitWorkIndex = $PitWorkIndex + 1;
ELSE
	$IsNotBlank = 0;				

ENDIF    		
ENDWHILE	
EndEvent

Event OnEndPit( $userName )  # Player event
	$NickName = GetCurrentPlayerVar("NickName");
	closePrivButton( "blank_back&warning&warning1&info&impressive&remember&warning_message1&swear_not_please&swear_not_kick" );
	closePrivButton( "enterpits&leavepits&pitcareful&lowdrift&acceleration&invoice_list_mechs&invoice_prices_mechs&invoice_list_body&invoice_prices_body" );
	closePrivButton("invoice_back&invoice_logo&invoice_text&invoice_line&invoice_times&invoice_list&invoice_prices&invoice_debit&invoice_thanks");
	closePrivButton("topback&serverlogo&track&date&easyklik&easyklikhelp&easykliktyes&easykliktoptimes&easykliktopdrifts&easyklikstats&easyklikadmin&easyklikclose");
	closePrivButton("easyklikopen&closetop&closetop1&easyklikclosemarshall");
	openPrivButton( "blank_back",152,45,46,25,3,8,32," ");
	openPrivButton( "remember",153,46,44,8,6,6,32,langEngine( "%{main_remember}%", $NickName ) );
	openPrivButton( "pitcareful",153,60,44,5,4,5,16,langEngine( "%{main_pitcareful}%" ) );
IF ( GetCurrentPlayerVar( "$marshall_on_off" ) == "on" )

THEN
	SE_DrawPitcrew();
ENDIF
EndEvent

Event OnPit( $userName )  # Player teleported to pit ( Shift + P )
	openPrivButton( "label_lfslogo",5,181,21,4,1,-1,128,langEngine( "%{label_lfslogo}%" ));
	openPrivButton( "label_logo",4,170,24,14,1,-1,128,langEngine( "%{label_logo}%" ));
	closePrivButton("speed_current&speed_current1&speed_bg&speed_title&speed_kmh&speed_mph&speed_close");
	closePrivButton("easyklikpstats&easyklikpbests&easykliktopcombo&easyklikpoints&easyklikspeed");
 	closePrivButton("topback&serverlogo&track&date&easyklik&easyklikhelp&easykliktyes&easykliktoptimes&easykliktopdrifts&easyklikstats&easyklikadmin&easyklikclose");
	closePrivButton("easyklikopen&easyklikclose&easyklikclosepb&closedriftbox&invoice_list_mechs&invoice_prices_mechs&invoice_list_body");
	closePrivButton("invoice_prices_body&easyklikclosemarshall&invoice_back&invoice_logo&invoice_text&invoice_line&invoice_times&invoice_list&invoice_prices");
	closePrivButton("invoice_debit&invoice_thanks&blank_back&warning&warning1&info&impressive&remember&warning_message1" );
	closePrivButton("circledrift_back&circledrift_back1&circledrift_thisdrift&circledrift_lastdriftscore&circledrift_lapscore&circledrift_maxscore&circledrift_anglerev");
	closePrivButton("circledrift_angle&swear_not_please&swear_not_kick&enterpits&leavepits&pitcareful&lowdrift&acceleration&spamming" );
	closePrivButton("help&help2&close&statsbacking&statstitle&statsdetails&qualdetails&closestats&option_lang_bg&option_lang_title");
	closePrivButton("closedrftop&closedrftop1&help&help2&close&drfback_button&back_button&drf_rubbish_button&drftop_button&topTBO_button");
	closePrivButton("19_36_button&37_54_button&55_72_button&73_90_button&91_108_button&217_234_button&235_252_button&271_289_button&290_307_button");
	closePrivButton("drf_rubbish_button&drfnear_button&109_126_button&127_144_button&145_162_button&163_180_button&181_198_button&199_216_button&253_270_button");
	closePrivButton("UF1_button&XFG_button&XRG_button&XRT_button&RB4_button&FXO_button&RAC_button&FZ5_button&LX4_button&LX6_button&closetop&closetop1");
	closePrivButton("MRT_button&UFR_button&XFR_button&FBM_button&FOX_button&FXR_button&XRR_button&FZR_button&FO8_button&BF1_button&back_button");
	closePrivButton("top1_button&top18_button&top35_button&top52_button&top69_button&top86_button&top103_button&top120_button&topGTR_button&topFWD_button&topRWD_button");
   	closeGlobalButton( "yellow_flag_top&spin_green_flag&spin_green_flag1&spin_green_flag2&spin_green_flag3&spin_green_flag4&spin_green_flag5&spin_green_flag6&spin_green_flag7");
   	closeGlobalButton( "spin_yellow_flag1a&spin_yellow_flag2a&spin_yellow_flag3a&spin_yellow_flag4a&spin_yellow_flag5a&spin_yellow_flag6a&spin_yellow_flag7a&spin_yellow_flag8a&spin_yellow_flag9a");
EndEvent

Event OnEnterPitLane( $userName,$reason ) # Player event
	$NickName = GetCurrentPlayerVar("NickName");
# $reason
#	"ENTER"		// entered pit lane
#	"NO_PURPOSE"	// entered for no purpose
#	"DT"		// entered for drive-through
#	"SG"		// entered for stop-go
	openPrivButton( "label_lfslogo",5,181,21,4,1,-1,128,langEngine( "%{label_lfslogo}%" ));
	openPrivButton( "label_logo",4,170,24,14,1,-1,128,langEngine( "%{label_logo}%" ));
            closeGlobalButton( "server_enter");

	openPrivButton( "label_lfslogo",5,181,21,4,1,-1,128,langEngine( "%{label_lfslogo}%" ));
	openPrivButton( "label_logo",4,170,24,14,1,-1,128,langEngine( "%{label_logo}%" ));
 			    	
	openGlobalButton( "hud_blinkleft",71,1,58,5,4,8,64 + 8,langEngine( "%{hud_blink_yellow}%" ) );
	openGlobalButton( "hud_blinkright",71,1,58,5,4,8,128 + 8,langEngine( "%{hud_blink_yellow}%" ) );
            	
	IF( $reason == ENTER ) THEN
		openGlobalButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_enterpitmessage}%", $NickName ) );
        ENDIF
	 IF( $reason == DT ) THEN
		openGlobalButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_enterpitmessage_dt}%", $NickName ) );
	ENDIF
        	IF( $reason == SG ) THEN
		openGlobalButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_enterpitmessage_sg}%", $NickName ) );
	ENDIF
EndEvent

Event OnExitPitLane(  $userName ) # Player event
	$NickName = GetCurrentPlayerVar("NickName");
	closePrivButton( "label_lfslogo&label_logo");

  openGlobalButton( "hud_blinkleft",71,1,58,5,4,8,64 + 8,langEngine( "%{hud_blink_blue}%" ) );
  openGlobalButton( "hud_blinkright",71,1,58,5,4,8,128 + 8,langEngine( "%{hud_blink_blue}%" ) );
  openGlobalButton( "hud_message",74,1,51,5,4,8,0,langEngine( "%{main_exitpitmessage}%", $NickName ) );EndEvent

#$FL_Changed -> Front Left Changed  : 1 Changed 0 No
#$FR_Changed -> Front Right Changed : 1 Changed 0 No
#$RL_Changed -> Rear Left Changed : 1 Changed 0 No
#$RR_Changed -> Rear Right Changed : 1 Changed 0 No

Event OnChangeTyres( $userName, $FL_Changed, $FR_Changed, $RL_Changed, $RR_Changed ) # Player event

EndEvent

############################
#Drifting Options		#
############################

# Actions to do on new personal best drift lap.
Event OnDriftPB( $userName ) # Player event
EndEvent

# Actions to do to when total lap drift score is higher or equal to MinimumDriftScore.
Event OnDriftLap( $userName ) # Player event
EndEvent

Event OnDriftScore( $userName ) # Player event
EndEvent

Event OnGoodDrift( $userName ) # Player event
EndEvent

# Actions to do at end of lap if MinimumDriftScore is not achieved.
Event OnDriftTooLow( $userName ) # Player event
EndEvent

# Actions to do when drift score is reset to zero when to low speed.
Event OnDriftResetScore( $userName ) # Player event
EndEvent

######################
#Actions on penalties#
######################
#Possible variables to use:
#
#OnFastDriveOnPitL1 = Actions on 30 Sec Penalty or drive-through
#OnFastDriveOnPitL2 = Actions on 45 Sec Penalty or Stop&Go
#MaxFastDriveOnPit = Max Fast Drive on Pit allowed per race
#OnMaxFastDriveOnPit = Actions on Max Fast Drive on Pit allowed
#OnFalseStartL1 = 30 Sec Penalty or drive-through
#OnFalseStartL2 = 45 Sec Penalty or Stop&Go
#
#Local Variable can be used:
#
#-------------------------------------------------------------------

Event OnFastDriveOnPitL1( $userName ) # Player event
	globalMsg( langEngine( "%{main_fastdrivepitl1_1}%",GetCurrentPlayerVar("NickName") ) );
	privMsg( langEngine( "%{main_fastdrivepitl1_2}%" ) );
EndEvent

Event OnFastDriveOnPitL2( $userName ) # Player event
	globalMsg( langEngine( "%{main_fastdrivepitl2_1}%",GetCurrentPlayerVar("NickName") ) );
	privMsg( langEngine( "%{main_fastdrivepitl2_1}%", GetCurrentPlayerVar("RemainFDIP" ) ) );
	cmdLFS( "/spec " . GetCurrentPlayerVar( "UserName" ) );
EndEvent

Event OnMaxFastDriveOnPit( $userName ) # Player event
	globalMsg( langEngine( "%{main_maxfastdrivepit1}%",GetCurrentPlayerVar("NickName") ) );
	privRcm( langEngine( "%{main_maxfastdrivepit2}%"  ) );
	cmdLFS( "/kick " . GetCurrentPlayerVar("UserName") );
EndEvent
$MaxFastDriveOnPit = 3;

Event OnFalseStartL1( $userName ) # Player event
	privRcm( langEngine( "%{main_falsestart1}%"  ) );
    cmdLFS( "/spec " . GetCurrentPlayerVar("UserName") );
EndEvent

Event OnFalseStartL2( $userName ) # Player event
	privRcm( langEngine( "%{main_falsestart2}%"  ) );
    cmdLFS( "/spec " . GetCurrentPlayerVar("UserName") );
EndEvent


####################
#    Default Sub   #
####################
Sub PstInfo($userName )

	$currPly = getPlayerInfo( $userName );
	if( $currPly == "" ) THEN
	    WriteLine( "Cuckoo");
		RETURN();
	ENDIF
	openPrivButton( "Back",74,58,52,64,5,-1,32, "" );
	openPrivButton( "PSNickName",75,59,50,5,5,-1,32, "^7Public Stats: " . $currPly["NickName"] . " ^7( " . $currPly["PSCountry"] . " )" );
	openPrivButton( "PSDistance",75,65,50,5,5,-1,80, langEngine("%{main_psdistance}%", strFormat( "{0:0}", ToPlayerUnit( $currPly["PSDistance"]/1000 )),$currPly["UnitDist"]) );
	openPrivButton( "PSFuel",75,70,50,5,5,-1,80, langEngine("%{main_psfuel}%", strFormat( "{0:0}", $currPly["PSFuel"]/1000)) );
	openPrivButton( "PSLaps",75,75,50,5,5,-1,80, langEngine("%{main_pslaps}%", $currPly["PSLaps"]) );
	openPrivButton( "PSWins",75,80,50,5,5,-1,80, langEngine("%{main_pswins}%", $currPly["PSWins"]) );
	openPrivButton( "PSSecond",75,85,50,5,5,-1,80, langEngine("%{main_pssecond}%", $currPly["PSSecond"]) );
	openPrivButton( "PSThird",75,90,50,5,5,-1,80, langEngine("%{main_psthird}%", $currPly["PSThird"]) );
	openPrivButton( "PSFinished",75,95,50,5,5,-1,80, langEngine("%{main_psfinished}%", $currPly["PSFinished"]) );
	openPrivButton( "PSQuals",75,100,50,5,5,-1,80, langEngine("%{main_psquals}%", $currPly["PSQuals"]) );
	openPrivButton( "PSPole",75,105,50,5,5,-1,80, langEngine("%{main_pspole}%", $currPly["PSPole"]) );

	openPrivButton( "pstclose",75,111,50,10,5,-1,2, langEngine("%{main_close}%"),ClosePstInfo );

EndSub

Sub PstInfoShow($userName )

	$currPly = getPlayerInfo( $userName );
	if( $currPly == "" ) THEN
	    WriteLine( "Cuckoo");
		RETURN();
	ENDIF
	openGlobalButton( "Back",139,58,52,64,5,12,32, "" );
	openGlobalButton( "PSNickName",140,59,50,5,5,12,32, "^7Public Stats: " . $currPly["NickName"] . " ^7( " . $currPly["PSCountry"] . " )" );
	openGlobalButton( "PSDistance",140,65,50,5,5,12,80, langEngine("%{main_psdistance}%", strFormat( "{0:0}", ToPlayerUnit( $currPly["PSDistance"]/1000 )),$currPly["UnitDist"]) );
	openGlobalButton( "PSFuel",140,70,50,5,5,12,80, langEngine("%{main_psfuel}%", strFormat( "{0:0}", $currPly["PSFuel"]/1000)) );
	openGlobalButton( "PSLaps",140,75,50,5,5,12,80, langEngine("%{main_pslaps}%", $currPly["PSLaps"]) );
	openGlobalButton( "PSWins",140,80,50,5,5,12,80, langEngine("%{main_pswins}%", $currPly["PSWins"]) );
	openGlobalButton( "PSSecond",140,85,50,5,5,12,80, langEngine("%{main_pssecond}%", $currPly["PSSecond"]) );
	openGlobalButton( "PSThird",140,90,50,5,5,12,80, langEngine("%{main_psthird}%", $currPly["PSThird"]) );
	openGlobalButton( "PSFinished",140,95,50,5,5,12,80, langEngine("%{main_psfinished}%", $currPly["PSFinished"]) );
	openGlobalButton( "PSQuals",140,100,50,5,5,12,80, langEngine("%{main_psquals}%", $currPly["PSQuals"]) );
	openGlobalButton( "PSPole",140,105,50,5,5,12,80, langEngine("%{main_pspole}%", $currPly["PSPole"]) );

	openPrivButton( "pstclose",140,111,50,10,5,12,32, langEngine("%{main_close}%"),ClosePstInfo );

EndSub


Sub ClosePstInfo( $KeyFlags,$id )
	closePrivButton( "pstclose&Back&PSNickName&PSDistance&PSFuel&PSLaps&PSWins&PSSecond&PSThird&PSFinished&PSQuals&PSPole");
EndSub
####################
#Overriding options#
####################
include( "./includes/addonsused.lpr");


#	ENGLISH LANGUAGE SECTION
#################################

Lang "EN"

main_noname = "You must have proper nickname - 'unnamed' not allowed - kicked";
main_shorttrackname = "^7{0}";

#	INVOICE SECTION

main_mylogo = "^1LFSLapper InSim";
main_invoice = "^7R E C E I P T" . "%nl%{0}";
main_date_time = "{0} {1}";
main_invlist = "Premium Unleaded " . "%nl%Newspaper " . "%nl%Adult Magazine " . "%nl%Confectionery [Mints] " . "%nl%Screenwash [Economy] " . "%nl% " . "%nl%^7Payment";
main_invprices= "82.10" . "%nl%1.25" . "%nl%5.05" . "%nl%0.65" . "%nl%1.99" . "%nl% " . "%nl%^791.04";
main_invlist_mechs = "Wheel Bearing " . "%nl%Brake Disk [2]] " . "%nl%Brake Caliper[2] " . "%nl%Widget [XLarge] " . "%nl%Bushing [Rear] " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs = "42.10" . "%nl%212.26" . "%nl%35.00" . "%nl%90.65" . "%nl%7.99" . "%nl% " . "%nl%^7388.00";
main_invlist_body = "Bumper [Front] " . "%nl%Wing [Front] " . "%nl%Screen [Clear] " . "%nl%Mirror [Nearside] " . "%nl%Signs [Vinyl] " . "%nl% " . "%nl%^7Payment";
main_invprices_body = "82.10" . "%nl%61.25" . "%nl%85.05" . "%nl%18.65" . "%nl%31.99" . "%nl% " . "%nl%^7279.04";
main_invlist_UF1 = "Premium Unleaded" . "%nl%Newspaper" . "%nl%Mini Magazine" . "%nl%Confectionery [Nougat]" . "%nl%Oil [Own Brand]" . "%nl%^7Payment . . . . . . . ";
main_invprices_UF1= "22.40" . "%nl%1.25" . "%nl%4.05" . "%nl%0.75" . "%nl%4.99" . "%nl%^733.44";
main_invlist_XFG = "Premium Unleaded" . "%nl%Newspaper" . "%nl%Adult Magazine" . "%nl%Confectionery [Mints]" . "%nl%Screenwash" . "%nl%^7Payment . . . . . . . ";
main_invprices_XFG= "32.10" . "%nl%1.25" . "%nl%5.05" . "%nl%0.65" . "%nl%1.99" . "%nl%^741.04";
main_invlist_XRG = "Premium Unleaded" . "%nl%Newspaper" . "%nl%Child Magazine" . "%nl%Confectionery [Choc]" . "%nl%Air Freshener" . "%nl%^7Payment . . . . . . . ";
main_invprices_XRG= "36.15" . "%nl%1.25" . "%nl%3.05" . "%nl%0.85" . "%nl%1.99" . "%nl%^743.29";
main_invlist_FXO= "Premium Unleaded" . "%nl%Newspaper" . "%nl%TV Magazine" . "%nl%Confectionery [Gum]" . "%nl%Glass Cleaner" . "%nl%^7Payment . . . . . . . ";
main_invprices_FXO= "38.15" . "%nl%1.25" . "%nl%2.05" . "%nl%0.75" . "%nl%1.99" . "%nl%^744.19";
main_invlist_RB4= "Premium Unleaded" . "%nl%Newspaper" . "%nl%OK Magazine" . "%nl%Confectionery [Pot. Chips]" . "%nl%KY Jelly" . "%nl%^7Payment . . . . . . . ";
main_invprices_RB4= "37.35" . "%nl%1.25" . "%nl%6.05" . "%nl%0.70" . "%nl%3.99" . "%nl%^749.34";
main_invlist_XRT= "Premium Unleaded" . "%nl%Newspaper" . "%nl%Ola Magazine" . "%nl%Confectionery [Crisps]" . "%nl%Tyre Shine" . "%nl%^7Payment . . . . . . . ";
main_invprices_XRT= "38.60" . "%nl%1.25" . "%nl%6.05" . "%nl%0.70" . "%nl%3.99" . "%nl%^750.59";
main_invlist_LX4= "Premium Unleaded" . "%nl%Newspaper" . "%nl%Hello Magazine" . "%nl%Confectionery [Mints]" . "%nl%Flowers" . "%nl%^7Payment . . . . . . . ";
main_invprices_LX4= "31.42" . "%nl%1.25" . "%nl%5.05" . "%nl%0.65" . "%nl%1.99" . "%nl%^740.36";
main_invlist_LX6= "Premium Unleaded" . "%nl%Newspaper" . "%nl%Radio Magazine" . "%nl%Confectionery [Choc]" . "%nl%Condoms [Small]" . "%nl%^7Payment . . . . . . . ";
main_invprices_LX6= "33.64" . "%nl%1.25" . "%nl%4.05" . "%nl%0.85" . "%nl%7.99" . "%nl%^747.78";
main_invlist_MRT= "Premium Unleaded" . "%nl%Bread" . "%nl%Milk" . "%nl%Sandwiches" . "%nl%Cat Food [Premium]" . "%nl%^7Payment . . . . . . . ";
main_invprices_MRT= "37.85" . "%nl%1.65" . "%nl%1.95" . "%nl%2.55" . "%nl%11.99" . "%nl%^755.99";
main_invlist_UFR= "Premium Unleaded" . "%nl%Magazine" . "%nl%Confectionery [Choc]" . "%nl%Confectionery [Choc]" . "%nl%Toilet Roll" . "%nl%^7Payment . . . . . . . ";
main_invprices_UFR= "38.64" . "%nl%3.25" . "%nl%1.05" . "%nl%0.85" . "%nl%3.99" . "%nl%^747.78";
main_invlist_RAC= "Premium Unleaded" . "%nl%Confectionery [Choc]" . "%nl%Confectionery [Choc]" . "%nl%Confectionery [Choc]" . "%nl%Confectionery [Choc]" . "%nl%^7Payment . . . . . . . ";
main_invprices_RAC= "36.25" . "%nl%1.25" . "%nl%0.85" . "%nl%0.85" . "%nl%0.89" . "%nl%^740.09";
main_invlist_FZ5= "Premium Unleaded" . "%nl%Adult Magazine". "%nl%" . "%nl%" . "%nl%" . "%nl%^7Payment . . . . . . . ";
main_invprices_FZ5= "26.25" . "%nl%5.05". "%nl%" . "%nl%" . "%nl%" . "%nl%^731.30";
main_invlist_FBM= "Super Unleaded" . "%nl%Puncture Repair Kit" . "%nl%Hardback [Driving Greats]" . "%nl%" . "%nl%" . "%nl%^7Payment . . . . . . . ";
main_invprices_FBM= "46.25" . "%nl%8.05" . "%nl%15.05". "%nl%" . "%nl%" . "%nl%^769.35";
main_invlist_FOX= "Super Unleaded" . "%nl%Hardback [The Stig]" . "%nl%Hardback [J. Clarkson]" . "%nl%" . "%nl%" . "%nl%^7Payment . . . . . . . ";
main_invprices_FOX= "52.25" . "%nl%18.05" . "%nl%0.05". "%nl%" . "%nl%" . "%nl%^770.35";
main_invlist_XFR= "Unleaded [Unbranded]" . "%nl%Hardback [The Stig]" . "%nl%Hardback [The Stig and I]" . "%nl%Hardback [Mrs Stig]" . "%nl%Hardback [Mrs/Mrs Stig]" . "%nl%^7Payment . . . . . . . ";
main_invprices_XFR= "8.64" . "%nl%18.05" . "%nl%11.05" . "%nl%25.85" . "%nl%3.99" . "%nl%^767.58";
main_invlist_XRR= "Premium Fuel" . "%nl%Hardback [The Stig]" . "%nl%Hardback [Top Gear]" . "%nl%Hardback [Who is Stig?]" . "%nl%Hardback [What is Stig?]" . "%nl%^7Payment . . . . . . . ";
main_invprices_XRR= "98.64" . "%nl%18.05" . "%nl%1.05" . "%nl%18.05" . "%nl%18.05" . "%nl%^7153.84";
main_invlist_FXR= "Premium Unleaded" . "%nl%Wiper Blade" . "%nl%Bulb (Xenon)" . "%nl%Bulb [Torch]" . "%nl%Oil [Premium]" . "%nl%^7Payment . . . . . . . ";
main_invprices_FXR= "72.01" . "%nl%3.99" . "%nl%21.99" . "%nl%1.99" . "%nl%31.99" . "%nl%^7131.97";
main_invlist_FZR= "Premium Unleaded" . "%nl%Lottery [Scratchcard]" . "%nl%Oil [Premium]" . "%nl%Oil [Premium]" . "%nl%Oil [Premium]" . "%nl%^7Payment . . . . . . . ";
main_invprices_FZR= "82.01" . "%nl%1.00" . "%nl%31.99" . "%nl%31.99" . "%nl%31.99" . "%nl%^7178.98";
main_invlist_FO8= "Premium Fuel" . "%nl%Lottery [Scratchcard]" . "%nl%Lottery [Scratchcard]" . "%nl%Clutch Fluid [1l]" . "%nl%Oil [Premium]" . "%nl%^7Payment . . . . . . . ";
main_invprices_FO8= "122.01" . "%nl%1.00" . "%nl%1.00" . "%nl%33.99" . "%nl%31.99" . "%nl%^7189.99";
main_invlist_BF1= "Premium Fuel" . "%nl%Lottery [EuroMillions]" . "%nl%Lottery [EuroMillions]" . "%nl%Lottery [EuroMillions]" . "%nl%Lottery [Scratchcard]" . "%nl%^7Payment . . . . . . . ";
main_invprices_BF1= "800.01" . "%nl%1.00" . "%nl%1.00" . "%nl%1.00" . "%nl%1.00" . "%nl%^7804.01";
main_invdebit = "Your account has been debited with the above amount." . "%nl%Please retain a copy of this receipt for your records.";
main_invthanks = "Any discrepencies should be reported to:" . "%nl% sinanju@hotmail.co.uk ";
main_invcustom = "Thank you for your custom.  Please call again.";
main_invlist_mechs_UF1 = "Wheel Bearing " . "%nl%Brake Drum [2] " . "%nl%Brake Pad [2] " . "%nl%Widget [Small] " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_UF1 = "22.10" . "%nl%82.26" . "%nl%32.00" . "%nl%9.65" . "%nl%88.00" . "%nl% " . "%nl%^7234.01";
main_invlist_mechs_XFG = "Wheel Bearing " . "%nl%Gasket [Set] " . "%nl%Fanbelt  " . "%nl%Exhaust [Front] " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_XFG = "22.10" . "%nl%22.26" . "%nl%9.00" . "%nl%49.65" . "%nl%88.00" . "%nl% " . "%nl%^7191.01";
main_invlist_mechs_XRG = "Track Rod " . "%nl%Gasket [Set]" . "%nl%Fanbelt " . "%nl%AntiRoll Bar [Front] " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_XRG = "22.10" . "%nl%22.26" . "%nl%9.00" . "%nl%49.65" . "%nl%88.00" . "%nl% " . "%nl%^7191.01";
main_invlist_mechs_FXO = "Gearbox " . "%nl%Gasket [Set]" . "%nl%Widget [Small] " . "%nl%AntiRoll Bar [Front] " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_FXO = "422.10" . "%nl%22.26" . "%nl%9.00" . "%nl%49.65" . "%nl%88.00" . "%nl% " . "%nl%^7591.01";
main_invlist_mechs_RB4 = "Cylinder Head " . "%nl%Gasket [Set]" . "%nl%Widget [Medium] " . "%nl%AntiRoll Bar [Front] " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_RB4 = "222.10" . "%nl%22.26" . "%nl%14.00" . "%nl%49.65" . "%nl%88.00" . "%nl% " . "%nl%^7396.01";
main_invlist_mechs_XRT = "Cylinder Head " . "%nl%Fanbelt] " . "%nl%Seat Mount " . "%nl%AntiRoll Bar [Front] " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_XRT = "222.10" . "%nl%12.26" . "%nl%14.00" . "%nl%19.65" . "%nl%88.00" . "%nl% " . "%nl%^7356.01";
main_invlist_mechs_MRT = "Tyre [Budget] " . "%nl%Tyre [Budget] " . "%nl%Bearing [Wheel] " . "%nl%Widget [Small]  " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_MRT = "22.10" . "%nl%22.10" . "%nl%14.00" . "%nl%19.65" . "%nl%49.65" . "%nl% " . "%nl%^7127.50";
main_invlist_mechs_UFR= "Tyre [Budget] " . "%nl%Tyre [Budget] " . "%nl%Bearing [Wheel] " . "%nl%Widget [Small]  " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_UFR = "32.10" . "%nl%32.10" . "%nl%14.00" . "%nl%19.65" . "%nl%49.65" . "%nl% " . "%nl%^7147.50";
main_invlist_mechs_RAC= "Tyre [Own Brand] " . "%nl%Tyre [Own Brand] " . "%nl%Bearing [Wheel] " . "%nl%Bearing [Wheel]  " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_RAC = "38.10" . "%nl%38.10" . "%nl%18.00" . "%nl%18.00" . "%nl%69.65" . "%nl% " . "%nl%^7182.15";
main_invlist_mechs_FZ5= "Tyre [Budget] " . "%nl%Damper [Spring] " . "%nl%Exhaust [Front] " . "%nl%Bearing [Wheel]  " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_FZ5 = "35.10" . "%nl%18.10" . "%nl%18.00" . "%nl%68.00" . "%nl%9.65" . "%nl% " . "%nl%^7148.85";
main_invlist_mechs_FBM= "Tyre [Premium] " . "%nl%Tyre [Premium] " . "%nl%Brake Disk " . "%nl%Brake Disk  " . "%nl%Tyre Valve [2] " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_FBM = "85.10" . "%nl%85.10" . "%nl%78.00" . "%nl%78.00" . "%nl%7.85" . "%nl% " . "%nl%^7334.05";
main_invlist_mechs_LX4= "Tyre [Remold] " . "%nl%Tyre [Remold] " . "%nl%Tyre [Remold] " . "%nl%Tyre [Remold]  " . "%nl%Tyre Valve [4] " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_LX4 = "25.10" . "%nl%25.10" . "%nl%25.10" . "%nl%25.10" . "%nl%9.65" . "%nl% " . "%nl%^7110.05";
main_invlist_mechs_LX6= "Welding [Subframe] " . "%nl%Engine Oil [5L] " . "%nl%Transmission Fluid [5L] " . "%nl% " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_LX6 = "4.10" . "%nl%18.10" . "%nl%16.00" . "%nl%" . "%nl%89.65" . "%nl% " . "%nl%^7127.85";
main_invlist_mechs_XFR= "Widget [Large] " . "%nl%Widget [Large] " . "%nl%Spring [Offside] " . "%nl%Bearing [Wheel]  " . "%nl%Labour " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_XFR = "15.10" . "%nl%15.10" . "%nl%18.00" . "%nl%12.00" . "%nl%79.65" . "%nl% " . "%nl%^7139.85";
main_invlist_mechs_FOX= "Tyre [Own Brand] " . "%nl%Tyre [Own Brand]" . "%nl%Tyre [Own Brand] " . "%nl%Brake Disk  " . "%nl%Brake Caliper " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_FOX = "45.10" . "%nl%45.10" . "%nl%45.10" . "%nl%68.00" . "%nl%14.65" . "%nl% " . "%nl%^7217.95";
main_invlist_mechs_FXR= "Tyre [Budget] " . "%nl%Tyre [Budget] " . "%nl%Tyre [Budget] " . "%nl%Tyre [Budget]  " . "%nl%Tyre Valve [4] " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_FXR = "95.10" . "%nl%95.10" . "%nl%95.10" . "%nl%95.10" . "%nl%9.65" . "%nl% " . "%nl%^7390.05";
main_invlist_mechs_XRR= "Tyre [Premium] " . "%nl%Tyre [Premium] " . "%nl% " . "%nl% " . "%nl%" . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_XRR = "335.00" . "%nl%335.00" . "%nl%" . "%nl%" . "%nl%" . "%nl% " . "%nl%^7670.00";
main_invlist_mechs_FZR= "Tyre [Premium]  " . "%nl%Tyre [Premium]  " . "%nl%Tyre [Premium]  " . "%nl%Tyre [Premium]   " . "%nl%" . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_FZR = "335.00" . "%nl%335.00" . "%nl%335.00" . "%nl%335.00" . "%nl%" . "%nl% " . "%nl%^71,340.00";
main_invlist_mechs_FO8= "Tyre [Premium] " . "%nl%Widget [Small] " . "%nl%Transmission Fluid [5L] " . "%nl%Transmission Fluid [5L] " . "%nl% " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_FO8 = "335.00" . "%nl%9.65" . "%nl%16.00" . "%nl%16.00" . "%nl%" . "%nl% " . "%nl%^7376.65";
main_invlist_mechs_BF1= "Gearbox " . "%nl%Tyre [Premium] " . "%nl%Tyre [Premium] " . "%nl%Tyre [Premium]  " . "%nl%Tyre [Premium] " . "%nl% " . "%nl%^7Payment . . . . . . . ";
main_invprices_mechs_BF1 = "3,500.00" . "%nl%488.10" . "%nl%488.10" . "%nl%488.10" . "%nl%488.10" . "%nl% " . "%nl%^75,452.40";

#	ON CONNECT MESSAGES
                                  
main_serv = "^7Server is hosted by:";
main_serv1 = "^7Server paid for + provided by:^0";
main_thanks = "^6Thanks to ^1Gai-Luron ^6for making his ^2LFSLapper ^6available for free,%nl%^3Yisc[NL]^4, ^3Tim[NL]^4and ^3Krayy ^4for their programming add-ons/advice.%nl%^3Marshalls, Drift Score Board & Winner Flags by ^1Sinanju";
main_faster = "Obligation is with faster drivers to pass safely";
main_email = "Comments to sinanju@hotmail.co.uk";
main_welc1 = "^3Welcome {0} ^3to my server";
main_welc2 = "^7Your actual friendly Time Position (all visitors + vehicles): ^2{0}";
main_welc3 = "^7Your highest Drift Score (with this vehicle): ^2{0}%nl%^2Comments to ^1sinanju@hotmail.co.uk%nl%Automatic kick for speeding in pits or swearing%nl%^4Respect other players at all times, otherwise you may be banned";
main_blurb = "^8The InSim graphical interface is powered by LFSLapper, fully customised%nl%^8by ^4[^7><^4]^2S^3inanju^8, and has the standard InSim commands, e.g. ^2!help^8, ^2!menu^8, etc%nl%^3I hope you enjoy your stay here.";
main_five = "^0500servers.com";
main_accept = "^2[ O K ]";
label_logo = "^1This InSim";
label_lfslogo = "^7powered by ^3LFSLapper";

#	CARS

main_BF1 = "^2BF1";
main_FBM = "^2FBM";
main_FO8 = "^2FO8";
main_FOX = "^2FOX";
main_FXO = "^2FXO";
main_FXR = "^2FXR";
main_FZ5 = "^2FZ5";
main_FZR = "^2FZR";
main_LX4 = "^2LX4";
main_LX6 = "^2LX6";
main_MRT = "^2MRT";
main_RAC = "^2RAC";
main_RB4 = "^2RB4";
main_UF1 = "^2UF1";
main_UFR = "^2UFR";
main_XFG = "^2XFG";
main_XFR = "^2XFR";
main_XRG = "^2XRG";
main_XRR = "^2XRR";
main_XRT = "^2XRT";

main_top1 = "^2Top 1 - 18";
main_top18 = "^2Top 18 - 35";
main_top35 = "^2Top 35 - 52";
main_top52 = "^2Top 52 - 69";
main_top69 = "^2Top 69 - 86";
main_top86 = "^2Top 86 - 103";
main_top103 = "^2Top 103 - 120";
main_top120 = "^2Top 120 - 137";
main_topGTR = "^2Top GTR's";
#main_topFWD = "^2Top FWD's";
#main_topRWD = "^2Top RWD's";
main_topTBO = "^2Top TBO's";

#	DRIFT

main_TDS = "^7That Drift Scored:";
main_TDS01 = "^8?"; 
main_TDS02 = "^8?"; 
main_TDS03 = "^8?"; 
main_TDS04 = "^8?"; 
main_TDS05 = "^8?"; 
main_TDS11 = "^0:(";
main_TDS12 = "^0:("; 
main_TDS13 = "^0:("; 
main_TDS14 = "^0:("; 
main_TDS15 = "^0:(";
main_TDS21 = "^2+"; 
main_TDS22 = "^2+"; 
main_TDS23 = "^2+"; 
main_TDS24 = "^2+"; 
main_TDS25 = "^2+"; 
main_TDS31 = "^3++";
main_TDS32 = "^3++"; 
main_TDS33 = "^3++"; 
main_TDS34 = "^3++"; 
main_TDS35 = "^3++"; 
main_TDS41 = "^4*";
main_TDS42 = "^4*"; 
main_TDS43 = "^4*"; 
main_TDS44 = "^4*"; 
main_TDS45 = "^4*";
main_TDS51 = "^5**";
main_TDS52 = "^5**"; 
main_TDS53 = "^5**"; 
main_TDS54 = "^5**"; 
main_TDS55 = "^5**";
main_TDS61 = "^6:)";
main_TDS62 = "^6*"; 
main_TDS63 = "^6:)"; 
main_TDS64 = "^6*"; 
main_TDS65 = "^6:)";
main_TDS71 = "^7!";
main_TDS72 = "^7!"; 
main_TDS73 = "^7!"; 
main_TDS74 = "^7!"; 
main_TDS75 = "^7!";
main_TDS81 = "^8!!";
main_TDS82 = "^8!!"; 
main_TDS83 = "^8!!"; 
main_TDS84 = "^8!!"; 
main_TDS85 = "^8!!";
main_TDS91 = "^1:)";
main_TDS92 = "^1:)"; 
main_TDS93 = "^1:)"; 
main_TDS94 = "^1:)"; 
main_TDS95 = "^1:)"; 
main_TDSL = "^0-";
main_TDSL1 = "^0*";
main_TDSL2 = "^2*";
main_TDSL3 = "^3*";
main_TDSL4 = "^4*";
main_TDSL5 = "^5*";
main_TDSL6 = "^6*";
main_TDSL7 = "^7*";
main_TDSL8 = "^8*";
main_TDSL9 = "^1*";

main_TDSM = "^7How's my drifting?";
main_TDSM0 = "^8How's my drifting?"; 
main_TDSM1 = "^0That was rubbish!"; # <80
main_TDSM2 = "^2That was adequate"; # >80
main_TDSM3 = "^3That was ok"; # >180
main_TDSM4 = "^4That was good"; # >280
main_TDSM5 = "^5That was great"; # > 480
main_TDSM6 = "^6That was fantastic"; # > 780
main_TDSM7 = "^7That was superb"; # > 1180
main_TDSM8 = "^8That was awesome"; # > 1680
main_TDSM9 = "^1That was insane"; # > 2280

main_drfnear = "^3Who am I nearest?";
main_drfrubbish = "^8Some of%nl%^8the rest";
main_drftop = "^3At the very Top is?";
main_ongooddrift = "{0} ^3made excellent drift: ^7{1} ^3pts";

#	DRIFT SCORE BUTTONS

main_1936 = "^319 ^7to ^336";
main_3754 = "^337 ^7to ^354";
main_5572 = "^355 ^7to ^372";
main_7390 = "^373 ^7to ^390";
main_91108 = "^391 ^7to ^3108";
main_109126 = "^3109 ^7to ^3126";
main_127144 = "^3127 ^7to ^3144";
main_145162 = "^3145 ^7to ^3162";
main_163180 = "^3163 ^7to ^3180";
main_181198 = "^3181 ^7to ^3198";
main_199216 = "^3199 ^7to ^3216";
main_217234 = "^3217 ^7to ^3234";
main_235252 = "^3235 ^7to ^3252";
main_253270 = "^3253 ^7to ^3270";
main_271289 = "^3271 ^7to ^3289";
main_290307 = "^3290 ^7to ^3307";

main_closetop = "^3CLOSE ^1->"
. "%nl%^3ALL ^1->"
. "%nl%^3ROWS ^1->";

main_closetop1 = "^1<- ^3CLOSE"
. "%nl%^1<- ^3ALL"
. "%nl%^1<- ^3ROWS";

main_closetopa = "^3CLOSE ^1->"
. "%nl%^3ROWS ^1->";

main_closetop1a = "^1<- ^3CLOSE"
. "%nl%^1<- ^3ROWS";

#	AUTOMATIC QUIPS

main_alien = "^2Aliens?  Beam me up Scotty!";
main_brake1 = "^3Back of other car isn't substitute for your own brakes";
main_brb = "^3Missing you already.  Hurry back.";
main_bye = "^3Bye, and thanks for racing.";
main_cheers = "^3Cheers, and Slainte!";
main_damn = "^2Tut Tut";
main_faster = "Obligation is with faster drivers to pass safely";
main_feck = "^1That's close to unacceptable language!";
main_funny = "^1What's so funny,  {0}^1?";
main_funny2 = "^1You're right.  That was funny!";
main_g25 = "^2Logitech G25.  ^3THE wheel of choice!";
main_god = "^3Why do I ALWAYS get called on a PB?";
main_hello = "^3Thank you for the warm greeting, {0}";
main_help2 = "^3Do you mean ^2!help";
main_imho = "^3An honest opinion.  Such a rarity.";
main_imo = "^3Shouldn't there be an ^2'honest' ^3in that?";
main_ja = "^3Ja: ^2That's a yes then?";
main_jesus = "^3Walking on water is easier than driving an UF1 fast!";
main_joke = "^3A joke?  Wait!  I know one!  ^2Knock!   Knock! ";
main_keyboard = "Sinanju uses keyboard so can't respond quickly";
main_keys = "^3Keyboarders always have a hands-on attitude!";
main_noob = "^2Look out!!  Noobs about!!";
main_omg = "^3You have your own personal God?";
main_pb = "^3P^2itiful ^3B^2est?";
main_penis = "^3Penis: ^2 Poor substitute for a powerful car! ";
main_pitcareful = "^0Let's be very%nl%^0careful out there!";
main_please = "^3Please?  Nice to see someone with manners.";
main_porn = "^3New scene being set up, so I'm playing LFS just now!";
main_restart = "^1Whoa; trying to feed coins into meter!";
main_santa = "{0}^3 - you sound like Santa!";
main_sex = "^3Unsatisfying substitute for LFS online racing!!";
main_sorry = "^3Hopefully your apology was accepted.";
main_spb = "^1S^3ometimes unobtainable ^1P^3ersonal ^1B^3est";
main_tired1 = "It's confirmed - Tiredness causes accidents";
main_tired2 = "Would Tiredness please leave the race now!";
main_wip = "^7Button not yet enabled - Work In Progress";
main_women = "^3Females: ^2One day they'll rule the world!";
main_wtf = "^3What indeed!";
main_sinanju = "^3All give thanks to Sinanju!";
main_smiley = "^3Aahh; a smiley!  Thank you.";
main_sadsmiley = "^3Aahh; a sad face.  Cheer up:).";

#	COUNTRIES

main_america = "^3America:  ^2Country that sits under Canada!";
main_australia = "^3So ^2WHY ^3do you have to tie the kangaroo down?";
main_canada = "^3Canada:  ^2Country that sits on top of USA!";
main_czech = "^3Na Zdravi!";
main_dutch = "^3Netherlands:  ^2Where they put fingers in dikes!";
main_england = "^3England: ^2Country that sits under Scotland!";
main_finland = "^3Finland: ^2Home of Driving Gods!";
main_iceland = "^3Icelanders ALWAYS welcome!";
main_italy = "^3Italy: ^2Where the Italians come from!";
main_kiwi = "^3All Kiwi's welcome at this server!";
main_scotland = "^3Scotland:  ^2Country that sits on top of England!";
main_spain = "^3Spain: ^2Where the Spanish come from!";
main_swiss = "^3Cuckoo!   Cuckoo! ";

#	ACCELERATION  MESSAGES

main_gforce =  "^7You pulled ^1{0} ^7g's";
main_accel = "^3Getting your ^6{0} ^3to reach%nl%^60 ^3to ^6{1}  ^3{2} in ^6{3} ^3seconds!";
main_accel_amazing = "^3How did you get your ^6{0} ^3to reach%nl%^60 ^3to ^6{1} ^3{2} in ^6{3} ^3seconds?";
main_accel_incredible = "^3Great getting your ^6{0} ^3to reach%nl%^60 ^3to ^6{1} ^3 {2} in ^6{3} ^3seconds!";
main_accel_average = "^3Only got your ^6{0} ^3to reach%nl%^60 ^3to ^6{1} ^3 {2} in ^6{3} ^3seconds";
main_accel_pathetic = "^3Not good only getting your ^6{0} ^3to reach%nl%^60 ^3to ^6{1} ^3 {2} in ^6{3} ^3seconds";
main_accel_pitiful =  "^3Only getting your ^6{0} ^3to reach%nl%^60 ^3to ^6{1} ^3 {2} in ^6{3} ^3seconds";
main_accel_dismal =  "^3You drive a ^6{0}^3. ^3How did you only manage to reach%nl%^60 ^3to ^6{1} ^3 {2} in ^6{3} ^3seconds?";

#	STANDARD MESSAGES

main_allowed = "{0}^3 allowed on this server";
main_ban = "{0} Banned {1}";
main_beginpit = "{0}^8 makes a pit stop";
main_car_changed = "^3Car changed, go to pit!%at%^2Car changed, go to pit!%at%^3Current car = {0}%at%^2Current car = {0}";
main_close = "Close";
main_currnode = "The Current Node is : ^1{0}";
main_currzone = "The Current Zone is : ^1{0}";
main_date = "^7{0}";
main_dist = "^7Distance done in ^2{0} ^7on ^2{1}^7 is ^2{2} ^7{3} - this session is ^2{4} {5}";
main_enterpits = "^3Entering Pitlane%nl%^1Enable Pit Lane Limiter";
main_enterpitmessage = "{0} ^7entered the pit lane";
main_enterpitmessage_dt = "{0} ^7entered pit for drive-through penalty";
main_enterpitmessage_sg = "{0} ^7entered pit for stop-go penalty";
main_exitpitmessage = "{0} ^7has exited the pit lane";
main_exitpitmessage_dt = "{0} ^7has served a drive-through penalty";
main_exitpitmessage_sg = "{0} ^7has served a stop-go penalty";
main_fastdrivepitl1_1 = "{0}^1 Warning for fast driving in pit";
main_fastdrivepitl1_2 = "^1WARNING-KICK POSSIBLE" ;
main_fastdrivepitl2_1 = "{0}^1 Spectated for fast driving in pit";
main_fastdrivepitl2_2 = "^1KICK IN {0} TRY" ;
main_flood = "{0}^3 kicked for flooding";
main_friendpos = "^7Your friendly position is {0}";
main_good1 = "Good 1st split ({0}) by {1}^8!";
main_good2 = "Good 2nd split ({0}) by {1}^8!";
main_good3 = "Good 3rd split ({0}) by {1}^8!";
main_goodlap = "Good lap ({0}) by {1}^8!";
main_gotlevel =  "^3You have got level: {0}";
main_great1 = "Great 1st split ({0}) by {1}^8!";
main_great2 = "Great 2nd split ({0}) by {1}^8!";
main_great3 = "Great 3rd split ({0}) by {1}^8!";
main_greatlap = "Great lap ({0}) by {1}^8!";
main_groupqual = "Your groupqual is {0}";
main_idle1 = "{0}^3 is idle and will be%nl%^3spectated in 9.843 seconds";
main_idle2 = "^3You have now been%nl%^3spectated for non-activity";
main_inpitwindows = "{0} ^1You are allowed to pit";
main_kick = "{0} kicked {1}";
main_lapclose = "Lapper Closed By Administrator!";
main_lapsdone = "^7Laps done in ^2{0} ^7on ^2{1}^7 is ^2{2}^7 - This session is ^2{3}";
main_leavepits = "^1Watch for traffic%nl%^1when exiting pitlane";
main_namechangemessage = "{0} ^7has changed their name to {1}";
main_namedisconnect = "{0} ^7left the server ({}^7)";
main_pitentry = "^3Please watch out for marshalls and other cars";
hud_blink_yellow = "^3• •";
hud_blink_green = "^2• •";
hud_blink_blue = "^4• •";
main_left_server = "{0} ^7left the server";
main_level = "^3You have level(s): {0}";
main_lost_control = "^1Danger! ^8{0} ^2lost control!";
main_maxfastdrivepit1 = "{0}^1 kicked for fast driving in pit";
main_maxfastdrivepit2 = "^1YOU ARE KICKED";
main_falsestart1 = "^3You have been spectated for jumping start";
main_falsestart2 = "^3You have been spectated ^1again ^3for jumping start";
main_maxreset = "{0} spectated for exceeding max car resets";
main_midnight = "Midnight! Start of another day in paradise!";
main_newyear = "Happy New Year!";
main_nomatchflag = "Flags not match required flags";
main_notadmin = "You are not an Admin!";
main_notallowed = "{0}^3 not allowed on this server";
main_notpitwindow = "{0} ^1You are not on pit Windows, allowed in {1}-{2}";
main_on_result = "Finished Pos = {0}";
main_oncarreset = "Car Reset by {0} on lap {1}";
main_onnewpb = "New PB by {0}^8 ({1}): {2}";
main_onnewpb_avgspeed = "Average speed: {0}{1}";
main_onnewpb_rank = "Friendly rank : {0}";
main_onnewpb_rank2 = "Friendly {0} rank: ^7{1}";
main_onnewpb_servlaps = "Total laps done (server) = {0}";
main_onnewpb_sesslaps = "Session laps done = {0}";
main_onnewpbqual = "League - New QT by {0}^8:{1}";
main_onnewpbqual_avgspeed = "Average speed: {0}{1}";
main_onnewpbqual_pool = "^6Actual Pool: {0}";
main_onnewpbqual_pos = "^2Qualify pos.: {0}";
main_onnewpbqual_posqual = "{0} ^2Pos:{1} - Pool:{2}";
main_onnewpbqual_rank = "Friendly rank (all visitors): ^7{0}";
main_outpitwindows = "{0}  ^1You are not allowed to pit";
main_pitwork = "Pit begin! Work:{0}";
main_psdistance = "^7Distance: ^2{0} ^7{1}";
main_psfinished = "^7Race finished: ^2{0}";
main_psfuel = "^7Fuel used: ^2{0} ^7litres ";
main_pslaps = "^7Laps done: ^2{0}";
main_pspole = "^7Poles done: ^2{0}";
main_psquals = "^7Qualifications done: ^2{0}";
main_pssecond = "^7Second: ^2{0}";
main_psthird = "^7Third: ^2{0}";
main_pswins = "^7Wins: ^2{0}";
main_requiredflag = "Required flags -> {0}" ;
main_resetrest = "^2You have^3 {0} ^2car resets left";
main_serverclock = "Server time clock reference : {0}";
main_serverentermessage = "{0} ^7(^6Guest^7) connected to server";
main_serverentermessage_admin = "{0} ^7(^6Admin^7) connected to server";
main_spectated = "Spectated";
main_specmessage = "{0} ^7has decided to join the spectators";
main_specwarn = "^1Spectate Warning";
main_spinningmessage = "^1ACCIDENT: ^7Be prepared to slow down or stop";
main_timeinpit = "Time in pitting {0}";
main_tolowhand1 = "{0}^3 spectated for to low handicap";
main_tolowhand2 = "^3need {0}kg and {1}% of intake restriction!";
main_toslow1 = "you are too slow! Max : {0}";
main_toslow2 = "kick on {0}";
main_toslowvery1 = "You are very slow, spectated!";
main_toslowvery2 = "{0} is too slow, spectated!";
main_track_changed1 = "^1Track changed, please wait!";
main_track_changed2 = "^3Current Track = {0}";
main_trackname = "^1{0} ^3[{1}]";
main_trackused = "^7Track in use : ^1{0} ^7= ^2{1}";
main_vote_end1 = "End:";
main_vote_end2 = "({0}/{1}) Need {2}";
main_vote_qualify1 = "Qualify";
main_vote_qualify2 = "({0}/{1}) Need {2}";
main_vote_restart1 = "Restart:";
main_vote_restart2 = "({0}/{1}) Need {2}";
main_yourflag =  "Yours flags -> {0}";
main_tpb = ": ^7T^8heoretical ^7P^8ersonal ^7B^8est";
main_spb = "^7!SPB = S^8plits: ^7P^8ersonal ^7B^8est";

#	MYSTATS

main_statsbacking = "^2M y S t a t s"; 
main_statstitle = "^7Brought to you courtesy of ^1Sinanju"; 

main_statsdetails = "^7Username: ^3{0}^7 - Nickname: {1}"
. "%nl%"
. "%nl%^7Your actual friendly Position (all visitors / all vehicles): ^3{2}"
. "%nl%^7Your current best Drift Score (in ^3{4}^7): ^3{3}"
. "%nl%"
. "%nl%^7Current Track: ^3{5}^0 [ {6} ]"
. "%nl%^7Your current PB Laptime with this combo: ^3{7}"
. "%nl%^7Theoretical PB: ^3{8}"
. "%nl%^7You've done: ^3{9} ^7laps, which is approx ^3{10} ^7{11}"
. "%nl%";

main_qualdetails = "%nl%"
. "^4Q u a l i f i c a t i o n   D e t a i l s:"
. "%nl%^6Current qualification position: ^3{0}"
. "%nl%^6Current GROUP qualification position: ^3{1}" 
. "%nl%"
. "%nl%^2 {2} ^8- ^2{3}"
. "%nl%";

main_closestats = "CLOSE";
main_closedriftbox = "^7Close DriftMeter";

#	EASY KLIK SYSTEM

main_easyklik = "^7Easy%nl%^1Klik";
main_easyklikadmin = "^1Admin%nl%^1Only";
main_easyklikclose = "^8[Close]";
main_easyklikclosepb = "^7Close Pitboard";
main_easyklikhelp = "^7Help";
main_easyklikopen = "^8[Open Easy Klik]";
main_easyklikstats = "^7MyStats";
main_easykliktopdrifts = "^7Top [Drifts]";
main_easykliktoptimes = "^7Top [Times]";
main_easyklikmarshall = "^7Hide Marshall";
main_easykliklang = "^7Choose your language / Choisissez votre langue"
. "%nl%^7Kies uw taal / Velg ditt spràk";

main_pstatsbutton =  "^7Public Stats";
main_pbestsbutton =  "^7Personal Bests";
main_tcombobutton =  "^7Top Combo Position";
main_pointsbutton =  "^7Race Points";
main_speedbutton =  "^7MPH or KPH";

#	MARSHALL INFORMATION BOARDS

main_warning = "^1!! W A R N I N G !!"
. "%nl%{0}";

main_warning1 = "^1!! You Were Warned !!"
. "%nl%{0}";

main_info = "^2I N F O R M A T I O N"
. "%nl%{0}";

main_remember = "^1! ^3R E M E M B E R^1 !"
. "%nl%{0}";

main_amazing = "^7A M A Z I N G"
. "%nl%{0}";

main_incredible = "^7I N C R E D I B L E"
. "%nl%{0}";

main_impressive = "^7I M P R E S S I V E"
. "%nl%{0}";

main_average = "^7A V E R A G E"
. "%nl%{0}";

main_pathetic = "^7P A T H E T I C"
. "%nl%{0}";

main_pitiful = "^7P I T I F U L"
. "%nl%{0}";

main_dismal = "^7P E D E S T R I A N"
. "%nl%{0}";

#	YELLOW/GREEN/BLUE  FLAGS/VESTS

main_yellowback = "^3||";
main_yellowflag = "^3YELLOW FLAG";
main_yellowflag1 = "^3|";
main_yellowflag2 = "^3CONDITION";
main_greenflag = "^2|";
main_greenvest = "^2|";
main_bluevest = "^4|";

#	STANDARD HELP (NOT USED)

main_help1 = "^2Commands list";	
main_help = "^2General commands"	
. "%nl%^3!myconfig ^8Configure lapper for you"
. "%nl%^3!mypb ^8Your LFSWorld PB list"
. "%nl%^3!ps ^8Your pub stat info or !ps userName"
. "%nl%^3!who ^8Players present stats"
. "%nl%^3!top ^8[table offset] [3-letter car name] ['filter' pattern]"
. "%nl%^3!drf ^8[table offset] [3-letter car name] ['filter' pattern]"
. "%nl%^3!stats ^8[playername pattern]"
. "%nl%^3!dstats ^8[playername pattern]"
. "%nl%^3!near ^8Gap with 14 pilots near you on the ranking"
. "%nl%^3!spb ^8Split times and TPB (Theoretical PB)"
. "%nl%^3!razspb ^8Start new spb session (eg when changing car)"
. "%nl%^3!track ^8Name of actual track"
. "%nl%^3!time ^8Server time (to leagues mettings)"
. "%nl%^3!ver ^8Version of LFSLapper"
. "%nl%"
. "%nl%^2Special league commands"
. "%nl%^3!topqual ^8Rank to pilots specified on *.flt file"
. "%nl%^3!statsqual ^8Actual Position on prequalify session"
. "%nl%"
. "%nl%^2New functions"
. "%nl%^3!laps ^8Total laps number + session laps number"
. "%nl%^3!hand ^8Handicap by pilot ordered by league-host admin"
. "%nl%^3!pit ^8Total pit stop time"
. "%nl%^3Shift+i ^8Configure your display messages"
. "%nl%^3!closepb ^8Close Pitboard temporary"
. "%nl%^3!config ^8Configure Pitboard"
. "%nl%^3!ctrack ^8Open track change GUI (Admin only)"
. "%nl%^3!pitwindow ^8Show currently set pitwindow(s)"
. "%nl%^3!pwgui ^8Open Pitwindow GUI (Admin only)"
. "%nl%^3!sc ^8Open safetycar GUI (Admin only)";

#	PROPER (USED) HELP

main_help1_admin = "^7LFSLapper Admin Commands";	
main_help_admin = "^2Admin Commands"	
. "%nl%^3!gui  ^8- Update race config GUI"	
. "%nl%^3!pwgui  ^8- Open Pitwindow GUI"	
. "%nl%^3!sc  ^8- Open safetycar GUI"
. "%nl%^3!ctrack  ^8- Configure track (GUI)"
. "%nl%^3!groupcmdlfs [cmd]  ^8- Execute [cmd] on all players"
. "%nl%"
. "%nl%^3/qualify  ^8- Start new qualification session"
. "%nl%^3/restart  ^8- Start new race session"
. "%nl%"
. "%nl%^3!test  ^8- Admin Testing"
. "%nl%^3!count  ^8- Admin using countdown facility (from 3)"
. "%nl%^3!host  ^8- which server/host being used"	
. "%nl%^3!node  ^8- LFS Server Node number"	
. "%nl%^3!zone  ^8- Display current node on track"	
. "%nl%"	
. "%nl%^3!kick [username]  ^8- Kick [username] from server"	
. "%nl%^3!ban [username]  ^8- Ban [username] from server"	
. "%nl%"	
. "%nl%^3!start  ^8- Restart LFSLapper"	
. "%nl%^3!term  ^8- Terminate LFSLapper";	

main_help1_page1 = "^7LFSLapper Help ^8(Page 1)";
main_help_page1 = "^2Specific Player commands"
. "%nl%^3"
. "%nl%^3!myconfig  ^8- Configure language and split time display for yourself"
. "%nl%^3!mystats  ^8- Display connected user info and stats"
. "%nl%^3!stats [name]  ^8- Display user stats"
. "%nl%^3!mypb  ^8- Show user PBs all combinations"
. "%nl%^3!ps ^8Your public stats info on LFSWorld"
. "%nl%^3!mypb [cars]  ^8- Show user PBs for set of cars"
. "%nl%^3!pos  ^8- Show friendly position"
. "%nl%^3!near  ^8- Show top 14 drivers near your ranking"
. "%nl%^3!auth  ^8- Show players authority level"
. "%nl%^3!license  ^8- Show players license details (if any)"
. "%nl%^3!pit  ^8- Show how long spent in pit"
. "%nl%^3!hand  ^8- Show players handicap (if any)"
. "%nl%^3!drift  ^8- Turn Drift Meter off or on"
. "%nl%^3!marshall  ^8- Show or hide Marshall"
. "%nl%^3"
. "%nl%^2Scoring System"
. "%nl%^3!points  ^8- Where you are in the Points table (same as !rank)"
. "%nl%^3!rank  ^8- Where you are in the Points table (same as !points)";

main_help1_page2 = "^7LFSLapper Help ^8(Page 2)";
main_help_page2 =  "^2General Player commands"
. "%nl%^3"
. "%nl%^3!help  ^8- Opens these Help pages"
. "%nl%^3!laps  ^8- Total laps done for this car/track + session"
. "%nl%^3!cleanspb  ^8- Reset this sessions PBs"	
. "%nl%^3!hand  ^8- Show all players current handicaps"	
. "%nl%^3!license [name]  ^8- Display license status"	
. "%nl%^3!ps [name]  ^8Username's public stats info on LFSWorld"	
. "%nl%^3!who  ^8List of players, along with PB times, other stats, etc"
. "%nl%^3!show  ^8Shows everyone your LFSW race stats"
. "%nl%"
. "%nl%^2Qualifying Info"
. "%nl%^3!statsqual [name]  ^8- Display user stats"
. "%nl%^3!groupqual  ^8- Show group qualifying pos"
. "%nl%"
. "%nl%^2Pit Board Setup and Info"
. "%nl%^3!pbclose  ^8- Close pitboard"
. "%nl%^3!pbconfig  ^8- Configure pitboard"
. "%nl%^3!pit  ^8- Pit stop info"
. "%nl%^3!pitwindow ^8Show currently set pitwindow(s)"
. "%nl%^3";
	
main_help1_page3 = "^7LFSLapper Help ^8(Page 3)";
main_help_page3 = "^2Track/Race Info"
. "%nl%^3"
. "%nl%^3!track  ^8- Show current track information"
. "%nl%^3!top [car]  ^8- Show top drivers with this track/car"
. "%nl%^3!spb  ^8- Split times and TPB (Theoretical PB)"
. "%nl%^3!cleanspb  ^8- Clear spb data"
. "%nl%^3!distance  ^8- Show distance done on this combo"
. "%nl%^3!topqual [car]  ^8- Show top qual times with this car"
. "%nl%^3!nearqual [name]  ^8- Show top qualifiers near your time"
. "%nl%"
. "%nl%"
. "%nl%^2Drifting Info"
. "%nl%^3!drf [name]  ^8- Drift table"
. "%nl%^3!drfnear [name]  ^8- Show top 14 drivers near your ranking"
. "%nl%^3!drfnearqual [name]  ^8- Show top 14 drivers near your ranking"
. "%nl%"
. "%nl%"
. "%nl%"
. "%nl%"
. "%nl%^3";

#	OTHER MESSAGES

main_brake = "^3Please, brake in time!";
main_careful = "^1REMEMBER: ^7Let's be careful out there!";
main_danger = "^1! Use Caution if rejoining track !";

main_linespace = " ";
main_logo = "^1LFSLapper InSim";
main_namechange = "^0Ashamed of your old name [{0}^0], {1}^0?";
main_sin = "^0Sinanju ^8[with some help from the Devil!]";
main_speedtrap = "^0SpeedTrap =^4 {0} {1}";
main_speedtrap1 = "^0SpeedTrap =^4 {0} {1} (^2+{2}^4)";
main_speedtrap2 = "^0SpeedTrap =^4 {0} {1} (^1-{2}^4)";


main_location1 = "HIGH STREET TURN"
. "%nl%^1-->";

#	SWEAR FILES

main_swearL1 = "^3Please do not use swearwords on this server"
. "%nl%^3just ^1{0}^3 more swearwords, and you will be kicked";

main_swearL2 = "You will be kicked in ^2{0} ^1 more attempt(s)";

main_swear21 = "^7Do ^1NOT ^7use swearwords on this server"
. "%nl%^1You have been kicked!";

#	BUILT COMMANDS

built_car = "Car";
built_grp = "Grp";
built_hand_curr = "  - Current {0}Kg - Intake Restr.: {1}%";
built_hand_nick = "^3{0}^9 handicap:";
built_hand_req =  "  - Required {0}^9 {1}Kg - Intake Rest.: {2}%";
built_lapsdone = " Laps Done";
built_nick = "NickName";
built_nolfspb = "LFS World PB not yet retreived";
built_nolfspbcrit = "No LFS World PB for this criteria";
built_pb = "Pb";
built_points = "Points";
built_pos = "Pos";
built_split = "Split";
built_splits = "Splits";
built_track = "Track";

EndLang




Lang "FR"
main_welc1 = "^7Bienvenue {0} ^7sur ce serveur Géré par ^1LFSLapper^7!%nl%^2Tapez ^7!help ^2 pour voir les commandes après avoir quitté le garage";
main_welc2 = "^7Votre position absolue (Tous les visiteurs) : ^7{0}%nl%^2Votre position de préqualification : {1}^6Estimation de poule : {2}%nl%Ne pas employer de mots grossiers sur ce serveur%nl%Respecter les autres joueurs%nl%sinon vous risquez d'être banni";
main_accept = "Accepter";
main_deny = "Refuser";
main_speedtrap = "Radar = {0} {1}";
main_gotlevel =  "^3Vous avez atteind le niveau: {0}";
main_swear11 = "^1Ne pas utiliser de gros mots ici";
main_swear12 = "Encore {0} gros mot(s) et vous passerez spectateur";
main_swear21 = "Trop de gros mots, spectateur";
main_nomatchflag = "Flags ne correspondent pas aux flags requis";
main_yourflag =  "Vos flags -> {0}";
main_requiredflag = "Flags requis -> {0}" ;
main_spectated = "Spectateur";
main_notadmin = "Vous n'êtes pas admin!";
main_currnode = "Le noeud courant est: {0}";
main_currzone = "La zone courante est: {0}";
main_lapclose = "Lapper fermé par un administrateur!";
main_ban = "{0} a banni {1}";
main_kick = "{0} a kické {1}";
main_friendpos = "Votre position absolue est {0}";
main_groupqual = "Votre poule est {0}";
main_level = "^3Vous avez le(s) niveau(x): {0}";
main_dist = "Distance réalisée avec {0}/{1} = {2} {3}, session = {4} {5}";
main_lapdone = "Tours réalisés avec {0}/{1} = {2}, session = {3}";

main_timeinpit = "Temps passé aux stands {0}";
main_trackused = "Circuit actuel: {0} = {1}";
main_serverclock = "Heure du serveur: {0}";
main_midnight = "Minuit, attention aux travailleurs!";
main_newyear = "Bonne année!";
main_allowed = "{0}^3 autorisé sur ce serveur";
main_notallowed = "{0}^3 non autorisé sur ce serveur";
main_tolowhand1 = "{0}^3 spectateur car handicap trop faible";
main_tolowhand2 = "^3Requis {0}kg et {1}% de limitation à  l'admission!";
main_vote_restart1 = "Redémarrer:";
main_vote_restart2 = "({0}/{1}) Requis {2}";
main_vote_qualify1 = "Qualify";
main_vote_qualify2 = "({0}/{1}) Requis {2}";
main_vote_end1 = "Finir:";
main_vote_end2 = "({0}/{1}) Requis {2}";
main_car_changed = "La voiture a changé, Allez aux pits! Voiture = {0}";
main_track_changed1 = "Changement de circuit, patientez!";
main_track_changed2 = "Circuit actuel = {0}";
main_left_server = "{0} part du serveur";
main_great1 = "Superbe 1er split ({0}) par {1}^8!";
main_good1 = "Bon 1er split ({0}) par {1}^8!";
main_great2 = "Superbe 2ème split ({0}) par {1}^8!";
main_good2 = "Bon 2ème split ({0}) par {1}^8!";
main_great3 = "Superbe 3ème split ({0}) par {1}^8!";
main_good3 = "Bon 3ème split ({0}) par {1}^8!";
main_greatlap = "Superbe tour ({0}) par {1}^8!";
main_goodlap = "Bon tour ({0}) par {1}^8!";
main_flood = "{0}^3 kické car trop de flood";
main_on_result = "Position finale = {0}";
main_lost_control = "^1Danger! ^8{0} ^2a perdu le contrà´le!";
main_toslow1 = "Vous être trop lent! Max : {0}";
main_toslow2 = "Vous serez kické dans {0}";
main_toslowvery1 = "Vous êtes vraiment trop lent, spectateur!";
main_toslowvery2 = "{0} est trop lent, spectateur!";
main_idle1 = "^3Vous êtes inactif et passerez spectateur dans 10 secondes" ;
main_idle2 = "^3Vous êtes passé spectateur car inactif!";
main_onnewpb = "Nouveau PB par {0}^8 ({1}): {2}";
main_onnewpb_rank = "Position absolue : {0}";
main_onnewpb_sesslaps = "Tours réalisés durant la session = {0}";
main_onnewpb_servlaps = "Tours réalisés sur le serveur = {0}";
main_onnewpb_avgspeed = "Vitesse moyanne: {0}{1}";
main_onnewpb_rank2 = "Voiture {0} position: ^7{1}";
main_onnewpbqual = "Ligue - Nouveau temps de qualif par {0}^8:{1}";
main_onnewpbqual_rank = "Position absolue: ^7{0}";
main_onnewpbqual_pos = "^2Position Qualifiquation.: {0}";
main_onnewpbqual_pool = "^6Poule actuelle: {0}";
main_onnewpbqual_avgspeed = "Vitesse moyenne: {0}{1}";
main_onnewpbqual_posqual = "{0} ^2Pos:{1} - Poule:{2}";
main_accel = "^8De 0 à  {1}{2} en ^3{0}^8 secondes!";
main_notpitwindow = "{0} ^1Stand fermés, ouverture entre {1}-{2}";
main_inpitwindows = "{0} ^1Vous êtes autorisé à pitter";
main_outpitwindows = "{0}  ^1Vous n'êtes pas autorisé à  pitter";
main_beginpit = "{0}^8 s'arrête au stand";
main_pitwork = "Début d'arrêt au stand! Travail en cours:{0}";
main_fastdrivepitl1_1 = "{0}^1Attention vitesse excessive aux stands";
main_fastdrivepitl1_2 = "^1ATTENTION-KICK POSSIBLE" ;
main_fastdrivepitl2_1 = "{0}^1Spectateur car trop rapide dans les stands";
main_fastdrivepitl2_2 = "^1ENCORE {0} ESSAIS AVANT LE KICK" ;
main_maxfastdrivepit1 = "{0}^1Kické car trop rapide dans les stands";
main_maxfastdrivepit2 = "^1VOUS ETES KICKE";
main_maxreset = "{0} mis en spectateur pour excès de reset de voiture";
main_oncarreset = "Reset de voiture par {0} au tour {1}";
main_specwarn = "^1Attention mise en spectateur";
main_resetrest = "^2Il vous reste^3 {0} ^2reset de voiture";
main_close = "Fermer";
main_psdistance = "^7Distance: ^2{0} ^7{1}";
main_psfuel = "^7Essence consommée: ^2{0} ^7liters ";
main_pslaps = "^7Tours réalisés: ^2{0}";
main_pswins = "^7Victoires: ^2{0}";
main_pssecond = "^7Secondes places: ^2{0}";
main_psthird = "^7Troisièmes places: ^2{0}";
main_psfinished = "^7Courses termiée: ^2{0}";
main_psquals = "^7Qualifications réalisées: ^2{0}";
main_pspole = "^7Poles réalisées: ^2{0}";

built_pos = "Position";
built_grp = "Poule";
built_car = "Voiture";
built_track = "Circuit";
built_nick = "Pseudo";
built_pb = "PB";
built_nolfspb = "Les record de LFS World ne sont pas encore récupérés";
built_nolfspbcrit = "Pas de records LFS World pour ce critère";
built_lapsdone = "Tours réalisés";
built_hand_nick = "^9 Handicap pour ^3{0}^9 :";
built_hand_curr = "  - Actuel {0}Kg - Restr. admission.: {1}%";
built_hand_req =  "  - Requis {0}^9 {1}Kg - Restr. admission.: {2}%";
main_remember = "^1! ^3R A P P E L E Z^1 !"
. "%nl%{0}";

main_incredible = "^7F A N T A S T E Q U E"
. "%nl%{0}";

main_impressive = "^7I M P R E S S I O N N A N T"
. "%nl%{0}";

main_average = "^7M O Y E N N E"
. "%nl%{0}";

main_pathetic = "^7P A T H E T I Q U E"
. "%nl%{0}";

main_warning = "^1!! A T T E N T I O N !!"
. "%nl%{0}";

main_dismal = "^7P I É T O N S"
. "%nl%{0}";

label_lfslogo = "^7alimenté par  ^3LFSLapper";
main_TDSM1 = "^0C'est ordures!"; # <80
main_pitcareful = "^0permet de faire%nl%^0 très attention là-bas!";
main_close = "Fermer";
main_closestats = "FERMER";

main_closetop = "^3FERMEZ ^1->"
. "%nl%^3TOUTES ^1->"
. "%nl%^3LES LIGNES ^1->";

main_closetop1 = "^1<- ^3FERMEZ"
. "%nl%^1<- ^3TOUTES"
. "%nl%^1<- ^3LES LIGNES";

main_closetop = "^3FERMEZ ^1->"
. "%nl%^3LES LIGNES ^1->";

main_closetop1 = "^1<- ^3FERMEZ"
. "%nl%^1<- ^3LES LIGNES";



main_top1 = "^2Haut 1 - 18";
main_top18 = "^2Haut 18 - 35";
main_top35 = "^2Haut 35 - 52";
main_top52 = "^2Haut 52 - 69";
main_top69 = "^2Haut 69 - 86";
main_top86 = "^2Haut 86 - 103";
main_top103 = "^2Haut 103 - 120";
main_top120 = "^2Haut 120 - 137";
main_topGTR = "^2Haut GTR's";
#main_topFWD = "^2Haut FWD's";
#main_topRWD = "^2Haut RWD's";
main_topTBO = "^2Haut TBO's";

main_1936 = "^319 ^7à ^336";
main_3754 = "^337 ^7à ^354";
main_5572 = "^355 ^7à ^372";
main_7390 = "^373 ^7à ^390";
main_91108 = "^391 ^7à ^3108";
main_109126 = "^3109 ^7à ^3126";
main_127144 = "^3127 ^7à ^3144";
main_145162 = "^3145 ^7à ^3162";
main_163180 = "^3163 ^7à ^3180";
main_181198 = "^3181 ^7à ^3198";
main_199216 = "^3199 ^7à ^3216";
main_217234 = "^3217 ^7à ^3234";
main_235252 = "^3235 ^7à ^3252";
main_253270 = "^3253 ^7à ^3270";
main_271289 = "^3271 ^7à ^3289";
main_290307 = "^3290 ^7à ^3307";

EndLang

#	DUTCH LANGUAGE SECTION
################################

Lang "NL" # NL Lang made by $!N-Tim (emit-nl)
main_welc1 = "^7Welkom {0} ^7op een ^1LFSLapper ^7server!%nl%^2Typ ^7!help ^2na het verlaten van de garage om commando's te zien.";
main_welc2 = "^7Je plaats in het serverklassement is: ^7{0}%nl%^2Je huidige plaats in de voorkwalificatie: {1}^6Geschatte pool: {2}%nl%Spreek Engels en let op je taalgebruik!%nl%Respecteer andere spelers%nl%Zo niet, kun je verbannen worden";
main_accept = "Accepteren";
main_deny = "Weigeren";
main_speedtrap = "Gemeten snelheid = {0} {1}";
main_gotlevel =  "^3Jouw niveau is: {0}";
main_swear11 = "^1Let op het taalgebruik!";
main_swear12 = "Nog ^3{0} ^8pogingen en dan moet je toekijken.";
main_swear21 = "Te veel verkeerd taalgebruik, kijk toe";
main_nomatchflag = "Vlaggen komen niet overeen";
main_yourflag =  "Jouw vlaggen -> {0}";
main_requiredflag = "Benodigde vlaggen -> {0}" ;
main_spectated = "Kijk Toe";
main_notadmin = "Je bent geen Administrator!";
main_currnode = "Je huidige baanpositie is: {0}";
main_currzone = "Je huidige coördinaten zijn: {0}";
main_lapclose = "LFSLapper is afgesloten door een Administrator!";
main_ban = "{0} heeft {1} ^8verbannen";
main_kick = "{0} heeft {1} ^8gekickt";
main_friendpos = "Je huidige plaats in het serverklassement is: {0}";
main_groupqual = "Je huidige plaats in de groepkwalificatie is: {0}";
main_level = "^3Je hebt de volgende niveau(s): {0}";
main_dist = "Afstand afgelegd met de {0} op {1} = {2} {3}. Deze sessie = {4} {5}";
main_lapdone = "Rondes gedaan met {0} op {1} = {2}. Deze sessie = {3}";
main_timeinpit = "Tijd in pits = {0}";
main_trackused = "Huidige baan: {1} ({0})";
main_serverclock = "Tijd op deze server: {0}";
main_midnight = "Waarschuwing voor alle mensen met een baan! Het is middernacht!";
main_newyear = "Gelukkig Nieuw Jaar!";
main_allowed = "{0}^3 is toegestaan op deze server";
main_notallowed = "{0}^3 is niet toegestaan op deze server";
main_tolowhand1 = "{0}^3 moet toekijken vanwege een te laag ingestelde handicap";
main_tolowhand2 = "^3Benodigd: {0}kg toegevoegde massa en {1}% luchtinlaat beperking!";
main_vote_restart1 = "Herstart:";
main_vote_restart2 = "({0}/{1}) Nog {2} nodig";
main_vote_qualify1 = "Qualify";
main_vote_qualify2 = "({0}/{1}) Nog {2} nodig";
main_vote_end1 = "Einde:";
main_vote_end2 = "({0}/{1}) Nog {2} nodig";
main_car_changed = "Toegestane auto's veranderd, ga in pits! Huidige auto = {0}";
main_track_changed1 = "Baan veranderd, een ogenblik geduld!";
main_track_changed2 = "Huidige baan = {0}";
main_left_server = "{0} ^7heeft de server verlaten";
main_great1 = "Geweldige 1e split ({0}) door {1}^8!";
main_good1 = "Goede 1e split ({0}) door {1}^8!";
main_great2 = "Geweldige 2e split ({0}) door {1}^8!";
main_good2 = "Goede 2e split ({0}) door {1}^8!";
main_great3 = "Geweldige 3e split ({0}) door {1}^8!";
main_good3 = "Goede 3e split ({0}) door {1}^8!";
main_greatlap = "Geweldige ronde ({0}) door {1}^8!";
main_goodlap = "Goede ronde ({0}) door {1}^8!";
main_flood = "{0}^3 is gekickt vanwege flooding";
main_on_result = "Finish positie = {0}";
main_lost_control = "^1Gevaar! ^8{0} ^2verloor controle!";
main_toslow1 = "je bent te traag! Max : {0}";
main_toslow2 = "kick na {0}";
main_toslowvery1 = "Je bent erg traag, kijk toe!";
main_toslowvery2 = "{0} ging te traag, kijkt toe!";
main_idle1 = "^3Je bent inactief. Over 10 seconden moet je toekijken" ;
main_idle2 = "^3Je moet toekijken omdat je inactief bent";
main_onnewpb = "Nieuw PB door {0}^8 ({1}): {2}";
main_onnewpb_rank = "Positie : {0}";
main_onnewpb_sesslaps = "Rondes tijdens deze sessie = {0}";
main_onnewpb_servlaps = "Totaal aantal rondes op deze server = {0}";
main_onnewpb_avgspeed = "Gemiddelde snelheid: {0}{1}";
main_onnewpb_rank2 = "Positie op de server met de {0}: ^7{1}";
main_onnewpbqual = "Competitie - Nieuwe QT door {0}^8:{1}";
main_onnewpbqual_rank = "Positie in het serverklassement: ^7{0}";
main_onnewpbqual_pos = "^2Positie in kwalificatie: {0}";
main_onnewpbqual_pool = "^6Werkelijke Pool: {0}";
main_onnewpbqual_avgspeed = "Gemiddelde snelheid: {0}{1}";
main_onnewpbqual_posqual = "{0} ^2Positie:{1} - Pool:{2}";
main_accel = "^8Accelereerde in ^3{0}^8 seconden naar {1} {2}!";
main_notpitwindow = "{0} ^1Je bent niet in je pitwindows, allowed in {1}-{2}";
main_inpitwindows = "{0} ^1Je mag nu een pitstop maken";
main_outpitwindows = "{0}  ^1Je mag nu geen pitstop maken";
main_beginpit = "{0}^8 maakt een pitstop";
main_pitwork = "Pitstop begint! Werk:{0}";
main_fastdrivepitl1_1 = "{0}^1 Waarschuwing! Te hard in de pits";
main_fastdrivepitl1_2 = "^1Let op! Gekickt worden is mogelijk!" ;
main_fastdrivepitl2_1 = "{0}^1 Je reed te hard in de pits. Kijk toe";
main_fastdrivepitl2_2 = "^1Nog ^3{0} ^1keer voordat je gekickt wordt" ;
main_maxfastdrivepit1 = "{0}^1 is gekickt voor te hard rijden in pits";
main_maxfastdrivepit2 = "^1JE BENT GEKICKT!";
main_maxreset = "{0} moet toekijken vanwege te veel wagenresets";
main_oncarreset = "Wagen gereset door {0} in ronde {1}";
main_specwarn = "^1Let op! Te veel wagenresets betekend toekijken";
main_resetrest = "^2Je hebt nog ^3{0} ^2wagenresets over";
main_close = "Sluiten";
main_psdistance = "^7Afstand: ^2{0} ^7{1}";
main_psfuel = "^7Gebruikte brandstof: ^2{0} ^7Liter ";
main_pslaps = "^7Gereden rondes: ^2{0}";
main_pswins = "^7Gewonnen: ^2{0}";
main_pssecond = "^7Tweede: ^2{0}";
main_psthird = "^7Derde: ^2{0}";
main_psfinished = "^7Aantal Races gefinisht: ^2{0}";
main_psquals = "^7Aantal Kwalificaties gedaan: ^2{0}";
main_pspole = "^7Aantal Poles: ^2{0}";
built_car = "Auto";
built_track = "Baan";
built_points = "Punten";
built_nolfspb = "LFS World PB nog niet ontvangen";
built_nolfspbcrit = "Geen LFS World PB voor deze criteria";
built_lapsdone = " Gereden rondes";
built_hand_curr = "  - Toegevoegde massa: {0}Kg - Luchtinlaat beperking: {1}%";
built_hand_req =  "  - Benodigd: {0}^9 {1}Kg toegevoegde massa - Luchtinlaat beperking: {2}%";

main_warning = "^1!! W A A R S C H U W I N G !!"
. "%nl%{0}";

main_warning1 = "^1!! Je bent gewaarschuwd !!"
. "%nl%{0}";

main_info = "^2I N F O R M A T I E"
. "%nl%{0}";

main_remember = "^1! ^3N I E T V E R G E T E N^1 !"
. "%nl%{0}";

main_incredible = "^7O N G E L O O F L I J K"
. "%nl%{0}";

main_impressive = "^7I N D R U K W E K K E N D E"
. "%nl%{0}";

main_average = "^7A V E R I J"
. "%nl%{0}";

main_pathetic = "^7Z I E L I G"
. "%nl%{0}";

main_pitiful = "^7E R B A R N E L I J K"
. "%nl%{0}";

main_dismal = "^7V O E T G A N G E R"
. "%nl%{0}";

label_lfslogo = "^7aangedreven door ^3LFSLapper";
main_TDSM1 = "^0Dat was onzin!"; # <80
main_pitcareful = "^0laat heel voorzichtig%nl%^0zijn daar!";
main_close = "Sluiten";
main_closestats = "SLUITEN";

main_closetop = "^3SLUITEN ^1->"
. "%nl%^3ALLE ^1->"
. "%nl%^3RIJEN ^1->";

main_closetop1 = "^1<- ^3SLUITEN"
. "%nl%^1<- ^3ALLE"
. "%nl%^1<- ^3RIJEN";

main_closetop = "^3SLUITEN ^1->"
. "%nl%^3RIJEN ^1->";

main_closetop1 = "^1<- ^3SLUITEN"
. "%nl%^1<- ^3RIJEN";

main_1936 = "^319 ^7tot ^336";
main_3754 = "^337 ^7tot ^354";
main_5572 = "^355 ^7tot ^372";
main_7390 = "^373 ^7tot ^390";
main_91108 = "^391 ^7tot ^3108";
main_109126 = "^3109 ^7tot ^3126";
main_127144 = "^3127 ^7tot ^3144";
main_145162 = "^3145 ^7tot ^3162";
main_163180 = "^3163 ^7tot ^3180";
main_181198 = "^3181 ^7tot ^3198";
main_199216 = "^3199 ^7tot ^3216";
main_217234 = "^3217 ^7tot ^3234";
main_235252 = "^3235 ^7tot ^3252";
main_253270 = "^3253 ^7tot ^3270";
main_271289 = "^3271 ^7tot ^3289";
main_290307 = "^3290 ^7tot ^3307";

EndLang


#	NORVEGIAN LANGUAGE SECTION
####################################

Lang "NO" #Translated by Carlos/DenonForce14
main_welc1 = "^7Velkommen {0} ^7til ^1LFSLapper ^7forsynte servere!%nl%^2Press ^7!help ^2etter du har forlatt garasjen for å se kommandoer";
main_welc2 = "^7Din vennlige posisjon (alle seere) : ^7{0}%nl%^2Din aktuelle prekvalifasjon i liga : {1}^6Anslått Sammenslutning : {2}%nl%Ikke bruk banneord på denne serveren og respekter andre, ellers kan du bli utestengt";
main_accept = "Godta";
main_deny = "Avslå";
main_speedtrap = "Fartsfelle = {0} {1}";
main_gotlevel = "^3Du har level: {0}";
main_swear11 = "^1Ikke bruke dette ordet på denne serveren.";
main_swear12 = "^1Du havner i tilskuermodus hvis du bruker et banneord igjen.";
main_swear21 = "For mange banneord, du blir satt i tilskuermodus";
main_nomatchflag = "Flagg samsvarer ikke nødvendige flagg";
main_yourflag = "Dine flagg -> {0}";
main_requiredflag = "Nødvendige flagg -> {0}";
main_spectated = "Tilskuermodus";
main_notadmin = "Du er ikke en adminstrator!";
main_currnode = "Gjeldende klynge er : {0}";
main_currzone = "Gjeldende område er : {0}";
main_lapclose = "LFSLapper ble slått av av administrator!";
main_ban = "{0} Utesteng {1}";
main_kick = "{0} frakoble {1}";
main_friendpos = "Din vennlige posisjon er {0}";
main_groupqual = "Din gruppekvalifisering er {0}";
main_level = "^3Du har level(s): {0}";
main_dist = "Distanse gjort på {0}/{1} = {2} {3}, session = {4} {5}";
main_lapdone = "Runder gjort på {0}/{1} = {2}, session = {3}";
main_timeinpit = "Tid i pit {0}";
main_trackused = "Bane i bruk : {0} = {1}";
main_serverclock = "Server tid : {0}";
main_midnight = "Nattvarsel til alle arbeidende menn!";
main_newyear = "Godt nyttår!";
main_allowed = "{0}^3 tillatt på denne serveren";
main_notallowed = "{0}^3 ikke tillatt på denne serveren";
main_tolowhand1 = "{0}^3 satt i tilskuermodus pga for lite handicap";
main_tolowhand2 = "^3trenger {0}kg og {1}% av inntak begrensning!";
main_vote_restart1 = "Start løp på nytt:";
main_vote_restart2 = "({0}/{1}) trenger {2}";
main_vote_qualify1 = "Kvalifisering";
main_vote_qualify2 = "({0}/{1}) trenger {2}";
main_vote_end1 = "Slutt:";
main_vote_end2 = "({0}/{1}) Trenger {2}";
main_car_changed = "Bil endret, gå til garasje. Bil i bruk = {0}";
main_track_changed1 = "Banen er endret, vent litt!";
main_track_changed2 = "Bane i bruk = {0}";
main_left_server = "{0} ^7forlot serveren";
main_great1 = "Utmerket 1st split ({0}) by {1}^8!";
main_good1 = "Bra 1st split ({0}) by {1}^8!";
main_great2 = "Utmerket 2nd split ({0}) by {1}^8!";
main_good2 = "Bra 2nd split ({0}) by {1}^8!";
main_great3 = "Utmerket 3rd split ({0}) by {1}^8!";
main_good3 = "Bra 3rd split ({0}) by {1}^8!";
main_greatlap = "Utmerket runde ({0}) by {1}^8!";
main_goodlap = "Bra runde ({0}) by {1}^8!";
main_flood = "{0}^3 frakoblet for overfloding av chat";
main_on_result = "Avsluttende posisjon = {0}";
main_lost_control = "^1Fare! ^8{0} ^2er ut av kontroll!";
main_toslow1 = "Du kjører for langsomt! Max : {0}";
main_toslow2 = "frakoble om {0}";
main_toslowvery1 = "Du er for langsom, og blir satt i tilskuermodus!";
main_toslowvery2 = "{0} er for langsom, og ble satt i tilskuermodus!";
main_idle1 = "^3Du er for langsom, og vil bli satt i tilskuermodus om 10 sekunder";
main_idle2 = "^3Du er satt i tilskuermodus for langsomhet";
main_onnewpb = "Ny banerekord av {0}^8 ({1}): {2}";
main_onnewpb_rank = "Vennlig rank : {0}";
main_onnewpb_sesslaps = "Samlet antall runder = {0}";
main_onnewpb_servlaps = "Totalt antall runder (server) = {0}";
main_onnewpb_avgspeed = "Gjennomsnitt fart: {0}{1}";
main_onnewpb_rank2 = "Vennlig {0} rank: ^7{1}";
main_onnewpbqual = "Liga - Ny QT av {0}^8:{1}";
main_onnewpbqual_rank = "Vennlig rank (alle besøkende): ^7{0}";
main_onnewpbqual_pos = "^2Kvali. posisjon: {0}";
main_onnewpbqual_pool = "^6Virkelig sammenslutning: {0}";
main_onnewpbqual_avgspeed = "Gjennomsnitt fart: {0}{1}";
main_onnewpbqual_posqual = "{0} ^2Posisjon:{1} - Sammenslutning:{2}";
main_accel = "^8Akselererte fra 0 til {1} {2} på ^3{0}^8 sekunder!";
main_notpitwindow = "{0} ^1You are not on pit Windows, allowed in {1}-{2}";
main_inpitwindows = "{0} ^1Du kan gå til pit";
main_outpitwindows = "{0} ^1Du har ikke lov til å gå til pit";
main_beginpit = "{0}^8 gjorde et pit stopp";
main_pitwork = "Pit begynner! :{0}";
main_fastdrivepitl1_1 = "{0}^1 Advarsel for å kjøre for fort i pit";
main_fastdrivepitl1_2 = "^1ADVARSEL, FRAKOBLING MULIG";
main_fastdrivepitl2_1 = "{0}^1 Satt i tilskuermodus for å kjøre for fort i pit";
main_fastdrivepitl2_2 = "^1FRAKOBLET OM {0} TRY";
main_maxfastdrivepit1 = "{0}^1frakoblet for å kjøre for fort i pit";
main_maxfastdrivepit2 = "^1DU ER FRAKOBLET";
main_maxreset = "{0} satt i tilskuermodus for å overgå max resets lovlig";
main_oncarreset = "Reset av {0} på runde {1}";
main_specwarn = "^1Advarsel, tilskuermodus";
main_resetrest = "^2Du har^3 {0} ^2resets igjen";
main_close = "Avslutt";
main_psdistance = "^7Distanse: ^2{0} ^7{1}";
main_psfuel = "^7Drivstoff brukt: ^2{0} ^7liter";
main_pslaps = "^7Runder gjort: ^2{0}";
main_pswins = "^7Første plass: ^2{0}";
main_pssecond = "^7Andre plass: ^2{0}";
main_psthird = "^7Tredje plass: ^2{0}";
main_psfinished = "^7Løp gjort: ^2{0}";
main_psquals = "^7Kvalifisjoner gjort: ^2{0}";
main_pspole = "^7Staver gjort: ^2{0}";
built_pos = "Posisjon";
built_car = "Bil";
built_track = "Bane";
built_nick = "Kallenavn";
built_pb = "Banerekord";
built_nolfspb = "LFS World banerekord er ikke mottatt enda";
built_nolfspbcrit = "Ingen LFS World banerekord for denne bilen/banen";
built_lapsdone = "Runder gjort";
built_hand_curr = "  - Nåværende {0}Kg - Inntak begrensning.: {1}%";
built_hand_req =  "  - Krevet {0}^9 {1}Kg - Inntak begrensning.: {2}%";

label_lfslogo = "^7drives av ^3LFSLapper";
main_TDSM1 = "^0Det var søppel!"; # <80
main_pitcareful = "^0lar være veldig%nl%^0forsiktig der ute!";
main_close = "Avslutt";
main_closestats = "AVSLUTT";

main_closetop = "^3LUKK ^1->"
. "%nl%^3ALLE ^1->"
. "%nl%^3RADER ^1->";

main_closetop1 = "^1<- ^3LUKK"
. "%nl%^1<- ^3ALLE"
. "%nl%^1<- ^3RADER";

main_closetop = "^3LUKK ^1->"
. "%nl%^3RADER ^1->";

main_closetop1 = "^1<- ^3LUKK"
. "%nl%^1<- ^3RADER";

main_1936 = "^319 ^7- ^336";
main_3754 = "^337 ^7- ^354";
main_5572 = "^355 ^7- ^372";
main_7390 = "^373 ^7- ^390";
main_91108 = "^391 ^7- ^3108";
main_109126 = "^3109 ^7- ^3126";
main_127144 = "^3127 ^7- ^3144";
main_145162 = "^3145 ^7- ^3162";
main_163180 = "^3163 ^7- ^3180";
main_181198 = "^3181 ^7- ^3198";
main_199216 = "^3199 ^7- ^3216";
main_217234 = "^3217 ^7- ^3234";
main_235252 = "^3235 ^7- ^3252";
main_253270 = "^3253 ^7- ^3270";
main_271289 = "^3271 ^7- ^3289";
main_290307 = "^3290 ^7- ^3307";


main_top1 = "^2Topp 1 - 18";
main_top18 = "^2Topp 18 - 35";
main_top35 = "^2Topp 35 - 52";
main_top52 = "^2Topp 52 - 69";
main_top69 = "^2Topp 69 - 86";
main_top86 = "^2Topp 86 - 103";
main_top103 = "^2Topp 103 - 120";
main_top120 = "^2Topp 120 - 137";
main_topGTR = "^2Topp GTR's";
#main_topFWD = "^2Topp FWD's";
#main_topRWD = "^2Topp RWD's";
main_topTBO = "^2Topp TBO's";

main_warning = "^1!! A D V A R S E L !!"
. "%nl%{0}";

main_warning1 = "^1!! Du ble advart !!"
. "%nl%{0}";

main_info = "^2I N F O R M A S J O N"
. "%nl%{0}";

main_remember = "^1! ^3H U S K^1 !"
. "%nl%{0}";

main_impressive = "^7I M P O N E R E N D E"
. "%nl%{0}";

main_average = "^7G J E N N O M S N I T T L I G"
. "%nl%{0}";

main_pathetic = "^7P A T E T I S K"
. "%nl%{0}";

main_pitiful = "^7Y N K E L I G"
. "%nl%{0}";

main_dismal = "^7F O T G J E N G E R"
. "%nl%{0}";


EndLang


#	ITALIAN LANGUAGE SECTION
################################

Lang "IT"

label_lfslogo = "^7alimentato ^3LFSLapper";
main_TDSM1 = "^0Questo era spazzatura!"; # <80
main_pitcareful = "^0lascia stare molto%nl%^0attenti là fuori!";
main_close = "Chiudere";
main_closestats = "CHIUDERE";

main_closetop = "^3CHIUDERE ^1->"
. "%nl%^3TUTTE ^1->"
. "%nl%^3LE RIGHE ^1->";

main_closetop1 = "^1<- ^3CHIUDERE"
. "%nl%^1<- ^3TUTTE"
. "%nl%^1<- ^3E RIGHE";

main_closetop = "^3CHIUDERE ^1->"
. "%nl%^3LE RIGHE ^1->";

main_closetop1 = "^1<- ^3CHIUDERE"
. "%nl%^1<- ^3E RIGHE";

main_psdistance = "^7Distanza: ^2{0} ^7{1}";
main_psfinished = "^7Gara finita: ^2{0}";
main_psfuel = "^7Il carburante utilizzato: ^2{0} ^7litres ";
main_pslaps = "^7Giri fatto: ^2{0}";
main_pspole = "^7Pali fatto: ^2{0}";
main_psquals = "^7Qualifiche fatto: ^2{0}";
main_pssecond = "^7Seconda: ^2{0}";
main_psthird = "^7Terzo: ^2{0}";
main_pswins = "^7Vittorie: ^2{0}";

main_statstitle = "Presente par ^1Sin'rs ^3(^1Sin^3anju^1'^3s ^1r^3acing ^1s^3erver)"; 
main_qualdetails = "%nl%^4Q u a l i f i c a t i o n   d e   D e t a i l s: ";
main_pitcareful = "^0Cerchiamo di essere attenti la fuori!";
main_leavepits = "^3Guarda per il traffico%nl%prima di uscire dalla pitlane";
main_enterpits = "^3Immissione Pitlane%nl%^1avete abilitato Pit Limiter?";
main_accept = "Accettat";
main_deny = "Negare";
main_speedtrap = "^0Velocita Trappola =^1 {0} {1}";
main_gotlevel =  "^3Avete livello: {0}";
main_swearL2 = "Verra spectated in ^2{0} ^1 piu tentativi";
main_swear21 = "Troppi swearwords."
. "%nl%^1You have been kicked!";
main_nomatchflag = "Bandiere non corrispondere richieste bandiere";
main_yourflag =  "La tua bandiera -> {0}";
main_requiredflag = "Obbligatorio bandiere -> {0}" ;
main_spectated = "Spectated";
main_notadmin = "Se non sono un amministratore!";
main_currnode = "Il nodo corrente e : {0}";
main_currzone = "La zona attuale e : {0}";
main_lapclose = "Lapper Chiuso da Administrator!";
main_ban = "{0} vietare {1}";
main_kick = "{0} calciare {1}";
main_friendpos = "La vostra posizione è amichevole {0}";
main_groupqual = "Il tuo gruppo di qualificazione e {0}";
main_level = "^3avete livello(s): {0}";
main_dist = "Distanza sul fatto {0}/{1} = {2} {3}, sessione = {4} {5}";
main_lapdone = "Giri sul fatto {0}/{1} = {2}, sessione = {3}";
main_timeinpit = "Tempo in pitting {0}";
main_trackused = "Pista in uso : {0} = {1}";
main_serverclock = "Server orologio in tempo di riferimento : {0}";
main_midnight = "Midnight avviso a tutti i lavoratori, uomini!";
main_newyear = "Capodanno Felice!";
main_allowed = "{0}^3 su questo server";
main_notallowed = "{0}^3 non e consentito su questo server";
main_tolowhand1 = "{0}^3 spectated troppo basso per handicap";
main_tolowhand2 = "^3necessita {0}kg e {1}% di assunzione di restrizione!";
main_vote_restart1 = "Riavviare";
main_vote_restart2 = "({0}/{1}) Necessita {2}";
main_vote_qualify1 = "Qualify";
main_vote_qualify2 = "({0}/{1}) Necessita {2}";
main_vote_end1 = "Fine:";
main_vote_end2 = "({0}/{1}) Necessita {2}";
main_car_changed = "auto modificate, vai alla buca! Attuale auto = {0}";
main_track_changed1 = "Traccia cambiato, attendere prego!";
main_track_changed2 = "brano corrente = {0}";
main_left_server = "{0} a sinistra il server";
main_before = "Prima: ";
main_behind = "Dietro: ";
main_newdriftpb = "{0}^3 realise un nouveau PB: ^7{1} ^3pts!";
main_driftlap = "{0} ^3realise ^7{1} ^3pts de drift";
main_ongooddrift = "{0} ^3realise un drift excellent: ^7{1} ^3pts";
main_impressive = "^7I M P R E S S I O N N A N T"
. "%nl%{0}";
built_hand_curr = "  - Attuale {0}Kg - Intake Restr.: {1}%";
built_hand_req =  "  - Required {0}^9 {1}Kg - L'assunzione di restr.: {2}%";
built_lapsdone = " Fatto Laps";
built_nolfspb = "LFS World PB non ancora retreived";
built_nolfspbcrit = "No LFS World PB per questo criterio";
built_points = "Punti";
built_track = "Pista";


main_1936 = "^319 ^7- ^336";
main_3754 = "^337 ^7- ^354";
main_5572 = "^355 ^7- ^372";
main_7390 = "^373 ^7- ^390";
main_91108 = "^391 ^7- ^3108";
main_109126 = "^3109 ^7- ^3126";
main_127144 = "^3127 ^7- ^3144";
main_145162 = "^3145 ^7- ^3162";
main_163180 = "^3163 ^7- ^3180";
main_181198 = "^3181 ^7- ^3198";
main_199216 = "^3199 ^7- ^3216";
main_217234 = "^3217 ^7- ^3234";
main_235252 = "^3235 ^7- ^3252";
main_253270 = "^3253 ^7- ^3270";
main_271289 = "^3271 ^7- ^3289";
main_290307 = "^3290 ^7- ^3307";

main_warning = "^1!! A T T E N Z I O N E !!"
. "%nl%{0}";

main_warning1 = "^1!! Siete stati avvisati !!"
. "%nl%{0}";

main_info = "^2I N F O R M A Z I O N I"
. "%nl%{0}";

main_remember = "^1! ^3R I C O R D A T I^1 !"
. "%nl%{0}";

main_incredible = "^7I N C R E D I B I L E"
. "%nl%{0}";

main_impressive = "^7I M P R E S S I O N A N T E"
. "%nl%{0}";

main_average = "^7M E D I A"
. "%nl%{0}";

main_pathetic = "^7P A T E T I C O"
. "%nl%{0}";

main_pitiful = "^7P I E T O S O"
. "%nl%{0}";

main_dismal = "^7P E D O N A L E"
. "%nl%{0}";


EndLang

