<?php
/**
 ********************************************
 * Masters of Endurance tracker / LFS-Tracker 
 ********************************************
 * 
 * Copyright © 2007 Wolfgang Tom (WolleT)
 * v1.0 originally written by Wolfgang Tom
 * 
 * Copyright © 2009-2011 Michael Booth (Boothy)
 * v2.0 tracker modified by Michael Booth
 * 
 * Thanks also to Casper Roescher (Kaspur).  
 * 
 * Latest tracker version available from the LFS forum thread - http://www.lfsforum.net/showthread.php?t=73414
 * Any code changes/improvements can be submitted for inclusion in the public tracker version. 
 * E-mail me at web@michaelbooth.me.uk or PM me via http://www.lfsforum.net/private.php?do=newpm&u=202039
 * 
 ********************************************
 * 
 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * Version 2, December 2004

 * Copyright © 2004 Sam Hocevar <sam@hocevar.net>

 * Everyone is permitted to copy and distribute verbatim or modified
 * copies of this license document, and changing it is allowed as long
 * as the name is changed.

 * DO WHAT THE FUCK YOU WANT TO PUBLIC LICENSE
 * TERMS AND CONDITIONS FOR COPYING, DISTRIBUTION AND MODIFICATION

 * 0. You just DO WHAT THE FUCK YOU WANT TO. 
 * 
 ******************************************** 
 * See http://sam.zoy.org/wtfpl/ for more information
 **/

unset($bodypage);
$bodypage = "teamstats";
include 'header.php';
echo "<table id='raceStandings'>";
echo "<thead>";
echo "<tr>";
if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
    echo "<th scope='col'>Grid</th>";
    if ($showServer) {
        echo "<th scope='col'>Server</th>";
        $colspanExtra++;
    }
} else {
    echo "<th scope='col'>Pos</th>";
}
echo "<th scope='col'>Num</th>";
if ($raceFocus == "driver") {
    echo "<th scope='col'>Driver</th>";
    $teamcol = $XMLTEAM[$i]['team_data']['name'] ? true : false;
    if ($teamcol) {
        echo "<th scope='col'>Team</th>";
    }
} else {
    echo "<th scope='col'>Team Name</th>";
}
if ($showCars) {
    echo "<th scope='col'>Car</th>";
}
$swapcol = $XMLTEAM[$i]['race_data']['num_swap'] ? true : false;
if ($swapcol) {
    echo "<th scope='col'>Swap</th>";
    $colspanExtra++;
}

$pitcol = $XMLTEAM[$i]['race_data']['num_pits'] ? true : false;
if ($pitcol) {
    echo "<th scope='col'>Pit</th>";
    echo "<th scope='col'>Last Pit</th>";
}
$dtcol = $XMLTEAM[$i]['race_data']['num_dt'] ? true : false;
$sgcol = $XMLTEAM[$i]['race_data']['num_sg'] ? true : false;
if ($dtcol and $sgcol)
    echo "<th scope='col'>DT / SG</th>";
elseif ($dtcol)
    echo "<th scope='col'>DT</th>";
elseif ($sgcol)
    echo "<th scope='col'>SG</th>";
echo "<th scope='col'>Best</th>";
if ($showStatus) {
    echo "<th scope='col'>Status</th>";
    $colspanExtra++;
}
if ($raceFocus != "driver") {
    echo "<th scope='col'>Current Driver</th>";
}
if ($showPrev) {
    echo "<th scope='col'>Prev</th>";
    $colspanExtra++;
}
if ($showSector) {
    echo "<th scope='col'>Sector</th>";
    $colspanExtra++;
}
echo "<th scope='col'>Gap</th>";
echo "<th scope='col'>Diff</th>";
$pencolfull = false;
$pencollaps = false;
$pencoltime = false;
if ($XMLTEAM[$i]['race_data']['penalty_laps'])
    $pencollaps = true;
if ($XMLTEAM[$i]['race_data']['penalty_time'])
    $pencoltime = true;
if ($XMLTEAM[$i]['race_data']['penalty_laps'] && $XMLTEAM[$i]['race_data']['penalty_time'])
    $pencolfull = true;
if ($pencolfull) {
    $colspanExtra++;
    echo "<th scope='col' colspan='2'>Penalty</th>";
    $colspanExtra++;
} elseif ($pencollaps || $pencoltime) {
    echo "<th scope='col'>Pen</th>";
    $colspanExtra++;
}
echo "</tr>";
echo "</thead>";
echo "<tbody>";
if ($XMLTEAM[$i]['race_data']['laps'])
    $teamlaps = $XMLTEAM[$i]['race_data']['laps'] - 1;
if ($raceClassCSS[$XMLTEAM[$i]['team_data']['class']]) {
    $classrow = $raceClassCSS[$XMLTEAM[$i]['team_data']['class']];
} else {
    $classrow = strtolower($XMLTEAM[$i]['team_data']['class']);
}
echo "<tr class='" . $classrow . "'>";
// GRID/SERVER if pre-race
if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
    echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['grid'] . "</td>";
    // SERVER
    if ($showServer) {
        echo "<td class='pos'>" . $XMLTEAM[$i]['team_data']['server'] . "</td>";
    }
} else {
    //CLASS POSITION
    if ($XMLRACE['numClasses'] > 1) {
        if ($XMLTEAM[$i]['team_data']['class_position'] !== $XMLTEAM[$i]['race_data']['position']) {
            echo "<td class='pos'><abbr title='" . ordinalSuffix($XMLTEAM[$i]['race_data']['position']) .
                " overall'>" . $XMLTEAM[$i]['team_data']['class_position'] . "</abbr></td>";
        } else {
            echo "<td class='pos'>" . $XMLTEAM[$i]['race_data']['position'] . "</td>";
        }
    } else {
        echo "<td class='pos'>" . $XMLTEAM[$i]['race_data']['position'] . "</td>";
    }
}
// TEAM NUMBER
echo "<td class='num'><a href='team_" . $XMLTEAM[$i]['team_data']['number'] .
    ".html'><em>" . $XMLTEAM[$i]['team_data']['number'] . "</em></a></td>";

// TEAM NAME
if ($raceFocus == "driver") {
    echo "<td class='teamName'>";
    $j = 0;
    echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
        ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
        "'><span title='" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] .
        "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] . "</span>";
    echo "</td>";
    if ($teamcol) {
        echo "<td class='currentDriver'>" . $XMLTEAM[$i]['team_data']['name'] . "</td>";
    }
} else {
    echo "<td class='teamName'>" . $XMLTEAM[$i]['team_data']['name'] . "</td>";
}

if ($showCars) {
    // TEAM CAR - LMP, FZR, FZ2, FZ3
    if ($XMLTEAM[$i]['team_data']['class'] == "GT2" || $XMLTEAM[$i]['team_data']['class'] ==
        "GUE") {
        $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
            "2", -1);
    } elseif ($XMLTEAM[$i]['team_data']['class'] == "GT3") {
        $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
            "3", -1);
    } elseif ($raceClassName[1] !== "GT1" && $XMLTEAM[$i]['team_data']['class'] ==
    "GT1") {
        $XMLTEAM[$i]['team_data']['car'] = substr_replace($XMLTEAM[$i]['team_data']['car'],
            "1", -1);
    }
    echo "<td>" . $XMLTEAM[$i]['team_data']['car'] . "</td>";
}

// NUMBER OF DRIVER SWAPS
if ($swapcol and $XMLTEAM[$i]['race_data']['num_swap']) {
    echo "<td>" . $XMLTEAM[$i]['race_data']['num_swap'] . "</td>";
} elseif ($swapcol) {
    echo "<td></td>";
}

//PIT STOPS AND LAST PIT
if ($pitcol) {
    if ($XMLTEAM[$i]['race_data']['num_pits'] == 0) {
        echo "<td></td>";
    } elseif ($XMLTEAM[$i]['race_data']['pitstops'][($XMLTEAM[$i]['race_data']['last_pit_index'] -
    1)]['type'] == "PITIN")
        echo "<td class='pitin'><strong>" . $XMLTEAM[$i]['race_data']['num_pits'] .
            "</strong></td>";
    else
        echo "<td>" . $XMLTEAM[$i]['race_data']['num_pits'] . "</td>";


    if ($XMLTEAM[$i]['race_data']['num_pits'] == 0) {
        echo "<td></td>";
    } elseif ($XMLTEAM[$i]['race_data']['num_pits'] and $XMLTEAM[$i]['race_data']['pitstops'][($XMLTEAM[$i]['race_data']['last_pit_index'] -
    1)]['type'] == "PITIN") {
        echo "<td class='teamStatus'><abbr title='In the Pit Lane'>PIT</abbr></td>";
    } elseif (($XMLTEAM[$i]['filter_laps'][$teamlaps]['logged'] - ($XMLTEAM[$i]['race_data']['pitstops'][($XMLTEAM[$i]['race_data']['last_pit_index'] -
    1)]['time'] + ($timeOffset * 60 * 60))) < 0) {
        echo "<td class='teamStatus'><abbr title='Exited the Pit Lane'>OUT</abbr></td>";
    } else {
        echo "<td><span title='" . date("H:i:s O", $XMLTEAM[$i]['race_data']['pitstops'][($XMLTEAM[$i]['race_data']['last_pit_index'] -
            1)]['time']) . "'>" . date("G:i", $XMLTEAM[$i]['filter_laps'][$teamlaps]['logged'] -
            ($XMLTEAM[$i]['race_data']['pitstops'][($XMLTEAM[$i]['race_data']['last_pit_index'] -
            1)]['time'] + ($timeOffset * 60 * 60))) . "</span></td>";
    }
}

// DT AND SG COLUMN - SHOULD COLLAPSE IF NO DT/SG FOR ANY TEAM
if ($dtcol and $sgcol) {
    echo "<td>" . $XMLTEAM[$i]['race_data']['num_dt'] . " / " . $XMLTEAM[$i]['race_data']['num_sg'] .
        "</td>";
} elseif ($dtcol) {
    echo "<td>" . $XMLTEAM[$i]['race_data']['num_dt'] . "</td>";
} elseif ($sgcol) {
    echo "<td>" . $XMLTEAM[$i]['race_data']['num_sg'] . "</td>";
} elseif ($dtcol or $sgcol) {
    echo "<td></td>";
}

// OVERALL BEST, TEAM BEST, DRIVER BEST LAP
if ($XMLTEAM[$i]['race_data']['laps']) {
    if ($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime'] == $XMLRACE['fastest_lap'] or
        $XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
        $bestlapconstruct = "<strong class='classbestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
            "</strong>";
        $prevlapconstruct = $bestlapconstruct;
    } elseif ($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or
    $XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
        $bestlapconstruct = "<strong class='teambestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
            "</strong>";
        $prevlapconstruct = $bestlapconstruct;
    } elseif ($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime'] == $XMLTEAM[$i]['team_data']['drivers'][($XMLTEAM[$i]['race_data']['current_driver_num'])]['fastest_lap']) {
        $prevlapconstruct = "<strong class='driverbestlap'>" . normalTime($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime']) .
            "</strong>";
        $bestlapconstruct = normalTime($XMLTEAM[$i]['race_data']['fastest_lap']);
    } elseif ($XMLRACE['fastest_lap'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or
    $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap'] == $XMLTEAM[$i]['race_data']['fastest_lap']) {
        $bestlapconstruct = "<strong>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
            "</strong>";
        $prevlapconstruct = normalTime($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime']);
    } else {
        $bestlapconstruct = normalTime($XMLTEAM[$i]['race_data']['fastest_lap']);
        $prevlapconstruct = normalTime($XMLTEAM[$i]['filter_laps'][$teamlaps]['laptime']);
    }


} else {
    $bestlapconstruct = "";
    $prevlapconstruct = "";
}
// PRINT BEST LAP CONSTRUCTED
echo "<td>$bestlapconstruct</td>";

// TEAM STATUS
if ($showStatus) {
    if ($XMLTEAM[$i]['team_data']['finished'] && $trimFinished) {
        echo "<td class='teamStatus'><abbr title='Finished the race'>FIN</abbr></td>";
    } elseif ($XMLTEAM[$i]['team_data']['team_status_num'] === 2) {
        echo "<td class='teamStatus'><abbr title='Not a classified finisher'>NC</abbr></td>";
    } elseif ($XMLTEAM[$i]['team_data']['team_status_num'] === 3) {
        echo "<td class='teamStatus'><abbr title='Retired'>RET</abbr></td>";
    } elseif ($XMLTEAM[$i]['team_data']['team_status_num'] === 4) {
        echo "<td class='teamStatus'><abbr title='Disqualified'>DQ</abbr></td>";
    } elseif ($XMLTEAM[$i]['team_data']['team_status_num'] === 5) {
        echo "<td class='teamStatus'><abbr title='Did Not Start'>DNS</abbr></td>";
    } else {
        if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
            echo "<td class='teamStatus'><abbr title='On the Grid'>GRID</abbr></td>";
        } elseif (($XMLTEAM[0]['filter_laps'][($XMLTEAM[0]['race_data']['laps'] - 1)]['logged'] -
        $XMLTEAM[$i]['filter_laps'][$teamlaps]['logged']) > $inactiveTime) {
            echo "<td class='teamStatus'><abbr title='Not Completing Laps'>OUT</abbr></td>";
        } elseif ($XMLTEAM[$i]['race_data']['num_pits'] and $XMLTEAM[$i]['race_data']['pitstops'][count
        ($XMLTEAM[$i]['race_data']['pitstops']) - 1]['type'] == "PITIN") {
            echo "<td class='teamStatus'><abbr title='In the Pit Lane'>PIT</abbr></td>";
        } elseif ($XMLTEAM[$i]['team_data']['team_status_num'] === 1) {
            echo "<td class='teamStatus'><abbr title='Running on track'>RUN</abbr></td>";
        }
    }
}


if ($raceFocus != "driver") {
    echo "<td class='currentDriver'>";
    for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
        if ($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] == $XMLTEAM[$i]['race_data']['current_driver'])
            echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
                ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
                "'><span title='" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] .
                " / " . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] . "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_real'] .
                "</span>";
    }
    echo "</td>";
}

// PRINT PREV LAP CONSTRUCTED
if ($showPrev) {
    echo "<td>$prevlapconstruct</td>";
}
// SECTORS
if ($showSector && strtoupper($XMLTEAM[$i]['team_data']['team_status']) !==
    "DNS") {
    if ($XMLTEAM[$i]['team_data']['finished'] && $trimFinished) {
        $XMLTEAM[$i]['race_data']['current_sector'] = "f";
    }
    echo "<td><img src='" . $trackerRoot . "images/" . $XMLRACE['num_sectors'] . "s" .
        $XMLTEAM[$i]['race_data']['current_sector'] . ".gif' ";
    switch ($XMLRACE['num_sectors']) {
        case 4:
            echo "width='35' height='3'";
            break;
        case 3:
            echo "width='32' height='3'";
            break;
        case 2:
            echo "width='21' height='3'";
    }
    echo " alt='sector " . ($XMLTEAM[$i]['race_data']['current_sector'] + 1) .
        "'></td>";
} elseif (strtoupper($XMLTEAM[$i]['team_data']['team_status']) == "DNS") {
    echo "<td></td>";
}

// GAP
if ($i == 0) {
    echo "<td class='gap'><strong><span title='" . normalTime($XMLTEAM[$i]['filter_laps'][($XMLTEAM[$i]['race_data']['laps'] -
        1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['dist_to_lead_car'] .
        "</span></strong></td>";
} elseif (isset($XMLTEAM[$i]['race_data']['indexgap'])) {
    echo "<td class='gap'><span title='" . normalTime($XMLTEAM[$i]['filter_laps'][($XMLTEAM[$i]['race_data']['laps'] -
        1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['indexgap'] .
        "</span></td>";
} else {
    echo "<td class='gap'><strong><span title='" . normalTime($XMLTEAM[$i]['filter_laps'][($XMLTEAM[$i]['race_data']['laps'] -
        1)]['sessiontime'], true, false, false, true, false, true, true) . "'>" . $XMLTEAM[$i]['race_data']['dist_to_lead_car'] .
        "</span></strong></td>";
}
// DIFF
if ($i == 0 || ($XMLTEAM[$i]['race_data']['dist_to_car_in_front'] < 1)) {
    echo "<td class='diff'><strong>" . $XMLTEAM[$i]['race_data']['dist_to_car_in_front'] .
        "</strong></td>";
} elseif ($XMLTEAM[$i]['team_data']['team_status_num'] == 4) {
    echo "<td class='diff'></td>";
} else {
    echo "<td class='diff'>" . $XMLTEAM[$i]['race_data']['dist_to_car_in_front'] .
        "</td>";
}

// PENALTY LAPS & TIME
if ($pencolfull) {
    if (!$XMLTEAM[$i]['race_data']['penalty_laps'])
        echo "<td></td>";
    if (!$XMLTEAM[$i]['race_data']['penalty_time'])
        echo "<td></td>";
} elseif ($pencoltime or $pencollaps) {
    if (!$XMLTEAM[$i]['race_data']['penalty_laps'] && !$XMLTEAM[$i]['race_data']['penalty_time'])
        echo "<td></td>";
}
if ($XMLTEAM[$i]['race_data']['penalty_laps'] == 1)
    echo "<td class='penlapspos'>+" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
        " lap</td>";
if ($XMLTEAM[$i]['race_data']['penalty_laps'] > 1)
    echo "<td class='penlapspos'>+" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
        " laps</td>";
if ($XMLTEAM[$i]['race_data']['penalty_laps'] == -1)
    echo "<td class='penlaps'>" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
        " lap</td>";
if (($XMLTEAM[$i]['race_data']['penalty_laps'] < -1) && ($XMLTEAM[$i]['race_data']['penalty_laps']))
    echo "<td class='penlaps'>" . $XMLTEAM[$i]['race_data']['penalty_laps'] .
        " laps</td>";
if ($XMLTEAM[$i]['race_data']['penalty_time'] < 0)
    echo "<td class='penlaps'>+" . substr($XMLTEAM[$i]['race_data']['penalty_time'],
        1) . "s</td>";
if ($XMLTEAM[$i]['race_data']['penalty_time'] > 0)
    echo "<td class='penlapspos'>-" . $XMLTEAM[$i]['race_data']['penalty_time'] .
        "s</td>";


echo "</tr>";
echo "<tr class='collapsed_stats " . $classrow . "'>";
echo "<td colspan='" . (9 + $colspanExtra) . "'>";
echo "<table>";
echo "<tr>";
echo "<th></th>";
for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
    echo "<th><img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ",
        "_", $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country'])) .
        ".gif' width='18' height='12' alt='' title='" . ucwords($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_country']) .
        "'><br><span title=\"" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_full'] .
        "\">" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_real'] . "</span></th>";
echo "</tr>";
echo "<tr>";
echo "<th scope='row'>Username</th>";
for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
    echo "<td><a href='http://spdoracing.com/eventdb/driver/" . urlencode($XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs']) .
        "'>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['driver_lfs'] . "</a></td>";
echo "</tr>";
if ($XMLTEAM[$i]['team_data']['num_drivers'] > 1) {
    echo "<tr>";
    echo "<th scope='row'><span title='Calculated using the teams laps, not including penalty laps'>Race %</span></th>";
    for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
        if ($driverPercentMax && ($XMLTEAM[$i]['team_data']['drivers'][$j]['percent'] >
            $driverPercentMax) && ($XMLTEAM[$i]['team_data']['[team_status_num]'] < 3)) {
            echo "<td class='pitin'><strong>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['percent'] .
                "</strong></td>";
        } else {
            echo "<td>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['percent'] . "</td>";
        }
    }
    echo "</tr>";
    echo "<tr>";
    echo "<th scope='row'>Race laps</th>";
    for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++)
        echo "<td>" . $XMLTEAM[$i]['team_data']['drivers'][$j]['laps'] . "</td>";
    echo "</tr>";

    echo "<tr>";
    echo "<th scope='row'>Best lap</th>";
    for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
        if ($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap']) {
            if ($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
                echo "<td><strong class='classbestlap'>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                    "</strong></td>";
            } elseif ($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'] == $XMLTEAM[$i]['race_data']['fastest_lap']) {
                echo "<td><strong class='teambestlap'>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                    "</strong></td>";
            } else {
                echo "<td>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['fastest_lap'], true) .
                    "</td>";
            }
        } else {
            echo "<td></td>";
        }
    }
    echo "</tr>";
}
if ($averagelap !== false) {
    if ($averagelap > 100) {
        echo "<tr>";
        echo "<th scope='row'><span title='Excludes laps above " . $averagelap .
            "% of each drivers fastest lap'>Average lap</span></th>";
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
            echo "<td>";
            if ($XMLTEAM[$i]['team_data']['drivers'][$j]['average_time'] != 0) {
                echo normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['average_time'], true);
            }
            echo "</td>";
        }
        echo "</tr>";
    } else {
        echo "<tr>";
        echo "<th scope='row'><span title='Calculated using all of the laps completed by each driver'>Average lap</span></th>";
        for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
            echo "<td>";
            if ($XMLTEAM[$i]['team_data']['drivers'][$j]['average_time'] != 0) {
                echo normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['average_time'], true);
            }
            echo "</td>";
        }
        echo "</tr>";
    }
}
if ($XMLTEAM[$i]['team_data']['num_drivers'] > 1) {
    echo "<tr>";
    if ($standingStartOffset > 0) {
        $drivingTimeText = "<span title='Excludes any formation laps, time might be 1 lap out for either driver, check the race statistics or lapchart'>Driving time</span>";
    } else {
        $drivingTimeText = "Driving time";
    }
    echo "<th scope='row'>$drivingTimeText</th>";
    for ($j = 0; $j < $XMLTEAM[$i]['team_data']['num_drivers']; $j++) {
        if ($driverTimeMax && ($XMLTEAM[$i]['team_data']['drivers'][$j]['driving_time'] >
            ($driverTimeMax * 1000)) && ($XMLTEAM[$i]['team_data']['[team_status_num]'] < 3)) {
            echo "<td class='pitin'><strong>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['driving_time']) .
                "</strong></td>";
        } elseif ($XMLTEAM[$i]['team_data']['drivers'][$j]['driving_time'] != 0) {
            echo "<td>" . normalTime($XMLTEAM[$i]['team_data']['drivers'][$j]['driving_time']) .
                "</td>";
        } else {
            echo "<td></td>";
        }
    }
    echo "</tr>";
}
echo "</table>";
echo "<table style='width:99%'>";
echo "<tr>";
echo "<td colspan='" . ($XMLTEAM[$i]['team_data']['num_drivers'] + 1) .
    "' class='expandedbottom'>";
// link to extended stats
echo "<p>Race statistics &mdash; ";
// link to unfiltered stats
echo "<a href='race_" . $XMLTEAM[$i]['team_data']['number'] .
    ".html'>Race lapchart</a>";
if (file_exists('qualifying.html')) {
    echo " &mdash; <a href='qual_" . $XMLTEAM[$i]['team_data']['number'] .
        ".html'>Qualifying statistics</a>";
}
echo "</p><p>";
// number of laps + total laps
echo "Laps: " . $XMLTEAM[$i]['race_data']['laps'];
if ($XMLTEAM[$i]['race_data']['laps'] !== $XMLTEAM[$i]['race_data']['corrected_laps']) {
    echo ", Total laps: " . $XMLTEAM[$i]['race_data']['corrected_laps'];
}
// total time
echo "</p><p>";
echo "Session time: " . normalTime($XMLTEAM[$i]['race_data']['total_sessiontime']);


if ($XMLTEAM[$i]['race_data']['corrected_laps'] !== $XMLTEAM[0]['race_data']['corrected_laps']) {
    echo ", behind leader: " . normalTime($XMLTEAM[$i]['race_data']['total_sessiontime'] -
        $XMLTEAM[0]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] - 1)]['sessiontime']);
}
if ($XMLRACE['numClasses'] > 1) {
    if (($XMLTEAM[$i]['team_data']['class_position'] !== 1) && ($XMLTEAM[$i]['team_data']['class']
        !== $XMLTEAM[0]['team_data']['class'])) {
        echo ", behind " . $XMLTEAM[$i]['team_data']['class'] . " leader: " . normalTime($XMLTEAM[$i]['race_data']['total_sessiontime'] -
            $XMLTEAM[$XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['i']]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
            1)]['sessiontime']);
    }
}
echo "</p>";
if ($showServer) {
    echo "<p>Server: #" . $XMLTEAM[$i]['team_data']['server'];
    if (!$XMLTEAM[$i]['team_data']['grid'] > 0) {
        echo "</p>";
    }
}

if ($XMLTEAM[$i]['team_data']['grid'] > 0) {
    if ($showServer) {
        echo " &mdash; ";
    } else {
        echo "<p>";
    }
    $gridchange = $XMLTEAM[$i]['team_data']['grid'] - $XMLTEAM[$i]['race_data']['position'];
    $gridchange = ($gridchange > 0) ? "+" . $gridchange : $gridchange;

    echo "Grid: " . $XMLTEAM[$i]['team_data']['grid'] . ", Position: " . $XMLTEAM[$i]['race_data']['position'] .
        ", Change: " . $gridchange;
    echo "</p>";
}
echo "</td>";
echo "</tr>";
echo "</table>";
if ($showCar) {
    $showcarimgsrc = $showCarBaseUrl . $XMLTEAM[$i]['team_data']['number'] .
        strtolower($XMLTEAM[$i]['team_data']['class']) . $thumbCar[removeszeros($XMLTEAM[$i]['team_data']['number'])] .
        ".png";
    list($width, $height, $type, $attr) = getimagesize($showcarimgsrc);
    if ($width) {
        echo "<img src='", $showcarimgsrc, "' ", $attr, " alt='' class='carimage'>";
    }
}

echo "</td>";
echo "</tr>";
echo "</tbody></table>";

echo "<table id='teamstatscomparison'>";
echo "<tr>";
if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
    echo "<th>Grid</th>";
} else {
    echo "<th>Pos</th>";
}
echo "<th>Num</th>";
if ($raceFocus == "driver") {
    echo "<th>Driver</th>";
} else {
    echo "<th>Team Name</th>";
}
echo "<th>Diff</th>";
for ($j = 0; $j < min($XMLTEAM[$i]['race_data']['corrected_laps'], $teamstatsComparisonLaps);
    $j++)
    echo "<th>Lap " . ($XMLTEAM[$i]['race_data']['corrected_laps'] - $j) . "</th>";
echo "<th>Total</th>";
echo "</tr>";
$teamstatsmaxlaps = min($XMLTEAM[$i]['race_data']['corrected_laps'], $teamstatsComparisonLaps);
for ($m = (0 - $teamstatsComparisonNumber); $m < ($teamstatsComparisonNumber + 1);
    $m++) {
    if (isset($XMLTEAM[$i + $m])) {
        $teamstatscomparisongain = 0;
        if ($raceClassCSS[$XMLTEAM[$i + $m]['team_data']['class']]) {
            $classrow = $raceClassCSS[$XMLTEAM[$i + $m]['team_data']['class']];
        } else {
            $classrow = strtolower($XMLTEAM[$i + $m]['team_data']['class']);
        }
        echo "<tr class='" . $classrow . "'>";
        // GRID if pre-race
        if (strtoupper($XMLRACE['session_status']) == "PRE-RACE") {
            echo "<td class='num'>" . $XMLTEAM[$i + $m]['team_data']['grid'] . "</td>";

        } else {
            if ($XMLRACE['numClasses'] > 1) {
                if ($XMLTEAM[$i + $m]['team_data']['class_position'] !== $XMLTEAM[$i + $m]['race_data']['position']) {
                    echo "<th scope='row' class='pos'><abbr title='" . ordinalSuffix($XMLTEAM[$i + $m]['race_data']['position']) .
                        " overall'>" . $XMLTEAM[$i + $m]['team_data']['class_position'] . "</abbr></th>";
                } else {
                    echo "<th scope='row' class='pos'>" . $XMLTEAM[$i + $m]['team_data']['class_position'] .
                        "</th>";
                }
            } else {
                echo "<th scope='row' class='pos'>" . $XMLTEAM[$i + $m]['race_data']['position'] .
                    "</th>";
            }
        }
        // TEAM NUMBER
        echo "<td class='num'><a href='team_" . $XMLTEAM[$i + $m]['team_data']['number'] .
            ".html'><em>" . $XMLTEAM[$i + $m]['team_data']['number'] . "</em></a></td>";

        // TEAM NAME
        if ($raceFocus == "driver") {
            $j = 0;
            echo "<td class='teamName'><a href='team_" . $XMLTEAM[$i + $m]['team_data']['number'] .
                ".html'>" . $XMLTEAM[$i + $m]['team_data']['drivers'][$j]['driver_full'] .
                "</a></td>";

        } else {
            echo "<td class='teamName'><a href='team_" . $XMLTEAM[$i + $m]['team_data']['number'] .
                ".html'>" . $XMLTEAM[$i + $m]['team_data']['name'] . "</a></td>";
        }


        // DIFF
        echo "<td class='diff'>" . $XMLTEAM[$i + $m]['race_data']['dist_to_car_in_front'] .
            "</a></td>";
        if ($m == 0) {
            for ($j = 0; $j < $teamstatsmaxlaps; $j++) {
                echo "<td class='teamStat'><strong>";
                // print_r($XMLTEAM[$i]['filter_laps'][(($XMLTEAM[$i]['race_data']['corrected_laps']) -
                //                    ($j + 1))]);
                // echo "-$i,$j,$m-";
                /*if ($XMLTEAM[$i]['race_data']['penalty_laps'] > 0) {
                $teamstatsmain = $XMLTEAM[$i]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
                ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'];
                //echo $teamstatsmain;
                echo normalTime($teamstatsmain, true, false);
                } else
                if (isset($XMLTEAM[$i]['filter_laps'][(($XMLTEAM[$i]['race_data']['corrected_laps']) -
                ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'])) {*/
                $teamstatsmain = $XMLTEAM[$i]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
                    ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'];
                //echo $teamstatsmain;
                echo normalTime($teamstatsmain, true, false);
                // }
                echo "</strong></td>";
            }
            echo "<td></td></tr>";
        } else {
            for ($j = 0; $j < $teamstatsmaxlaps; $j++) {
                if (isset($XMLTEAM[$i + $m]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
                    ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))])) {
                    if ($XMLTEAM[$i + $m]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
                        ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'] < $XMLTEAM[$i]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
                        ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'])
                        echo "<td class='rf'>";
                    else
                        echo "<td class='gf'>";
                    $teamstatscomparisongap = ($XMLTEAM[$i]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
                        ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'] - $XMLTEAM[$i +
                        $m]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] - ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime']);
                    echo "<span title='" . normalTime($XMLTEAM[$i + $m]['filter_laps'][($XMLTEAM[$i]['race_data']['corrected_laps'] -
                        ($j + 1 + $XMLTEAM[$i]['race_data']['penalty_laps_teamstats']))]['laptime'], true) .
                        "'>" . normalTime($teamstatscomparisongap, true, true) . "</span>";
                    $teamstatscomparisongain += $teamstatscomparisongap;
                } else
                    echo "<td>";
                echo "</td>";
            }
            if ($teamstatscomparisongain == 0) {
                echo "<td></td>";
            } elseif ($teamstatscomparisongain > 0) {
                echo "<td class='rf'>" . normalTime($teamstatscomparisongain, true, true) .
                    "</td>";
            } else
                echo "<td class='gf'>" . normalTime($teamstatscomparisongain, true, true) .
                    "</td>";
            echo "</tr>";
            $teamstatscomparisongain = 0;
        }
    }

}
echo "</table>";
if ($raceFocus == "driver") {
    if ($XMLRACE['numClasses'] > 1) {
        echo "<h3>#" . $XMLTEAM[$i]['team_data']['number'] . " " . $XMLTEAM[$i]['team_data']['class'] .
            " &mdash; " . $XMLTEAM[$i]['team_data']['drivers'][0]['driver_full'];
        echo $XMLTEAM[$i]['team_data']['name'] ? " &mdash; " . $XMLTEAM[$i]['team_data']['name'] :
            "";
        echo "</h3>";
    } else
        echo "<h3>#" . $XMLTEAM[$i]['team_data']['number'] . " " . $XMLTEAM[$i]['team_data']['drivers'][0]['driver_full'];
    echo $XMLTEAM[$i]['team_data']['name'] ? " &mdash; " . $XMLTEAM[$i]['team_data']['name'] :
        "";
    echo "</h3>";
} else {
    if ($XMLRACE['numClasses'] > 1) {
        echo "<h3>#" . $XMLTEAM[$i]['team_data']['number'] . " " . $XMLTEAM[$i]['team_data']['class'] .
            " &mdash; " . $XMLTEAM[$i]['team_data']['name'] . "</h3>";
    } else
        echo "<h3>#" . $XMLTEAM[$i]['team_data']['number'] . " " . $XMLTEAM[$i]['team_data']['name'] .
            "</h3>";
}
echo "<div id='lapchart'>";
//echo("$i = " . $i);
$column = 0;
//echo(" -- $column = " . $column);
$stintLap = 1;
//echo(" -- $stintLap = " . $stintLap);
$newStint = false;
//echo(" -- $newStint = " . $newStint);
$swapDriver = true;
//echo(" -- $swapDriver = " . $swapDriver);

//echo_r($XMLTEAM[0]);
if ($raceClassCSS[$XMLTEAM[$i]['team_data']['class']]) {
    $classrow = $raceClassCSS[$XMLTEAM[$i]['team_data']['class']];
} else {
    $classrow = strtolower($XMLTEAM[$i]['team_data']['class']);
}
for ($j = 0; $j < $XMLTEAM[$i]['race_data']['laps']; $j++)
    //for ($j=0; $j < count($XMLTEAM[$i]['filter_laps']); $j++)
    //  echo(" -- $j = " . $j);


{
    if ($swapDriver || $newStint) {
        if ($j == 0 && ($standingStartOffset > 0)) {
            $XMLTEAM[$i]['team_data']['stints'][$column]['start'] = $XMLTEAM[$i]['filter_laps'][($standingStartOffset -
                1)]['sessiontime'];
        } elseif ($j == 0) {
            $XMLTEAM[$i]['team_data']['stints'][$column]['start'] = 0;
        } else {
            $XMLTEAM[$i]['team_data']['stints'][$column]['start'] = $XMLTEAM[$i]['filter_laps'][$j -
                1]['sessiontime'];
        }
        if ($newStint) {
            //echo ("newstint: $j $pitInAtKey ");
            if (isset($XMLTEAM[$i]['race_data']['pitstops'][$pitInAtKey + 1])) {
                if ($XMLTEAM[$i]['race_data']['pitstops'][$pitInAtKey + 1]['type'] == 'PITOUT') {
                    echo "<td colspan=3><strong>Pitstop " . normalTime(($XMLTEAM[$i]['race_data']['pitstops'][$pitInAtKey +
                        1]['time'] - $XMLTEAM[$i]['race_data']['pitstops'][$pitInAtKey]['time']) * 1000, false) .
                        "</strong></td>";
                    echo "<tr><td colspan=3><strong>Stint " . normalTime($XMLTEAM[$i]['team_data']['stints'][$column]['start'] -
                        $XMLTEAM[$i]['team_data']['stints'][$column - 1]['start']) .
                        "</strong></td></tr>";
                } else {
                    echo "<td colspan=3>No time recorded</td>";
                }
            } else {
                echo "<td colspan=3>Driver didn't leave pitlane yet.</td>";
            }
        }
        if ($column % 33 == 0 && $j == 0) {
            $column = 0;
            echo "<table class='" . $classrow . "'><tr><td colspan='3'>";
            foreach ($XMLTEAM[$i]['team_data']['drivers'] as $driver) {
                if (strtolower($driver['driver_lfs']) == strtolower($XMLTEAM[$i]['filter_laps'][$j]['driverUserName']))
                    echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $driver['driver_country'])) .
                        ".gif'/><br>" . $driver['driver_real'] . "</td></tr>";
            }
        } else
            if ($column % 33 != 0 && $j != 0 && $j != ($XMLTEAM[$i]['race_data']['laps'])) {
                echo "<table class='" . $classrow . "'><tr><td colspan=3>";
                foreach ($XMLTEAM[$i]['team_data']['drivers'] as $driver) {
                    if (strtolower($driver['driver_lfs']) == strtolower($XMLTEAM[$i]['filter_laps'][$j]['driverUserName']))
                        echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $driver['driver_country'])) .
                            ".gif'/><br/>" . $driver['driver_real'] . "</td></tr>";
                }
            } else
                if ($column % 7 == 0 && $j != 0 && $j != ($XMLTEAM[$i]['race_data']['laps'])) {
                    $column = 0;
                    echo "</table><table class='" . $classrow . "'><tr><td colspan=3>";
                    foreach ($XMLTEAM[$i]['team_data']['drivers'] as $driver) {
                        if (strtolower($driver['driver_lfs']) == strtolower($XMLTEAM[$i]['filter_laps'][$j]['driverUserName']))
                            echo "<img src='" . $trackerRoot . "flags/" . strtolower(str_replace(" ", "_", $driver['driver_country'])) .
                                ".gif'/><br/>" . $driver['driver_real'] . "</td></tr>";
                    }
                } else {
                    echo "</table></td></tr>";
                }
                $stintLap = 1;
        $column++;
    }
    echo "<tr>";

    if ($XMLTEAM[$i]['filter_laps'][$j]['laptime'] == $XMLRACE['fastest_lap'] or $XMLTEAM[$i]['filter_laps'][$j]['laptime'] ==
        $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
        $teamsstatslapconstruct = "<strong class='classbestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
            "</strong>";
    } elseif ($XMLTEAM[$i]['filter_laps'][$j]['laptime'] == $XMLTEAM[$i]['race_data']['fastest_lap'] or
    $XMLTEAM[$i]['filter_laps'][$j]['laptime'] == $XMLRACE['classes'][($XMLTEAM[$i]['team_data']['class'])]['fastest_lap']) {
        $teamsstatslapconstruct = "<strong class='teambestlap'>" . normalTime($XMLTEAM[$i]['race_data']['fastest_lap']) .
            "</strong>";
    } elseif ($XMLTEAM[$i]['filter_laps'][$j]['laptime'] == $XMLTEAM[$i]['team_data']['drivers'][($XMLTEAM[$i]['race_data']['current_driver_num'])]['fastest_lap']) {
        $teamsstatslapconstruct = "<strong class='driverbestlap'>" . normalTime($XMLTEAM[$i]['filter_laps'][$j]['laptime']) .
            "</strong>";
    } else {
        $teamsstatslapconstruct = normalTime($XMLTEAM[$i]['filter_laps'][$j]['laptime']);
    }

    echo "<td>" . ($j + 1) . "</td><td>" . $stintLap . "</td><td>$teamsstatslapconstruct</td>";
    echo "</tr>";
    if ($j + 1 == $XMLTEAM[$i]['race_data']['laps']) {
        echo "<tr><td colspan=3><strong>Stint " . normalTime($XMLTEAM[$i]['filter_laps'][$j]['sessiontime'] -
            $XMLTEAM[$i]['team_data']['stints'][$column - 1]['start']) .
            "</strong></td></tr>";
    }
    $stintLap++;
    $newStint = false;
    for ($k = 0; $k < count($XMLTEAM[$i]['race_data']['pitstops']); $k++) {
        if ($j - 1 > -1) {
            if (is_array($XMLTEAM[$i]['filter_laps'][$j - 1])) {
                if ($XMLTEAM[$i]['race_data']['pitstops'][$k]['mysqlid'] > $XMLTEAM[$i]['filter_laps'][$j -
                    1]['mysqlid'] && $XMLTEAM[$i]['race_data']['pitstops'][$k]['mysqlid'] < $XMLTEAM[$i]['filter_laps'][$j]['mysqlid'] &&
                    $XMLTEAM[$i]['race_data']['pitstops'][$k]['type'] == 'PITIN') {
                    $pitInAtKey = $k;
                    $newStint = true;
                    //    echo ("hi $k");
                    //   echo ($newStint);
                }
            }
        }
    }
    $swapDriver = false;
    if ($j - 1 > -1) {
        if (is_array($XMLTEAM[$i]['filter_laps'][$j - 1]) && $XMLTEAM[$i]['filter_laps'][$j -
            1]['driverUserName'] != $XMLTEAM[$i]['filter_laps'][$j]['driverUserName'])
            $swapDriver = true;
    }
}
echo "</table>";
echo "</div>";
include 'footer.php'; ?>