//  
//  cfguser.cs
//  
//  Author:
//       Robert BRACCAGNI alias Gai-Luron <lfsgailuron@free.fr>
// 
//  Copyright (c) 2010 Gai-Luron
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.


using System;
using System.Text;
using System.Collections;

namespace LFSLapper
{
    class cfguser
    {
        System.Collections.Hashtable cfu = new System.Collections.Hashtable();
        public void load()
        {
            try
            {
                using (System.IO.StreamReader sr = new System.IO.StreamReader("cfguser.txt"))
                {
                    cfu.Clear();
                    while (true)
                    {
                        string line = sr.ReadLine();
                        if (line == null)
                            break;
                        string[] cfg = line.Split(':');
                        cfu[cfg[0]] = line;
                    }
                }
            }
            catch { }
        }
        private void save()
        {
            using (System.IO.StreamWriter sw = new System.IO.StreamWriter("cfguser.txt"))
            {
                foreach (DictionaryEntry cf in cfu)
                    sw.WriteLine((string)cf.Value);
            }
        }
        public void retreive(infoPlayer currPly)
        {
            if (cfu.ContainsKey(currPly.userName))
            {
                string[] cfg = (cfu[currPly.userName] as string).Split(':');
                string tmp = cfg[1];
                currPly.viewSPBSplit = tmp[0].ToString();
                currPly.showSplitPB = bool.Parse(cfg[2]);
                try
                {
                    currPly.idLang = cfg[4];
                }
                catch
                {
                    currPly.idLang = "en";
                }
                try { currPly.unitSpeedKmh = bool.Parse(cfg[3]); }

                catch { };
            }
        }
        public void update( infoPlayer currPly )
        {
            cfu.Remove(currPly.userName);
            cfu[currPly.userName] = currPly.userName
                                    + ":" + currPly.viewSPBSplit
                                    + ":" + currPly.showSplitPB.ToString()
                                    + ":" + currPly.unitSpeedKmh.ToString()
                                    + ":" + currPly.idLang
                                    ;
            this.save();
        }
    }
}
