Imports System.Net
Imports System.Net.Sockets
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Threading

Module modFunctions

    'This sub hold track of the ACK packets and handles timeouts.
    Public bTimeOut1 As Boolean = True
    Public Sub AckTimer(ByVal sender As Object, ByVal e As System.Timers.ElapsedEventArgs)
        'This handles the sever timeout
        cfg.ACKTimer += 1
        cfg.ACKIdleTimer += 1

        'Send warning after 60 seconds no data arrival
        If cfg.ACKTimer >= 60 And cfg.ACKTimer < 120 And bTimeOut1 = True Then
            Console.WriteLine("WARNING: Connection is about to timeout")
            bTimeOut1 = False
        End If

        'Assume disconnected after 2 minutes not data arriaval
        If cfg.ACKTimer >= 120 Then
            Console.WriteLine("WARNING: Connection timed out, lost connection to server")
            tmrACKTimer.Enabled = False
            bTimeOut1 = True
            cfg.Connected = False

            'Handles reconnect option
            If cfg.AutoReconnect = True Then
                Console.WriteLine("Auto reconnect activated...")
                Reconnect(Nothing, Nothing)
                tmrReconnect.Enabled = True
            End If
        End If

        If cfg.ACKIdleTimer >= 25 Then Send.ISP(ACK)

    End Sub

    'This sub tries to connect to the server and does 3 connection attempts
    Public Sub ConnectToServer()
        'Set main connection info
        cfg.Connected = False
        cfg.ACKIdleTimer = 0
        cfg.ACKTimer = 0
        bTimeOut1 = True
        tmrACKTimer.Enabled = True

        'Setup connection, 3 attempts.
        Dim i As Integer
        For i = 0 To 2
            'You might want to specify there flags yourself (make your own cfg.Flags of something)
            Send.ISI(cfg.LocalPort, Send.ISF.ISF_KEEP_ALIVE + Send.ISF.ISF_GUARANTEE + Send.ISF.ISF_NLP_MCI + Send.ISF.ISF_RACE_TRACKING + Send.ISF.ISF_SPLIT_MESSAGE, 0, cfg.Password)
            Thread.Sleep(500)
            Send.ISP("VER", , "Requesting InSim version information...")
            Thread.Sleep(500)
            If cfg.Connected = True Then Exit For
            Thread.Sleep(1000)
        Next

        'Did we connect or not? (cfg.Connected handled by the listening socket)
        Select Case cfg.Connected
            Case True
                Console.WriteLine("Connection established to " & cfg.IPAddress.ToString & ":" & cfg.RemotePort.ToString())
                tmrACKTimer.Enabled = True
            Case False
                Console.WriteLine("No response from server, disconnected")
                tmrACKTimer.Enabled = False
        End Select

    End Sub

    'This reconnect sub is called every 60 seconds(by default) when connection timed out. It attempts to reconnect to the server.
    Public Sub Reconnect(ByVal sender As Object, ByVal e As System.Timers.ElapsedEventArgs)
        If cfg.Connected = True Then
            tmrReconnect.Enabled = False
        Else
            ConnectToServer()
        End If
    End Sub


    'Remove color and language tags from a string (Used for MSS example, see modDataArrival -> MSS)
    Public Function CleanString(ByVal str As String) As String
        str = Replace(str, "^L", "")
        str = Replace(str, "^G", "")
        str = Replace(str, "^C", "")
        str = Replace(str, "^J", "")
        str = Replace(str, "^E", "")
        str = Replace(str, "^T", "")
        str = Replace(str, "^B", "")
        str = Replace(str, "^^", "^")

        str = Replace(str, "^0", "")
        str = Replace(str, "^1", "")
        str = Replace(str, "^2", "")
        str = Replace(str, "^3", "")
        str = Replace(str, "^4", "")
        str = Replace(str, "^5", "")
        str = Replace(str, "^6", "")
        str = Replace(str, "^7", "")
        str = Replace(str, "^8", "")
        str = Replace(str, "^9", "")
        Return str
    End Function
End Module
