Imports System.Net
Imports System.Net.Sockets
Imports System.Text
Imports System.Runtime.InteropServices
Imports System.Threading

Module modPackets

    'Holds main config settings. You should load this from file or something.
    Public Structure structCFG
        Public IPAddress As IPAddress
        Public RemotePort As UShort
        Public LocalPort As UShort
        Public Connected As Boolean
        Public ACKTimer As Integer
        Public ACKIdleTimer As Integer
        Public Password As String
        Public AutoReconnect As Boolean
    End Structure
    Public cfg As structCFG

    '*******************'
    Public Structure MSTH                                                               ' NOT A PACKET - small 2-byte structure - time indication
        Public Minutes As Byte
        Public Seconds As Byte
        Public Hundredths As Byte
        Public Thousandths As Byte
    End Structure

    Public Structure PosId                                                              ' NOT A PACKET - small 2-byte structure - part of the REO (below)
        Public OldPos As Byte                                                           ' old position in list
        Public UniqueId As Byte                                                         ' player's assigned unique id
    End Structure
    '*******************'

    'InSimInit - ISI
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure InSimInit                                                          ' UDP packet to initialise the InSim system
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String          ' ISI + zero
        Public Port As UShort                                                           ' Port for UDP replies from LFS (0...65535)
        Public Flags As Byte                                                            ' Bit flags for options - see below
        Public NodeSecs As Byte                                                         ' Number of seconds between NLP or MCI packets (0=none)
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=16)> Public Admin As String      ' Admin password (required if set in LFS host options) 16
    End Structure
    Public sISI As InSimInit

    'InSimPack - ISP
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure SendISP                                                            ' General purpose 8 byte UDP packet
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String          ' 3 character identifier followed by zero character
        Public Value As Integer                                                         ' 32 bit value depending on the type of InSimPack
    End Structure
    Public sISP As SendISP

    'InSimVersion - VER
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveVER                                                         ' struct InSimVersion
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String          ' VER + zero
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=8)> Public Version As String     ' Product : DEMO, S1 or S2
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=6)> Public Product As String     ' InSim Version : increased when InSim packets change
        Public InSimVer As UShort
    End Structure
    Public rVER As ReceiveVER

    'StatePack - STA
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Structure ReceiveSTA
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String
        Public ReplaySpeed As Single                                                    ' 4-byte float - 1.0 is normal speed

        Public Flags As UShort                                                          ' State Flags (see below)
        Public InGameCambyte As Byte                                                    ' Which type of camera is selected (see below)
        Public ViewPlayer As Byte                                                       ' Player index of viewed car

        Public NumPlayers As Byte                                                       ' Num in race
        Public NumConns As Byte                                                         ' Num connections including host
        Public NumFinished As Byte                                                      ' Number finished or qualified
        Public RaceInProgress As Byte                                                   ' 0 - no / 1 - race / 2 - qualifying

        Public QualMins As Byte
        Public RaceLaps As Byte                                                         ' see "RaceLaps" near the top of this document
        Public Spare2 As Byte
        Public Spare3 As Byte

        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=6)> Public Track As String       ' short name for track e.g. FE2R
        Public Weather As Byte ' 0,1,2...
        Public Wind As Byte    ' 0=off 1=weak 2=strong
    End Structure
    Public rSTA As ReceiveSTA

    'MsgTypePack - MST
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure SendMST                                                            ' 64 chars - send to LFS to simulate typing message or command
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String          ' MST + zero
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=64)> Public Msg As String        ' text message or /command, must end with zero
    End Structure
    Public sMST As SendMST

    'MsgToConn - MTC
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure SendMTC                                                            ' 64 chars - send to LFS and on to a chosen connection (0 = host)
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String          ' MTC + zero
        Public Conn As Byte                                                             ' connection
        Public UniqueId As Byte                                                         ' destination player UniqueId : if set, Conn is ignored
        Public Sp2 As Byte
        Public Sp3 As Byte
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=64)> Public Msg As String        ' text message or /command, must end with zero
    End Structure
    Public sMTC As SendMTC

    'MsgOutPack - MSO
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveMSO                                                         ' 128 chars - LFS reporting displayed messages
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String          ' MSO + zero
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=128)> Public Msg As String       ' displayed message, with colours removed
    End Structure
    Public rMSO As ReceiveMSO

    'MsgOutSplit - MSS
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveMSS                                                         ' 64 chars - user messages if ISF_SPLIT_MESSAGE flag is ON
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String          ' MSS + zero
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public UName As String      ' user name
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public PName As String      ' player name
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=64)> Public Msg As String        ' text message from user
    End Structure
    Public rMSS As ReceiveMSS

    'InSimMulti - ISM
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveISM
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String          ' ISM	
        Public Host As Byte                                                             ' 0 = guest / 1 = host
        Public Sp1 As Byte
        Public Sp2 As Byte
        Public Sp3 As Byte
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=32)> Public Name As String       ' the name of the host joined or started
    End Structure
    Public rISM As ReceiveISM

    'Vote Notify - VTN
    Public Enum VTNCType
        VOTE_NONE
        VOTE_END_RACE
        VOTE_RESTART
        VOTE_QUALIFY
    End Enum
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveVTN
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String          ' VTN + zero (VoTe Notify)	
        Public Conn As Byte                                                             ' connection (0 is host)
        Public Type As Byte                                                             ' VOTE_X (Vote Action as defined above)
        Public Sp2 As Byte
        Public Sp3 As Byte
    End Structure
    Public rVTN As ReceiveVTN

    'Vote Action - VTA
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveVTA
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String          ' VTA + zero (VoTe Action)	
        Public Value As Byte                                                            ' value VOTE_X
    End Structure
    Public rVTA As ReceiveVTA


    ' ***** RACE TRACKING PACKETS - you must send an acknowledgement reply to these packets *****

    'Race STart - RST
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveRST                                                         ' Race STart
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        Public RaceLaps As Byte                                                         ' see "RaceLaps" near the top of this document
        Public QualMins As Byte                                                         ' 0 if race
        Public NumInRace As Byte
        Public Spare As Byte

        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=6)> Public Track As String
        Public Weather As Byte
        Public Wind As Byte

        Public Sp0 As Byte
        Public Sp1 As Byte
        Public VerifyId As UShort
    End Structure
    Public rRST As ReceiveRST

    'Race End - REN
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveREN                                                         ' Race End (return to entry screen)
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String
        Public Sp0 As Byte
        Public Sp1 As Byte
        Public VerifyId As UShort
    End Structure
    Public rREN As ReceiveREN

    'New Connection - NCN
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveNCN                                                         ' Race ENd (return to entry screen)
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public UName As String      ' username
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public PName As String      ' nickname

        Public Admin As Byte
        Public Sp1 As Byte
        Public Sp2 As Byte
        Public Sp3 As Byte

        Public ConnNum As Byte                                                          ' new conn's number (0 = host, 1, 2...)
        Public Total As Byte                                                            ' number of connections on host, including host
        Public VerifyId As UShort
    End Structure
    Public rNCN As ReceiveNCN

    'Connection Leave - CNL
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveCNL                                                         ' Conn Leave (end connection is moved down into this slot)
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public UName As String      ' username
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public PName As String      ' nickname

        Public ConnNum As Byte
        Public Total As Byte                                                            ' number of connections on host, including host
        Public VerifyId As UShort
    End Structure
    Public rCNL As ReceiveCNL

    'New Player - NPL
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveNPL                                                         ' New PLayer joining race (if number already exists, then leaving pits)
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public UName As String      ' username
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public PName As String      ' nickname
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=8)> Public Plate As String       ' number plate - NO ZERO AT END!
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=32)> Public CName As String      ' car name

        Public Flags As UShort                                                          ' player flags (see below)
        Public Type As Byte                                                             ' bit 0 - female / bit 1 - AI
        Public UniqueId As Byte                                                         ' player's assigned unique id

        Public PlyNum As Byte                                                           ' player's number (0 = pole, 1, 2...)
        Public Total As Byte                                                            ' number in race (same when leaving pits, 1 more if new)
        Public VerifyId As UShort
    End Structure
    Public rNPL As ReceiveNPL

    'Player Pits - PLP
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceivePLP                                                         ' Player Pits (go to settings - stays in player list)
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public UName As String      ' username
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public PName As String      ' nickname

        Public UniqueId As Byte                                                         ' player's assigned unique id
        Public Sp1 As Byte
        Public Sp2 As Byte
        Public Sp3 As Byte

        Public PlyNum As Byte                                                           ' player's number (0 = pole, 1, 2...)
        Public Total As Byte                                                            ' new total (expect : same as before)
        Public VerifyId As UShort
    End Structure
    Public rPLP As ReceivePLP

    'PLayer Leave race - PLL
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceivePLL                                                         ' Player Leave race (spectate - leaves player list, all are shunted down)
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public UName As String      ' username
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public PName As String      ' nickname

        Public UniqueId As Byte                                                         ' player's assigned unique id
        Public Sp1 As Byte
        Public Sp2 As Byte
        Public Sp3 As Byte

        Public PlyNum As Byte                                                           ' player's number (others shunt down)
        Public Total As Byte                                                            ' new total (expect : 1 less than before)
        Public VerifyId As UShort
    End Structure
    Public rPLL As ReceivePLL

    'PLayer Leave race - CPR
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveCPR                                                         ' Conn Player Rename
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public UName As String      ' username
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public OldName As String    ' old name
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public NewName As String    ' new name
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=8)> Public Plate As String       ' number plate - NO ZERO AT END!

        Public UniqueId As Byte                                                         ' unique id : 0 = connection has no player in race
        Public Sp1 As Byte
        Public VerifyId As UShort
    End Structure
    Public rCPR As ReceiveCPR

    'Clear Race - CLR
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveCLR                                                         ' Clear Race - all players removed from race in one go
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        Public Sp0 As Byte
        Public Sp1 As Byte
        Public VerifyId As UShort
    End Structure
    Public rCLR As ReceiveCLR

    'Lap time - LAP
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveLAP                                                         ' Lap time
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public UName As String      ' username
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public PName As String      ' nickname
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=32)> Public CName As String      ' car name

        Public Time As MSTH                                                             ' lap time

        Public PlyNum As Byte                                                           ' player's number
        Public UniqueId As Byte                                                         ' player's assigned unique id
        Public VerifyId As UShort
    End Structure
    Public rLAP As ReceiveLAP

    'Lap time - SP1
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveSP1                                                         ' Lap time
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        Public Time As MSTH                                                             ' split time

        Public PlyNum As Byte                                                           ' player's number
        Public UniqueId As Byte                                                         ' player's assigned unique id
        Public VerifyId As UShort
    End Structure
    Public rSP1 As ReceiveSP1

    'Lap time - SP2
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveSP2                                                         ' Lap time
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        Public Time As MSTH                                                             ' split time

        Public PlyNum As Byte                                                           ' player's number
        Public UniqueId As Byte                                                         ' player's assigned unique id
        Public VerifyId As UShort
    End Structure
    Public rSP2 As ReceiveSP2

    'Lap time - SP3
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveSP3                                                         ' Lap time
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        Public Time As MSTH                                                             ' split time

        Public PlyNum As Byte                                                           ' player's number
        Public UniqueId As Byte                                                         ' player's assigned unique id
        Public VerifyId As UShort
    End Structure
    Public rSP3 As ReceiveSP3

    'Result - RES
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveRES                                                         ' ReSult (qualify or finish)
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public UName As String      ' username
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=24)> Public PName As String      ' nickname
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=8)> Public Plate As String       ' number plate - NO ZERO AT END!
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public CName As String       ' short car name / skin prefix (e.g. XRT)

        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=20)> Public Spare As String      ' zero

        Public Hours As UShort                                                          ' total hours (when TotalTime >= 1 hour)
        Public SpareW As UShort                                                         ' zero 

        Public LapsDone As UShort                                                       ' laps completed
        Public Flags As UShort                                                          ' player flags : help settings etc - see below

        Public ConfirmFlags As Byte                                                     ' confirmation flags : disqualified etc - see below
        Public NumStops As Byte                                                         ' number of pit stops
        Public Type As Byte                                                             ' bit 0 - female / bit 1 - AI
        Public UniqueId As Byte                                                         ' unique id : 0 = player already left before result was sent

        Public TotalTime As MSTH                                                        ' race time
        Public BestLap As MSTH                                                          ' best lap

        Public ResultNum As Byte                                                        ' position in results table (qualify may be inserted not at end)
        Public NumResults As Byte                                                       ' total number of results (qualify doesn't always add a new one)
        Public VerifyId As UShort
    End Structure
    Public rRES As ReceiveRES

    'Reorder - REO
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveREO                                                         ' Lap time
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        'Public Info() As PosId                                                         ' old positions and unique id
        Public Info() As PosId
        Public Sp0 As Byte                                                              ' spare
        Public NumPlayers As Byte                                                       ' number of players in race
        Public VerifyId As UShort
    End Structure
    Public rREO As ReceiveREO

    'MultiCarInfo - MCI
    <StructLayout(LayoutKind.Sequential, CharSet:=CharSet.Ansi)> _
    Public Structure ReceiveMCI                                                         ' MultiCarInfo - if more than 8 in race then more than one of these is sent
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=4)> Public Id As String

        Public NumNodes As UShort                                                       ' total number of nodes in the path
        Public FinishLine As UShort                                                     ' the node number of the finish line 
        Public NumPlayers As Byte                                                       ' number of players in race
        Public FirstPly As Byte                                                         ' first player in this packet (0 in 1st packet, 8 in 2nd...)
        Public Sp2 As Byte                                                              ' spare
        Public Sp3 As Byte                                                              ' spare


        Public Info() As CompCar                                                         ' car info for each player, max 8 per packet

    End Structure
    Public rMCI As ReceiveMCI

    Public Structure CompCar                                                            ' NOT A PACKET - Car info in a 24-byte structure - part of the MCI (below)
        Public Node_Lap_Hi3 As UShort                                                   ' current path node (and high 3 bits of Lap)
        Public Lap_Lo8 As Byte                                                          ' current lap (low byte... see above : NODE/LAP)
        Public UniqueId As Byte                                                         ' player's assigned unique id
        Public X As Integer                                                             ' X map (65536 = 1 metre)
        Public Y As Integer                                                             ' Y map (65536 = 1 metre)
        Public Z As Integer                                                             ' Z alt (65536 = 1 metre)
        Public Speed As UShort                                                          ' speed (32768 = 100 m/s)
        Public Direction As UShort                                                      ' direction of car's motion : (see note 1 below)
        Public Heading As UShort                                                        ' direction of forward axis : (see note 1 below)
        Public AngVel As Short                                                          ' signed, rate of change of heading : (see note 2)
    End Structure

End Module
