<?php

$SDK = new LFSWorldSDK('idk', true);

/*
** Live For Speed World SDK, easily find what you need from the World of Live For Speed.
**
** @package   LFSWorldSDK
** @since     2007-10-27 06:30
** @author    Mark 'Dygear' Tomlin
** @coauthor  Mikael 'filur' Forsberg
** @coauthor  Victor van Vlaardingen.
** @license   MIT License (http://opensource.org/licenses/mit-license.php)
** @copyright Copyright (C) 2006, Mark 'Dygear' Tomlin, Mikael 'filur' Forsberg & Victor van Vlaardingen.
** @version   1.7
*/

class LFSWorldSDK {
	function LFSWorldSDK($idk, $ps = false) {
		$this->ps = $ps;
		$this->idk = $idk;
		$this->version = 1.3;
		$this->compression = (function_exists ('gzinflate')) ? 3 : 0;
	}
	function make_query($qryStr, $file = 'get_stat2.php') {
		return $this->res_preproc (file_get_contents("http://www.lfsworld.net/pubstat/{$file}?version={$this->version}&idk={$this->idk}&ps={$this->ps}{$qryStr}&c={$this->compression}"));
	}
	function res_preproc ($data) {
		return ($this->compression) ? gzinflate ($data) : $data;
	}
	function get_hl($racer) {
		if (is_array($racer)) {
			foreach($racer as $uname) {
				$result[$uname] = $this->get_hl($uname);
			}
		} else {
			foreach (explode("\n", $this->make_query("&action=hl&racer={$racer}")) as $line => $data) {
				list($result[$line]['id_hl'], $result[$line]['track'], $result[$line]['car'], $result[$line]['split1'], $result[$line]['split2'], $result[$line]['split3'], $result[$line]['time'], $result[$line]['flags_hlaps']) = split(' ', $data, 8);
			}
			unset($result[$line]);
		}
		return $result;
	}
	function get_pb($racer) {
		if (is_array($racer)) {
			foreach($racer as $uname) {
				$result[$uname] = $this->get_pb($uname);
			}
		} else {
			foreach (explode("\n", $this->make_query("&action=pb&racer={$racer}")) as $line => $data) {
				list($result[$line]['track'], $result[$line]['car'], $result[$line]['time'], $result[$line]['lapcount']) = split(' ', $data, 4);
			}
			unset($result[$line]);
		}
		return $result;
	}
	function get_ch($track, $car, $control = null) {
		if (is_array($track) || is_array($car)) {
			if (is_array($track) && is_array($car)) {
				foreach($track as $tname) {
					foreach ($car as $cname) {
						$result[$tname][$cname] = $this->get_ch($tname, $cname, $control);
					}
				}
			} else if (is_array($track)) {
				foreach($track as $tname) {
					$result[$tname] = $this->get_ch($tname, $cname, $control);
				}
			} else if (is_array($car)) {
				foreach ($car as $cname) {
					$result[$cname] = $this->get_ch($tname, $cname, $control);
				}
			}
		} else {
			foreach (explode("\n", $this->make_query("&action=ch&track={$track}&car={$car}&control={$control}")) as $line => $data) {
				list($result[$line]['split1'], $result[$line]['split2'], $result[$line]['split3'], $result[$line]['time'], $result[$line]['flags_hlaps'], $result[$line]['racername']) = split(' ', $data, 6);
			}
			unset($result[$line]);
		}
		return $result;
	}
	function get_wr() {
		foreach (explode("\n", $this->make_query("&action=wr")) as $line => $data) {
			list($result[$line]['id_wr'], $result[$line]['track'], $result[$line]['car'], $result[$line]['split1'], $result[$line]['split2'], $result[$line]['split3'], $result[$line]['time'], $result[$line]['flags_hlaps'], $result[$line]['racername']) = split(' ', $data, 9);
		}
		unset($result[$line]);
		return $result;
	}
	function get_pst($racer) {
		if (is_array($racer)) {
			foreach($racer as $uname) {
				$result[$uname] = $this->get_pst($uname);
			}
		} else {
			list($result['distance'], $result['fuel'], $result['laps'], $result['hosts'], $result['wins'], $result['second'], $result['third'], $result['finished'], $result['quals'], $result['pole'], $result['credits'], $result['drags'], $result['drag'], $result['status'], $result['hostname'], $result['time'], $result['track'], $result['car']) = explode("\n", $this->make_query("&action=pst&racer={$racer}"));
		}
		return $result;
	}
	function get_hosts() {
		$string = $this->make_query("&action=hosts");
		for ($pointer = 0, $i = 0; $pointer <= strlen($string); $i++) {
			$NumberOfRacers = @unpack("c", substr($string, $pointer + 52, 1));
			$NumberOfRacers = $NumberOfRacers[1];
			$NumberOfRacersLen = $NumberOfRacers * 24;
			$PointerPast = $NumberOfRacersLen + 53;
			$result[$i] = array();
			if (($result[$i] = @unpack("a32hostname/A4tmlt/a4tcrm/icars/irules/claps/cqual/cspare1/cspare2/cnrofracers/a{$NumberOfRacersLen}racernames", substr($string, $pointer, $PointerPast)))) {
				$result[$i]['racernames'] = preg_split("/\\0/", $result[$i]['racernames'], -1, PREG_SPLIT_NO_EMPTY);
				$result[$i]['tmlt'] = unpack("ctype/cmain/a1letter/ctestId", $result[$i]['tmlt']);
				$result[$i]['tcrm'] = unpack("ctrack/cconfig/creversed/cmax", $result[$i]['tcrm']);
			}
			else
				unset($result[$i]);
			$pointer += $PointerPast;
		}
		return $result;
	}
	function get_progress($host) {
		$string = $this->make_query("&host={$host}", 'hostprogress.php');
		list($null, $string) = explode("\n", $string);
		return json_decode($string, true);
	}
	function get_teams() {
		$string = $this->make_query("&action=teams");
		for ($pointer = 0, $i = 0; $pointer <= strlen($string); $i++) {
			$infoLen = @unpack("S", substr($string, $pointer + 298, 2));
			$infoLen = $infoLen[1];
			$nrMembers = @unpack("S", substr($string, $pointer + 300 + $infoLen, 2));
			$nrMembers = $nrMembers[1] * 24;
			$PointerPast = 302 + $infoLen + $nrMembers;
			$result[$i] = array();
			if (($result[$i] = @unpack("a128team/a6tag/a32country/a128url/Ibits/Sinfo_len/a{$infoLen}info/Snr_members/a{$nrMembers}members", substr($string, $pointer, $PointerPast)))) {
				$result[$i]['members'] = preg_split("/\\0/", $result[$i]['members'], -1, PREG_SPLIT_NO_EMPTY);
				$result[$i]['info'] = urldecode($result[$i]['info']);
			}
			else
				unset($result[$i]);
			$pointer += $PointerPast;
		}
		return $result;
	}
	function get_hl_log($log_filter = 4, $lines = 150, $control = null, $starttime = 0) {
		$string = $this->make_query("&action=hl_log&log_filter={$log_filter}&lines={$lines}&control={$control}&starttime={$starttime}&format=3");
		for ($pointer = 0, $i = 0; $pointer <= strlen($string); $i++) {
			$result[$i] = array();
			if (($result[$i] = @unpack("itime/a24racer/a32country/A4tcrc/i4split/Spos/Sflags/iid_hl", substr($string, $pointer, 88))))
				$result[$i]['tcrc'] = unpack("ctrack/cconfig/creversed/ccar", $result[$i]['tcrc']);
			else
				unset($result[$i]);
			$pointer += 88;
		}
		return $result;
	}
}

$LFS_Tracks = array(
	'BL1'	=> array('Blackwood', 'GP Track', 2.1, 'Standard', '000'),
	'BL1R'	=> array('Blackwood', 'GP Track', 2.1, 'Reversed', '001'),
	'BL2'	=> array('Blackwood', 'Rally Cross', 1.2, 'Standard', '010'),
	'BL2R'	=> array('Blackwood', 'Rally Cross', 1.2, 'Reversed', '011'),
	'BL3'	=> array('Blackwood', 'Car Park', 0.2, 'Arena', '020'),
	'SO1'	=> array('South City', 'Classic', 1.3, 'Standard', '100'),
	'SO1R'	=> array('South City', 'Classic', 1.3, 'Reversed', '101'),
	'SO2'	=> array('South City', 'Sprint Track 1', 1.3, 'Standard', '110'),
	'SO2R'	=> array('South City', 'Sprint Track 1', 1.3, 'Reversed', '111'),
	'SO3'	=> array('South City', 'Sprint Track 2', 0.8, 'Standard', '120'),
	'SO3R'	=> array('South City', 'Sprint Track 2', 0.8, 'Reversed', '121'),
	'SO4'	=> array('South City', 'Long', 2.5, 'Standard', '130'),
	'SO4R'	=> array('South City', 'Long', 2.5, 'Reversed', '131'),
	'SO5'	=> array('South City', 'Town Course ', 2.0, 'Standard', '140'),
	'SO5R'	=> array('South City', 'Town Course', 2.0, 'Reversed', '141'),
	'FE1'	=> array('Fern Bay', 'Club', 1.0, 'Standard', '200'),
	'FE1R'	=> array('Fern Bay', 'Club', 1.0, 'Reversed', '201'),
	'FE2'	=> array('Fern Bay', 'Green Track', 1.9, 'Standard', '210'),
	'FE2R'	=> array('Fern Bay', 'Green Track', 1.9, 'Reversed', '211'),
	'FE3'	=> array('Fern Bay', 'Gold Track', 2.2, 'Standard', '220'),
	'FE3R'	=> array('Fern Bay', 'Gold Track', 2.2, 'Reversed', '221'),
	'FE4'	=> array('Fern Bay', 'Black Track', 4.1, 'Standard', '230'),
	'FE4R'	=> array('Fern Bay', 'Black Track', 4.1, 'Reversed', '231'),
	'FE5'	=> array('Fern Bay', 'Rally Cross', 1.3, 'Standard', '240'),
	'FE5R'	=> array('Fern Bay', 'Rally Cross', 1.3, 'Reversed', '241'),
	'FE6'	=> array('Fern Bay', 'RallyX Green', 0.5, 'Standard', '250'),
	'FE6R'	=> array('Fern Bay', 'RallyX Green', 0.5, 'Reversed', '251'),
	'AU1'	=> array('Autocross', 'Autocross', 0.3, 'Arena', '300'),
	'AU2'	=> array('Autocross', 'Slod Pad', 0.1, 'Arena', '310'),
	'AU3'	=> array('Autocross', 'Drag Strip', 0.7, 'Single Stage', '320'),
	'AU4'	=> array('Autocross', '8 Lane Drag', 0.7, 'Single Stage', '330'),
	'KY1'	=> array('Kyoto Ring', 'Oval', 1.9, 'Standard', '400'),
	'KY1R'	=> array('Kyoto Ring', 'Oval', 1.9, 'Reversed', '401'),
	'KY2'	=> array('Kyoto Ring', 'National', 3.2, 'Standard', '410'),
	'KY2R'	=> array('Kyoto Ring', 'National', 3.2, 'Reversed', '411'),
	'KY3'	=> array('Kyoto Ring', 'GP Long', 4.6, 'Standard', '420'),
	'KY3R'	=> array('Kyoto Ring', 'GP Long', 4.6, 'Reversed', '421'),
	'WE1'	=> array('Westhill', 'International', 3.2, 'Standard', '500'),
	'WE1R'	=> array('Westhill', 'International', 3.2, 'Reversed', '501'),
	'AS1'	=> array('Aston', 'Cadet', 1.2, 'Standard', '600'),
	'AS1R'	=> array('Aston', 'Cadet', 1.2, 'Reversed', '601'),
	'AS2'	=> array('Aston', 'Club', 1.9, 'Standard', '610'),
	'AS2R'	=> array('Aston', 'Club', 1.9, 'Reversed', '611'),
	'AS3'	=> array('Aston', 'National', 3.5, 'Standard', '620'),
	'AS3R'	=> array('Aston', 'National', 3.5, 'Reversed', '621'),
	'AS4'	=> array('Aston', 'Historic', 5.0, 'Standard', '630'),
	'AS4R'	=> array('Aston', 'Historic', 5.0, 'Reversed', '631'),
	'AS5'	=> array('Aston', 'Grand Prix', 5.5, 'Standard', '640'),
	'AS5R'	=> array('Aston', 'Grand Prix', 5.5, 'Reversed', '641'),
	'AS6'	=> array('Aston', 'Grand Touring', 5.0, 'Standard', '650'),
	'AS6R'	=> array('Aston', 'Grand Touring', 5.0, 'Reversed', '651'),
	'AS7'	=> array('Aston', 'North', 3.2, 'Standard', '660'),
	'AS7R'	=> array('Aston', 'North', 3.2, 'Reversed', '661')
);

$LFSW_Tracks = array(
	'000' => 'BL1',
	'001' => 'BL1R',
	'010' => 'BL2',
	'011' => 'BL2R',
	'020' => 'BL3',
	'100' => 'SO1',
	'101' => 'SO1R',
	'110' => 'SO2',
	'111' => 'SO2R',
	'120' => 'SO3',
	'121' => 'SO3R',
	'130' => 'SO4',
	'131' => 'SO4R',
	'140' => 'SO5',
	'141' => 'SO5R',
	'200' => 'FE1',
	'201' => 'FE1R',
	'210' => 'FE2',
	'211' => 'FE2R',
	'220' => 'FE3',
	'221' => 'FE3R',
	'230' => 'FE4',
	'231' => 'FE4R',
	'240' => 'FE5',
	'241' => 'FE5R',
	'250' => 'FE6',
	'251' => 'FE6R',
	'300' => 'AU1',
	'310' => 'AU2',
	'320' => 'AU3',
	'330' => 'AU4',
	'400' => 'KY1',
	'401' => 'KY1R',
	'410' => 'KY2',
	'411' => 'KY2R',
	'420' => 'KY3',
	'421' => 'KY3R',
	'500' => 'WE1',
	'501' => 'WE1R',
	'600' => 'AS1',
	'601' => 'AS1R',
	'610' => 'AS2',
	'611' => 'AS2R',
	'620' => 'AS3',
	'621' => 'AS3R',
	'630' => 'AS4',
	'631' => 'AS4R',
	'640' => 'AS5',
	'641' => 'AS5R',
	'650' => 'AS6',
	'651' => 'AS6R',
	'660' => 'AS7',
	'661' => 'AS7R'
);

$LFS_Cars = array(
	'UF1' => 'UF 1000',
	'XFG' => 'XF GTI',
	'XRG' => 'XR GT',
	'LX4' => 'LX4',
	'RB4' => 'RB4 GT',
	'FXO' => 'FXO TURBO',
	'XRT' => 'XR GT TURBO',
	'LX6' => 'LX6',
	'RAC' => 'RA',
	'FZ5' => 'FZ50',
	'UFR' => 'UF GTR',
	'XFR' => 'XF GTR',
	'MRT' => 'MTR5',
	'FOX' => 'FORMULA XR',
	'FO8' => 'FORMULA V8',
	'BF1' => 'BMW SAUBER',
	'FXR' => 'FXO GTR',
	'XRR' => 'XR GTR',
	'FZR' => 'FZ50 GTR'
);

$LFS_Cars_Classes = array(
	'ALL' => array('UF1','XFG','XRG','LX6','RB4','FX0','XRT','LX6','RAC','FZ5','UFR','XFR','MRT','FOX','FO8','BF1','FXR','XRR','FZR'),
	'STD' => array('UF1','XFG','XRG'),
	'TBO' => array('UF1','XFG','XRG','LX4','RB4','FXO','XRT'),
	'LRF' => array('UF1','XFG','XRG','LX4','RB4','FXO','XRT','LX6','RAC','FZ5'),
	'FWD' => array('UF1','XFG','FXO','UFR','XFR'),
	'GTR' => array('FXR','XRR','FXR'),
	'S-S' => array('MRT','FOX','FO8','BF1')
);

?>