/* ------------------------------------------------------------------------- *
 * Copyright (C) 2007,2008 Dino Miniutti
 *
 * Dino Miniutti <dino [dot] miniutti [at] gmail [dot] com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ------------------------------------------------------------------------- */
using System;
using System.IO;
using System.Xml;
using System.Xml.Serialization;

namespace PenaltyReset
{
    public class ConnectionOptions
    {
        public string HostAddress;
        public int Port;
        public string AdminPassword;

        public ConnectionOptions()
        {
            HostAddress = "127.0.0.1";
            Port = 29999;
            AdminPassword = "";
        }
    }

    public class PenaltyOptions
    {
        public UInt16 PenaltyDurationInSeconds = 15;
    }

    public class MessageOptions
    {
        public string MessageColour = "^1";
        public bool AnnounceStopTimeToPlayer = false;
        public bool AnnouncePenaltiesEveryLap = true;
    }

    public class LoggingOptions
    {
        public bool LogToConsole = true;
        public bool LogToFile = true;
        public string LogFileName = "log.txt";
    }

    [Serializable]
    public class ConfigurationOptions
    {
        public ConnectionOptions connectionOptions;
        public PenaltyOptions penaltyOptions;
        public MessageOptions messageOptions;
        public LoggingOptions loggingOptions;

        public ConfigurationOptions()
        {
            connectionOptions = new ConnectionOptions();
            penaltyOptions = new PenaltyOptions();
            messageOptions = new MessageOptions();
            loggingOptions = new LoggingOptions();
        }

        public static void Serialize(string file, ConfigurationOptions c)
        {
            System.Xml.Serialization.XmlSerializer xs
               = new System.Xml.Serialization.XmlSerializer(c.GetType());
            StreamWriter writer = File.CreateText(file);
            xs.Serialize(writer, c);
            writer.Flush();
            writer.Close();
        }

        public static ConfigurationOptions Deserialize(string file)
        {
            System.Xml.Serialization.XmlSerializer xs
               = new System.Xml.Serialization.XmlSerializer(
                  typeof(ConfigurationOptions));
            StreamReader reader = File.OpenText(file);
            ConfigurationOptions c = (ConfigurationOptions)xs.Deserialize(reader);
            reader.Close();
            return c;
        }
    }
}
