<?php

# error_reporting(0);
# set_time_limit(0);

function get_dir_structure($path, $recursive = TRUE, $ext = FALSE) {
	// This function Requires PHP5 >= 5.2.0;
	# Check for a '/' at the end of the path, append if not there.
	if (substr($path, -1) != '/')
		$path .= '/';
	# Check to see if the $path is a directory, fail if it's not.
	if (!is_dir($path)) {
		trigger_error('$path ' . $path . ' is not a directory!', E_USER_WARNING);
		return -1;
	}
	# Check to see if we can open the directory, fail if we can't.
	if (($handle = @opendir($path)) === FALSE) {
		print_r(error_get_last());
		trigger_error('Unable to open directory!', E_USER_WARNING);
		return -2;
	}
	# A, possibly, recursive read of the directory sturcture.
	while (FALSE !== ($item = readdir($handle))) {
		# Check to see if the $item is the up handle or current handle, skip to next if yes.
		if ($item != '.' && $item != '..') {
			# Check to see if the item is it's self a directory.
			if (is_dir($path . $item)) {
				# Check to see if we are going to read the contents of this directory.
				if ($recursive)
					$return[$item] = get_dir_structure($path . $item . '/', TRUE, $ext);
				else
					$return[$item] = array();
			} else {
				# Check to see if we are filtering for one extension.
				if ($ext != FALSE && strrpos($item, $ext) !== FALSE)
					$return[] = $item;
			}
		}
	}
	# Close the directory handle.
	closedir($handle);
	# Return the results.
	return $return;
}

	$path = 'C:/Documents and Settings/Dygear/My Documents/My Music';
	$gdsa = get_dir_structure($path, TRUE, '.mp3');

	file_put_contents('gdsa.txt', print_r($gdsa, TRUE));

	# Artists
	$artists = '';
	$lastLetter = '';
	$artistsAlbum = '';
	$artistsAlbumSongs = '';
	$artistsAlbumSongsEditor = '';
	$artists .= "\t\t<ul id=\"artists\" title=\"Artists\">\n";
	foreach($gdsa as $artist => $array) {
		$currentLetter = strToUpper(subStr($artist, 0, 1));
		if ($lastLetter != $currentLetter) {
			$artists .= "\t\t\t<li class=\"group\">{$currentLetter}</li>\n";
			$lastLetter = $currentLetter;
		}
		$artists .= "\t\t\t<li><a href=\"#{$artist}\">{$artist}</a></li>\n";
		# Album
		$artistsAlbum .= "\t\t<ul id=\"{$artist}\" title=\"{$artist}\">\n";
		foreach ($array as $album => $array) {
			$artistsAlbum .= "\t\t\t<li><a href=\"#{$artist}-{$album}\">{$album}</a></li>\n";
			# Songs
			$artistsAlbumSongs .= "\t\t<ul id=\"{$artist}-{$album}\" title=\"{$album}\">\n";
			foreach ($array as $song) {
				$id3 = id3_get_tag("$path/$artist/$album/$song", ID3_V1_0);
				$id3['track'] = (($id3['track'] > 10) ? $id3['track'] : "0{$id3['track']}");
				$artistsAlbumSongs .= "\t\t\t<li><a href=\"#{$artist}-{$album}-{$id3['title']}\">{$id3['track']} {$id3['title']}</a></li>\n";
				# -- S -- Editor -- S --
				$artistsAlbumSongsEditor .= "\t\t<div id=\"{$artist}-{$album}-{$id3['title']}\" class=\"panel\" title=\"{$id3['title']} Tags\">\n";
				foreach ($id3 as $key => $val) {
					$artistsAlbumSongsEditor .= "\t\t\t$key : <input type=\"text\" name=\"{$artist}-{$album}-{$id3['title']}-{$key}\" value=\"{$val}\"><br />\n";
				}
				$artistsAlbumSongsEditor .= "\t\t</div>\n";
				# -- E -- Editor -- E --
			}
			$artistsAlbumSongs .= "\t\t</ul>\n";
		}
		$artistsAlbum .= "\t\t</ul>\n";
	}
	$artists .= "\t\t</ul>\n";

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>iUI Music Demo</title>
		<meta name="viewport" content="width=320; initial-scale=1.0; maximum-scale=1.0; user-scalable=0;"/>
		<link rel="stylesheet" href="assests/iUi.css" type="text/css" media="screen" />
		<script type="application/x-javascript" src="assests/iUi.js"></script>
	</head>
	<body>
		<div class="toolbar">
			<h1 id="pageTitle"></h1>
			<a id="backButton" class="button" href="#"></a>
			<a class="button" href="#searchForm">Search</a>
		</div>
		<ul id="home" title="Music" selected="true">
			<li><a href="#artists">Artists</a></li>
			<li><a href="#settings">Settings</a></li>
			<li>Nothing</li>
		</ul>
<?php
	echo $artists;
	echo $artistsAlbum;
	echo $artistsAlbumSongs;
	echo $artistsAlbumSongsEditor;
?>
		<form id="searchForm" class="dialog" action="search.php">
			<fieldset>
				<h1>Music Search</h1>
				<a class="button leftButton" type="cancel">Cancel</a>
				<a class="button blueButton" type="submit">Search</a>
				<label>Artist:</label>
				<input type="text" name="artist"/>
				<label>Song:</label>
				<input type="text" name="song"/>
			</fieldset>
		</form>
		<div id="settings" title="Settings" class="panel">
			<h2>Playback</h2>
			<fieldset>
				<div class="row">
					<label>Repeat</label>
					<div class="toggle" onclick=""><span class="thumb"></span><span class="toggleOn">ON</span><span class="toggleOff">OFF</span></div>
				</div>
				<div class="row">
					<label>Shuffle</label>
					<div class="toggle" onclick="" toggled="true"><span class="thumb"></span><span class="toggleOn">ON</span><span class="toggleOff">OFF</span></div>
				</div>
			</fieldset>
			<h2>User</h2>
			<fieldset>
				<div class="row">
					<label>Name</label>
					<input type="text" name="userName" value="johnappleseed"/>
				</div>
				<div class="row">
					<label>Password</label>
					<input type="password" name="password" value="delicious"/>
				</div>
				<div class="row">
					<label>Confirm</label>
					<input type="password" name="password" value="delicious"/>
				</div>
			</fieldset>
		</div>
	</body>
</html>
