<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
	<head>
		<title>iUI Music Demo</title>
		<meta name="viewport" content="width=320; initial-scale=1.0; maximum-scale=1.0; user-scalable=0;"/>
		<!--
			<style type="text/css" media="screen">@import "http://www.joehewitt.com/iui/iui/iui.css";</style>
			<script type="application/x-javascript" src="http://www.joehewitt.com/iui/iui/iui.js"></script>
		-->
	</head>
	<body>
<?php

function get_dir_structure($path, $recursive = true, $ext = null) {
	if (is_dir($path)) {
		if ($handle = opendir($path)) {
			while (false !== ($item = readdir($handle))) {
				if ($item != '.' && $item != '..') {
					if (is_dir($path . $item)) {
						if ($recursive) {
							$return[$item] = get_dir_structure($path . $item . '/', $recursive, $ext);
						} else {
							$return[$item] = array();
						}
					} else {
						if ($ext != null && strrpos($item, $ext) !== FALSE) {
							$return[] = $item;
						}
					}
				}
			}
			closedir($handle);
		}
		return $return;
	} else {
		trigger_error('$path is not a directory!', E_USER_WARNING);
		return FALSE;
	}
}

	$path = 'C:/Documents and Settings/Dygear/My Documents/My Music/';
	$gdsa = get_dir_structure($path, true, '.mp3');
	foreach($gdsa as $artist => $array) {
		if ($artist == 'iTunes')
			continue;
		echo "<ul id=\"{$artist}\">\n";
		echo "\t<li>{$artist}\n";
		foreach ($array as $album => $array) {
			echo "\t\t<ul id=\"{$artist}-{$album}\">\n";
			echo "\t\t\t<li>{$album}\n";
			foreach ($array as $track => $song) {
				unset($gdsa[$artist][$album][$track]);
				$gdsa[$artist][$album][$track] = id3_get_tag("{$path}{$artist}/{$album}/{$song}", ID3_V1_0);
				echo "\t\t\t<ul id=\"{$artist}-{$album}-{$song['title']}\">\n";
				echo "\t\t\t\t<li>{$gdsa[$artist][$album][$track]['title']}\n";
				echo "\t\t\t\t\t<ul>\n";
				foreach ($gdsa[$artist][$album][$track] as $key => $val) {
					echo "\t\t\t\t\t\t<li>{$key}:<br /><input type=\"text\" name=\"{$artist}-{$album}-{$song['title']}-$key\" value=\"{$val}\" /></li>\n";
				}
				echo "\t\t\t\t\t</ul>\n";
				echo "\t\t\t\t</li>\n";
				echo "\t\t\t</ul>\n";
			}
			echo "\t\t\t</li>\n";
			echo "\t\t</ul>\n";
		}
		echo "\t</li>\n";
		echo "</ul>\n";
	}

?>
	</body>
</html>