package src;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class gui extends JFrame implements ActionListener {
	
	private GetInfo info;
	private Driver[] drivers;
	
	private Container pane;
	private JPanel panel;
	private JButton show;
	private JComboBox tracklist, carlist;
	public JTextPane display;
	
	public gui() {
		super("PB Fetch");
		super.setSize(270,300);
		super.setDefaultCloseOperation(super.EXIT_ON_CLOSE);
		createGui();
	}
	
	private void createGui() {
		
		GetInfo info = new GetInfo();
		
		Container pane = super.getContentPane();
		panel = new JPanel();
		panel.setLayout(new FlowLayout());
		panel.setBackground(new Color(91, 92, 112));
		panel.setForeground(Color.WHITE);
		
		tracklist = new JComboBox();
		for (int i = 0; i < info.tracklist.length; i++) {
			tracklist.addItem(info.tracklist[i][1]);
		}
		tracklist.setBackground(new Color(51,51,51));
		tracklist.setForeground(Color.WHITE);
		
		carlist = new JComboBox();
		for (int i = 0; i < info.carlist.length; i++) {
			carlist.addItem(info.carlist[i]);
		}
		carlist.setBackground(new Color(51,51,51));
		carlist.setForeground(Color.WHITE);
		
		show = new JButton("Fetch");
		show.setBackground(new Color(51,51,51));
		show.setForeground(Color.WHITE);
		
		display = new JTextPane();
		display.setEditable(false);
		display.setBackground(new Color(91, 92, 112));
		display.setForeground(Color.WHITE);
		display.setPreferredSize(new Dimension(257, 255));
		
		JScrollPane display_holder = new JScrollPane(display);
		display_holder.setBorder(null);
		
		panel.add(tracklist);
		panel.add(carlist);
		panel.add(show);
		panel.add(display_holder);
		pane.add(panel);
		
		show.addActionListener(this);
		tracklist.addActionListener(this);
		carlist.addActionListener(this);
	}
	
	private void reinit() {
		
		info = new GetInfo();
		drivers = new Driver[info.names.length];
		
		String[][] driver_names = info.names;
		
		for (int i = 0; i < drivers.length; i++) {
			drivers[i] = new Driver(driver_names[i][0], driver_names[i][1], info);
		}
	}
	
	private String fetchData() {
		String track = (String)tracklist.getSelectedItem();
		String car = (String)carlist.getSelectedItem();
		String output = "";
		String[][] driver_PB = new String[drivers.length][2];
		String[][] sorted_driver_PB;
		int longname=0;
		
		for (int i = 0; i < drivers.length; i++) {
			driver_PB[i][0] = drivers[i].getDriverName();
			driver_PB[i][1] = drivers[i].findPB(track, car);
		}
		sorted_driver_PB = info.sortPBs(driver_PB);
		
		for (int i = 0; i < sorted_driver_PB.length; i++) {
			if (sorted_driver_PB[i][0].length() > longname) {
				longname = sorted_driver_PB[i][0].length();
			}
		}
		
		for (int i = 0; i < sorted_driver_PB.length; i++) {
			output += (i+1) + ". ";
			int spaces = longname - sorted_driver_PB[i][0].length();
			output += sorted_driver_PB[i][0];
			while (spaces > 0) { output += " "; spaces--; }
			output += "\t" + info.convertTimes(sorted_driver_PB[i][1]) + "\n";
		}
		
		return output;
	}
	
	public void actionPerformed(ActionEvent e) {
		
		if (e.getSource() == show) { reinit(); display.setText("Data Retrieved."); }
		else if (e.getSource() == carlist || e.getSource() == tracklist) { display.setText(fetchData()); }
	}

}
