#region Copyright  2006 Daniel Monzert [jackd.m@gmx.net]
/*
 * cSharpToHtml is provided 'as-is' without any warranties. I am not responsible
 * for any damages or data loss happening from using this program.
 * You can use, alter and redistribute this software freely by the following
 * restrictions:
 * 
 * 1. Do not misrepresent the origin of this software and the origin of the
 *    software by Jean-Claude Manoli. You do not claim to be the original
 *    author of either software.
 * 
 * 2. If you alter the source code and redistribute it, plainly mark it
 *    as such.
 * 
 * 3. This notice will not be removed or altered from any sourcecode
 *    distribution.
 */
#endregion
#region Copyright  2001-2003 Jean-Claude Manoli [jc@manoli.net]
/*
 * This software is provided 'as-is', without any express or implied warranty.
 * In no event will the author(s) be held liable for any damages arising from
 * the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 * 
 *   1. The origin of this software must not be misrepresented; you must not
 *      claim that you wrote the original software. If you use this software
 *      in a product, an acknowledgment in the product documentation would be
 *      appreciated but is not required.
 * 
 *   2. Altered source versions must be plainly marked as such, and must not
 *      be misrepresented as being the original software.
 * 
 *   3. This notice may not be removed or altered from any source distribution.
 */ 
#endregion
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Text;
using System.Windows.Forms;
using Manoli.Utils.CSharpFormat;

namespace cSharpToHtml
{
	/// <summary>
	///		Main user interface form.
	/// </summary>
	public class frmMain : System.Windows.Forms.Form
	{
		private System.Windows.Forms.TabControl m_tabControl;
		private System.Windows.Forms.TabPage m_tabSource;
		private System.Windows.Forms.TabPage m_tabHTML;
		private System.Windows.Forms.TextBox m_txtSource;
		private System.Windows.Forms.RadioButton m_optCSharp;
		private System.Windows.Forms.RadioButton m_optVB;
		private System.Windows.Forms.RadioButton m_optJavaScript;
		private System.Windows.Forms.RadioButton m_optHTML;
		private System.Windows.Forms.Label m_lblLanguage;
		private System.Windows.Forms.Button m_cmdConvert;
		private System.Windows.Forms.TextBox m_txtHTML;
		private System.Windows.Forms.CheckBox m_chkLineNumbers;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.CheckBox m_chkAlternate;
		private System.Windows.Forms.CheckBox m_chkEmbeddedStyleSheet;
		private System.Windows.Forms.Label m_lblTabSpaces;
		private System.Windows.Forms.TextBox m_txtTabSpaces;
		private System.Windows.Forms.Button m_cmdCSS;
		private System.Windows.Forms.Button m_cmdSource;
		private System.ComponentModel.Container components = null;

		public frmMain()
		{
			InitializeComponent();

			// set window title.
			this.Text = "cSharpToHTML GUI - CSharpFormat wrapped - " + Core.VersionString;

			// set tooltips.
			ToolTip toolTip = new ToolTip();
			toolTip.SetToolTip(m_chkAlternate, "Check to background coloring lines with 2 colors.");
			toolTip.SetToolTip(m_chkEmbeddedStyleSheet, "Check to embed CSS into the HTML document.");
			toolTip.SetToolTip(m_chkLineNumbers, "Check to include line numbers in the HTML output.");
			toolTip.SetToolTip(m_optCSharp, "Select, if the code is C#.");
			toolTip.SetToolTip(m_optVB, "Select, if the code is Visual Basic.NET.");
			toolTip.SetToolTip(m_optJavaScript, "Select, if the code is JavaScript.");
			toolTip.SetToolTip(m_optHTML, "Select, if the code is HTML.");
			toolTip.SetToolTip(m_cmdCSS, "Only outputs the CSS code.");
			toolTip.SetToolTip(m_cmdConvert, "Click to create HTML output for the pasted source code.");
			toolTip.SetToolTip(m_lblTabSpaces, "Amount of spaces for a tab character (indentation).");
			toolTip.SetToolTip(m_txtTabSpaces, "Amount of spaces for a tab character (indentation).");

			// assign callbacks.
			m_cmdConvert.Click += new EventHandler(cmdConvert_Click);
			m_cmdCSS.Click += new EventHandler(cmdCSS_Click);
			m_cmdSource.Click += new EventHandler(cmdSource_Click);
		}

		/// <summary>
		///		Generates HTML output for the source code pasted.
		/// </summary>
		private void cmdConvert_Click(object sender, EventArgs e)
		{
			// get the proper formatter.
			SourceFormat sourceFormat = GetFormatter();

			// assign options.
			sourceFormat.LineNumbers = m_chkLineNumbers.Checked;
			sourceFormat.Alternate = m_chkAlternate.Checked;
			sourceFormat.EmbedStyleSheet = m_chkEmbeddedStyleSheet.Checked;

			// parse or default to 2 space charaters per TAB.
			try { sourceFormat.TabSpaces = (byte)int.Parse(m_txtTabSpaces.Text); }
			catch { sourceFormat.TabSpaces = 2; }

			// output source, show and clean up.
			StringBuilder sb = new StringBuilder();
			sb.Append(sourceFormat.FormatCode(m_txtSource.Text));
			sb.Replace("\r", "");
			sb.Replace("\n", "\r\n");

			m_txtHTML.Text = sb.ToString();
			m_tabControl.SelectedTab = m_tabHTML;
			m_txtSource.SelectAll();
			sb = null;
			GC.Collect();
		}

		/// <summary>
		///		Generates only CSS output.
		/// </summary>
		private void cmdCSS_Click(object sender, EventArgs e)
		{
			// get proper formatter.
			SourceFormat sourceFormat = GetFormatter();

			// output, show and cleanup.
			m_txtHTML.Text = sourceFormat.GetCssString();
			m_tabControl.SelectedTab = m_tabHTML;
			GC.Collect();
		}

		/// <summary>
		///		Opens back the source-code tab.
		/// </summary>
		private void cmdSource_Click(object sender, EventArgs e)
		{
			m_tabControl.SelectedTab = m_tabSource;
		}

		/// <summary>
		///		Instanciates the proper formatter for the selected language.
		/// </summary>
		private SourceFormat GetFormatter()
		{
			SourceFormat sourceFormat = null;

			if (m_optCSharp.Checked)
				sourceFormat = new CSharpFormat();
			else if (m_optVB.Checked)
				sourceFormat = new VisualBasicFormat();
			else if (m_optJavaScript.Checked)
				sourceFormat = new JavaScriptFormat();
			else if (m_optHTML.Checked)
				sourceFormat = new HtmlFormat();

			if (sourceFormat == null)
				throw new Exception("Unknown format selected.");

			return sourceFormat;
		}

		/// <summary>
		///		Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.m_tabControl = new System.Windows.Forms.TabControl();
			this.m_tabSource = new System.Windows.Forms.TabPage();
			this.m_cmdCSS = new System.Windows.Forms.Button();
			this.m_txtTabSpaces = new System.Windows.Forms.TextBox();
			this.m_lblTabSpaces = new System.Windows.Forms.Label();
			this.m_chkEmbeddedStyleSheet = new System.Windows.Forms.CheckBox();
			this.m_chkAlternate = new System.Windows.Forms.CheckBox();
			this.label1 = new System.Windows.Forms.Label();
			this.m_chkLineNumbers = new System.Windows.Forms.CheckBox();
			this.m_cmdConvert = new System.Windows.Forms.Button();
			this.m_lblLanguage = new System.Windows.Forms.Label();
			this.m_optHTML = new System.Windows.Forms.RadioButton();
			this.m_optJavaScript = new System.Windows.Forms.RadioButton();
			this.m_optVB = new System.Windows.Forms.RadioButton();
			this.m_optCSharp = new System.Windows.Forms.RadioButton();
			this.m_txtSource = new System.Windows.Forms.TextBox();
			this.m_tabHTML = new System.Windows.Forms.TabPage();
			this.m_txtHTML = new System.Windows.Forms.TextBox();
			this.m_cmdSource = new System.Windows.Forms.Button();
			this.m_tabControl.SuspendLayout();
			this.m_tabSource.SuspendLayout();
			this.m_tabHTML.SuspendLayout();
			this.SuspendLayout();
			// 
			// m_tabControl
			// 
			this.m_tabControl.Controls.Add(this.m_tabSource);
			this.m_tabControl.Controls.Add(this.m_tabHTML);
			this.m_tabControl.Location = new System.Drawing.Point(8, 8);
			this.m_tabControl.Name = "m_tabControl";
			this.m_tabControl.SelectedIndex = 0;
			this.m_tabControl.Size = new System.Drawing.Size(792, 544);
			this.m_tabControl.TabIndex = 0;
			// 
			// m_tabSource
			// 
			this.m_tabSource.Controls.Add(this.m_cmdCSS);
			this.m_tabSource.Controls.Add(this.m_txtTabSpaces);
			this.m_tabSource.Controls.Add(this.m_lblTabSpaces);
			this.m_tabSource.Controls.Add(this.m_chkEmbeddedStyleSheet);
			this.m_tabSource.Controls.Add(this.m_chkAlternate);
			this.m_tabSource.Controls.Add(this.label1);
			this.m_tabSource.Controls.Add(this.m_chkLineNumbers);
			this.m_tabSource.Controls.Add(this.m_cmdConvert);
			this.m_tabSource.Controls.Add(this.m_lblLanguage);
			this.m_tabSource.Controls.Add(this.m_optHTML);
			this.m_tabSource.Controls.Add(this.m_optJavaScript);
			this.m_tabSource.Controls.Add(this.m_optVB);
			this.m_tabSource.Controls.Add(this.m_optCSharp);
			this.m_tabSource.Controls.Add(this.m_txtSource);
			this.m_tabSource.Location = new System.Drawing.Point(4, 22);
			this.m_tabSource.Name = "m_tabSource";
			this.m_tabSource.Size = new System.Drawing.Size(784, 518);
			this.m_tabSource.TabIndex = 0;
			this.m_tabSource.Text = "Source-Code";
			// 
			// m_cmdCSS
			// 
			this.m_cmdCSS.Location = new System.Drawing.Point(624, 488);
			this.m_cmdCSS.Name = "m_cmdCSS";
			this.m_cmdCSS.TabIndex = 15;
			this.m_cmdCSS.Text = "CS&S";
			// 
			// m_txtTabSpaces
			// 
			this.m_txtTabSpaces.Location = new System.Drawing.Point(544, 456);
			this.m_txtTabSpaces.MaxLength = 1;
			this.m_txtTabSpaces.Name = "m_txtTabSpaces";
			this.m_txtTabSpaces.Size = new System.Drawing.Size(32, 21);
			this.m_txtTabSpaces.TabIndex = 14;
			this.m_txtTabSpaces.Text = "2";
			this.m_txtTabSpaces.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
			// 
			// m_lblTabSpaces
			// 
			this.m_lblTabSpaces.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
			this.m_lblTabSpaces.Location = new System.Drawing.Point(456, 456);
			this.m_lblTabSpaces.Name = "m_lblTabSpaces";
			this.m_lblTabSpaces.Size = new System.Drawing.Size(88, 21);
			this.m_lblTabSpaces.TabIndex = 13;
			this.m_lblTabSpaces.Text = " &Tab-Spaces:";
			this.m_lblTabSpaces.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// m_chkEmbeddedStyleSheet
			// 
			this.m_chkEmbeddedStyleSheet.Location = new System.Drawing.Point(288, 456);
			this.m_chkEmbeddedStyleSheet.Name = "m_chkEmbeddedStyleSheet";
			this.m_chkEmbeddedStyleSheet.Size = new System.Drawing.Size(160, 24);
			this.m_chkEmbeddedStyleSheet.TabIndex = 12;
			this.m_chkEmbeddedStyleSheet.Text = "&Embedded style-sheet";
			// 
			// m_chkAlternate
			// 
			this.m_chkAlternate.Checked = true;
			this.m_chkAlternate.CheckState = System.Windows.Forms.CheckState.Checked;
			this.m_chkAlternate.Location = new System.Drawing.Point(200, 456);
			this.m_chkAlternate.Name = "m_chkAlternate";
			this.m_chkAlternate.Size = new System.Drawing.Size(80, 24);
			this.m_chkAlternate.TabIndex = 11;
			this.m_chkAlternate.Text = "&Alternate";
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(8, 456);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(64, 23);
			this.label1.TabIndex = 9;
			this.label1.Text = "Options:";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// m_chkLineNumbers
			// 
			this.m_chkLineNumbers.Location = new System.Drawing.Point(80, 456);
			this.m_chkLineNumbers.Name = "m_chkLineNumbers";
			this.m_chkLineNumbers.Size = new System.Drawing.Size(112, 24);
			this.m_chkLineNumbers.TabIndex = 8;
			this.m_chkLineNumbers.Text = "Line &numbers";
			// 
			// m_cmdConvert
			// 
			this.m_cmdConvert.Location = new System.Drawing.Point(704, 488);
			this.m_cmdConvert.Name = "m_cmdConvert";
			this.m_cmdConvert.TabIndex = 7;
			this.m_cmdConvert.Text = "&Convert";
			// 
			// m_lblLanguage
			// 
			this.m_lblLanguage.Location = new System.Drawing.Point(8, 488);
			this.m_lblLanguage.Name = "m_lblLanguage";
			this.m_lblLanguage.Size = new System.Drawing.Size(64, 23);
			this.m_lblLanguage.TabIndex = 6;
			this.m_lblLanguage.Text = "Language:";
			this.m_lblLanguage.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// m_optHTML
			// 
			this.m_optHTML.Location = new System.Drawing.Point(296, 488);
			this.m_optHTML.Name = "m_optHTML";
			this.m_optHTML.Size = new System.Drawing.Size(56, 24);
			this.m_optHTML.TabIndex = 4;
			this.m_optHTML.Text = "&HTML";
			// 
			// m_optJavaScript
			// 
			this.m_optJavaScript.Location = new System.Drawing.Point(208, 488);
			this.m_optJavaScript.Name = "m_optJavaScript";
			this.m_optJavaScript.Size = new System.Drawing.Size(88, 24);
			this.m_optJavaScript.TabIndex = 3;
			this.m_optJavaScript.Text = "&JavaScript";
			// 
			// m_optVB
			// 
			this.m_optVB.Location = new System.Drawing.Point(128, 488);
			this.m_optVB.Name = "m_optVB";
			this.m_optVB.Size = new System.Drawing.Size(72, 24);
			this.m_optVB.TabIndex = 2;
			this.m_optVB.Text = "&VB.NET";
			// 
			// m_optCSharp
			// 
			this.m_optCSharp.Checked = true;
			this.m_optCSharp.Location = new System.Drawing.Point(80, 488);
			this.m_optCSharp.Name = "m_optCSharp";
			this.m_optCSharp.Size = new System.Drawing.Size(40, 24);
			this.m_optCSharp.TabIndex = 1;
			this.m_optCSharp.TabStop = true;
			this.m_optCSharp.Text = "&C#";
			// 
			// m_txtSource
			// 
			this.m_txtSource.Location = new System.Drawing.Point(8, 8);
			this.m_txtSource.MaxLength = 0;
			this.m_txtSource.Multiline = true;
			this.m_txtSource.Name = "m_txtSource";
			this.m_txtSource.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.m_txtSource.Size = new System.Drawing.Size(768, 440);
			this.m_txtSource.TabIndex = 0;
			this.m_txtSource.Text = "";
			this.m_txtSource.WordWrap = false;
			// 
			// m_tabHTML
			// 
			this.m_tabHTML.Controls.Add(this.m_cmdSource);
			this.m_tabHTML.Controls.Add(this.m_txtHTML);
			this.m_tabHTML.Location = new System.Drawing.Point(4, 22);
			this.m_tabHTML.Name = "m_tabHTML";
			this.m_tabHTML.Size = new System.Drawing.Size(784, 518);
			this.m_tabHTML.TabIndex = 1;
			this.m_tabHTML.Text = "HTML";
			// 
			// m_txtHTML
			// 
			this.m_txtHTML.Location = new System.Drawing.Point(8, 8);
			this.m_txtHTML.MaxLength = 0;
			this.m_txtHTML.Multiline = true;
			this.m_txtHTML.Name = "m_txtHTML";
			this.m_txtHTML.ScrollBars = System.Windows.Forms.ScrollBars.Both;
			this.m_txtHTML.Size = new System.Drawing.Size(768, 472);
			this.m_txtHTML.TabIndex = 0;
			this.m_txtHTML.Text = "";
			this.m_txtHTML.WordWrap = false;
			// 
			// m_cmdSource
			// 
			this.m_cmdSource.Location = new System.Drawing.Point(704, 488);
			this.m_cmdSource.Name = "m_cmdSource";
			this.m_cmdSource.TabIndex = 1;
			this.m_cmdSource.Text = "&Source";
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 14);
			this.ClientSize = new System.Drawing.Size(808, 557);
			this.Controls.Add(this.m_tabControl);
			this.Font = new System.Drawing.Font("Verdana", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "frmMain";
			this.Text = "frmMain";
			this.m_tabControl.ResumeLayout(false);
			this.m_tabSource.ResumeLayout(false);
			this.m_tabHTML.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion
	}
}
