import cfscrape
import json
import traceback
import sys

nick = sys.argv[1]
PubKey = sys.argv[2]

wr = "http://www.lfsworld.net/pubstat/get_stat2.php?version=1.5&idk=" + PubKey + "&action=wr&s=1"
pb = "http://www.lfsworld.net/pubstat/get_stat2.php?version=1.5&idk=" + PubKey + "&action=pb&racer=" + nick + "&s=1"

tracks = {
	'000': "BL1",
	'001': "BL1R",
	'010': "BL2",
	'011': "BL2R",
	'020': "BL3",
	'021': "BL3R",
	
	'100': "SO1",
	'101': "SO1R",
	'110': "SO2",
	'111': "SO2R",
	'120': "SO3",
	'121': "SO3R",
	'130': "SO4",
	'131': "SO4R",
	'140': "SO5",
	'141': "SO5R",
	'150': "SO6",
	'151': "SO6R",
	
	'200': "FE1",
	'201': "FE1R",
	'210': "FE2",
	'211': "FE2R",
	'220': "FE3",
	'221': "FE3R",
	'230': "FE4",
	'231': "FE4R",
	'240': "FE5",
	'241': "FE5R",
	'250': "FE6",
	'251': "FE6R",
	
	'300': "AU1",
	'310': "AU2",
	'320': "AU3",
	'330': "AU4",
	
	'400': "KY1",
	'401': "KY1R",
	'410': "KY2",
	'411': "KY2R",
	'420': "KY3",
	'421': "KY3R",
	
	'500': "WE1",
	'501': "WE1R",
	'510': "WE2",
	'511': "WE2R",
	'520': "WE3",
	'530': "WE4",
	'531': "WE4R",
	'540': "WE5",
	'541': "WE5R",
	
	'600': "AS1",
	'601': "AS1R",
	'610': "AS2",
	'611': "AS2R",
	'620': "AS3",
	'621': "AS3R",
	'630': "AS4",
	'631': "AS4R",
	'640': "AS5",
	'641': "AS5R",
	'650': "AS6",
	'651': "AS6R",
	'660': "AS7",
	'661': "AS7R",
	
	'700': "RO1",
	'710': "RO2",
	'720': "RO3",
	'730': "RO4",
	'740': "RO5",
	'750': "RO6",
	'760': "RO7",
	'770': "RO8",
	'780': "RO9",
	'790': "RO10",
	'7100': "RO11"
}

export = "<!DOCTYPE html>\n  <body>\n"
export += "    <script src=\"https://www.kryogenix.org/code/browser/sorttable/sorttable.js\"></script>\n"
export += "    <link rel=\"stylesheet\" href=\"style.css\" type=\"text/css\">\n"
export += "    <table class=\"sortable\">\n\n"
export += "      <tr>\n        <th>Track</th>\n        <th>Car</th>\n       <th>Percent</th></tr>\n"

try:
	scraper = cfscrape.create_scraper()
	
	output_wr = scraper.get(wr)
	output_wr = json.loads(output_wr.content)

	output_pb = scraper.get(pb)
	output_pb = json.loads(output_pb.content)

	json_str_wr = json.dumps(output_wr)
	resp_wr = json.loads(json_str_wr)

	json_str_pb = json.dumps(output_pb)
	resp_pb = json.loads(json_str_pb)

	wr = []
	pb = []

	for line_wr in resp_wr:
		json_str_wr = json.dumps(line_wr)
		resp_wr = json.loads(json_str_wr)
		wr.append([resp_wr['track'], resp_wr['car'], resp_wr['laptime']])
		
	for line_pb in resp_pb:
		json_str_pb = json.dumps(line_pb)
		resp_pb = json.loads(json_str_pb)	
		pb.append([resp_pb['track'], resp_pb['car'], resp_pb['laptime']])
		
	#wr.sort()
		
	for w in wr:
		for p in pb:
			if p[0] == w[0]:
				if p[1] == w[1]:
					print tracks[str(p[0])],'\t', p[1], '\t', str(round(float(p[2])/float(w[2])*100, 2))+"%"
					export += "\n      <tr>\n        <td>" + tracks[str(p[0])] + "</td>\n        <td>" + p[1] + "</td>\n        <td>" + str(round(float(p[2])/float(w[2])*100, 2))+"%" + "</td>\n      </tr>\n"

	export += "\n    </table>\n  </body>\n</html>"

	f = open("index_" + nick + ".html", "w")
	f.write(export)
	f.close()
except Exception as e:
	traceback.print_exc(e)