﻿/*
 *  Copyright Alex McBride 2008.
 * 
 *  This file is part of LFSReplayParser.
 *
 *  LFSReplayParser is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  LFSReplayParser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with LFSReplayParser. If not, see <http://www.gnu.org/licenses/>.
 *  
 */

namespace LFSReplayParser.Replays
{
    /// <summary>
    /// The multiplayer host flags.
    /// </summary>
    [System.Flags]
    public enum HostFlags
    {
        /// <summary>
        /// Host allows players to vote.
        /// </summary>
        Vote = 1,
        /// <summary>
        /// Host allows players to select track.
        /// </summary>
        Select = 2,
        /// <summary>
        /// Host allows mid-race joins.
        /// </summary>
        MidRaceJoin = 32,
        /// <summary>
        /// Host requires mandatory pit stop.
        /// </summary>
        MustPit = 64,
        /// <summary>
        /// Host allows players to reset car.
        /// </summary>
        CanReset = 128,
        /// <summary>
        /// Host requires players to use forced-cockpit view.
        /// </summary>
        ForcedCockpitView = 256,
        /// <summary>
        /// Host is a cruise server.
        /// </summary>
        Cruise = 512
    }
}
