﻿/*
 *  Copyright Alex McBride 2008.
 * 
 *  This file is part of LFSReplayParser.
 *
 *  LFSReplayParser is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  LFSReplayParser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with LFSReplayParser. If not, see <http://www.gnu.org/licenses/>.
 *  
 */

namespace LFSReplayParser.Replays
{
    /// <summary>
    /// Host rules flags (allowed cars).
    /// </summary>
    [System.Flags]
    public enum HostRules
    {
        /// <summary>
        /// XFG
        /// </summary>
        XFG = 1,

        /// <summary>
        /// XRG
        /// </summary>
        XRG = 2,

        /// <summary>
        /// XRT
        /// </summary>
        XRT = 4,

        /// <summary>
        /// RB4
        /// </summary>
        RB4 = 8,

        /// <summary>
        /// FX0
        /// </summary>
        FXO = 16,

        /// <summary>
        /// LX4
        /// </summary>
        LX4 = 32,

        /// <summary>
        /// LX6
        /// </summary>
        LX6 = 64,

        /// <summary>
        /// MRT
        /// </summary>
        MRT = 128,

        /// <summary>
        /// UF1
        /// </summary>
        UF1 = 256,

        /// <summary>
        /// RAC
        /// </summary>
        RAC = 512,

        /// <summary>
        /// FZ5
        /// </summary>
        FZ5 = 1024,

        /// <summary>
        /// FOX
        /// </summary>
        FOX = 2048,

        /// <summary>
        /// XFR
        /// </summary>
        XFR = 4096,

        /// <summary>
        /// UFR
        /// </summary>
        UFR = 8192,

        /// <summary>
        /// FO8
        /// </summary>
        FO8 = 16384,

        /// <summary>
        /// FXR
        /// </summary>
        FXR = 32768,

        /// <summary>
        /// XRR
        /// </summary>
        XRR = 65536,

        /// <summary>
        /// FZR
        /// </summary>
        FZR = 131072,

        /// <summary>
        /// BF1
        /// </summary>
        BF1 = 262144
    }
}
