﻿/*
 *  Copyright Alex McBride 2008.
 * 
 *  This file is part of LFSReplayParser.
 *
 *  LFSReplayParser is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  LFSReplayParser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with LFSReplayParser. If not, see <http://www.gnu.org/licenses/>.
 *  
 */

namespace LFSReplayParser.Replays
{
    /// <summary>
    /// Player flags.
    /// </summary>
    [System.Flags]
    public enum PlayerFlags
    {
        /// <summary>
        /// Player using left-hand drive.
        /// </summary>
        LeftHandDrive = 1,

        /// <summary>
        /// Player has gear-change cut enabled.
        /// </summary>
        GearChangeCut = 2,

        /// <summary>
        /// Player has gear-change blip enabled.
        /// </summary>
        GearChangeBlip = 4,

        /// <summary>
        /// Player is using auto-gear shifts.
        /// </summary>
        AutoShift = 8,

        /// <summary>
        /// Player is using H-shifter.
        /// </summary>
        Shifter = 16,

        /// <summary>
        /// Player has breaking help enabled.
        /// </summary>
        BrakingHelp = 64,

        /// <summary>
        /// Player using manual clutch-pedal.
        /// </summary>
        AxisClutch = 128,

        /// <summary>
        /// Player has auto-clutch enabled.
        /// </summary>
        AutoClutch = 512,

        /// <summary>
        /// Player using mouse-steering.
        /// </summary>
        Mouse = 1024,

        /// <summary>
        /// Player using keyboard controls with no driver aids.
        /// </summary>
        KeyboardNoHelp = 2048,

        /// <summary>
        /// Player using keyboard controls with driver aids.
        /// </summary>
        KeyboardStabalised = 4096,
    }
}
