﻿/*
 *  Copyright Alex McBride 2008.
 * 
 *  This file is part of LFSReplayParser.
 *
 *  LFSReplayParser is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  LFSReplayParser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with LFSReplayParser. If not, see <http://www.gnu.org/licenses/>.
 *  
 */

namespace LFSReplayParser.Replays
{
    /// <summary>
    /// Gets the type of the replay.
    /// </summary>
    public enum RaceTypes
    {
        /// <summary>
        /// The replay is of a race.
        /// </summary>
        Race,

        /// <summary>
        /// The replay is of a practice session.
        /// </summary>
        Practice,

        /// <summary>
        /// The replay is of a qualifying.
        /// </summary>
        Qualifying
    }
}
