﻿/*
 *  Copyright Alex McBride 2008.
 * 
 *  This file is part of LFSReplayParser.
 *
 *  LFSReplayParser is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  LFSReplayParser is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with LFSReplayParser. If not, see <http://www.gnu.org/licenses/>.
 *  
 */

using System;

namespace LFSReplayParser.Replays
{
    /// <summary>
    /// Represents a LFSReplayParser exception.
    /// </summary>
    [global::System.Serializable]
    public class ReplayException : ApplicationException
    {
        /// <summary>
        /// Create a new ReplayException object.
        /// </summary>
        public ReplayException() { }

        /// <summary>
        /// Create a new ReplayException object.
        /// </summary>
        public ReplayException(string message) : base(message) { }

        /// <summary>
        /// Create a new ReplayException object.
        /// </summary>
        public ReplayException(string message, Exception inner) : base(message, inner) { }

        /// <summary>
        /// Create a new ReplayException object.
        /// </summary>
        protected ReplayException(
          System.Runtime.Serialization.SerializationInfo info,
          System.Runtime.Serialization.StreamingContext context)
            : base(info, context) { }
    }
}
